//
//  ChooseParentViewController.m
//  XFFruit
//
//  Created by 陈俊俊 on 15/9/2.
//  Copyright (c) 2015年 Xummer. All rights reserved.
//

#import "ChooseParentViewController.h"
#define TopMargin 50
#define TableHeight 50

@interface ChooseParentViewController ()<UITableViewDataSource,UITableViewDelegate,UITextFieldDelegate>
@end

@implementation ChooseParentViewController
- (void)dealloc{
    [[NSNotificationCenter defaultCenter] removeObserver:self];
}
- (void)viewDidLoad {
    [super viewDidLoad];
     [[NSNotificationCenter defaultCenter] addObserver:self selector:@selector(boxValueChanged:) name:UITextFieldTextDidChangeNotification object:nil];
    [self initData];
    [self bulidLayout];
    [self createRefresh];
}

- (void)initData{
    self.dataArr = [NSMutableArray array];
    self.indexArr = [NSMutableArray array];
}

#pragma mark - 布局
- (void)bulidLayout
{
    self.selectTextFiled = [[UITextField alloc] initWithFrame:CGRectMake(20,5,ScreenSize.width - 40,TopMargin -10)];
    self.selectTextFiled.textAlignment = NSTextAlignmentLeft;
    self.selectTextFiled.background = [UIImage imageNamed:@"textFiled"];
    self.selectTextFiled.delegate = self;
    self.selectTextFiled.font = GXF_FIFTEENTEN_SIZE;
    [self.view addSubview:self.selectTextFiled];
    
    UIImageView *leftView = [[UIImageView alloc]initWithFrame:CGRectMake(0, 0, 35, 40)];
    leftView.image = [UIImage imageNamed:@"search"];
    self.selectTextFiled.leftView = leftView;
    self.selectTextFiled.leftViewMode = UITextFieldViewModeAlways;
    
    UIButton *rightView = [UIButton buttonWithType:UIButtonTypeCustom];
    [rightView setImage:[UIImage imageNamed:@"delete"] forState:UIControlStateNormal];
    rightView.frame = CGRectMake(0, 0, 35, 40);
    [rightView addTarget:self action:@selector(deleteTextFieldStr) forControlEvents:UIControlEventTouchUpInside];
    self.selectTextFiled.rightView = rightView;
    self.selectTextFiled.rightViewMode = UITextFieldViewModeAlways;
    
    
    self.tableView = [[UITableView alloc]initWithFrame:(CGRectMake(0, TopMargin,ScreenSize.width, ScreenSize.height - 64 - TopMargin)) style:(UITableViewStylePlain)];
    self.tableView.backgroundColor = [UIColor whiteColor];
    self.tableView.delegate = self;
    self.tableView.dataSource = self;
    [self.view addSubview:self.tableView];
    
    
    UIBarButtonItem *rightItem = [[UIBarButtonItem alloc]initWithTitle:@"确定" style:UIBarButtonItemStylePlain target:self action:@selector(sureClick)];
    self.navigationItem.rightBarButtonItem = rightItem;
}

- (void)createRefresh{
    self.tableView.header = [MJRefreshNormalHeader headerWithRefreshingBlock:^{
        if (self.isRefresh) {
            return ;
        }
        self.isRefresh = YES;
        [self getBaseDataFromServer];
    }];
}

#pragma mark - 协议方法
- (NSInteger)numberOfSectionsInTableView:(UITableView *)tableView {
    return 1;
}
- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section {
    return self.dataArr.count;
}
- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath {
    static NSString *cellID = @"cellID";
    UITableViewCell *cell = [tableView dequeueReusableCellWithIdentifier:cellID];
    return cell;
}

- (CGFloat)tableView:(UITableView *)tableView heightForRowAtIndexPath:(NSIndexPath *)indexPath{
    return TableHeight;
}
- (void)keyboardHidden{
    [self.selectTextFiled resignFirstResponder];
}
- (void)deleteTextFieldStr{
    self.selectTextFiled.text = @"";
}
#pragma mark - 结束刷新
- (void)endRefreshing{
    self.isRefresh = NO;
    [self.tableView.header endRefreshing];
}

- (BOOL)isHaveIndexPath:(NSIndexPath *)indexPath{
    for (NSIndexPath *path in self.indexArr) {
        if (path.row == indexPath.row) {
            return YES;
        }
    }
    return NO;
}

#pragma mark -childFunction
-(void)getBaseDataFromServer
{
}
- (void)sureClick
{
}
- (void)boxValueChanged:(NSNotification *)fication
{
}
- (void)didReceiveMemoryWarning {
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}

/*
#pragma mark - Navigation

// In a storyboard-based application, you will often want to do a little preparation before navigation
- (void)prepareForSegue:(UIStoryboardSegue *)segue sender:(id)sender {
    // Get the new view controller using [segue destinationViewController].
    // Pass the selected object to the new view controller.
}
*/

@end
