//
//  VankeSettingsBoard_iPhone.m
//  vanke
//
//  Created by xiaomi on 15/8/3.
//  Copyright (c) 2015年 Reese. All rights reserved.
//

#import "VankeSettingsBoard_iPhone.h"
#import "GEToast.h"
#import "AppDelegate.h"
#import "VankeCommonModel.h"

#define TAG_ACTION_SHEET_EXIT 0

@interface VankeSettingsBoard_iPhone()

@property UITableView *tableView;

@end


@implementation VankeSettingsBoard_iPhone

DEF_NOTIFICATION( SUCC_LOGOUT )

- (id)initWithNibName:(NSString *)nibNameOrNil bundle:(NSBundle *)nibBundleOrNil
{
    self = [super initWithNibName:nibNameOrNil bundle:nibBundleOrNil];
    if (self) {
        // Custom initialization
    }
    return self;
}


#pragma mark - Signal

ON_CREATE_VIEWS( signal )
{
    self.navigationBarShown = YES;
    self.navigationBarTitle = @"我";
    
    UIColor *color = [UIColor colorWithRed:237/255.0 green:27/255.0 blue:35/255.0 alpha:1.0];
    if ( IOS7_OR_LATER ) {
        self.navigationController.navigationBar.barTintColor = color;
    } else {
        self.navigationController.navigationBar.tintColor = color;
    }
    
    UIView *topPlaceholder = [[UIView alloc] initWithFrame:CGRectMake(0, 0, 0, 0)];
    [self.view addSubview:topPlaceholder];
    
    self.tableView = [[UITableView alloc] initWithFrame:CGRectMake(0, 20, self.width, self.height)];
    _tableView.delegate = self;
    _tableView.dataSource = self;
    [self.view addSubview:_tableView];
    
    [_tableView reloadData];
    [self RELAYOUT];
}

ON_DELETE_VIEWS( signal )
{
}

ON_LAYOUT_VIEWS( signal )
{
}

ON_WILL_APPEAR( signal )
{
    self.navigationBarShown = YES;
}

ON_DID_APPEAR( signal )
{
}

ON_WILL_DISAPPEAR( signal )
{
}

ON_DID_DISAPPEAR( signal )
{
}

#pragma mark ===tableview===
-(NSInteger)numberOfSectionsInTableView:(UITableView *)tableView
{
    return 3;
}

-(NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section
{
    switch (section) {
        case 0:
            return 2;
            break;
        case 1:
            return 3;
            break;
        case 2:
            return 1;
            break;
        default:
            return 0;
            break;
    }
}

-(UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath
{
    static NSString * identifier=@"infoCell";
    UITableViewCell *cell=[tableView dequeueReusableCellWithIdentifier:identifier];
    if (!cell) {
        if (indexPath.section == 2) {
            cell=[[UITableViewCell alloc]initWithStyle:UITableViewCellStyleDefault reuseIdentifier:identifier];
        } else {
            cell=[[UITableViewCell alloc]initWithStyle:UITableViewCellStyleValue1 reuseIdentifier:identifier];
        }
    }
    
    [cell.detailTextLabel setNumberOfLines:6];
    [cell.detailTextLabel setText:@""];
    [cell.detailTextLabel setFont:[UIFont systemFontOfSize:12]];
    [cell setAccessoryType:UITableViewCellAccessoryNone];
    
    VankeCommonModel *userModel = [VankeCommonModel sharedInstance];
    User *user = [userModel currentUser];
    Enterpirse *ent = [userModel currentEnterprise];
    
    switch (indexPath.section) {
        case 0:
            switch (indexPath.row) {
                case 0:
                    if (nil != user) {
                        [cell.textLabel setText:@"当前用户"];
                        [cell.detailTextLabel setText:user.name];
                    }
                    break;
                case 1:
                    if (nil != ent) {
                        [cell.textLabel setText:@"所属企业"];
                        [cell.detailTextLabel setText:ent.name];
                    }
                    break;
                default:
                    break;
            }
            break;
        case 1:
            switch (indexPath.row) {
                case 0:
                    [cell.textLabel setText:@"当前版本"];
                    [cell.detailTextLabel setText:@"1.0.1"];
                    break;
                case 1:
                    [cell.textLabel setText:@"关于万科"];
                    [cell setAccessoryType:UITableViewCellAccessoryDisclosureIndicator];
                    break;
                case 2:
                    [cell.textLabel setText:@"修改密码"];
                    [cell setAccessoryType:UITableViewCellAccessoryDisclosureIndicator];
                    break;
                default:
                    break;
            }
            break;
        case 2:
            [cell.textLabel setText:@"退出登录"];
            [cell.textLabel setTextColor:[UIColor colorWithRed:237/255.0 green:27/255.0 blue:35/255.0 alpha:1.0]];
            [cell.textLabel setTextAlignment:NSTextAlignmentCenter];
            [cell setAccessoryType:UITableViewCellAccessoryNone];
            break;
        default:
            break;
    }
    
    return cell;
}

-(void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath
{
    switch (indexPath.section) {
        case 0:
            break;
        case 1:
            switch (indexPath.row) {
                case 2:
                    // 修改密码
                    break;
                default:
                    break;
            }
            break;
        case 2:
            [self confirmToLogout];
            break;
        default:
            break;
    }
}

-(CGFloat)tableView:(UITableView *)tableView heightForRowAtIndexPath:(NSIndexPath *)indexPath
{
    //        if (indexPath.section==0 && indexPath.row==0) {
    //            return 80;
    //        }else
    return 45;
}

-(void) confirmToLogout {
    UIActionSheet *as=[[UIActionSheet alloc]initWithTitle:nil delegate:self cancelButtonTitle:@"取消" destructiveButtonTitle:@"退出登录" otherButtonTitles:@"退出应用", nil ];
    as.tag = TAG_ACTION_SHEET_EXIT;
    [as showInView:self.view];
}

-(void) doLogout {
    // 删除当前用户
    VankeCommonModel *userModel = [VankeCommonModel sharedInstance];
    [userModel removeCurrentUser];
    [self postNotification:self.SUCC_LOGOUT];
}

- (void)exitApplication {
    AppDelegate *app = [UIApplication sharedApplication].delegate;
    UIWindow *window = app.window;
    
    [UIView animateWithDuration:1.0f animations:^{
        window.alpha = 0;
        window.frame = CGRectMake(0, window.bounds.size.width, 0, 0);
    } completion:^(BOOL finished) {
        exit(0);
    }];
    //exit(0);
}

#pragma mark ----------ActionSheet 按钮点击-------------
-(void)actionSheet:(UIActionSheet *)actionSheet clickedButtonAtIndex:(NSInteger)buttonIndex
{
    if (actionSheet.tag == TAG_ACTION_SHEET_EXIT) {
        if (buttonIndex == 0) {
            [self doLogout];
        } else if (buttonIndex == 1) {
            [self exitApplication];
        }
    }
}

-(void) processGenderSelection: (UIActionSheet *)actionSheet clickedButtonAtIndex:(NSInteger)buttonIndex {
}

- (CGFloat)tableView:(UITableView *)tableView heightForHeaderInSection:(NSInteger)section {
    if (section > 0) {
        return 20;
    } else {
        return 40;
    }
}

- (CGFloat)tableView:(UITableView *)tableView heightForFooterInSection:(NSInteger)section {
    return 1;
}

- (UIView *)tableView:(UITableView *)tableView viewForHeaderInSection:(NSInteger)section {
    UIView *view=[[UIView alloc] initWithFrame:CGRectZero];
    return view;
}

- (UIView *)tableView:(UITableView *)tableView viewForFooterInSection:(NSInteger)section {
    UIView *view=[[UIView alloc] initWithFrame:CGRectZero];
    return view;
}

@end