

#import "VankePassengerDetailBoard_iPhone.h"
#import "PullLoader.h"
#import "FootLoader.h"
#import "VankeBusinessChartCell_iPhone.h"
#import "VankeFloorDetailBoardPhoto_iPhone.h"

#pragma mark - VankePassengerDetailBoard_iPhone

@interface VankePassengerDetailBoard_iPhone ()
AS_SIGNAL( VIEW_PROFILE )
AS_SIGNAL( VIEW_URL )
@end

#pragma mark -

@implementation VankePassengerDetailBoard_iPhone

@synthesize data = _data;
@synthesize passengerFlowDate = _passengerFlowDate;

SUPPORT_AUTOMATIC_LAYOUT( YES );
SUPPORT_RESOURCE_LOADING( YES );

DEF_SIGNAL( VIEW_PROFILE )
DEF_SIGNAL( VIEW_URL )

DEF_MODEL( VankePassengerFlowModel,        passengerFlowModel );

DEF_OUTLET( BeeUIScrollView,    list );

- (void)load
{
    self.passengerFlowModel = [VankePassengerFlowModel modelWithObserver:self];
}

- (void)unload
{
    [self.passengerFlowModel removeAllObservers];
    self.passengerFlowModel = nil;
}

#pragma mark -

ON_CREATE_VIEWS( signal )
{
    self.view.backgroundColor = [UIColor whiteColor];
    
    //	self.allowedSwipeToBack = YES;
    
    self.navigationBarShown = YES;
    self.navigationBarTitle = self.data.projectName;
    self.navigationBarLeft  = [UIImage imageNamed:@"left_arrow"];
    
    self.list.headerClass = [PullLoader class];
    self.list.headerShown = YES;
    
    self.list.footerClass = [FootLoader class];
    self.list.footerShown = YES;
    
    self.list.lineCount = 1;
    self.list.vertical = YES;
    self.list.animationDuration = 0.25f;
    self.list.baseInsets = bee.ui.config.baseInsets;
    
    self.list.whenReloading = ^
    {
        NSInteger chartTotal = 0;
        PassengerFlowResponse *resp = [_passengerFlowModel getServerResp];
        if (nil != resp) {
            chartTotal = [resp dataCount];
        }
        self.list.total = 1 + chartTotal;
        
        BeeUIScrollItem * photo = self.list.items[0];
        photo.clazz = [VankeFloorDetailBoardPhoto_iPhone class];
        self.data.salesDate = self.passengerFlowDate;
        photo.data = self.data;
        photo.order = 0;
        photo.size = CGSizeMake(0, 230);
        
        for (int i = 0; i < chartTotal; ++i) {
            BeeUIScrollItem *bizChart = self.list.items[i + 1];
            bizChart.clazz = [VankeBusinessChartCell_iPhone class];
            
            // 取值
            ChartValue *cv = [[ChartValue alloc] init];
            cv.name = @"楼层";
            cv.values = [resp getChartValues];
            cv.theme = self.theme;
            bizChart.data = cv;
            
            bizChart.order = 0;
            bizChart.size = CGSizeMake(0, 250);
        }
    };
    
    self.list.whenHeaderRefresh = ^
    {
        [self reloadSalesolumeModel];
    };
    
    self.list.whenFooterRefresh = ^
    {
        [self reloadSalesolumeModel];
    };
    
    self.list.whenReachBottom = ^
    {
        [self reloadSalesolumeModel];
    };
}

ON_DELETE_VIEWS( signal )
{
}

ON_LAYOUT_VIEWS( signal )
{
}

ON_WILL_APPEAR( signal )
{
    [self.passengerFlowModel reload];
    [self.list reloadData];
}

ON_DID_APPEAR( signal )
{
}

ON_WILL_DISAPPEAR( signal )
{
}

ON_DID_DISAPPEAR( signal )
{
}

#pragma mark -

ON_SIGNAL3( VankeSaleVolumeModel, RELOADING, signal )
{
    self.list.headerLoading = self.passengerFlowModel.loaded;
    self.list.footerLoading = YES;
}

ON_SIGNAL3( VankeSaleVolumeModel, RELOADED, signal )
{
    self.list.headerLoading = NO;
    self.list.footerLoading = NO;
    self.list.footerMore = NO;
    [self.list reloadData];
}

-(void) reloadSalesolumeModel {
    self.passengerFlowModel.projectEquals = self.data.projectId;
    self.passengerFlowModel.passengerFlowDateEquals = self.passengerFlowDate;
    [self.passengerFlowModel reload];
}

@end
