

#import "VankeServiceDashBoard_iPhone.h"

#pragma mark -

@interface VankeServiceDashBoard_iPhone ()
{
}
@end

@implementation VankeServiceDashBoard_iPhone

SUPPORT_AUTOMATIC_LAYOUT( YES )
SUPPORT_RESOURCE_LOADING( YES )

DEF_OUTLET( VankeServiceSaleCell_iPhone, salesInfo );
DEF_OUTLET( VankeServiceBoardCell_iPhone, passenger );
DEF_OUTLET( VankeServiceBoardCell_iPhone, traffic );
DEF_OUTLET( VankeServiceBoardCell_iPhone, energy );
DEF_OUTLET( VankeServiceBoardCell_iPhone, complaint );

@synthesize name = _name;
@synthesize theme = _theme;

+ (id) communityDashBarod {
    VankeServiceDashBoard_iPhone *board = [super cell];
    board.name = @"社区2049";
    board.theme = @"red";
    return board;
}

+ (id) centerDashBarod {
    VankeServiceDashBoard_iPhone *board = [super cell];
    board.name = @"万科中心";
    board.theme = @"purple";
    return board;
}

+ (id) squreDashBarod {
    VankeServiceDashBoard_iPhone *board = [super cell];
    board.name = @"万科广场";
    board.theme = @"orange";
    return board;
}

- (void)load
{
    self.salesInfo.imgRightBg.backgroundColor = [UIColor colorWithRed:237/255.0 green:27/255.0 blue:35/255.0 alpha:1];
    
    self.passenger.imgIcon.data = @"people.png";
    self.passenger.lblTitle.data = @"当前客流";
    self.passenger.imgBg.backgroundColor = [UIColor colorWithRed:0 green:195/255.0 blue:230/255.0 alpha:1];
    self.passenger.lblAmountUnit.data = @"人";
    
    self.traffic.imgIcon.data = @"car.png";
    self.traffic.lblTitle.data = @"当前车流";
    self.traffic.imgBg.backgroundColor = [UIColor colorWithRed:79/255.0 green:143/255.0 blue:248/255.0 alpha:1];
    //    self.traffic.lblAmountUnit.data = @"次";
    [self.traffic asNotAvailableCell];
    
    self.energy.imgIcon.data = @"energy.png";
    self.energy.lblTitle.data = @"能耗";
    self.energy.imgBg.backgroundColor = [UIColor colorWithRed:149/255.0 green:200/255.0 blue:8/255.0 alpha:1];
    //    self.energy.lblAmountUnit.data = @"正在研发中...";
    //    self.energy.lblAmount.data = @" ";
    [self.energy asNotAvailableCell];
    
    self.complaint.imgIcon.data = @"complaint.png";
    self.complaint.lblTitle.data = @"投诉";
    self.complaint.imgBg.backgroundColor = [UIColor colorWithRed:252/255.0 green:67/255.0 blue:62/255.0 alpha:1];
    //    self.complaint.lblAmountUnit.data = @"正在研发中...";
    //    self.complaint.lblAmount.data = @" ";
    [self.complaint asNotAvailableCell];
}

- (void)unload
{
}

- (BOOL)dataWillChange:(id)newData {
    return self.data != newData;
}

- (void) dataDidChanged {
    ProjectSummary *summary = self.data;
    if (nil != summary) {
        [self.salesInfo setData:summary.salesAmount];
        [self.passenger setData:summary.passengerFlowVolume];
        //        [self.traffic setData:summary.trafficVolume];
    }
}

-(void) setTheme:(NSString *)theme {
    _theme = theme;
    [self.salesInfo setTheme: theme];
}

@end
