

#import "VankeMainBoard_iPhone.h"
#import "VankeFloorListBoard_iPhone.h"
#import "VankeFloorListBoardCell_iPhone.h"
#import "VankeServiceDashBoard_iPhone.h"
#import "VankeAppBoard_iPhone.h"
#import "VankeUtil.h"
#import "GEToast.h"

@interface VankeMainBoard_iPhone ()
@property (strong, nonatomic) VankeServiceDashBoard_iPhone *communityDashBoard;
@property (strong, nonatomic) VankeServiceDashBoard_iPhone *centerDashBoard;
@property (strong, nonatomic) VankeServiceDashBoard_iPhone *squreDashBoard;
@property (strong, nonatomic) VankeServiceDashBoard_iPhone *currDashBoard;
@end

#pragma mark -

@interface VankeMainBoard_iPhone ()
{
    NSInteger _curTopMenuIndex;
}
@end

@implementation VankeMainBoard_iPhone

SUPPORT_AUTOMATIC_LAYOUT( YES )
SUPPORT_RESOURCE_LOADING( YES )

DEF_OUTLET( VankeWeatherCell_iPhone, weatherBoard );
DEF_OUTLET( VankeTopMenuBoardCell_iPhone, topMenu );
DEF_OUTLET( BeeUIView, serviceDashBoardView );
DEF_OUTLET( BeeUITextField, txtQuery);

DEF_MODEL( VankeProjectSummaryModel, summaryModel );

- (void)load
{
    _curTopMenuIndex = 0;
    self.summaryModel = [VankeProjectSummaryModel modelWithObserver:self];
}

- (void)unload
{
    self.summaryModel = nil;
}

#pragma mark - Signal

ON_CREATE_VIEWS( signal )
{
    self.view.backgroundColor = [UIColor whiteColor];
    [self addLeftIconToTextField:_txtQuery icon:@"search"];
    [_weatherBoard reloadLocationAndWeather];
}

ON_DELETE_VIEWS( signal )
{
}

ON_LAYOUT_VIEWS( signal )
{
    // 如果没有设置当前tab，则默认为第一页
    if (nil == _currDashBoard) {
        [self showCommunityDashBoard];
    }
}

ON_WILL_APPEAR( signal )
{
    [BeeUIRouter sharedInstance].view.pannable = YES;
    self.navigationBarShown = NO;
    [[VankeAppBoard_iPhone sharedInstance] showMenu];
}

ON_DID_APPEAR( signal )
{
}

ON_WILL_DISAPPEAR( signal )
{
    [BeeUIRouter sharedInstance].view.pannable = NO;
}

ON_DID_DISAPPEAR( signal )
{
}

ON_SIGNAL3( VankeMainBoard_iPhone, txtQuery, signal )
{
    if ([signal is:BeeUITextField.RETURN]) {
        [self showFloorListView];
    }
}

#pragma VankeWeatherCell_iPhone

ON_SIGNAL3( VankeWeatherCell_iPhone, btnMask, signal )
{
    [_weatherBoard reloadLocationAndWeather: YES];
}

#pragma VankeTopMenuBoardCell_iPhone

ON_SIGNAL3( VankeTopMenuBoardCell_iPhone, menuCommunity, signal ) {
    [self.topMenu selectCommunity];
    [self showCommunityDashBoard];
}

ON_SIGNAL3( VankeTopMenuBoardCell_iPhone, menuCenter, signal ) {
    [self.topMenu selectCenter];
    [self showCenterDashBoard];
}

ON_SIGNAL3( VankeTopMenuBoardCell_iPhone, menuSqure, signal ) {
    [self.topMenu selectSqure];
    [self showSqureDashBoard];
}

#pragma mark - VankeServiceSaleCell_iPhone

ON_SIGNAL3( VankeServiceSaleCell_iPhone, mask, signal ) {
    [[VankeAppBoard_iPhone sharedInstance] hideMenu];
    [self showFloorListView];
}

#pragma mark - VankeProjectSummaryModel

ON_SIGNAL3(VankeProjectSummaryModel, RELOADING, signal) {
    
}

ON_SIGNAL3(VankeProjectSummaryModel, RELOADED, signal) {
    if (![_summaryModel isOk]) {
        [GEToast showWithText:[_summaryModel getMessage] bottomOffset:20 duration:1.0f];
        return;
    }
    
    if (nil != _currDashBoard) {
        ProjectSummary *data = [[_summaryModel getServerResp] getSummary:_currDashBoard.name];
        if (nil != data) {
            [_currDashBoard setData:data];
        }
    }
}

-(void) addLeftIconToTextField: (BeeUITextField*) textField icon: (NSString*) icon {
    UIImageView *img = [[UIImageView alloc] initWithImage:[UIImage imageNamed:icon]];
    img.frame = CGRectMake(0, 0, 30, 25);
    img.contentMode = UIViewContentModeCenter;
    textField.leftView = img;
    textField.leftViewMode = UITextFieldViewModeAlways;
}

-(void) showCommunityDashBoard {
    _curTopMenuIndex = 0;
    
    if (self.currDashBoard != nil && self.currDashBoard == self.communityDashBoard) {
        return;
    }
    
    CGRect frame = self.serviceDashBoardView.frame;
    if (frame.size.width <= 0) {
        return;
    }
    
    if (self.communityDashBoard == nil) {
        self.communityDashBoard = [VankeServiceDashBoard_iPhone communityDashBarod];
    }
    
    if (self.currDashBoard != nil) {
        self.currDashBoard.frame = CGRectMake(0, 0, 0, 0);
        [self.currDashBoard removeFromSuperview];
    }
    
    [self.serviceDashBoardView addSubview:self.communityDashBoard];
    [UIView animateWithDuration:0.25  animations:^{
        self.communityDashBoard.frame = CGRectMake(0, 0, frame.size.width, frame.size.height);
        self.currDashBoard = self.communityDashBoard;
        [self RELAYOUT];
    }];
    
    // 刷新数据
    [_summaryModel reload];
}

-(void) showCenterDashBoard {
    _curTopMenuIndex = 1;
    
    if (self.currDashBoard != nil && self.currDashBoard == self.centerDashBoard) {
        return;
    }
    
    CGRect frame = self.serviceDashBoardView.frame;
    if (frame.size.width <= 0) {
        return;
    }
    
    if (self.centerDashBoard == nil) {
        self.centerDashBoard = [VankeServiceDashBoard_iPhone centerDashBarod];
    }
    
    if (self.currDashBoard != nil) {
        self.currDashBoard.frame = CGRectMake(0, 0, 0, 0);
        [self.currDashBoard removeFromSuperview];
    }
    
    [self.serviceDashBoardView addSubview:self.centerDashBoard];
    [UIView animateWithDuration:0.25  animations:^{
        self.centerDashBoard.frame = CGRectMake(0, 0, frame.size.width, frame.size.height);
        self.currDashBoard = self.centerDashBoard;
        [self RELAYOUT];
    }];
    
    // 刷新数据
    [_summaryModel reload];
}


-(void) showSqureDashBoard {
    _curTopMenuIndex = 2;
    
    if (self.currDashBoard != nil && self.currDashBoard == self.squreDashBoard) {
        return;
    }
    
    CGRect frame = self.serviceDashBoardView.frame;
    if (frame.size.width <= 0) {
        return;
    }
    
    if (self.squreDashBoard == nil) {
        self.squreDashBoard = [VankeServiceDashBoard_iPhone squreDashBarod];
    }
    
    if (self.currDashBoard != nil) {
        self.currDashBoard.frame = CGRectMake(0, 0, 0, 0);
        [self.currDashBoard removeFromSuperview];
    }
    
    [self.serviceDashBoardView addSubview:self.squreDashBoard];
    [UIView animateWithDuration:0.25  animations:^{
        self.squreDashBoard.frame = CGRectMake(0, 0, frame.size.width, frame.size.height);
        self.currDashBoard = self.squreDashBoard;
        [self RELAYOUT];
    }];
    
    // 刷新数据
    [_summaryModel reload];
}

-(void) showFloorListView {
    VankeFloorListBoard_iPhone * board = [VankeFloorListBoard_iPhone board];
    if (nil != _currDashBoard) {
        board.projectCategory = _currDashBoard.name;
        board.salesDate = _summaryModel.salesDate;
        board.theme = _currDashBoard.theme;
        
        NSString *nameLike = [VankeUtil trim:$(self.txtQuery).data];
        board.projectNameLike = nameLike;
    }
    [self.stack pushBoard:board animated:YES transition:bee.ui.transitionFade];
}

@end
