

#import "VankeFloorListBoardCell_iPhone.h"
#import "VankeUtil.h"

#pragma mark -

@implementation VankeFloorListBoardCell_iPhone

SUPPORT_RESOURCE_LOADING(YES)
SUPPORT_AUTOMATIC_LAYOUT(YES)

DEF_OUTLET( BeeUIImageView,	imgPhoto )
DEF_OUTLET( BeeUILabel,		lblName )
DEF_OUTLET( BeeUILabel,		lblOpenDate )
DEF_OUTLET( BeeUILabel,		lblSaleAmount )
DEF_OUTLET( BeeUILabel,		lblPassenger )
DEF_OUTLET( BeeUILabel,		lblPrice )

- (BOOL)dataWillChange:(id)newData
{
	return newData != self.data;
}

- (void)dataDidChanged
{
	FloorCellValue * obj = self.data;
    if (nil == obj) {
        return;
    }
    
//    $(self.lblSaleAmount).SET_CLASS(obj.theme);
    $(self.lblSaleAmount).ADD_CLASS(obj.theme);
    
    ProjectCategory *prj = obj.project;
	if ( prj )
	{
        self.lblName.data = prj.projectName;
        self.imgPhoto.data = [prj getPictureUrlOrDefault];
        self.lblOpenDate.data = prj.foundingDate;
        self.lblSaleAmount.data = prj.salesAmount;
        self.lblPassenger.data = prj.passengerFlowVolume;
        self.lblPrice.data = prj.perCustomerTransaction;
	}
}

@end

#pragma mark - FloorCellValue

@implementation FloorCellValue

@synthesize theme = _theme;
@synthesize project = _project;

@end


