

#import "VankeFloorDetailBoard_iPhone.h"
//#import "DribbbleDetailBoardPlayer_iPhone.h"
#import "VankeFloorDetailBoardPhoto_iPhone.h"
//#import "DribbbleDetailBoardComment_iPhone.h"
//#import "DribbblePreviewBoard_iPhone.h"
//#import "DribbbleProfileBoard_iPhone.h"
//#import "DribbbleWebBoard_iPhone.h"
#import "PullLoader.h"
#import "FootLoader.h"
#import "VankeBusinessChartCell_iPhone.h"

#pragma mark - VankeFloorDetailBoard_iPhone

@interface VankeFloorDetailBoard_iPhone()
AS_SIGNAL( VIEW_PROFILE )
AS_SIGNAL( VIEW_URL )
@end

#pragma mark -

@implementation VankeFloorDetailBoard_iPhone

@synthesize data = _data;
@synthesize salesDate = _salesDate;

SUPPORT_AUTOMATIC_LAYOUT( YES );
SUPPORT_RESOURCE_LOADING( YES );

DEF_SIGNAL( VIEW_PROFILE )
DEF_SIGNAL( VIEW_URL )

//DEF_MODEL( ShotInfoModel,		info );
//DEF_MODEL( ShotCommentsModel,	comments );
DEF_MODEL( VankeSaleVolumeModel,	saleVolumeModel );

DEF_OUTLET( BeeUIScrollView,	list );

- (void)load
{
//	self.info = [ShotInfoModel modelWithObserver:self];
//	self.comments = [ShotCommentsModel modelWithObserver:self];
    self.saleVolumeModel = [VankeSaleVolumeModel modelWithObserver:self];
}

- (void)unload
{
//	[self.comments removeAllObservers];
//	self.comments = nil;
//	
//	[self.info removeAllObservers];
//	self.info = nil;
    [self.saleVolumeModel removeAllObservers];
    self.saleVolumeModel = nil;
}

#pragma mark -

ON_CREATE_VIEWS( signal )
{
//	self.view.backgroundColor = SHORT_RGB( 0x444 );
    self.view.backgroundColor = [UIColor whiteColor];

//	self.allowedSwipeToBack = YES;
	
	self.navigationBarShown = YES;
	self.navigationBarTitle = self.data.projectName;
	self.navigationBarLeft  = [UIImage imageNamed:@"left_arrow"];

	self.list.headerClass = [PullLoader class];
	self.list.headerShown = YES;
	
	self.list.footerClass = [FootLoader class];
	self.list.footerShown = YES;

	self.list.lineCount = 1;
	self.list.vertical = YES;
	self.list.animationDuration = 0.25f;
	self.list.baseInsets = bee.ui.config.baseInsets;
	
	self.list.whenReloading = ^
	{
        int chartTotal = 0;
        ProjectSaleVolumeResponse *resp = [_saleVolumeModel getServerResp];
        NSArray *dimensions = nil;
        if (nil != resp) {
            dimensions = [resp getSortedDimensions];
            chartTotal = [dimensions count];
        }
        
        self.list.total = 1 + chartTotal;

		BeeUIScrollItem * photo = self.list.items[0];
		photo.clazz = [VankeFloorDetailBoardPhoto_iPhone class];
		photo.data = self.data;
		photo.order = 0;
        photo.size = CGSizeMake(0, 230);
        
        for (int i = 0; i < chartTotal; ++i) {
            BeeUIScrollItem *bizChart = self.list.items[i + 1];
            bizChart.clazz = [VankeBusinessChartCell_iPhone class];
            
            // 取值
            ChartValue *cv = [[ChartValue alloc] init];
            NSString *dimension = [dimensions objectAtIndex:i];
            cv.name = dimension;
            cv.values = [resp getSalesInfo:dimension];
            cv.theme = self.theme;
            bizChart.data = cv;
            
            bizChart.order = 0;
            bizChart.size = CGSizeMake(0, 250);
        }
	};
	
	self.list.whenHeaderRefresh = ^
	{
        [self reloadSalesolumeModel];
	};
	
	self.list.whenFooterRefresh = ^
	{
        [self reloadSalesolumeModel];
	};
	
	self.list.whenReachBottom = ^
	{
        [self reloadSalesolumeModel];
	};
}

ON_DELETE_VIEWS( signal )
{
}

ON_LAYOUT_VIEWS( signal )
{
}

ON_WILL_APPEAR( signal )
{
//	if ( NO == self.info.loaded )
//	{
//		[self.info reload];
//	}
//
//	if ( NO == self.comments.loaded )
//	{
//		[self.comments firstPage];
//	}
    
    [self.saleVolumeModel reload];
    [self.list reloadData];
}

ON_DID_APPEAR( signal )
{
}

ON_WILL_DISAPPEAR( signal )
{
}

ON_DID_DISAPPEAR( signal )
{
}

#pragma mark -

ON_RIGHT_BUTTON_TOUCHED( signal )
{
}

#pragma mark -

ON_SIGNAL3( DribbbleDetailBoardPlayer_iPhone, mask, signal )
{
//	DribbbleProfileBoard_iPhone * board = [DribbbleProfileBoard_iPhone board];
//	board.player = self.info.shot.player;
//	[self.stack pushBoard:board animated:YES];
}

#pragma mark -

ON_SIGNAL3( VankeFloorDetailBoardPhoto_iPhone, mask, signal )
{
//	DribbblePreviewBoard_iPhone * board = [DribbblePreviewBoard_iPhone board];
//	board.shot = self.info.shot;
//	[self.stack pushBoard:board animated:YES];
}

#pragma mark -

ON_SIGNAL3( DribbbleDetailBoardComment_iPhone, mask, signal )
{
//	COMMENT * comment = signal.sourceCell.data;
//	NSArray * urls = [comment.body allURLs];
//
//	if ( urls.count )
//	{
//		BeeUIActionSheet * actionSheet = [[[BeeUIActionSheet alloc] init] autorelease];
//		
//		[actionSheet addButtonTitle:[NSString stringWithFormat:@"%@", comment.player.name]
//							 signal:self.VIEW_PROFILE
//							 object:comment.player];
//
//		for ( NSString * url in urls )
//		{
//			[actionSheet addButtonTitle:url signal:self.VIEW_URL object:url];
//		}
//
//		[actionSheet addCancelTitle:@"Cancel"];
//		
//		[actionSheet showInViewController:self];
//	}
//	else
//	{
//		DribbbleProfileBoard_iPhone * board = [DribbbleProfileBoard_iPhone board];
//		board.player = comment.player;
//		[self.stack pushBoard:board animated:YES];
//	}
}

#pragma mark -

ON_SIGNAL3( VankeFloorDetailBoard_iPhone, VIEW_PROFILE, signal )
{
//	DribbbleProfileBoard_iPhone * board = [DribbbleProfileBoard_iPhone board];
//	board.player = signal.object;
//	[self.stack pushBoard:board animated:YES];
}

ON_SIGNAL3( VankeFloorDetailBoard_iPhone, VIEW_URL, signal )
{
//	DribbbleWebBoard_iPhone * board = [DribbbleWebBoard_iPhone board];
//	board.url = signal.object;
//	[self.stack pushBoard:board animated:YES];
}

#pragma mark -

ON_SIGNAL3( VankeSaleVolumeModel, RELOADING, signal )
{
	self.list.headerLoading = self.saleVolumeModel.loaded;
	self.list.footerLoading = YES;
}

ON_SIGNAL3( VankeSaleVolumeModel, RELOADED, signal )
{
	self.list.headerLoading = NO;
	self.list.footerLoading = NO;
    self.list.footerMore = NO;
	[self.list reloadData];
}

-(void) reloadSalesolumeModel {
    self.saleVolumeModel.projectEquals = self.data.projectId;
    self.saleVolumeModel.salesDateEquals = self.salesDate;
    [self.saleVolumeModel reload];
}

@end
