
#import <math.h>
#import "PNChart.h"
#import "VankeSaleVolumeAPI.h"
#import "VankeBusinessChartCell_iPhone.h"

#define CHART_DIAMETER 200

#pragma mark -

@implementation VankeBusinessChartCell_iPhone

PNPieChart *chartPieChart;
NSArray *chartColors;

SUPPORT_AUTOMATIC_LAYOUT( YES )
SUPPORT_RESOURCE_LOADING( YES )

- (void)load
{
    [self initChartColors];
}

- (void)unload
{
    chartColors = nil;
    chartPieChart = nil;
}

- (BOOL)dataWillChange:(id)newData
{
    return self.data != newData;
}

- (void)dataDidChanged
{
    ChartValue *data = self.data;
    if (nil == data) {
        return;
    }
    
    $(self.lblChartTitle).DATA(data.name);
    $(self.lblChartTitle).ADD_CLASS(data.theme);
    if (nil != chartPieChart) {
        [chartPieChart updateChartData:[self getChartItems]];
    }
}


- (void)layoutDidFinish
{
    [self drawPieChart];
}

- (void) drawPieChart {
    chartPieChart = [[PNPieChart alloc] initWithFrame:CGRectMake((self.width - CHART_DIAMETER)/2.0, 0, CHART_DIAMETER, CHART_DIAMETER) items:[self getChartItems]];
    chartPieChart.descriptionTextColor = [UIColor blackColor];
    chartPieChart.descriptionTextFont  = [UIFont fontWithName:@"微软雅黑" size:12.0];
    chartPieChart.descriptionTextShadowColor = [UIColor clearColor];
    chartPieChart.showAbsoluteValues = NO;
    chartPieChart.showOnlyValues = NO;
    [chartPieChart strokeChart];
    [self.chartView addSubview:chartPieChart];
}

-(NSArray*) getChartItems {
    NSMutableArray *items = [[NSMutableArray alloc] init];
    if (nil == self.data) {
        return items;
    }
    
    ChartValue *data = self.data;
    NSInteger colorLen = [chartColors count];
    
    for (NSInteger i = 0; i < [data.values count]; ++i) {
        ProjectSaleVolume *obj = [data.values objectAtIndex:i];
        UIColor *color = [chartColors objectAtIndex:i % colorLen];
        float itemValue = [obj.amount floatValue];
        NSString *itemDesc = obj.dimensionValue;
        [items addObject:[PNPieChartDataItem dataItemWithValue:itemValue color:color description:itemDesc]];
    }
    //    [data.values enumerateObjectsUsingBlock:^(ProjectSaleVolume *obj, NSUInteger idx, BOOL * _Nonnull stop) {
    //        UIColor *color = [chartColors objectAtIndex:idx % colorLen];
    //        float itemValue = [obj.amount floatValue];
    //        NSString *itemDesc = obj.dimensionValue;
    //        [items addObject:[PNPieChartDataItem dataItemWithValue:itemValue color:color description:itemDesc]];
    //    }];
    return items;
}

-(void) initChartColors {
    chartColors = @[PNYellow, PNBlue, PNTwitterColor, PNLightBlue, PNPinkDark, PNGreen, PNTitleColor,PNLightGreen, PNFreshGreen, PNDeepGreen, PNRed, PNMauve, PNBrown,  PNStarYellow, PNDarkBlue,  PNDeepGrey, PNPinkGrey, PNLightGrey, PNCleanGrey, PNDarkYellow, PNCloudWhite, PNBlack, PNiOSGreenColor];
}

@end


@implementation ChartValue

@synthesize theme = _theme;
@synthesize name = _name;
@synthesize values = _values;

@end
