//
//  VankeUtil.m
//  vanke
//
//  Created by xiaomi on 15/10/5.
//  Copyright © 2015年 gomore. All rights reserved.
//

#import <Foundation/Foundation.h>
#import <CocoaSecurity.h>
#import "VankeUtil.h"

@implementation VankeUtil

DEF_SINGLETON(VankeUtil)

+ (NSDictionary*) getConfigDict {
    NSString *plistPath = [[NSBundle mainBundle] pathForResource:@"Info" ofType:@"plist"];
    NSDictionary *dict = [[NSDictionary alloc] initWithContentsOfFile:plistPath];
    return dict;
}

+ (NSString*) getConfigValue: (NSString*) key {
    NSDictionary *dict = [self getConfigDict];
    return [dict objectForKey:key];
}

+ (NSString*) trim: (NSString*) str {
    NSString *cleanString = [str stringByTrimmingCharactersInSet:[NSCharacterSet whitespaceAndNewlineCharacterSet]];
    return cleanString;
}

+ (BOOL) isBlankString:(NSString*) string {
    if (string == nil || string == NULL) {
        return YES;
    }
    if ([string isKindOfClass:[NSNull class]]) {
        return YES;
    }
    if ([[VankeUtil trim:string] length]==0) {
        return YES;
    }
    return NO;
}

+ (NSString*) md5: (NSString*) src {
    CocoaSecurityResult *md5 = [CocoaSecurity md5:src];
    return md5.hexLower;
}

+ (NSString*) base64: (NSString*) src {
    CocoaSecurityEncoder *encoder = [CocoaSecurityEncoder new];
    return [encoder base64:[src dataUsingEncoding:NSUTF8StringEncoding]];
}

+ (NSString*)dictToJsonString:(id)object {
    NSString *jsonString = nil;
    NSError *error;
    NSData *jsonData = [NSJSONSerialization dataWithJSONObject:object options:0 error:&error];
    if (!jsonData) {
        NSLog(@"Got an error: %@", error);
    } else {
        jsonString = [[NSString alloc] initWithData:jsonData encoding:NSUTF8StringEncoding];
    }
    return jsonString;
}

+ (UIColor *)colorWithHexString:(NSString *)stringToConvert {
    NSString *noHashString = [stringToConvert stringByReplacingOccurrencesOfString:@"#" withString:@""];
    NSScanner *scanner = [NSScanner scannerWithString:noHashString];
    [scanner setCharactersToBeSkipped:[NSCharacterSet symbolCharacterSet]];
    
    unsigned hex;
    if (![scanner scanHexInt:&hex]) return nil;
    int r = (hex >> 16) & 0xFF;
    int g = (hex >> 8) & 0xFF;
    int b = (hex) & 0xFF;
    
    return [UIColor colorWithRed:r / 255.0f green:g / 255.0f blue:b / 255.0f alpha:1.0f];
}

+ (NSString *)hexToRGB:(NSString *)hexString {
    NSString *noHashString = [hexString stringByReplacingOccurrencesOfString:@"#" withString:@""];
    NSScanner *scanner = [NSScanner scannerWithString:noHashString];
    [scanner setCharactersToBeSkipped:[NSCharacterSet symbolCharacterSet]];
    
    unsigned hex;
    if (![scanner scanHexInt:&hex]) return nil;
    int r = (hex >> 16) & 0xFF;
    int g = (hex >> 8) & 0xFF;
    int b = (hex) & 0xFF;
    
    return [NSString stringWithFormat: @"rgb(%d,%d,%d)",r,g,b];
}

+ (UIColor *)rgbStringToColor:(NSString *)rgbString {
    NSArray *items = [rgbString componentsSeparatedByString:@","];
    int i = 0;
    int r = 0;
    int g = 0;
    int b = 0;
    for (NSString *item in items) {
        if (i==0) {
            NSString *rString = [VankeUtil removeAllButNumbers:item];
            r = [rString intValue];
        } else if (i==1) {
            NSString *gString = [VankeUtil removeAllButNumbers:item];
            g = [gString intValue];
        } else if (i==2) {
            NSString *bString = [VankeUtil removeAllButNumbers:item];
            b = [bString intValue];
        }
        i = i + 1;
    }
    return [UIColor colorWithRed:r / 255.0f green:g / 255.0f blue:b / 255.0f alpha:1.0f];
}

+ (NSString *)getHexStringForColor:(UIColor*)color {
    const CGFloat *components = CGColorGetComponents(color.CGColor);
    CGFloat r = components[0];
    CGFloat g = components[1];
    CGFloat b = components[2];
    
    return [NSString stringWithFormat:@"#%02X%02X%02X", (int)(r * 255), (int)(g * 255), (int)(b * 255)];
}

+ (NSString *)removeAllButNumbers:(NSString *)stringToConvert {
    NSString *numberValue = [[stringToConvert componentsSeparatedByCharactersInSet: [[NSCharacterSet decimalDigitCharacterSet] invertedSet]] componentsJoinedByString:@""];
    return numberValue;
}


@end
