//
//  VankeWeatherModel.h
//  vanke
//
//  Created by xiaomi on 15/10/4.
//  Copyright © 2015年 gomore. All rights reserved.
//

#import "Bee_ActiveRecord.h"

// 每日天气
@interface DayWeather: BeeActiveRecord

@property(nonatomic, strong) NSString *city;
@property(nonatomic, strong) NSString *date;
@property(nonatomic, strong) NSString *realTemperature;
@property(nonatomic, strong) NSString *temperature;
@property(nonatomic, strong) NSString *wind;
@property(nonatomic, strong) NSString *weather;
@property(nonatomic, strong) NSString *dayPictureUrl;
@property(nonatomic, strong) NSString *nightPictureUrl;

@end

// 每周天气
@interface WeekWeather: BeeActiveObject

@property(nonatomic, strong) NSString *date;
@property(nonatomic, strong) NSString *city;
@property(nonatomic, strong) NSArray *weekData;

@end

// 天气模型
@interface VankeWeatherModel : BeeModel

@property (nonatomic, strong) DayWeather *weather;

-(void) removeAll;
-(void) loadOnline;
-(BOOL) loadCache: (NSString*) city;

@end
