//
//  VankeSaleVolumeModel.m
//  vanke
//
//  Created by xiaomi on 15/10/9.
//  Copyright © 2015年 gomore. All rights reserved.
//

#import "VankeSaleVolumeModel.h"

@implementation VankeSaleVolumeModel

@synthesize projectEquals;
@synthesize salesDateEquals;

-(ProjectSaleVolumeResponse*) getServerResp {
    return (ProjectSaleVolumeResponse*) self.serverResp;
}

-(void) reload {
    [VankeSaleVolumeAPI cancel];
    
    VankeSaleVolumeAPI *api = [VankeSaleVolumeAPI api];
    
    @weakify(api);
    @weakify(self);
    
    api.projectEquals = self.projectEquals;
    api.salesDateEquals = self.salesDateEquals;
    
    // 清空结果
    self.serverResp = nil;
    
    api.whenSucceed = ^{
        @normalize(api);
        @normalize(self);
        
        if (api.sending) {
            [self sendUISignal:self.RELOADING];
        } else {
            if (api.succeed) {
                if (nil == api.serverResp) {
                    api.failed = YES;
                } else {
                    self.serverResp = api.serverResp;
                }
            }
            [self sendUISignal:self.RELOADED];
        }
    };
    api.whenFailed = ^{
        @normalize(api);
        @normalize(self);
        
        self.serverResp = [ProjectSaleVolumeResponse initWith:NO message:nil == api.errorDesc? @"网络异常": api.errorDesc];
        [self sendUISignal:self.RELOADED];
    };
    [api send];
}

@end
