//
//  VankeProjectListModel.m
//  vanke
//
//  Created by xiaomi on 15/10/8.
//  Copyright © 2015年 gomore. All rights reserved.
//

#import "VankeProjectListModel.h"
#import "VankeProjectListAPI.h"

#undef	PER_PAGE
#define PER_PAGE	(30)

@implementation VankeProjectListModel

@synthesize classificationEquals = _classificationEquals;
@synthesize nameLike = _nameLike;
@synthesize salesDateEquals = _salesDateEquals;
@synthesize projects = _projects;

- (void)load
{
    self.autoSave = YES;
    self.autoLoad = YES;
    self.projects = [NSMutableArray array];
}

- (void)unload
{
    self.classificationEquals = nil;
    self.name = nil;
    self.salesDateEquals = nil;
    self.projects = nil;
}

#pragma mark - cache

- (void)loadCache
{
    [self.projects removeAllObjects];
    [self.projects addUniqueObjectsFromArray:[ProjectCategory readObjectForKey:self.classificationEquals]
                                  compare:^NSComparisonResult(id left, id right) {
                                      return [((ProjectCategory*)left).projectId compare:((ProjectCategory*)right).projectId];
                                  }];
}

- (void)saveCache
{
    [ProjectCategory saveObject:self.projects forKey:self.classificationEquals];
}

- (void)clearCache
{
    [self.projects removeAllObjects];
    
    [ProjectCategory removeObjectForKey:self.classificationEquals];
}

#pragma mark - paging query

- (void)firstPage
{
    [self gotoPage:1];
}

- (void)nextPage
{
    if ( self.projects.count )
    {
        [self gotoPage:(self.projects.count / PER_PAGE + 1)];
    }
}

- (void)gotoPage:(NSUInteger)page {
    [VankeProjectListAPI cancel];
    
    VankeProjectListAPI *api = [VankeProjectListAPI api];
    
    @weakify(api);
    @weakify(self);
    
    api.classificationEquals = self.classificationEquals;
    api.nameLike = self.nameLike;
    api.salesDateEquals = self.salesDateEquals;
    api.passengerDateEquals = self.salesDateEquals;
    api.trafficDateEquals = self.salesDateEquals;
    
    api.whenUpdate = ^
    {
        @normalize(api);
        @normalize(self);
        
        if ( api.sending )
        {
            [self sendUISignal:self.RELOADING];
        }
        else
        {
            if ( api.succeed )
            {
                ProjectListResponse *resp = (ProjectListResponse*) api.serverResp;
                
                if ( nil == resp || nil == resp.data )
                {
                    api.failed = YES;
                }
                else
                {
                    if ( page <= 1 )
                    {
                        [self.projects removeAllObjects];
                        [self.projects addObjectsFromArray:resp.data];
                    }
                    else
                    {
                        [self.projects addObjectsFromArray:resp.data];
                        [self.projects unique:^NSComparisonResult(id left, id right) {
                            return [((ProjectCategory *)left).projectId compare:((ProjectCategory *)right).projectId];
                        }];
                    }
                    
                    self.more = (self.projects.count >= [resp total]) ? NO : YES;
                    self.loaded = YES;
                    
                    [self saveCache];
                }
            }
                        
            [self sendUISignal:self.RELOADED];
        }
    };
    
    [api send];
}

@end
