//
//   ______    ______    ______
//  /\  __ \  /\  ___\  /\  ___\
//  \ \  __<  \ \  __\_ \ \  __\_
//   \ \_____\ \ \_____\ \ \_____\
//    \/_____/  \/_____/  \/_____/
//
//
//  Copyright (c) 2014-2015, Geek Zoo Studio
//  http://www.bee-framework.com
//
//
//  Permission is hereby granted, free of charge, to any person obtaining a
//  copy of this software and associated documentation files (the "Software"),
//  to deal in the Software without restriction, including without limitation
//  the rights to use, copy, modify, merge, publish, distribute, sublicense,
//  and/or sell copies of the Software, and to permit persons to whom the
//  Software is furnished to do so, subject to the following conditions:
//
//  The above copyright notice and this permission notice shall be included in
//  all copies or substantial portions of the Software.
//
//  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
//  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
//  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
//  AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
//  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
//  FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS
//  IN THE SOFTWARE.
//
//  Created by QFish used flex & bison.

#if (TARGET_OS_IPHONE || TARGET_IPHONE_SIMULATOR)

//#line 3 "lex.yy.c"

#define  YY_INT_ALIGNED short int

/* A lexical scanner generated by flex */

#define FLEX_SCANNER
#define YY_FLEX_MAJOR_VERSION 2
#define YY_FLEX_MINOR_VERSION 5
#define YY_FLEX_SUBMINOR_VERSION 35
#if YY_FLEX_SUBMINOR_VERSION > 0
#define FLEX_BETA
#endif

/* First, we deal with  platform-specific or compiler-specific issues. */

/* begin standard C headers. */
#include <stdio.h>
#include <string.h>
#include <errno.h>
#include <stdlib.h>

/* end standard C headers. */

/* flex integer type definitions */

#ifndef FLEXINT_H
#define FLEXINT_H

/* C99 systems have <inttypes.h>. Non-C99 systems may or may not. */

#if defined (__STDC_VERSION__) && __STDC_VERSION__ >= 199901L

/* C99 says to define __STDC_LIMIT_MACROS before including stdint.h,
 * if you want the limit (max/min) macros for int types. 
 */
#ifndef __STDC_LIMIT_MACROS
#define __STDC_LIMIT_MACROS 1
#endif

#include <inttypes.h>
typedef int8_t flex_int8_t;
typedef uint8_t flex_uint8_t;
typedef int16_t flex_int16_t;
typedef uint16_t flex_uint16_t;
typedef int32_t flex_int32_t;
typedef uint32_t flex_uint32_t;
typedef uint64_t flex_uint64_t;
#else
typedef signed char flex_int8_t;
typedef short int flex_int16_t;
typedef int flex_int32_t;
typedef unsigned char flex_uint8_t; 
typedef unsigned short int flex_uint16_t;
typedef unsigned int flex_uint32_t;
#endif /* ! C99 */

/* Limits of integral types. */
#ifndef INT8_MIN
#define INT8_MIN               (-128)
#endif
#ifndef INT16_MIN
#define INT16_MIN              (-32767-1)
#endif
#ifndef INT32_MIN
#define INT32_MIN              (-2147483647-1)
#endif
#ifndef INT8_MAX
#define INT8_MAX               (127)
#endif
#ifndef INT16_MAX
#define INT16_MAX              (32767)
#endif
#ifndef INT32_MAX
#define INT32_MAX              (2147483647)
#endif
#ifndef UINT8_MAX
#define UINT8_MAX              (255U)
#endif
#ifndef UINT16_MAX
#define UINT16_MAX             (65535U)
#endif
#ifndef UINT32_MAX
#define UINT32_MAX             (4294967295U)
#endif

#endif /* ! FLEXINT_H */

#ifdef __cplusplus

/* The "const" storage-class-modifier is valid. */
#define YY_USE_CONST

#else	/* ! __cplusplus */

/* C99 requires __STDC__ to be defined as 1. */
#if defined (__STDC__)

#define YY_USE_CONST

#endif	/* defined (__STDC__) */
#endif	/* ! __cplusplus */

#ifdef YY_USE_CONST
#define yyconst const
#else
#define yyconst
#endif

/* Returned upon end-of-file. */
#define YY_NULL 0

/* Promotes a possibly negative, possibly signed char to an unsigned
 * integer for use as an array index.  If the signed char is negative,
 * we want to instead treat it as an 8-bit unsigned char, hence the
 * double cast.
 */
#define YY_SC_TO_UI(c) ((unsigned int) (unsigned char) c)

/* Enter a start condition.  This macro really ought to take a parameter,
 * but we do it the disgusting crufty way forced on us by the ()-less
 * definition of BEGIN.
 */
#define BEGIN (yy_start) = 1 + 2 *

/* Translate the current start state into a value that can be later handed
 * to BEGIN to return to the state.  The YYSTATE alias is for lex
 * compatibility.
 */
#define YY_START (((yy_start) - 1) / 2)
#define YYSTATE YY_START

/* Action number for EOF rule of a given start state. */
#define YY_STATE_EOF(state) (YY_END_OF_BUFFER + state + 1)

/* Special action meaning "start processing a new file". */
#define YY_NEW_FILE yyrestart(yyin  )

#define YY_END_OF_BUFFER_CHAR 0

/* Size of default input buffer. */
#ifndef YY_BUF_SIZE
#define YY_BUF_SIZE 16384
#endif

/* The state buf must be large enough to hold one state per character in the main buffer.
 */
#define YY_STATE_BUF_SIZE   ((YY_BUF_SIZE + 2) * sizeof(yy_state_type))

#ifndef YY_TYPEDEF_YY_BUFFER_STATE
#define YY_TYPEDEF_YY_BUFFER_STATE
typedef struct yy_buffer_state *YY_BUFFER_STATE;
#endif

#ifndef YY_TYPEDEF_YY_SIZE_T
#define YY_TYPEDEF_YY_SIZE_T
typedef size_t yy_size_t;
#endif

extern yy_size_t yyleng;

extern FILE *yyin, *yyout;

#define EOB_ACT_CONTINUE_SCAN 0
#define EOB_ACT_END_OF_FILE 1
#define EOB_ACT_LAST_MATCH 2

    #define YY_LESS_LINENO(n)
    
/* Return all but the first "n" matched characters back to the input stream. */
#define yyless(n) \
	do \
		{ \
		/* Undo effects of setting up yytext. */ \
        int yyless_macro_arg = (n); \
        YY_LESS_LINENO(yyless_macro_arg);\
		*yy_cp = (yy_hold_char); \
		YY_RESTORE_YY_MORE_OFFSET \
		(yy_c_buf_p) = yy_cp = yy_bp + yyless_macro_arg - YY_MORE_ADJ; \
		YY_DO_BEFORE_ACTION; /* set up yytext again */ \
		} \
	while ( 0 )

#define unput(c) yyunput( c, (yytext_ptr)  )

#ifndef YY_STRUCT_YY_BUFFER_STATE
#define YY_STRUCT_YY_BUFFER_STATE
struct yy_buffer_state
	{
	FILE *yy_input_file;

	char *yy_ch_buf;		/* input buffer */
	char *yy_buf_pos;		/* current position in input buffer */

	/* Size of input buffer in bytes, not including room for EOB
	 * characters.
	 */
	yy_size_t yy_buf_size;

	/* Number of characters read into yy_ch_buf, not including EOB
	 * characters.
	 */
	yy_size_t yy_n_chars;

	/* Whether we "own" the buffer - i.e., we know we created it,
	 * and can realloc() it to grow it, and should free() it to
	 * delete it.
	 */
	int yy_is_our_buffer;

	/* Whether this is an "interactive" input source; if so, and
	 * if we're using stdio for input, then we want to use getc()
	 * instead of fread(), to make sure we stop fetching input after
	 * each newline.
	 */
	int yy_is_interactive;

	/* Whether we're considered to be at the beginning of a line.
	 * If so, '^' rules will be active on the next match, otherwise
	 * not.
	 */
	int yy_at_bol;

    int yy_bs_lineno; /**< The line count. */
    int yy_bs_column; /**< The column count. */
    
	/* Whether to try to fill the input buffer when we reach the
	 * end of it.
	 */
	int yy_fill_buffer;

	int yy_buffer_status;

#define YY_BUFFER_NEW 0
#define YY_BUFFER_NORMAL 1
	/* When an EOF's been seen but there's still some text to process
	 * then we mark the buffer as YY_EOF_PENDING, to indicate that we
	 * shouldn't try reading from the input source any more.  We might
	 * still have a bunch of tokens to match, though, because of
	 * possible backing-up.
	 *
	 * When we actually see the EOF, we change the status to "new"
	 * (via yyrestart()), so that the user can continue scanning by
	 * just pointing yyin at a new input file.
	 */
#define YY_BUFFER_EOF_PENDING 2

	};
#endif /* !YY_STRUCT_YY_BUFFER_STATE */

/* Stack of input buffers. */
static size_t yy_buffer_stack_top = 0; /**< index of top of stack. */
static size_t yy_buffer_stack_max = 0; /**< capacity of stack. */
static YY_BUFFER_STATE * yy_buffer_stack = 0; /**< Stack as an array. */

/* We provide macros for accessing buffer states in case in the
 * future we want to put the buffer states in a more general
 * "scanner state".
 *
 * Returns the top of the stack, or NULL.
 */
#define YY_CURRENT_BUFFER ( (yy_buffer_stack) \
                          ? (yy_buffer_stack)[(yy_buffer_stack_top)] \
                          : NULL)

/* Same as previous macro, but useful when we know that the buffer stack is not
 * NULL or when we need an lvalue. For internal use only.
 */
#define YY_CURRENT_BUFFER_LVALUE (yy_buffer_stack)[(yy_buffer_stack_top)]

/* yy_hold_char holds the character lost when yytext is formed. */
static char yy_hold_char;
static yy_size_t yy_n_chars;		/* number of characters read into yy_ch_buf */
yy_size_t yyleng;

/* Points to current character in buffer. */
static char *yy_c_buf_p = (char *) 0;
static int yy_init = 0;		/* whether we need to initialize */
static int yy_start = 0;	/* start state number */

/* Flag which is used to allow yywrap()'s to do buffer switches
 * instead of setting up a fresh yyin.  A bit of a hack ...
 */
static int yy_did_buffer_switch_on_eof;

void yyrestart (FILE *input_file  );
void yy_switch_to_buffer (YY_BUFFER_STATE new_buffer  );
YY_BUFFER_STATE yy_create_buffer (FILE *file,int size  );
void yy_delete_buffer (YY_BUFFER_STATE b  );
void yy_flush_buffer (YY_BUFFER_STATE b  );
void yypush_buffer_state (YY_BUFFER_STATE new_buffer  );
void yypop_buffer_state (void );

static void yyensure_buffer_stack (void );
static void yy_load_buffer_state (void );
static void yy_init_buffer (YY_BUFFER_STATE b,FILE *file  );

#define YY_FLUSH_BUFFER yy_flush_buffer(YY_CURRENT_BUFFER )

YY_BUFFER_STATE yy_scan_buffer (char *base,yy_size_t size  );
YY_BUFFER_STATE yy_scan_string (yyconst char *yy_str  );
YY_BUFFER_STATE yy_scan_bytes (yyconst char *bytes,yy_size_t len  );

void *yyalloc (yy_size_t  );
void *yyrealloc (void *,yy_size_t  );
void yyfree (void *  );

#define yy_new_buffer yy_create_buffer

#define yy_set_interactive(is_interactive) \
	{ \
	if ( ! YY_CURRENT_BUFFER ){ \
        yyensure_buffer_stack (); \
		YY_CURRENT_BUFFER_LVALUE =    \
            yy_create_buffer(yyin,YY_BUF_SIZE ); \
	} \
	YY_CURRENT_BUFFER_LVALUE->yy_is_interactive = is_interactive; \
	}

#define yy_set_bol(at_bol) \
	{ \
	if ( ! YY_CURRENT_BUFFER ){\
        yyensure_buffer_stack (); \
		YY_CURRENT_BUFFER_LVALUE =    \
            yy_create_buffer(yyin,YY_BUF_SIZE ); \
	} \
	YY_CURRENT_BUFFER_LVALUE->yy_at_bol = at_bol; \
	}

#define YY_AT_BOL() (YY_CURRENT_BUFFER_LVALUE->yy_at_bol)

/* Begin user sect3 */

#define yywrap(n) 1
#define YY_SKIP_YYWRAP

typedef unsigned char YY_CHAR;

FILE *yyin = (FILE *) 0, *yyout = (FILE *) 0;

typedef int yy_state_type;

extern int yylineno;

int yylineno = 1;

extern char *yytext;
#define yytext_ptr yytext

static yy_state_type yy_get_previous_state (void );
static yy_state_type yy_try_NUL_trans (yy_state_type current_state  );
static int yy_get_next_buffer (void );
static void yy_fatal_error (yyconst char msg[]  );

/* Done after the current pattern has been matched and before the
 * corresponding action - sets up yytext.
 */
#define YY_DO_BEFORE_ACTION \
	(yytext_ptr) = yy_bp; \
	yyleng = (yy_size_t) (yy_cp - yy_bp); \
	(yy_hold_char) = *yy_cp; \
	*yy_cp = '\0'; \
	(yy_c_buf_p) = yy_cp;

#define YY_NUM_RULES 60
#define YY_END_OF_BUFFER 61
/* This struct is not used in this scanner,
   but its presence is necessary. */
struct yy_trans_info
	{
	flex_int32_t yy_verify;
	flex_int32_t yy_nxt;
	};
static yyconst flex_int16_t yy_accept[377] =
    {   0,
        0,    0,    0,    0,   61,   59,    2,    2,   59,   59,
       59,   59,   59,   59,   59,   59,   59,   59,   45,   59,
       59,   14,   14,   14,   59,   59,   59,   59,   58,   14,
       14,   14,   57,    2,    0,    0,    0,   13,    0,    0,
       16,   16,   17,    0,    8,    0,    0,    9,    0,   15,
        0,   14,   14,   14,    0,   46,    0,   44,    0,    0,
       45,   42,   42,   42,   42,   42,   42,   42,   42,   42,
       15,   42,   42,   39,   42,    0,   42,    0,    0,   22,
       22,   22,   22,   22,    0,   54,   14,    0,    0,    0,
       14,   14,    0,   14,   14,   14,    7,    6,    5,   14,

       14,   14,    0,    0,    0,   13,    0,    0,   17,   16,
        0,   17,   17,    0,    0,   13,    0,    0,    4,   14,
        0,    0,   43,   42,    0,   29,   42,   24,   27,   42,
       40,   31,   42,   30,   38,   43,   42,   33,   32,   28,
       42,   42,   42,   42,   42,   42,    0,   22,    0,   22,
       22,   22,   22,   22,   22,   14,   14,    0,   15,   14,
       14,   55,   55,   14,   14,   12,   10,   14,    0,    0,
        0,   17,   17,   17,    0,    0,   14,    0,    1,   42,
       42,   34,   42,   41,   15,   35,   25,   42,   42,   42,
        3,   22,   22,   22,   22,   22,   22,   22,   14,   48,

        0,   55,   55,   55,   54,   14,   11,    0,    0,   17,
       17,    0,   14,    0,    0,   42,   36,   37,   42,   42,
       22,   22,   22,   22,   22,   22,   14,   56,   55,   55,
       55,   55,    0,    0,    0,    0,   50,    0,   14,    0,
        0,   17,   17,    0,   14,   42,   42,   26,   22,   22,
       22,   22,   19,   22,   14,   56,   55,   55,   55,   55,
       55,    0,    0,    0,    0,    0,    0,    0,    0,    0,
       50,    0,    0,   14,    0,    0,   17,   17,    0,   14,
       42,   42,   22,   22,   22,   18,   22,   14,   56,   55,
       55,   55,   55,   55,   55,    0,   49,    0,    0,    0,

        0,    0,    0,    0,    0,    0,    0,    0,   14,    0,
        0,   17,   17,    0,   14,   42,   42,   22,   21,   22,
       22,   14,   56,   55,   55,   55,   55,   55,   55,   55,
        0,   49,    0,    0,    0,   49,    0,    0,    0,    0,
       17,   14,   14,   14,   42,   22,   22,   56,    0,    0,
        0,   23,   14,   14,   14,   14,   20,   56,    0,    0,
        0,   14,   14,   14,   14,    0,    0,    0,   47,   14,
       53,   52,    0,    0,   51,    0
    } ;

static yyconst flex_int32_t yy_ec[256] =
    {   0,
        1,    1,    1,    1,    1,    1,    1,    1,    2,    3,
        1,    4,    5,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    6,    7,    8,    9,   10,   11,   12,   13,   14,
       15,   16,   17,   12,   18,   19,   20,   21,   21,   21,
       21,   21,   21,   21,   21,   21,   21,   12,   22,   23,
       24,   25,   26,   27,   28,   29,   30,   31,   32,   33,
       34,   35,   36,   37,   38,   39,   40,   41,   42,   43,
       44,   45,   46,   47,   48,   37,   49,   50,   51,   52,
       12,   53,   12,   54,   55,   12,   56,   57,   58,   59,

       60,   61,   62,   63,   64,   37,   65,   66,   67,   68,
       69,   70,   71,   72,   73,   74,   75,   37,   76,   77,
       78,   79,   80,   81,   12,   82,    1,   83,   83,   83,
       83,   83,   83,   83,   83,   83,   83,   83,   83,   83,
       83,   83,   83,   83,   83,   83,   83,   83,   83,   83,
       83,   83,   83,   83,   83,   83,   83,   83,   83,   83,
       83,   83,   83,   83,   83,   83,   83,   83,   83,   83,
       83,   83,   83,   83,   83,   83,   83,   83,   83,   83,
       83,   83,   83,   83,   83,   83,   83,   83,   83,   83,
       83,   83,   83,   83,   83,   83,   83,   83,   83,   83,

       83,   83,   83,   83,   83,   83,   83,   83,   83,   83,
       83,   83,   83,   83,   83,   83,   83,   83,   83,   83,
       83,   83,   83,   83,   83,   83,   83,   83,   83,   83,
       83,   83,   83,   83,   83,   83,   83,   83,   83,   83,
       83,   83,   83,   83,   83,   83,   83,   83,   83,   83,
       83,   83,   83,   83,   83
    } ;

static yyconst flex_int32_t yy_meta[84] =
    {   0,
        1,    2,    3,    4,    4,    5,    6,    7,    6,    6,
        6,    6,    7,    8,    6,    6,    9,   10,    6,    6,
       11,    6,    6,    6,    6,   12,    6,   13,   13,   13,
       13,   13,   13,   14,   14,   14,   14,   14,   14,   14,
       14,   14,   14,   14,   14,   14,   14,   14,   14,   14,
       14,   14,   14,    6,   14,   13,   13,   13,   13,   13,
       13,   14,   14,   14,   14,   14,   14,   14,   14,   14,
       14,   14,   14,   14,   14,   14,   14,   14,   14,    6,
        6,    6,   14
    } ;

static yyconst flex_int16_t yy_base[431] =
    {   0,
        0,    0,   62,   64, 1127, 5282,   91,   96,  105,   81,
      152, 1101,   72, 1097,   94,   96, 1099, 1085,  203, 1086,
      110,   73,  282,  107,  331, 1040,  985,  969, 5282,   98,
      287,  134, 5282,  151,  193,   98,   83, 5282,  391,  140,
        0,  432,  933,  473, 5282,  106,  533, 5282,  126,  186,
      936,   74,  292,  288,  574,  297,  937,  910,  850,  866,
        0,  173,  286,  290,  304,  274,  325,  314,  362,  363,
      464,  355,  455,  294,  353,  615,  313,  868,  296,  815,
      165,  331,  374,  378,  656, 5282,  162,  697,  437,  474,
      507,  500,  829,  420,  164,  757, 5282, 5282, 5282,  525,

      502,  504,  375,  305,  275,  403,  817,  877,  783,  918,
      959,  758, 1019,  373,  321,  404, 1079, 1139, 5282,  470,
      784,  200, 5282,  316, 1180,  418,  534,  505,  524,  555,
      527,  528,  562,  535,  556,  595,  647,  565,  568,  602,
      606,  639,  609,  605, 1240,  607,  765,  717, 1281,  610,
      572,  454,  415,  699, 1341,  172, 1401,  688,  721,  681,
      322,  201,  672,  384, 1442,  506,  557,  668,  456,  425,
     1483,  627, 1543, 1584,  487, 1625,  682,  626, 5282,  644,
     1685,  650,  652,  684,  687,  690,  714,  724, 1726,  716,
     5282,  576, 1786,  497,  692,  722,  715, 1827, 1868, 5282,

        0,  297,  602,  541,  791, 1928,  685,  503, 1969, 2010,
     2051, 2092,  788,  510,  716, 2133,  727,  755, 2174,  786,
     2215,  728,  731,  567,  777, 2256, 2297,    0,  299,  493,
      470,  449,  887,  909,  774,  604, 5282, 2357, 2417,  676,
     2477, 2537, 2597, 2657, 2717, 2771, 2812,  756, 2853,  775,
      779,  784,  405, 2894, 2935,    0,  816,  381,  357,  311,
      306,  857,  790,  939, 2995,  657, 3055,  953,  979,  993,
     1051, 3115, 3175, 3235,  571, 3295, 3355, 3415, 3475, 3535,
     3595, 3655, 3696,  878,  801,  259, 3737, 3778,    0,  838,
      204,  197,  181,  180,  175,  998, 5282,  863,  843, 1111,

     3838, 3898,  870,  916, 1171, 3958, 4018, 4078, 1024,  826,
     1033, 4138,  961, 1092, 1163, 4179, 4239, 4280,   76,  874,
     1065, 1056,    0,   98, 5282, 5282, 5282, 5282, 5282, 5282,
     1151,  920,  952, 4321, 1212, 1175, 1176, 4362, 4422,  852,
     1229, 1081, 1016, 1230, 1085, 1250, 1070,    0, 4463, 4504,
     4545, 5282, 1055, 1085, 1113, 1208,   60, 5282, 4586, 4627,
     4668,  851, 1164,  870,  883, 4709, 4750, 1275, 5282,  993,
     5282, 5282, 1313, 1355, 5282, 5282, 4810, 4815, 4828, 4833,
     4838, 4845, 4855, 4868,  711, 4873, 4883, 4896, 4910,  109,
     4916, 4926, 4931, 4941, 4951, 4955, 4964, 4978, 4988, 4998,

     5003, 5016,  907, 5021, 5033, 5047,  959, 5052, 5064, 5077,
     5090, 5103, 5116,  999, 5121, 5133, 5146, 5159, 5172, 5185,
     5198, 5211, 1020, 5216, 5228, 5241, 5254, 5267, 1032, 1052
    } ;

static yyconst flex_int16_t yy_def[431] =
    {   0,
      376,    1,    1,    1,  376,  376,  376,  376,  376,  377,
      378,  376,  379,  376,  376,  380,  376,  376,  376,  376,
      381,  382,  382,  382,  383,  376,  376,  376,  376,  382,
      382,  382,  376,  376,  376,  376,  377,  376,  384,  378,
      385,  386,  386,  387,  376,  379,  388,  376,  376,  376,
      376,  382,  382,  382,  383,   19,  389,  376,  390,  376,
       19,  391,  391,  391,  391,  391,  391,  391,  391,  391,
      391,  391,  391,  391,  391,  392,  391,  376,  381,  393,
      393,  393,  393,  393,  394,  376,  382,  395,  376,  376,
      382,  382,  396,  382,  382,  382,  376,  376,  376,  382,

      382,  382,  376,  377,  377,  377,  377,  384,  386,  386,
      397,  386,  110,  379,  379,  379,  379,  388,  376,  382,
      389,  398,  376,  391,  399,  391,  391,  391,  391,  391,
      391,  391,  391,  391,  391,  376,  391,  391,  391,  391,
      391,  391,  391,  391,  391,  391,  376,  393,  400,  393,
      393,  393,  393,  393,  393,  382,   96,  376,  376,  382,
      382,  401,  376,  382,   96,  382,  382,  382,  376,  377,
      107,  386,  110,  113,  379,  117,  382,  402,  376,  391,
      145,  391,  391,  391,  391,  391,  391,  391,  145,  391,
      376,  393,  155,  393,  393,  393,  393,  155,  157,  376,

      403,  404,  376,  376,  405,  157,  382,  376,  107,  173,
      113,  117,  382,  402,  406,  181,  391,  391,  145,  391,
      193,  393,  393,  393,  393,  155,  157,  407,  408,  376,
      376,  376,  405,  405,  409,  410,  376,  411,  157,  376,
      412,  113,  242,  413,  157,  181,  145,  391,  221,  393,
      393,  393,  393,  155,  157,  414,  415,  376,  376,  376,
      376,  376,  409,  376,  416,  410,  417,  418,  418,  418,
      418,  418,  419,  157,  376,  420,  421,  421,  422,  157,
      145,  281,  221,  393,  393,  393,  155,  157,  423,  424,
      376,  376,  376,  376,  376,  376,  376,  409,  409,  409,

      409,  425,  426,  426,  426,  426,  427,  428,  280,  376,
      420,  278,  421,  422,  280,  281,  281,  221,  393,  393,
      393,  280,  429,  376,  376,  376,  376,  376,  376,  376,
      409,  409,  409,  301,  426,  426,  426,  306,  428,  376,
      421,  280,  280,  280,  317,  393,  393,  430,  301,  306,
      339,  376,  280,  280,  280,  280,  393,  376,  301,  306,
      339,  280,  280,  280,  280,  301,  306,  428,  376,  280,
      376,  376,  409,  426,  376,    0,  376,  376,  376,  376,
      376,  376,  376,  376,  376,  376,  376,  376,  376,  376,
      376,  376,  376,  376,  376,  376,  376,  376,  376,  376,

      376,  376,  376,  376,  376,  376,  376,  376,  376,  376,
      376,  376,  376,  376,  376,  376,  376,  376,  376,  376,
      376,  376,  376,  376,  376,  376,  376,  376,  376,  376
    } ;

static yyconst flex_int16_t yy_nxt[5366] =
    {   0,
        6,    7,    8,    7,    7,    7,    9,   10,   11,   12,
        6,    6,   13,    6,    6,   14,   15,   16,   17,   18,
       19,    6,   20,    6,    6,    6,   21,   22,   22,   22,
       22,   22,   22,   22,   22,   22,   22,   22,   22,   22,
       23,   22,   22,   22,   22,   22,   22,   24,   22,   22,
       22,   22,   25,   26,   22,   22,   22,   22,   22,   22,
       22,   22,   22,   22,   22,   22,   22,   23,   22,   22,
       22,   22,   22,   22,   24,   22,   22,   22,   22,    6,
       27,   28,   22,   29,   38,   29,   86,   86,   38,   30,
       38,   30,   34,   34,   34,   34,   34,   34,   34,   34,

       34,   34,   31,   32,   31,   32,   35,   35,   35,   35,
       35,   86,  149,   51,   49,  201,   49,   30,   38,   30,
       86,   62,   62,   93,   47,   88,   88,   79,  149,   31,
       32,   31,   32,   39,   50,   39,   53,  103,  100,   81,
       36,   33,   82,   33,   54,   83,   49,   86,   55,   84,
       88,   94,   34,   34,   34,   34,   34,  376,   47,   88,
      376,   50,   85,   53,  103,  100,   50,   81,   36,   40,
       82,   54,   41,   83,  102,   86,   84,   86,   94,   42,
       42,   42,   42,   42,   42,   86,   88,   89,   89,  123,
       89,   89,   44,   50,   35,   35,   35,   35,   35,  150,

      330,  102,   90,   90,   44,  329,  328,   42,   42,   42,
       42,   42,   42,   58,   88,  122,   88,  149,  201,  179,
       59,   60,  327,   61,   88,  125,  203,  150,   36,  326,
       62,   62,   63,   64,   65,   62,   66,   67,   68,   62,
       69,   62,   70,   71,   62,   72,   62,   73,   74,   75,
       62,   62,   62,   62,   62,   76,   36,   77,   62,   62,
       63,   64,   65,   62,   66,   67,   68,   69,   62,   70,
       71,   62,   72,   62,   73,   74,   75,   62,   62,   62,
       62,   62,   38,   89,   89,   62,   89,   89,   89,   89,
      123,   89,   89,   89,   89,   86,   89,   89,   90,   91,

       86,   86,  123,   90,   91,   86,  123,   37,   90,   91,
      123,  149,   38,  376,  201,  376,  201,   56,  130,  120,
      123,  127,  230,   92,  258,  126,  125,   39,  101,  123,
      123,  295,  123,   38,   88,  200,  294,   62,  125,   88,
       88,  123,  125,  128,   88,  130,  125,  120,   85,  127,
       92,   96,  126,  129,  132,  101,  125,   39,   96,   96,
       96,   96,   96,   96,   62,  125,  125,  146,  125,  123,
      128,  123,  151,   47,   88,   46,  131,  125,  123,  123,
      129,  132,  293,  149,  138,   38,   96,   96,   96,   96,
       96,   96,   37,   37,   37,  104,  133,  205,  106,  151,

      143,  139,  134,  131,  140,  125,  292,  125,  135,  153,
       38,  107,  138,  152,  125,  125,   38,  169,  107,  107,
      107,  107,  107,  107,  133,   47,  149,  143,  139,  134,
      149,  140,   38,   86,  123,  135,   88,  153,   89,   89,
      152,   89,   89,  108,  169,  197,  107,  107,  107,  107,
      107,  107,  110,   90,   90,   39,   47,  149,  164,  110,
      110,  110,  110,  110,  110,   89,   89,  149,   89,   89,
      125,  123,   88,  197,  261,  158,  158,   39,  158,  158,
      136,  137,  141,   86,  111,  164,  142,  110,  110,  110,
      110,  110,  110,  113,  159,  260,  196,  208,  177,   38,

      113,  113,  113,  113,  113,  113,  149,  125,  158,  158,
      141,  158,  158,   86,  142,   86,  125,   86,  259,   86,
       86,  123,   88,  196,  208,  215,  177,  160,  113,  113,
      113,  113,  113,  113,   46,   46,   46,  114,   86,   47,
      123,  222,  168,  123,  123,  116,  161,  240,  167,  149,
      123,  123,   88,  117,   88,  166,   88,  125,   88,   88,
      117,  117,  117,  117,  117,  117,  232,  182,  222,  168,
      200,  123,  123,  161,  240,  167,  125,   88,  123,  125,
      125,  123,  183,  166,  123,  118,  125,  125,  117,  117,
      117,  117,  117,  117,   96,  182,  158,  158,  310,  158,

      158,   96,   96,   96,   96,   96,   96,  125,  125,   88,
      183,  252,  195,  184,  125,  159,  264,  125,  123,  149,
      125,  123,  123,  123,  149,  123,  310,  231,  149,   96,
       96,   96,   96,   96,   96,  145,  186,  194,  252,  195,
      184,  215,  145,  145,  145,  145,  145,  145,  158,  158,
      190,  158,  158,  188,  125,  123,  267,  125,  125,  125,
      123,  125,  149,  123,  186,  194,  123,  185,  123,  264,
      145,  145,  145,  145,  145,  145,  155,  190,  187,  111,
      188,   86,  217,  155,  155,  155,  155,  155,  155,  158,
      158,  125,  158,  158,   86,   86,  125,  204,   86,  125,

      123,  160,  125,  123,  125,  187,  123,  185,  159,  267,
      217,  155,  155,  155,  155,  155,  155,  157,  207,  213,
       88,   41,  275,   41,  157,  157,  157,  157,  157,  157,
      123,  215,  123,   88,   88,  179,  125,   88,  223,  125,
      123,  159,  125,  123,  149,  207,  213,  220,  251,  275,
      225,  149,  157,  157,  157,  157,  157,  157,   95,   95,
       95,   95,   95,  224,  218,  223,  125,  149,  125,  149,
       86,  123,  123,  250,  149,  220,  125,  165,  225,  125,
      149,  264,  191,  149,  165,  165,  165,  165,  165,  165,
      224,  218,  233,  233,  233,  233,  233,  264,  235,  122,

      250,   86,  123,  236,  253,  237,  284,  125,  125,   88,
      111,  285,  165,  165,  165,  165,  165,  165,  105,  170,
      170,  170,  105,  245,   38,  248,  265,  149,  320,  149,
      286,  149,  253,  201,  284,  111,  149,  171,  125,  285,
       88,  291,  265,  238,  171,  171,  171,  171,  171,  171,
      264,  245,  248,  149,  163,  201,  320,  286,  262,  262,
      262,  262,  262,  325,  369,  263,  340,  149,   87,   39,
      264,  237,  171,  171,  171,  171,  171,  171,   37,   37,
       37,  104,  264,  371,  106,  147,   56,   87,  233,  233,
      233,  233,  233,  340,  235,  265,  372,  107,  352,  236,

       87,  237,   76,  347,  107,  107,  107,  107,  107,  107,
      262,  262,  262,  262,  262,  265,  376,  228,  376,  228,
       58,  376,  267,  237,  319,  352,  149,  264,  264,  108,
      149,  347,  107,  107,  107,  107,  107,  107,  110,  238,
      296,  296,  296,  296,  296,  110,  110,  110,  110,  110,
      110,  319,  122,  297,  262,  262,  262,  262,  262,  264,
      119,  238,  112,  112,  112,  112,  112,  237,  267,  256,
      111,  256,  265,  110,  110,  110,  110,  110,  110,  173,
      262,  262,  262,  262,  262,  111,  173,  173,  173,  173,
      173,  173,   99,  237,  262,  262,  262,  262,  262,  296,

      296,  296,  296,  296,  265,  238,  375,  237,   98,  289,
       87,  289,  297,  111,  173,  173,  173,  173,  173,  173,
      112,  112,  112,  112,  112,   95,   95,   95,   95,   95,
      323,  238,  323,   87,  105,  170,  170,  170,  105,  174,
       38,   87,  348,  354,  348,  238,  174,  174,  174,  174,
      174,  174,  262,  262,  262,  262,  262,  156,  156,  156,
      156,  156,  358,   97,  358,  237,  154,  154,  154,  154,
      154,  354,   87,   87,  174,  174,  174,  174,  174,  174,
      115,  175,  175,  175,  115,   39,  180,  180,  180,  180,
      180,   38,   78,  115,  175,  175,  175,  115,   87,  176,

       57,  357,   87,  238,   38,  362,  176,  176,  176,  176,
      176,  176,  331,  296,  296,  296,  331,  149,  264,   56,
       48,  353,  149,  363,   45,  332,  376,  376,  376,  357,
       87,   47,  362,  376,  176,  176,  176,  176,  176,  176,
       46,   46,   46,  114,   47,  376,  376,  376,  353,  376,
      363,  116,  331,  296,  296,  296,  331,  376,  264,  117,
      376,  376,  364,  265,  376,  332,  117,  117,  117,  117,
      117,  117,  335,  296,  296,  296,  335,  376,  376,  376,
       87,   87,  376,  264,  376,  336,  376,  264,  264,  364,
      342,  118,  343,  370,  117,  117,  117,  117,  117,  117,

      181,  376,  344,  265,  376,  376,  376,  181,  181,  181,
      181,  181,  181,  335,  296,  296,  296,  335,  342,  376,
      343,  370,  376,  267,  264,   87,  336,  267,  267,  344,
      172,  172,  172,  172,  172,  181,  181,  181,  181,  181,
      181,  144,  144,  144,  144,  144,  376,   87,  365,  376,
      376,  192,  192,  192,  192,  192,  123,  355,  376,  376,
      189,  376,  376,  376,  267,  356,  376,  189,  189,  189,
      189,  189,  189,  376,  376,  365,  268,  268,  268,  268,
      268,  111,  376,  376,  376,  355,  376,  376,  376,  237,
      376,  376,  125,  356,  376,  189,  189,  189,  189,  189,

      189,  193,  149,  376,  376,  376,  376,  376,  193,  193,
      193,  193,  193,  193,  299,  333,  333,  333,  299,  376,
      264,  376,  376,  376,  376,  376,  376,  238,  376,  376,
      376,  376,  376,  376,  376,  376,  193,  193,  193,  193,
      193,  193,  154,  154,  154,  154,  154,  376,  376,  376,
      376,  376,  376,  376,  376,  376,  304,  337,  337,  337,
      304,  198,  376,  376,  376,  265,  376,  264,  198,  198,
      198,  198,  198,  198,  376,  376,  376,  376,  376,  376,
      376,  376,  376,  376,  376,  376,  376,  376,  376,  376,
      376,  376,  376,  149,  376,  376,  198,  198,  198,  198,

      198,  198,  156,  156,  156,  156,  156,  267,  376,  376,
      376,  376,  376,  376,  376,  376,  376,  376,  376,  376,
      376,  199,  376,  376,  376,  376,  376,  376,  199,  199,
      199,  199,  199,  199,  376,  376,  376,  376,  376,  376,
      376,  376,  376,  376,  376,  376,  376,  376,  376,  376,
      376,  376,  376,  376,  376,  376,  199,  199,  199,  199,
      199,  199,  206,  376,  376,  376,  376,  376,  376,  206,
      206,  206,  206,  206,  206,  376,  376,  376,  376,  376,
      376,  376,  376,  376,  376,  376,  376,  376,  376,  376,
      376,  376,  376,  376,  376,  376,  376,  206,  206,  206,

      206,  206,  206,  209,  376,  376,  376,  376,  376,  376,
      209,  209,  209,  209,  209,  209,  376,  376,  376,  376,
      376,  376,  376,  376,  376,  376,  376,  376,  376,  376,
      376,  376,  376,  376,  376,  376,  376,  376,  209,  209,
      209,  209,  209,  209,  172,  172,  172,  172,  172,  376,
      376,  376,  376,  376,  376,  376,  376,  376,  376,  376,
      376,  376,  376,  210,  376,  376,  376,  376,  376,  376,
      210,  210,  210,  210,  210,  210,  376,  376,  376,  376,
      376,  376,  376,  376,  376,  376,  376,  376,  376,  376,
      376,  376,  376,  376,  376,  376,  376,  376,  210,  210,

      210,  210,  210,  210,  211,  376,  376,  376,  376,  376,
      376,  211,  211,  211,  211,  211,  211,  376,  376,  376,
      376,  376,  376,  376,  376,  376,  376,  376,  376,  376,
      376,  376,  376,  376,  376,  376,  376,  376,  376,  211,
      211,  211,  211,  211,  211,  212,  376,  376,  376,  376,
      376,  376,  212,  212,  212,  212,  212,  212,  376,  376,
      376,  376,  376,  376,  376,  376,  376,  376,  376,  376,
      376,  376,  376,  376,  376,  376,  376,  376,  376,  376,
      212,  212,  212,  212,  212,  212,  180,  180,  180,  180,
      180,  376,  376,  376,  376,  376,  376,  376,  376,  376,

      376,  376,  376,  376,  376,  216,  376,  376,  376,  376,
      376,  376,  216,  216,  216,  216,  216,  216,  376,  376,
      376,  376,  376,  376,  376,  376,  376,  376,  376,  376,
      376,  376,  376,  376,  376,  376,  376,  376,  376,  376,
      216,  216,  216,  216,  216,  216,  219,  376,  376,  376,
      376,  376,  376,  219,  219,  219,  219,  219,  219,  376,
      376,  376,  376,  376,  376,  376,  376,  376,  376,  376,
      376,  376,  376,  376,  376,  376,  376,  376,  376,  376,
      376,  219,  219,  219,  219,  219,  219,  192,  192,  192,
      192,  192,  376,  376,  376,  376,  376,  376,  376,  376,

      376,  376,  376,  376,  376,  376,  221,  376,  376,  376,
      376,  376,  376,  221,  221,  221,  221,  221,  221,  376,
      376,  376,  376,  376,  376,  376,  376,  376,  376,  376,
      376,  376,  376,  376,  376,  376,  376,  376,  376,  376,
      376,  221,  221,  221,  221,  221,  221,  226,  376,  376,
      376,  376,  376,  376,  226,  226,  226,  226,  226,  226,
      376,  376,  376,  376,  376,  376,  376,  376,  376,  376,
      376,  376,  376,  376,  376,  376,  376,  376,  376,  376,
      376,  376,  226,  226,  226,  226,  226,  226,  227,  376,
      376,  376,  376,  376,  376,  227,  227,  227,  227,  227,

      227,  376,  376,  376,  376,  376,  376,  376,  376,  376,
      376,  376,  376,  376,  376,  376,  376,  376,  376,  376,
      376,  376,  376,  227,  227,  227,  227,  227,  227,   95,
       95,   95,   95,   95,  376,  376,  376,  376,  376,  376,
      376,  376,  376,  376,  376,  376,  376,  376,  239,  376,
      376,  376,  376,  376,  376,  239,  239,  239,  239,  239,
      239,  376,  376,  376,  376,  376,  376,  376,  376,  376,
      376,  376,  376,  376,  376,  376,  376,  376,  376,  376,
      376,  376,  376,  239,  239,  239,  239,  239,  239,  241,
      376,  376,  376,  376,  376,  376,  241,  241,  241,  241,

      241,  241,  376,  376,  376,  376,  376,  376,  376,  376,
      376,  376,  376,  376,  376,  376,  376,  376,  376,  376,
      376,  376,  376,  376,  241,  241,  241,  241,  241,  241,
      242,  376,  376,  376,  376,  376,  376,  242,  242,  242,
      242,  242,  242,  376,  376,  376,  376,  376,  376,  376,
      376,  376,  376,  376,  376,  376,  376,  376,  376,  376,
      376,  376,  376,  376,  376,  242,  242,  242,  242,  242,
      242,  243,  376,  376,  376,  376,  376,  376,  243,  243,
      243,  243,  243,  243,  376,  376,  376,  376,  376,  376,
      376,  376,  376,  376,  376,  376,  376,  376,  376,  376,

      376,  376,  376,  376,  376,  376,  243,  243,  243,  243,
      243,  243,  244,  376,  376,  376,  376,  376,  376,  244,
      244,  244,  244,  244,  244,  376,  376,  376,  376,  376,
      376,  376,  376,  376,  376,  376,  376,  376,  376,  376,
      376,  376,  376,  376,  376,  376,  376,  244,  244,  244,
      244,  244,  244,  246,  376,  376,  376,  376,  376,  376,
      246,  246,  246,  246,  246,  246,  376,  376,  376,  376,
      376,  376,  376,  376,  376,  376,  376,  376,  376,  376,
      376,  376,  376,  376,  376,  376,  376,  376,  246,  246,
      246,  246,  246,  246,  247,  376,  376,  376,  376,  376,

      376,  247,  247,  247,  247,  247,  247,  376,  376,  376,
      376,  376,  376,  376,  376,  376,  376,  376,  376,  376,
      376,  376,  376,  376,  376,  376,  376,  376,  376,  247,
      247,  247,  247,  247,  247,  249,  376,  376,  376,  376,
      376,  376,  249,  249,  249,  249,  249,  249,  376,  376,
      376,  376,  376,  376,  376,  376,  376,  376,  376,  376,
      376,  376,  376,  376,  376,  376,  376,  376,  376,  376,
      249,  249,  249,  249,  249,  249,  254,  376,  376,  376,
      376,  376,  376,  254,  254,  254,  254,  254,  254,  376,
      376,  376,  376,  376,  376,  376,  376,  376,  376,  376,

      376,  376,  376,  376,  376,  376,  376,  376,  376,  376,
      376,  254,  254,  254,  254,  254,  254,  255,  376,  376,
      376,  376,  376,  376,  255,  255,  255,  255,  255,  255,
      376,  376,  376,  376,  376,  376,  376,  376,  376,  376,
      376,  376,  376,  376,  376,  376,  376,  376,  376,  376,
      376,  376,  255,  255,  255,  255,  255,  255,  262,  262,
      262,  262,  268,  376,  270,  376,  376,  376,  376,  270,
      270,  271,  376,  376,  376,  376,  376,  272,  376,  376,
      376,  376,  376,  376,  272,  272,  272,  272,  272,  272,
      376,  376,  376,  376,  376,  376,  376,  376,  376,  376,

      376,  376,  376,  376,  376,  376,  376,  376,  376,  273,
      376,  376,  272,  272,  272,  272,  272,  272,   95,   95,
       95,   95,   95,  376,  376,  376,  376,  376,  376,  376,
      376,  376,  376,  376,  376,  376,  376,  274,  376,  376,
      376,  376,  376,  376,  274,  274,  274,  274,  274,  274,
      376,  376,  376,  376,  376,  376,  376,  376,  376,  376,
      376,  376,  376,  376,  376,  376,  376,  376,  376,  376,
      376,  376,  274,  274,  274,  274,  274,  274,  105,  170,
      170,  170,  105,  376,   38,  376,  376,  376,  376,  376,
      376,  376,  376,  376,  376,  376,  376,  276,  376,  376,

      376,  376,  376,  376,  276,  276,  276,  276,  276,  276,
      376,  376,  376,  376,  376,  376,  376,  376,  376,  376,
      376,  376,  376,  376,  376,  376,  376,  376,  376,   39,
      376,  376,  276,  276,  276,  276,  276,  276,  172,  172,
      172,  172,  172,  376,  376,  376,  376,  376,  376,  376,
      376,  376,  376,  376,  376,  376,  376,  277,  376,  376,
      376,  376,  376,  376,  277,  277,  277,  277,  277,  277,
      376,  376,  376,  376,  376,  376,  376,  376,  376,  376,
      376,  376,  376,  376,  376,  376,  376,  376,  376,  376,
      376,  376,  277,  277,  277,  277,  277,  277,  112,  112,

      112,  112,  112,  376,  376,  376,  376,  376,  376,  376,
      376,  376,  376,  376,  376,  376,  376,  278,  376,  376,
      376,  376,  376,  376,  278,  278,  278,  278,  278,  278,
      376,  376,  376,  376,  376,  376,  376,  376,  376,  376,
      376,  376,  376,  376,  376,  376,  376,  376,  376,  376,
      376,  376,  278,  278,  278,  278,  278,  278,  115,  175,
      175,  175,  115,  376,  376,  376,  376,  376,  376,   38,
      376,  376,  376,  376,  376,  376,  376,  279,  376,  376,
      376,  376,  376,  376,  279,  279,  279,  279,  279,  279,
      376,  376,  376,  376,  376,  376,  376,  376,  376,  376,

      376,  376,  376,  376,  376,  376,  376,  376,  376,   47,
      376,  376,  279,  279,  279,  279,  279,  279,  376,  376,
      376,  376,  376,  376,  376,  376,  376,  376,  376,  376,
      376,  376,  376,  376,  376,  376,  376,   87,  376,  376,
      376,  376,  376,  376,   87,   87,   87,   87,   87,   87,
      376,  376,  376,  376,  376,  376,  376,  376,  376,  376,
      376,  376,  376,  280,  376,  376,  376,  376,  376,  376,
      376,  376,   87,   87,   87,   87,   87,   87,  376,  376,
      376,  376,  376,  376,  376,  376,  376,  376,  376,  376,
      280,  281,  376,  376,  376,  376,  376,  376,  281,  281,

      281,  281,  281,  281,  376,  376,  376,  376,  376,  376,
      376,  376,  376,  376,  376,  376,  376,  376,  376,  376,
      376,  376,  376,  376,  376,  376,  281,  281,  281,  281,
      281,  281,  282,  376,  376,  376,  376,  376,  376,  282,
      282,  282,  282,  282,  282,  376,  376,  376,  376,  376,
      376,  376,  376,  376,  376,  376,  376,  376,  376,  376,
      376,  376,  376,  376,  376,  376,  376,  282,  282,  282,
      282,  282,  282,  283,  376,  376,  376,  376,  376,  376,
      283,  283,  283,  283,  283,  283,  376,  376,  376,  376,
      376,  376,  376,  376,  376,  376,  376,  376,  376,  376,

      376,  376,  376,  376,  376,  376,  376,  376,  283,  283,
      283,  283,  283,  283,  287,  376,  376,  376,  376,  376,
      376,  287,  287,  287,  287,  287,  287,  376,  376,  376,
      376,  376,  376,  376,  376,  376,  376,  376,  376,  376,
      376,  376,  376,  376,  376,  376,  376,  376,  376,  287,
      287,  287,  287,  287,  287,  288,  376,  376,  376,  376,
      376,  376,  288,  288,  288,  288,  288,  288,  376,  376,
      376,  376,  376,  376,  376,  376,  376,  376,  376,  376,
      376,  376,  376,  376,  376,  376,  376,  376,  376,  376,
      288,  288,  288,  288,  288,  288,  263,  263,  263,  298,

      376,  376,  300,  376,  376,  376,  376,  376,  376,  376,
      376,  376,  376,  376,  376,  301,  376,  376,  376,  376,
      376,  376,  301,  301,  301,  301,  301,  301,  376,  376,
      376,  376,  376,  376,  376,  376,  376,  376,  376,  376,
      376,  376,  376,  376,  376,  376,  376,  302,  376,  376,
      301,  301,  301,  301,  301,  301,  266,  266,  266,  303,
      376,  376,  376,  376,  376,  376,  376,  305,  376,  376,
      376,  376,  376,  376,  376,  306,  376,  376,  376,  376,
      376,  376,  306,  306,  306,  306,  306,  306,  376,  376,
      376,  376,  376,  376,  376,  376,  376,  376,  376,  376,

      376,  376,  376,  376,  376,  376,  376,  307,  376,  376,
      306,  306,  306,  306,  306,  306,  268,  268,  268,  268,
      268,  376,  376,  376,  376,  376,  376,  376,  376,  237,
      376,  376,  376,  376,  376,  308,  376,  376,  376,  376,
      376,  376,  308,  308,  308,  308,  308,  308,  376,  376,
      376,  376,  376,  376,  376,  376,  376,  376,  376,  376,
      376,  376,  376,  376,  376,  376,  376,  238,  376,  376,
      308,  308,  308,  308,  308,  308,  262,  262,  262,  262,
      268,  376,  270,  376,  376,  376,  376,  270,  270,  271,
      376,  376,  376,  376,  376,  272,  376,  376,  376,  376,

      376,  376,  272,  272,  272,  272,  272,  272,  376,  376,
      376,  376,  376,  376,  376,  376,  376,  376,  376,  376,
      376,  376,  376,  376,  376,  376,  376,  273,  376,  376,
      272,  272,  272,  272,  272,  272,   95,   95,   95,   95,
       95,  376,  376,  376,  376,  376,  376,  376,  376,  376,
      376,  376,  376,  376,  376,  309,  376,  376,  376,  376,
      376,  376,  309,  309,  309,  309,  309,  309,  376,  376,
      376,  376,  376,  376,  376,  376,  376,  376,  376,  376,
      376,  376,  376,  376,  376,  376,  376,  376,  376,  376,
      309,  309,  309,  309,  309,  309,  105,  170,  170,  170,

      105,  376,   38,  376,  376,  376,  376,  376,  376,  376,
      376,  376,  376,  376,  376,  311,  376,  376,  376,  376,
      376,  376,  311,  311,  311,  311,  311,  311,  376,  376,
      376,  376,  376,  376,  376,  376,  376,  376,  376,  376,
      376,  376,  376,  376,  376,  376,  376,   39,  376,  376,
      311,  311,  311,  311,  311,  311,  172,  172,  172,  172,
      172,  376,  376,  376,  376,  376,  376,  376,  376,  376,
      376,  376,  376,  376,  376,  312,  376,  376,  376,  376,
      376,  376,  312,  312,  312,  312,  312,  312,  376,  376,
      376,  376,  376,  376,  376,  376,  376,  376,  376,  376,

      376,  376,  376,  376,  376,  376,  376,  111,  376,  376,
      312,  312,  312,  312,  312,  312,  112,  112,  112,  112,
      112,  376,  376,  376,  376,  376,  376,  376,  376,  376,
      376,  376,  376,  376,  376,  313,  376,  376,  376,  376,
      376,  376,  313,  313,  313,  313,  313,  313,  376,  376,
      376,  376,  376,  376,  376,  376,  376,  376,  376,  376,
      376,  376,  376,  376,  376,  376,  376,  111,  376,  376,
      313,  313,  313,  313,  313,  313,  115,  175,  175,  175,
      115,  376,  376,  376,  376,  376,  376,   38,  376,  376,
      376,  376,  376,  376,  376,  314,  376,  376,  376,  376,

      376,  376,  314,  314,  314,  314,  314,  314,  376,  376,
      376,  376,  376,  376,  376,  376,  376,  376,  376,  376,
      376,  376,  376,  376,  376,  376,  376,   47,  376,  376,
      314,  314,  314,  314,  314,  314,  376,  376,  376,  376,
      376,  376,  376,  376,  376,  376,  376,  376,  376,  376,
      376,  376,  315,  376,  376,   87,  376,  376,  376,  376,
      376,  376,   87,   87,   87,   87,   87,   87,  376,  376,
      376,  376,  376,  376,  376,  376,  376,  376,  376,  376,
      376,  376,  376,  376,  376,  376,  376,  376,  376,  376,
       87,   87,   87,   87,   87,   87,  180,  180,  180,  180,

      180,  376,  376,  376,  376,  376,  376,  376,  376,  376,
      376,  376,  376,  376,  376,  316,  376,  376,  376,  376,
      376,  376,  316,  316,  316,  316,  316,  316,  376,  376,
      376,  376,  376,  376,  376,  376,  376,  376,  376,  376,
      376,  376,  376,  376,  376,  376,  376,  376,  376,  376,
      316,  316,  316,  316,  316,  316,  144,  144,  144,  144,
      144,  376,  376,  376,  376,  376,  376,  376,  376,  376,
      376,  376,  376,  376,  376,  317,  376,  376,  376,  376,
      376,  376,  317,  317,  317,  317,  317,  317,  376,  376,
      376,  376,  376,  376,  376,  376,  376,  376,  376,  376,

      376,  376,  376,  376,  376,  376,  376,  376,  376,  376,
      317,  317,  317,  317,  317,  317,  318,  376,  376,  376,
      376,  376,  376,  318,  318,  318,  318,  318,  318,  376,
      376,  376,  376,  376,  376,  376,  376,  376,  376,  376,
      376,  376,  376,  376,  376,  376,  376,  376,  376,  376,
      376,  318,  318,  318,  318,  318,  318,  321,  376,  376,
      376,  376,  376,  376,  321,  321,  321,  321,  321,  321,
      376,  376,  376,  376,  376,  376,  376,  376,  376,  376,
      376,  376,  376,  376,  376,  376,  376,  376,  376,  376,
      376,  376,  321,  321,  321,  321,  321,  321,  322,  376,

      376,  376,  376,  376,  376,  322,  322,  322,  322,  322,
      322,  376,  376,  376,  376,  376,  376,  376,  376,  376,
      376,  376,  376,  376,  376,  376,  376,  376,  376,  376,
      376,  376,  376,  322,  322,  322,  322,  322,  322,  299,
      333,  333,  333,  299,  376,  264,  376,  376,  376,  376,
      376,  376,  376,  376,  376,  376,  376,  376,  334,  376,
      376,  376,  376,  376,  376,  334,  334,  334,  334,  334,
      334,  376,  376,  376,  376,  376,  376,  376,  376,  376,
      376,  376,  376,  376,  376,  376,  376,  376,  376,  376,
      265,  376,  376,  334,  334,  334,  334,  334,  334,  263,

      263,  263,  298,  376,  376,  300,  376,  376,  376,  376,
      376,  376,  376,  376,  376,  376,  376,  376,  301,  376,
      376,  376,  376,  376,  376,  301,  301,  301,  301,  301,
      301,  376,  376,  376,  376,  376,  376,  376,  376,  376,
      376,  376,  376,  376,  376,  376,  376,  376,  376,  376,
      302,  376,  376,  301,  301,  301,  301,  301,  301,  304,
      337,  337,  337,  304,  376,  376,  376,  376,  376,  376,
      264,  376,  376,  376,  376,  376,  376,  376,  338,  376,
      376,  376,  376,  376,  376,  338,  338,  338,  338,  338,
      338,  376,  376,  376,  376,  376,  376,  376,  376,  376,

      376,  376,  376,  376,  376,  376,  376,  376,  376,  376,
      267,  376,  376,  338,  338,  338,  338,  338,  338,  266,
      266,  266,  303,  376,  376,  376,  376,  376,  376,  376,
      305,  376,  376,  376,  376,  376,  376,  376,  306,  376,
      376,  376,  376,  376,  376,  306,  306,  306,  306,  306,
      306,  376,  376,  376,  376,  376,  376,  376,  376,  376,
      376,  376,  376,  376,  376,  376,  376,  376,  376,  376,
      307,  376,  376,  306,  306,  306,  306,  306,  306,  268,
      268,  268,  268,  268,  376,  376,  376,  376,  376,  376,
      376,  376,  237,  376,  376,  376,  376,  376,  339,  376,

      376,  376,  376,  376,  376,  339,  339,  339,  339,  339,
      339,  376,  376,  376,  376,  376,  376,  376,  376,  376,
      376,  376,  376,  376,  376,  376,  376,  376,  376,  376,
      238,  376,  376,  339,  339,  339,  339,  339,  339,  172,
      172,  172,  172,  172,  376,  376,  376,  376,  376,  376,
      376,  376,  376,  376,  376,  376,  376,  376,  341,  376,
      376,  376,  376,  376,  376,  341,  341,  341,  341,  341,
      341,  376,  376,  376,  376,  376,  376,  376,  376,  376,
      376,  376,  376,  376,  376,  376,  376,  376,  376,  376,
      376,  376,  376,  341,  341,  341,  341,  341,  341,  345,

      376,  376,  376,  376,  376,  376,  345,  345,  345,  345,
      345,  345,  376,  376,  376,  376,  376,  376,  376,  376,
      376,  376,  376,  376,  376,  376,  376,  376,  376,  376,
      376,  376,  376,  376,  345,  345,  345,  345,  345,  345,
      144,  144,  144,  144,  144,  376,  376,  376,  376,  376,
      376,  376,  376,  376,  376,  376,  376,  376,  376,  124,
      376,  376,  376,  376,  376,  376,  124,  124,  124,  124,
      124,  124,  376,  376,  376,  376,  376,  376,  376,  376,
      376,  376,  376,  376,  376,  376,  376,  376,  376,  376,
      376,  376,  376,  376,  124,  124,  124,  124,  124,  124,

      346,  376,  376,  376,  376,  376,  376,  346,  346,  346,
      346,  346,  346,  376,  376,  376,  376,  376,  376,  376,
      376,  376,  376,  376,  376,  376,  376,  376,  376,  376,
      376,  376,  376,  376,  376,  346,  346,  346,  346,  346,
      346,  349,  376,  376,  376,  376,  376,  376,  349,  349,
      349,  349,  349,  349,  376,  376,  376,  376,  376,  376,
      376,  376,  376,  376,  376,  376,  376,  376,  376,  376,
      376,  376,  376,  376,  376,  376,  349,  349,  349,  349,
      349,  349,  350,  376,  376,  376,  376,  376,  376,  350,
      350,  350,  350,  350,  350,  376,  376,  376,  376,  376,

      376,  376,  376,  376,  376,  376,  376,  376,  376,  376,
      376,  376,  376,  376,  376,  376,  376,  350,  350,  350,
      350,  350,  350,  268,  268,  268,  268,  268,  376,  376,
      376,  376,  376,  376,  376,  376,  237,  376,  376,  376,
      376,  376,  351,  376,  376,  376,  376,  376,  376,  351,
      351,  351,  351,  351,  351,  376,  376,  376,  376,  376,
      376,  376,  376,  376,  376,  376,  376,  376,  376,  376,
      376,  376,  376,  376,  238,  376,  376,  351,  351,  351,
      351,  351,  351,  359,  376,  376,  376,  376,  376,  376,
      359,  359,  359,  359,  359,  359,  376,  376,  376,  376,

      376,  376,  376,  376,  376,  376,  376,  376,  376,  376,
      376,  376,  376,  376,  376,  376,  376,  376,  359,  359,
      359,  359,  359,  359,  360,  376,  376,  376,  376,  376,
      376,  360,  360,  360,  360,  360,  360,  376,  376,  376,
      376,  376,  376,  376,  376,  376,  376,  376,  376,  376,
      376,  376,  376,  376,  376,  376,  376,  376,  376,  360,
      360,  360,  360,  360,  360,  361,  376,  376,  376,  376,
      376,  376,  361,  361,  361,  361,  361,  361,  376,  376,
      376,  376,  376,  376,  376,  376,  376,  376,  376,  376,
      376,  376,  376,  376,  376,  376,  376,  376,  376,  376,

      361,  361,  361,  361,  361,  361,  366,  376,  376,  376,
      376,  376,  376,  366,  366,  366,  366,  366,  366,  376,
      376,  376,  376,  376,  376,  376,  376,  376,  376,  376,
      376,  376,  376,  376,  376,  376,  376,  376,  376,  376,
      376,  366,  366,  366,  366,  366,  366,  367,  376,  376,
      376,  376,  376,  376,  367,  367,  367,  367,  367,  367,
      376,  376,  376,  376,  376,  376,  376,  376,  376,  376,
      376,  376,  376,  376,  376,  376,  376,  376,  376,  376,
      376,  376,  367,  367,  367,  367,  367,  367,  368,  376,
      376,  376,  376,  376,  376,  368,  368,  368,  368,  368,

      368,  376,  376,  376,  376,  376,  376,  376,  376,  376,
      376,  376,  376,  376,  376,  376,  376,  376,  376,  376,
      376,  376,  376,  368,  368,  368,  368,  368,  368,  373,
      376,  376,  376,  376,  376,  376,  373,  373,  373,  373,
      373,  373,  376,  376,  376,  376,  376,  376,  376,  376,
      376,  376,  376,  376,  376,  376,  376,  376,  376,  376,
      376,  376,  376,  376,  373,  373,  373,  373,  373,  373,
      374,  376,  376,  376,  376,  376,  376,  374,  374,  374,
      374,  374,  374,  376,  376,  376,  376,  376,  376,  376,
      376,  376,  376,  376,  376,  376,  376,  376,  376,  376,

      376,  376,  376,  376,  376,  374,  374,  374,  374,  374,
      374,   37,  376,  376,   37,   37,   37,   37,   37,   37,
       37,   37,   37,   37,   43,   43,  376,   43,   43,   46,
      376,  376,   46,   46,   46,   46,   46,   46,   46,   46,
       46,   46,   52,   52,  376,   52,   52,   80,  376,  376,
       80,   80,   87,  376,   87,   87,  376,   87,   87,   95,
       95,   95,   95,   95,   95,   95,   95,   95,   95,  105,
      105,  105,  105,  105,  105,  105,  105,  105,  105,  105,
      105,  105,  109,  109,  376,  109,  109,  112,  112,  112,
      112,  112,  112,  112,  112,  112,  112,  115,  115,  115,

      115,  115,  115,  115,  115,  115,  115,  115,  115,  115,
      121,  121,  121,  121,  121,  121,  121,  121,  121,  121,
      121,  121,  121,  121,  124,  124,  124,  376,  124,  124,
      144,  144,  144,  144,  144,  144,  144,  144,  144,  144,
      148,  148,  376,  148,  148,  154,  154,  154,  154,  154,
      154,  154,  154,  154,  154,  156,  156,  156,  156,  156,
      156,  156,  156,  156,  156,  162,  162,  162,  172,  172,
      172,  172,  172,  172,  172,  172,  172,  172,  178,  178,
      178,  178,  178,  178,  178,  178,  178,  178,  178,  178,
      178,  178,  180,  180,  180,  180,  180,  180,  180,  180,

      180,  180,  192,  192,  192,  192,  192,  192,  192,  192,
      192,  192,  202,  202,  202,  202,  214,  214,  214,  214,
      214,  214,  214,  214,  214,  214,  214,  214,  214,  214,
      229,  229,  229,  229,  234,  234,  234,  234,  234,  234,
      376,  234,  234,  234,  234,  234,  234,  178,  178,  178,
      178,  178,  178,  178,  178,  178,  178,  178,  178,  178,
      178,  257,  257,  257,  257,  263,  376,  376,  263,  263,
      263,  263,  263,  263,  263,  263,  263,  263,  266,  376,
      376,  266,  266,  266,  266,  266,  266,  266,  266,  266,
      266,  269,  269,  269,  269,  269,  269,  269,  269,  269,

      269,  269,  269,  269,   37,   37,   37,   37,   37,   37,
       37,   37,   37,   37,   37,   37,   37,   46,   46,   46,
       46,   46,   46,   46,   46,   46,   46,   46,   46,   46,
      290,  290,  290,  290,  299,  299,  299,  299,  299,  299,
      299,  299,  299,  299,  299,  299,  299,  304,  304,  304,
      304,  304,  304,  304,  304,  304,  304,  304,  304,  304,
      234,  234,  234,  234,  234,  376,  376,  234,  234,  234,
      234,  234,  234,  269,  269,  269,  269,  269,  269,  269,
      269,  269,  269,  269,  269,  269,   37,   37,   37,   37,
       37,   37,   37,   37,   37,   37,   37,   37,   37,  109,

      109,  109,  109,  376,  376,  376,  376,  109,  109,  376,
      109,  109,   46,   46,   46,   46,   46,   46,   46,   46,
       46,   46,   46,   46,   46,  324,  324,  324,  324,  299,
      299,  299,  299,  299,  299,  299,  299,  299,  299,  299,
      299,  299,  266,  266,  376,  266,  266,  266,  266,  266,
      266,  266,  266,  266,  266,  304,  304,  304,  304,  304,
      304,  304,  304,  304,  304,  304,  304,  304,  234,  234,
      234,  234,  234,  376,  376,  234,  234,  234,  234,  234,
      234,    5,  376,  376,  376,  376,  376,  376,  376,  376,
      376,  376,  376,  376,  376,  376,  376,  376,  376,  376,

      376,  376,  376,  376,  376,  376,  376,  376,  376,  376,
      376,  376,  376,  376,  376,  376,  376,  376,  376,  376,
      376,  376,  376,  376,  376,  376,  376,  376,  376,  376,
      376,  376,  376,  376,  376,  376,  376,  376,  376,  376,
      376,  376,  376,  376,  376,  376,  376,  376,  376,  376,
      376,  376,  376,  376,  376,  376,  376,  376,  376,  376,
      376,  376,  376,  376,  376
    } ;

static yyconst flex_int16_t yy_chk[5366] =
    {   0,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    3,   13,    4,   22,   52,   10,    3,
       37,    4,    7,    7,    7,    7,    7,    8,    8,    8,

        8,    8,    3,    3,    4,    4,    9,    9,    9,    9,
        9,   30,  357,   16,   15,  324,   16,    3,   46,    4,
       24,  390,  390,   24,   13,   22,   52,   21,  319,    3,
        3,    4,    4,   10,   15,   37,   16,   36,   30,   21,
        9,    3,   21,    4,   16,   21,   49,   32,   16,   21,
       30,   24,   34,   34,   34,   34,   34,   40,   46,   24,
       40,   15,   21,   16,   36,   30,   49,   21,    9,   11,
       21,   16,   11,   21,   32,   87,   21,   95,   24,   11,
       11,   11,   11,   11,   11,  156,   32,   50,   50,   62,
       50,   50,   40,   49,   35,   35,   35,   35,   35,   81,

      295,   32,   50,   50,   11,  294,  293,   11,   11,   11,
       11,   11,   11,   19,   87,  122,   95,   81,  162,  122,
       19,   19,  292,   19,  156,   62,  162,   81,   35,  291,
       19,   19,   19,   19,   19,   19,   19,   19,   19,   19,
       19,   19,   19,   19,   19,   19,   19,   19,   19,   19,
       19,   19,   19,   19,   19,   19,   35,   19,   19,   19,
       19,   19,   19,   19,   19,   19,   19,   19,   19,   19,
       19,   19,   19,   19,   19,   19,   19,   19,   19,   19,
       19,   19,  105,   23,   23,   19,   23,   23,   31,   31,
       66,   31,   31,   53,   53,   23,   53,   53,   23,   23,

       31,   54,   63,   31,   31,   53,   64,  104,   53,   53,
       74,  286,  104,   79,  202,   56,  229,   56,   66,   54,
       65,   64,  202,   23,  229,   63,   66,  105,   31,   77,
       68,  261,  124,  115,   23,  161,  260,   56,   63,   31,
       54,   67,   64,   65,   53,   66,   74,   54,   79,   64,
       23,   25,   63,   65,   68,   31,   65,  104,   25,   25,
       25,   25,   25,   25,   56,   77,   68,   77,  124,   75,
       65,   72,   82,  115,  161,  114,   67,   67,   69,   70,
       65,   68,  259,   82,   72,  114,   25,   25,   25,   25,
       25,   25,   39,   39,   39,   39,   69,  164,   39,   82,

       75,   72,   70,   67,   72,   75,  258,   72,   70,   84,
      106,   39,   72,   83,   69,   70,  116,  103,   39,   39,
       39,   39,   39,   39,   69,  114,   83,   75,   72,   70,
       84,   72,  170,   94,  126,   70,  164,   84,   89,   89,
       83,   89,   89,   39,  103,  153,   39,   39,   39,   39,
       39,   39,   42,   89,   89,  106,  116,  253,   94,   42,
       42,   42,   42,   42,   42,   71,   71,  153,   71,   71,
      126,   73,   94,  153,  232,   90,   90,  170,   90,   90,
       71,   71,   73,  120,   42,   94,   73,   42,   42,   42,
       42,   42,   42,   44,   90,  231,  152,  169,  120,  175,

       44,   44,   44,   44,   44,   44,  152,   73,   91,   91,
       73,   91,   91,   92,   73,  101,   71,  102,  230,  166,
       91,  128,  120,  152,  169,  214,  120,   91,   44,   44,
       44,   44,   44,   44,   47,   47,   47,   47,  100,  175,
      129,  194,  102,  131,  132,   47,   92,  208,  101,  194,
      127,  134,   92,   47,  101,  100,  102,  128,  166,   91,
       47,   47,   47,   47,   47,   47,  204,  127,  194,  102,
      167,  130,  135,   92,  208,  101,  129,  100,  133,  131,
      132,  138,  130,  100,  139,   47,  127,  134,   47,   47,
       47,   47,   47,   47,   55,  127,  136,  136,  275,  136,

      136,   55,   55,   55,   55,   55,   55,  130,  135,  167,
      130,  224,  151,  133,  133,  136,  236,  138,  140,  224,
      139,  144,  141,  146,  151,  143,  275,  203,  192,   55,
       55,   55,   55,   55,   55,   76,  141,  150,  224,  151,
      133,  178,   76,   76,   76,   76,   76,   76,  137,  137,
      146,  137,  137,  143,  140,  142,  236,  144,  141,  146,
      180,  143,  150,  137,  141,  150,  182,  137,  183,  266,
       76,   76,   76,   76,   76,   76,   85,  146,  142,  172,
      143,  168,  183,   85,   85,   85,   85,   85,   85,  158,
      158,  142,  158,  158,  160,  177,  180,  163,  207,  137,

      184,  160,  182,  185,  183,  142,  186,  185,  158,  266,
      183,   85,   85,   85,   85,   85,   85,   88,  168,  177,
      168,  385,  240,  385,   88,   88,   88,   88,   88,   88,
      187,  215,  190,  160,  177,  215,  184,  207,  195,  185,
      188,  159,  186,  217,  195,  168,  177,  190,  223,  240,
      197,  154,   88,   88,   88,   88,   88,   88,   96,   96,
       96,   96,   96,  196,  188,  195,  187,  197,  190,  148,
       96,  218,  248,  222,  196,  190,  188,   96,  197,  217,
      222,  235,  147,  223,   96,   96,   96,   96,   96,   96,
      196,  188,  205,  205,  205,  205,  205,  263,  205,  121,

      222,  213,  220,  205,  225,  205,  250,  218,  248,   96,
      112,  251,   96,   96,   96,   96,   96,   96,  107,  107,
      107,  107,  107,  213,  107,  220,  235,  250,  285,  225,
      252,  251,  225,  257,  250,  109,  252,  107,  220,  251,
      213,  257,  263,  205,  107,  107,  107,  107,  107,  107,
      299,  213,  220,  285,   93,  290,  285,  252,  262,  262,
      262,  262,  262,  290,  362,  298,  310,   80,  362,  107,
      298,  262,  107,  107,  107,  107,  107,  107,  108,  108,
      108,  108,  303,  364,  108,   78,   60,  364,  233,  233,
      233,  233,  233,  310,  233,  299,  365,  108,  340,  233,

      365,  233,   59,  320,  108,  108,  108,  108,  108,  108,
      234,  234,  234,  234,  234,  298,  234,  403,  304,  403,
       58,  234,  303,  234,  284,  340,  320,  332,  304,  108,
      284,  320,  108,  108,  108,  108,  108,  108,  110,  233,
      264,  264,  264,  264,  264,  110,  110,  110,  110,  110,
      110,  284,   57,  264,  268,  268,  268,  268,  268,  333,
       51,  234,  313,  313,  313,  313,  313,  268,  304,  407,
      110,  407,  332,  110,  110,  110,  110,  110,  110,  111,
      269,  269,  269,  269,  269,   43,  111,  111,  111,  111,
      111,  111,   28,  269,  270,  270,  270,  270,  270,  296,

      296,  296,  296,  296,  333,  268,  370,  270,   27,  414,
      370,  414,  296,  313,  111,  111,  111,  111,  111,  111,
      113,  113,  113,  113,  113,  309,  309,  309,  309,  309,
      423,  269,  423,  343,  311,  311,  311,  311,  311,  113,
      311,  309,  429,  343,  429,  270,  113,  113,  113,  113,
      113,  113,  271,  271,  271,  271,  271,  322,  322,  322,
      322,  322,  430,   26,  430,  271,  321,  321,  321,  321,
      321,  343,  353,  322,  113,  113,  113,  113,  113,  113,
      117,  117,  117,  117,  117,  311,  345,  345,  345,  345,
      345,  117,   20,  314,  314,  314,  314,  314,  342,  117,

       18,  347,  354,  271,  314,  353,  117,  117,  117,  117,
      117,  117,  300,  300,  300,  300,  300,  321,  300,   17,
       14,  342,  347,  354,   12,  300,    5,    0,    0,  347,
      355,  117,  353,    0,  117,  117,  117,  117,  117,  117,
      118,  118,  118,  118,  314,    0,    0,    0,  342,    0,
      354,  118,  331,  331,  331,  331,  331,    0,  331,  118,
        0,    0,  355,  300,    0,  331,  118,  118,  118,  118,
      118,  118,  305,  305,  305,  305,  305,  336,  337,    0,
      315,  363,    0,  305,    0,  305,    0,  336,  337,  355,
      315,  118,  315,  363,  118,  118,  118,  118,  118,  118,

      125,    0,  315,  331,    0,    0,    0,  125,  125,  125,
      125,  125,  125,  335,  335,  335,  335,  335,  315,    0,
      315,  363,    0,  305,  335,  356,  335,  336,  337,  315,
      341,  341,  341,  341,  341,  125,  125,  125,  125,  125,
      125,  145,  145,  145,  145,  145,    0,  344,  356,    0,
        0,  346,  346,  346,  346,  346,  145,  344,    0,    0,
      145,    0,    0,    0,  335,  344,    0,  145,  145,  145,
      145,  145,  145,    0,    0,  356,  368,  368,  368,  368,
      368,  341,    0,    0,    0,  344,    0,    0,    0,  368,
        0,    0,  145,  344,    0,  145,  145,  145,  145,  145,

      145,  149,  346,    0,    0,    0,    0,    0,  149,  149,
      149,  149,  149,  149,  373,  373,  373,  373,  373,    0,
      373,    0,    0,    0,    0,    0,    0,  368,    0,    0,
        0,    0,    0,    0,    0,    0,  149,  149,  149,  149,
      149,  149,  155,  155,  155,  155,  155,    0,    0,    0,
        0,    0,    0,    0,    0,    0,  374,  374,  374,  374,
      374,  155,    0,    0,    0,  373,    0,  374,  155,  155,
      155,  155,  155,  155,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,  155,    0,    0,  155,  155,  155,  155,

      155,  155,  157,  157,  157,  157,  157,  374,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,  157,    0,    0,    0,    0,    0,    0,  157,  157,
      157,  157,  157,  157,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,  157,  157,  157,  157,
      157,  157,  165,    0,    0,    0,    0,    0,    0,  165,
      165,  165,  165,  165,  165,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,  165,  165,  165,

      165,  165,  165,  171,    0,    0,    0,    0,    0,    0,
      171,  171,  171,  171,  171,  171,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,  171,  171,
      171,  171,  171,  171,  173,  173,  173,  173,  173,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,  173,    0,    0,    0,    0,    0,    0,
      173,  173,  173,  173,  173,  173,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,  173,  173,

      173,  173,  173,  173,  174,    0,    0,    0,    0,    0,
        0,  174,  174,  174,  174,  174,  174,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,  174,
      174,  174,  174,  174,  174,  176,    0,    0,    0,    0,
        0,    0,  176,  176,  176,  176,  176,  176,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
      176,  176,  176,  176,  176,  176,  181,  181,  181,  181,
      181,    0,    0,    0,    0,    0,    0,    0,    0,    0,

        0,    0,    0,    0,    0,  181,    0,    0,    0,    0,
        0,    0,  181,  181,  181,  181,  181,  181,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
      181,  181,  181,  181,  181,  181,  189,    0,    0,    0,
        0,    0,    0,  189,  189,  189,  189,  189,  189,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,  189,  189,  189,  189,  189,  189,  193,  193,  193,
      193,  193,    0,    0,    0,    0,    0,    0,    0,    0,

        0,    0,    0,    0,    0,    0,  193,    0,    0,    0,
        0,    0,    0,  193,  193,  193,  193,  193,  193,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,  193,  193,  193,  193,  193,  193,  198,    0,    0,
        0,    0,    0,    0,  198,  198,  198,  198,  198,  198,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,  198,  198,  198,  198,  198,  198,  199,    0,
        0,    0,    0,    0,    0,  199,  199,  199,  199,  199,

      199,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,  199,  199,  199,  199,  199,  199,  206,
      206,  206,  206,  206,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,  206,    0,
        0,    0,    0,    0,    0,  206,  206,  206,  206,  206,
      206,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,  206,  206,  206,  206,  206,  206,  209,
        0,    0,    0,    0,    0,    0,  209,  209,  209,  209,

      209,  209,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,  209,  209,  209,  209,  209,  209,
      210,    0,    0,    0,    0,    0,    0,  210,  210,  210,
      210,  210,  210,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,  210,  210,  210,  210,  210,
      210,  211,    0,    0,    0,    0,    0,    0,  211,  211,
      211,  211,  211,  211,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,

        0,    0,    0,    0,    0,    0,  211,  211,  211,  211,
      211,  211,  212,    0,    0,    0,    0,    0,    0,  212,
      212,  212,  212,  212,  212,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,  212,  212,  212,
      212,  212,  212,  216,    0,    0,    0,    0,    0,    0,
      216,  216,  216,  216,  216,  216,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,  216,  216,
      216,  216,  216,  216,  219,    0,    0,    0,    0,    0,

        0,  219,  219,  219,  219,  219,  219,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,  219,
      219,  219,  219,  219,  219,  221,    0,    0,    0,    0,
        0,    0,  221,  221,  221,  221,  221,  221,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
      221,  221,  221,  221,  221,  221,  226,    0,    0,    0,
        0,    0,    0,  226,  226,  226,  226,  226,  226,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,

        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,  226,  226,  226,  226,  226,  226,  227,    0,    0,
        0,    0,    0,    0,  227,  227,  227,  227,  227,  227,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,  227,  227,  227,  227,  227,  227,  238,  238,
      238,  238,  238,    0,  238,    0,    0,    0,    0,  238,
      238,  238,    0,    0,    0,    0,    0,  238,    0,    0,
        0,    0,    0,    0,  238,  238,  238,  238,  238,  238,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,

        0,    0,    0,    0,    0,    0,    0,    0,    0,  238,
        0,    0,  238,  238,  238,  238,  238,  238,  239,  239,
      239,  239,  239,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,  239,    0,    0,
        0,    0,    0,    0,  239,  239,  239,  239,  239,  239,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,  239,  239,  239,  239,  239,  239,  241,  241,
      241,  241,  241,    0,  241,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,  241,    0,    0,

        0,    0,    0,    0,  241,  241,  241,  241,  241,  241,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,  241,
        0,    0,  241,  241,  241,  241,  241,  241,  242,  242,
      242,  242,  242,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,  242,    0,    0,
        0,    0,    0,    0,  242,  242,  242,  242,  242,  242,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,  242,  242,  242,  242,  242,  242,  243,  243,

      243,  243,  243,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,  243,    0,    0,
        0,    0,    0,    0,  243,  243,  243,  243,  243,  243,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,  243,  243,  243,  243,  243,  243,  244,  244,
      244,  244,  244,    0,    0,    0,    0,    0,    0,  244,
        0,    0,    0,    0,    0,    0,    0,  244,    0,    0,
        0,    0,    0,    0,  244,  244,  244,  244,  244,  244,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,

        0,    0,    0,    0,    0,    0,    0,    0,    0,  244,
        0,    0,  244,  244,  244,  244,  244,  244,  245,  245,
      245,  245,  245,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,  245,    0,    0,
        0,    0,    0,    0,  245,  245,  245,  245,  245,  245,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,  245,    0,    0,    0,    0,    0,    0,
        0,    0,  245,  245,  245,  245,  245,  245,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
      245,  246,    0,    0,    0,    0,    0,    0,  246,  246,

      246,  246,  246,  246,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,  246,  246,  246,  246,
      246,  246,  247,    0,    0,    0,    0,    0,    0,  247,
      247,  247,  247,  247,  247,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,  247,  247,  247,
      247,  247,  247,  249,    0,    0,    0,    0,    0,    0,
      249,  249,  249,  249,  249,  249,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,

        0,    0,    0,    0,    0,    0,    0,    0,  249,  249,
      249,  249,  249,  249,  254,    0,    0,    0,    0,    0,
        0,  254,  254,  254,  254,  254,  254,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,  254,
      254,  254,  254,  254,  254,  255,    0,    0,    0,    0,
        0,    0,  255,  255,  255,  255,  255,  255,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
      255,  255,  255,  255,  255,  255,  265,  265,  265,  265,

        0,    0,  265,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,  265,    0,    0,    0,    0,
        0,    0,  265,  265,  265,  265,  265,  265,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,  265,    0,    0,
      265,  265,  265,  265,  265,  265,  267,  267,  267,  267,
        0,    0,    0,    0,    0,    0,    0,  267,    0,    0,
        0,    0,    0,    0,    0,  267,    0,    0,    0,    0,
        0,    0,  267,  267,  267,  267,  267,  267,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,

        0,    0,    0,    0,    0,    0,    0,  267,    0,    0,
      267,  267,  267,  267,  267,  267,  272,  272,  272,  272,
      272,    0,    0,    0,    0,    0,    0,    0,    0,  272,
        0,    0,    0,    0,    0,  272,    0,    0,    0,    0,
        0,    0,  272,  272,  272,  272,  272,  272,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,  272,    0,    0,
      272,  272,  272,  272,  272,  272,  273,  273,  273,  273,
      273,    0,  273,    0,    0,    0,    0,  273,  273,  273,
        0,    0,    0,    0,    0,  273,    0,    0,    0,    0,

        0,    0,  273,  273,  273,  273,  273,  273,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,  273,    0,    0,
      273,  273,  273,  273,  273,  273,  274,  274,  274,  274,
      274,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,  274,    0,    0,    0,    0,
        0,    0,  274,  274,  274,  274,  274,  274,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
      274,  274,  274,  274,  274,  274,  276,  276,  276,  276,

      276,    0,  276,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,  276,    0,    0,    0,    0,
        0,    0,  276,  276,  276,  276,  276,  276,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,  276,    0,    0,
      276,  276,  276,  276,  276,  276,  277,  277,  277,  277,
      277,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,  277,    0,    0,    0,    0,
        0,    0,  277,  277,  277,  277,  277,  277,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,

        0,    0,    0,    0,    0,    0,    0,  277,    0,    0,
      277,  277,  277,  277,  277,  277,  278,  278,  278,  278,
      278,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,  278,    0,    0,    0,    0,
        0,    0,  278,  278,  278,  278,  278,  278,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,  278,    0,    0,
      278,  278,  278,  278,  278,  278,  279,  279,  279,  279,
      279,    0,    0,    0,    0,    0,    0,  279,    0,    0,
        0,    0,    0,    0,    0,  279,    0,    0,    0,    0,

        0,    0,  279,  279,  279,  279,  279,  279,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,  279,    0,    0,
      279,  279,  279,  279,  279,  279,  280,  280,  280,  280,
      280,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,  280,    0,    0,  280,    0,    0,    0,    0,
        0,    0,  280,  280,  280,  280,  280,  280,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
      280,  280,  280,  280,  280,  280,  281,  281,  281,  281,

      281,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,  281,    0,    0,    0,    0,
        0,    0,  281,  281,  281,  281,  281,  281,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
      281,  281,  281,  281,  281,  281,  282,  282,  282,  282,
      282,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,  282,    0,    0,    0,    0,
        0,    0,  282,  282,  282,  282,  282,  282,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,

        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
      282,  282,  282,  282,  282,  282,  283,    0,    0,    0,
        0,    0,    0,  283,  283,  283,  283,  283,  283,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,  283,  283,  283,  283,  283,  283,  287,    0,    0,
        0,    0,    0,    0,  287,  287,  287,  287,  287,  287,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,  287,  287,  287,  287,  287,  287,  288,    0,

        0,    0,    0,    0,    0,  288,  288,  288,  288,  288,
      288,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,  288,  288,  288,  288,  288,  288,  301,
      301,  301,  301,  301,    0,  301,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,  301,    0,
        0,    0,    0,    0,    0,  301,  301,  301,  301,  301,
      301,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
      301,    0,    0,  301,  301,  301,  301,  301,  301,  302,

      302,  302,  302,    0,    0,  302,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,  302,    0,
        0,    0,    0,    0,    0,  302,  302,  302,  302,  302,
      302,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
      302,    0,    0,  302,  302,  302,  302,  302,  302,  306,
      306,  306,  306,  306,    0,    0,    0,    0,    0,    0,
      306,    0,    0,    0,    0,    0,    0,    0,  306,    0,
        0,    0,    0,    0,    0,  306,  306,  306,  306,  306,
      306,    0,    0,    0,    0,    0,    0,    0,    0,    0,

        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
      306,    0,    0,  306,  306,  306,  306,  306,  306,  307,
      307,  307,  307,    0,    0,    0,    0,    0,    0,    0,
      307,    0,    0,    0,    0,    0,    0,    0,  307,    0,
        0,    0,    0,    0,    0,  307,  307,  307,  307,  307,
      307,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
      307,    0,    0,  307,  307,  307,  307,  307,  307,  308,
      308,  308,  308,  308,    0,    0,    0,    0,    0,    0,
        0,    0,  308,    0,    0,    0,    0,    0,  308,    0,

        0,    0,    0,    0,    0,  308,  308,  308,  308,  308,
      308,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
      308,    0,    0,  308,  308,  308,  308,  308,  308,  312,
      312,  312,  312,  312,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,  312,    0,
        0,    0,    0,    0,    0,  312,  312,  312,  312,  312,
      312,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,  312,  312,  312,  312,  312,  312,  316,

        0,    0,    0,    0,    0,    0,  316,  316,  316,  316,
      316,  316,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,  316,  316,  316,  316,  316,  316,
      317,  317,  317,  317,  317,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,  317,
        0,    0,    0,    0,    0,    0,  317,  317,  317,  317,
      317,  317,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,  317,  317,  317,  317,  317,  317,

      318,    0,    0,    0,    0,    0,    0,  318,  318,  318,
      318,  318,  318,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,  318,  318,  318,  318,  318,
      318,  334,    0,    0,    0,    0,    0,    0,  334,  334,
      334,  334,  334,  334,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,  334,  334,  334,  334,
      334,  334,  338,    0,    0,    0,    0,    0,    0,  338,
      338,  338,  338,  338,  338,    0,    0,    0,    0,    0,

        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,  338,  338,  338,
      338,  338,  338,  339,  339,  339,  339,  339,    0,    0,
        0,    0,    0,    0,    0,    0,  339,    0,    0,    0,
        0,    0,  339,    0,    0,    0,    0,    0,    0,  339,
      339,  339,  339,  339,  339,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,  339,    0,    0,  339,  339,  339,
      339,  339,  339,  349,    0,    0,    0,    0,    0,    0,
      349,  349,  349,  349,  349,  349,    0,    0,    0,    0,

        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,  349,  349,
      349,  349,  349,  349,  350,    0,    0,    0,    0,    0,
        0,  350,  350,  350,  350,  350,  350,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,  350,
      350,  350,  350,  350,  350,  351,    0,    0,    0,    0,
        0,    0,  351,  351,  351,  351,  351,  351,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,

      351,  351,  351,  351,  351,  351,  359,    0,    0,    0,
        0,    0,    0,  359,  359,  359,  359,  359,  359,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,  359,  359,  359,  359,  359,  359,  360,    0,    0,
        0,    0,    0,    0,  360,  360,  360,  360,  360,  360,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,  360,  360,  360,  360,  360,  360,  361,    0,
        0,    0,    0,    0,    0,  361,  361,  361,  361,  361,

      361,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,  361,  361,  361,  361,  361,  361,  366,
        0,    0,    0,    0,    0,    0,  366,  366,  366,  366,
      366,  366,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,  366,  366,  366,  366,  366,  366,
      367,    0,    0,    0,    0,    0,    0,  367,  367,  367,
      367,  367,  367,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,

        0,    0,    0,    0,    0,  367,  367,  367,  367,  367,
      367,  377,    0,    0,  377,  377,  377,  377,  377,  377,
      377,  377,  377,  377,  378,  378,    0,  378,  378,  379,
        0,    0,  379,  379,  379,  379,  379,  379,  379,  379,
      379,  379,  380,  380,    0,  380,  380,  381,    0,    0,
      381,  381,  382,    0,  382,  382,    0,  382,  382,  383,
      383,  383,  383,  383,  383,  383,  383,  383,  383,  384,
      384,  384,  384,  384,  384,  384,  384,  384,  384,  384,
      384,  384,  386,  386,    0,  386,  386,  387,  387,  387,
      387,  387,  387,  387,  387,  387,  387,  388,  388,  388,

      388,  388,  388,  388,  388,  388,  388,  388,  388,  388,
      389,  389,  389,  389,  389,  389,  389,  389,  389,  389,
      389,  389,  389,  389,  391,  391,  391,    0,  391,  391,
      392,  392,  392,  392,  392,  392,  392,  392,  392,  392,
      393,  393,    0,  393,  393,  394,  394,  394,  394,  394,
      394,  394,  394,  394,  394,  395,  395,  395,  395,  395,
      395,  395,  395,  395,  395,  396,  396,  396,  397,  397,
      397,  397,  397,  397,  397,  397,  397,  397,  398,  398,
      398,  398,  398,  398,  398,  398,  398,  398,  398,  398,
      398,  398,  399,  399,  399,  399,  399,  399,  399,  399,

      399,  399,  400,  400,  400,  400,  400,  400,  400,  400,
      400,  400,  401,  401,  401,  401,  402,  402,  402,  402,
      402,  402,  402,  402,  402,  402,  402,  402,  402,  402,
      404,  404,  404,  404,  405,  405,  405,  405,  405,  405,
        0,  405,  405,  405,  405,  405,  405,  406,  406,  406,
      406,  406,  406,  406,  406,  406,  406,  406,  406,  406,
      406,  408,  408,  408,  408,  409,    0,    0,  409,  409,
      409,  409,  409,  409,  409,  409,  409,  409,  410,    0,
        0,  410,  410,  410,  410,  410,  410,  410,  410,  410,
      410,  411,  411,  411,  411,  411,  411,  411,  411,  411,

      411,  411,  411,  411,  412,  412,  412,  412,  412,  412,
      412,  412,  412,  412,  412,  412,  412,  413,  413,  413,
      413,  413,  413,  413,  413,  413,  413,  413,  413,  413,
      415,  415,  415,  415,  416,  416,  416,  416,  416,  416,
      416,  416,  416,  416,  416,  416,  416,  417,  417,  417,
      417,  417,  417,  417,  417,  417,  417,  417,  417,  417,
      418,  418,  418,  418,  418,    0,    0,  418,  418,  418,
      418,  418,  418,  419,  419,  419,  419,  419,  419,  419,
      419,  419,  419,  419,  419,  419,  420,  420,  420,  420,
      420,  420,  420,  420,  420,  420,  420,  420,  420,  421,

      421,  421,  421,    0,    0,    0,    0,  421,  421,    0,
      421,  421,  422,  422,  422,  422,  422,  422,  422,  422,
      422,  422,  422,  422,  422,  424,  424,  424,  424,  425,
      425,  425,  425,  425,  425,  425,  425,  425,  425,  425,
      425,  425,  426,  426,    0,  426,  426,  426,  426,  426,
      426,  426,  426,  426,  426,  427,  427,  427,  427,  427,
      427,  427,  427,  427,  427,  427,  427,  427,  428,  428,
      428,  428,  428,    0,    0,  428,  428,  428,  428,  428,
      428,  376,  376,  376,  376,  376,  376,  376,  376,  376,
      376,  376,  376,  376,  376,  376,  376,  376,  376,  376,

      376,  376,  376,  376,  376,  376,  376,  376,  376,  376,
      376,  376,  376,  376,  376,  376,  376,  376,  376,  376,
      376,  376,  376,  376,  376,  376,  376,  376,  376,  376,
      376,  376,  376,  376,  376,  376,  376,  376,  376,  376,
      376,  376,  376,  376,  376,  376,  376,  376,  376,  376,
      376,  376,  376,  376,  376,  376,  376,  376,  376,  376,
      376,  376,  376,  376,  376
    } ;

static yy_state_type yy_last_accepting_state;
static char *yy_last_accepting_cpos;

extern int yy_flex_debug;
int yy_flex_debug = 0;

/* The intent behind this definition is that it'll catch
 * any uses of REJECT which flex missed.
 */
#define REJECT reject_used_but_not_detected
#define yymore() yymore_used_but_not_detected
#define YY_MORE_ADJ 0
#define YY_RESTORE_YY_MORE_OFFSET
char *yytext;

#import "CSSTokenizer.h"

int cssToken;

void yy_create_input(const char* buffer) {
    yy_scan_bytes(buffer,strlen(buffer));
}

void yy_delete_input() {
    yy_delete_buffer(YY_CURRENT_BUFFER);
}

#define INITIAL 0
#define mediaquery 1

#ifndef YY_NO_UNISTD_H
/* Special case for "unistd.h", since it is non-ANSI. We include it way
 * down here because we want the user's section 1 to have been scanned first.
 * The user has a chance to override it with an option.
 */
#include <unistd.h>
#endif

#ifndef YY_EXTRA_TYPE
#define YY_EXTRA_TYPE void *
#endif

static int yy_init_globals (void );

/* Accessor methods to globals.
   These are made visible to non-reentrant scanners for convenience. */

int yylex_destroy (void );

int yyget_debug (void );

void yyset_debug (int debug_flag  );

YY_EXTRA_TYPE yyget_extra (void );

void yyset_extra (YY_EXTRA_TYPE user_defined  );

FILE *yyget_in (void );

void yyset_in  (FILE * in_str  );

FILE *yyget_out (void );

void yyset_out  (FILE * out_str  );

yy_size_t yyget_leng (void );

char *yyget_text (void );

int yyget_lineno (void );

void yyset_lineno (int line_number  );

/* Macros after this point can all be overridden by user definitions in
 * section 1.
 */

#ifndef YY_SKIP_YYWRAP
#ifdef __cplusplus
extern "C" int yywrap (void );
#else
extern int yywrap (void );
#endif
#endif

    static void yyunput (int c,char *buf_ptr  );
    
#ifndef yytext_ptr
static void yy_flex_strncpy (char *,yyconst char *,int );
#endif

#ifdef YY_NEED_STRLEN
static int yy_flex_strlen (yyconst char * );
#endif

#ifndef YY_NO_INPUT

#ifdef __cplusplus
static int yyinput (void );
#else
static int input (void );
#endif

#endif

/* Amount of stuff to slurp up with each read. */
#ifndef YY_READ_BUF_SIZE
#define YY_READ_BUF_SIZE 8192
#endif

/* Copy whatever the last rule matched to the standard output. */
#ifndef ECHO
/* This used to be an fputs(), but since the string might contain NUL's,
 * we now use fwrite().
 */
#define ECHO fwrite( yytext, yyleng, 1, yyout )
#endif

/* Gets input and stuffs it into "buf".  number of characters read, or YY_NULL,
 * is returned in "result".
 */
#ifndef YY_INPUT
#define YY_INPUT(buf,result,max_size) \
	if ( YY_CURRENT_BUFFER_LVALUE->yy_is_interactive ) \
		{ \
		int c = '*'; \
		yy_size_t n; \
		for ( n = 0; n < max_size && \
			     (c = getc( yyin )) != EOF && c != '\n'; ++n ) \
			buf[n] = (char) c; \
		if ( c == '\n' ) \
			buf[n++] = (char) c; \
		if ( c == EOF && ferror( yyin ) ) \
			YY_FATAL_ERROR( "input in flex scanner failed" ); \
		result = n; \
		} \
	else \
		{ \
		errno=0; \
		while ( (result = fread(buf, 1, max_size, yyin))==0 && ferror(yyin)) \
			{ \
			if( errno != EINTR) \
				{ \
				YY_FATAL_ERROR( "input in flex scanner failed" ); \
				break; \
				} \
			errno=0; \
			clearerr(yyin); \
			} \
		}\
\

#endif

/* No semi-colon after return; correct usage is to write "yyterminate();" -
 * we don't want an extra ';' after the "return" because that will cause
 * some compilers to complain about unreachable statements.
 */
#ifndef yyterminate
#define yyterminate() return YY_NULL
#endif

/* Number of entries by which start-condition stack grows. */
#ifndef YY_START_STACK_INCR
#define YY_START_STACK_INCR 25
#endif

/* Report a fatal error. */
#ifndef YY_FATAL_ERROR
#define YY_FATAL_ERROR(msg) yy_fatal_error( msg )
#endif

/* end tables serialization structures and prototypes */

/* Default declaration of generated scanner - a define so the user can
 * easily add parameters.
 */
#ifndef YY_DECL
#define YY_DECL_IS_OURS 1

extern int yylex (void);

#define YY_DECL int yylex (void)
#endif /* !YY_DECL */

/* Code executed at the beginning of each rule, after yytext and yyleng
 * have been set up.
 */
#ifndef YY_USER_ACTION
#define YY_USER_ACTION
#endif

/* Code executed at the end of each rule. */
#ifndef YY_BREAK
#define YY_BREAK break;
#endif

#define YY_RULE_SETUP \
	YY_USER_ACTION

/** The main scanner function which does all the work.
 */
YY_DECL
{
	register yy_state_type yy_current_state;
	register char *yy_cp, *yy_bp;
	register int yy_act;
    
	if ( !(yy_init) )
		{
		(yy_init) = 1;

#ifdef YY_USER_INIT
		YY_USER_INIT;
#endif

		if ( ! (yy_start) )
			(yy_start) = 1;	/* first start state */

		if ( ! yyin )
			yyin = stdin;

		if ( ! yyout )
			yyout = stdout;

		if ( ! YY_CURRENT_BUFFER ) {
			yyensure_buffer_stack ();
			YY_CURRENT_BUFFER_LVALUE =
				yy_create_buffer(yyin,YY_BUF_SIZE );
		}

		yy_load_buffer_state( );
		}

	while ( 1 )		/* loops until end-of-file is reached */
		{
		yy_cp = (yy_c_buf_p);

		/* Support of yytext. */
		*yy_cp = (yy_hold_char);

		/* yy_bp points to the position in yy_ch_buf of the start of
		 * the current run.
		 */
		yy_bp = yy_cp;

		yy_current_state = (yy_start);
yy_match:
		do
			{
			register YY_CHAR yy_c = yy_ec[YY_SC_TO_UI(*yy_cp)];
			if ( yy_accept[yy_current_state] )
				{
				(yy_last_accepting_state) = yy_current_state;
				(yy_last_accepting_cpos) = yy_cp;
				}
			while ( yy_chk[yy_base[yy_current_state] + yy_c] != yy_current_state )
				{
				yy_current_state = (int) yy_def[yy_current_state];
				if ( yy_current_state >= 377 )
					yy_c = yy_meta[(unsigned int) yy_c];
				}
			yy_current_state = yy_nxt[yy_base[yy_current_state] + (unsigned int) yy_c];
			++yy_cp;
			}
		while ( yy_base[yy_current_state] != 5282 );

yy_find_action:
		yy_act = yy_accept[yy_current_state];
		if ( yy_act == 0 )
			{ /* have to back up */
			yy_cp = (yy_last_accepting_cpos);
			yy_current_state = (yy_last_accepting_state);
			yy_act = yy_accept[yy_current_state];
			}

		YY_DO_BEFORE_ACTION;

do_action:	/* This label is used only to access EOF actions. */

		switch ( yy_act )
	{ /* beginning of action switch */
			case 0: /* must back up */
			/* undo the effects of YY_DO_BEFORE_ACTION */
			*yy_cp = (yy_hold_char);
			yy_cp = (yy_last_accepting_cpos);
			yy_current_state = (yy_last_accepting_state);
			goto yy_find_action;

case 1:
/* rule 1 can match eol */
YY_RULE_SETUP
{ /* ignore comments */ }
	YY_BREAK
case 2:
/* rule 2 can match eol */
YY_RULE_SETUP
{cssToken = WHITESPACE; ECHO; return CSS_YYLEX_ACITON; }
	YY_BREAK
case 3:
YY_RULE_SETUP
{cssToken = SGML_CD; ECHO; return CSS_YYLEX_ACITON; }
	YY_BREAK
case 4:
YY_RULE_SETUP
{cssToken = SGML_CD; ECHO; return CSS_YYLEX_ACITON; }
	YY_BREAK
case 5:
YY_RULE_SETUP
{cssToken = INCLUDES; ECHO; return CSS_YYLEX_ACITON; }
	YY_BREAK
case 6:
YY_RULE_SETUP
{cssToken = DASHMATCH; ECHO; return CSS_YYLEX_ACITON; }
	YY_BREAK
case 7:
YY_RULE_SETUP
{cssToken = BEGINSWITH; ECHO; return CSS_YYLEX_ACITON; }
	YY_BREAK
case 8:
YY_RULE_SETUP
{cssToken = ENDSWITH; ECHO; return CSS_YYLEX_ACITON; }
	YY_BREAK
case 9:
YY_RULE_SETUP
{cssToken = CONTAINS; ECHO; return CSS_YYLEX_ACITON; }
	YY_BREAK
case 10:
YY_RULE_SETUP
{cssToken = MEDIA_NOT; ECHO; return CSS_YYLEX_ACITON; }
	YY_BREAK
case 11:
YY_RULE_SETUP
{cssToken = MEDIA_ONLY; ECHO; return CSS_YYLEX_ACITON; }
	YY_BREAK
case 12:
YY_RULE_SETUP
{cssToken = MEDIA_AND; ECHO; return CSS_YYLEX_ACITON; }
	YY_BREAK
case 13:
/* rule 13 can match eol */
YY_RULE_SETUP
{cssToken = STRING; ECHO; return CSS_YYLEX_ACITON; }
	YY_BREAK
case 14:
/* rule 14 can match eol */
YY_RULE_SETUP
{cssToken = IDENT; ECHO; return CSS_YYLEX_ACITON; }
	YY_BREAK
case 15:
/* rule 15 can match eol */
YY_RULE_SETUP
{cssToken = NTH; ECHO; return CSS_YYLEX_ACITON; }
	YY_BREAK
case 16:
YY_RULE_SETUP
{cssToken = HEX; ECHO; return CSS_YYLEX_ACITON; }
	YY_BREAK
case 17:
/* rule 17 can match eol */
YY_RULE_SETUP
{cssToken = IDSEL; ECHO; return CSS_YYLEX_ACITON; }
	YY_BREAK
case 18:
YY_RULE_SETUP
{BEGIN(mediaquery); cssToken = IMPORT_SYM; ECHO; return CSS_YYLEX_ACITON; }
	YY_BREAK
case 19:
YY_RULE_SETUP
{BEGIN(mediaquery); cssToken = MEDIA_SYM; ECHO; return CSS_YYLEX_ACITON; }
	YY_BREAK
case 20:
YY_RULE_SETUP
{cssToken = FONT_FACE_SYM; ECHO; return CSS_YYLEX_ACITON; }
	YY_BREAK
case 21:
YY_RULE_SETUP
{cssToken = CHARSET_SYM; ECHO; return CSS_YYLEX_ACITON; }
	YY_BREAK
case 22:
/* rule 22 can match eol */
YY_RULE_SETUP
{cssToken = ATKEYWORD; ECHO; return CSS_YYLEX_ACITON;  }
	YY_BREAK
case 23:
/* rule 23 can match eol */
YY_RULE_SETUP
{cssToken = IMPORTANT_SYM; ECHO; return CSS_YYLEX_ACITON; }
	YY_BREAK
case 24:
YY_RULE_SETUP
{cssToken = CSSLENGTH; ECHO; return CSS_YYLEX_ACITON; }
	YY_BREAK
case 25:
YY_RULE_SETUP
{cssToken = CSSLENGTH; ECHO; return CSS_YYLEX_ACITON; }
	YY_BREAK
case 26:
YY_RULE_SETUP
{cssToken = CSSLENGTH; ECHO; return CSS_YYLEX_ACITON; } /* quirky ems */
	YY_BREAK
case 27:
YY_RULE_SETUP
{cssToken = CSSLENGTH; ECHO; return CSS_YYLEX_ACITON; }
	YY_BREAK
case 28:
YY_RULE_SETUP
{cssToken = CSSLENGTH; ECHO; return CSS_YYLEX_ACITON; }
	YY_BREAK
case 29:
YY_RULE_SETUP
{cssToken = CSSLENGTH; ECHO; return CSS_YYLEX_ACITON; }
	YY_BREAK
case 30:
YY_RULE_SETUP
{cssToken = CSSLENGTH; ECHO; return CSS_YYLEX_ACITON; }
	YY_BREAK
case 31:
YY_RULE_SETUP
{cssToken = CSSLENGTH; ECHO; return CSS_YYLEX_ACITON; }
	YY_BREAK
case 32:
YY_RULE_SETUP
{cssToken = CSSLENGTH; ECHO; return CSS_YYLEX_ACITON; }
	YY_BREAK
case 33:
YY_RULE_SETUP
{cssToken = CSSLENGTH; ECHO; return CSS_YYLEX_ACITON; }
	YY_BREAK
case 34:
YY_RULE_SETUP
{cssToken = CSSLENGTH; ECHO; return CSS_YYLEX_ACITON; }
	YY_BREAK
case 35:
YY_RULE_SETUP
{cssToken = CSSLENGTH; ECHO; return CSS_YYLEX_ACITON; }
	YY_BREAK
case 36:
YY_RULE_SETUP
{cssToken = CSSLENGTH; ECHO; return CSS_YYLEX_ACITON; }
	YY_BREAK
case 37:
YY_RULE_SETUP
{cssToken = CSSLENGTH; ECHO; return CSS_YYLEX_ACITON; }
	YY_BREAK
case 38:
YY_RULE_SETUP
{cssToken = CSSLENGTH; ECHO; return CSS_YYLEX_ACITON; }
	YY_BREAK
case 39:
YY_RULE_SETUP
{cssToken = CSSLENGTH; ECHO; return CSS_YYLEX_ACITON; }
	YY_BREAK
case 40:
YY_RULE_SETUP
{cssToken = CSSLENGTH; ECHO; return CSS_YYLEX_ACITON; }
	YY_BREAK
case 41:
YY_RULE_SETUP
{cssToken = CSSLENGTH; ECHO; return CSS_YYLEX_ACITON; }
	YY_BREAK
case 42:
/* rule 42 can match eol */
YY_RULE_SETUP
{cssToken = DIMEN; ECHO; return CSS_YYLEX_ACITON; }
	YY_BREAK
case 43:
/* rule 43 can match eol */
YY_RULE_SETUP
{cssToken = INVALIDDIMEN; ECHO; return CSS_YYLEX_ACITON; }
	YY_BREAK
case 44:
YY_RULE_SETUP
{cssToken = PERCENTAGE; ECHO; return CSS_YYLEX_ACITON; }
	YY_BREAK
case 45:
YY_RULE_SETUP
{cssToken = INTEGER; ECHO; return CSS_YYLEX_ACITON; }
	YY_BREAK
case 46:
YY_RULE_SETUP
{cssToken = FLOATTOKEN; ECHO; return CSS_YYLEX_ACITON; }
	YY_BREAK
case 47:
YY_RULE_SETUP
{cssToken = ANYFUNCTION; ECHO; return CSS_YYLEX_ACITON; }
	YY_BREAK
case 48:
YY_RULE_SETUP
{cssToken = NOTFUNCTION; ECHO; return CSS_YYLEX_ACITON; }
	YY_BREAK
case 49:
/* rule 49 can match eol */
YY_RULE_SETUP
{cssToken = URII; ECHO; return CSS_YYLEX_ACITON; }
	YY_BREAK
case 50:
/* rule 50 can match eol */
YY_RULE_SETUP
{cssToken = URII; ECHO; return CSS_YYLEX_ACITON; }
	YY_BREAK
case 51:
YY_RULE_SETUP
{cssToken = CALCFUNCTION; ECHO; return CSS_YYLEX_ACITON; }
	YY_BREAK
case 52:
YY_RULE_SETUP
{cssToken = MINFUNCTION; ECHO; return CSS_YYLEX_ACITON; }
	YY_BREAK
case 53:
YY_RULE_SETUP
{cssToken = MAXFUNCTION; ECHO; return CSS_YYLEX_ACITON; }
	YY_BREAK
case 54:
/* rule 54 can match eol */
YY_RULE_SETUP
{cssToken = CSSFUNCTION; ECHO; return CSS_YYLEX_ACITON; }
	YY_BREAK
case 55:
YY_RULE_SETUP
{cssToken = UNICODERANGE; ECHO; return CSS_YYLEX_ACITON; }
	YY_BREAK
case 56:
YY_RULE_SETUP
{cssToken = UNICODERANGE; ECHO; return CSS_YYLEX_ACITON; }
	YY_BREAK
case 57:
case 58:
YY_RULE_SETUP
{BEGIN(INITIAL); cssToken = *yytext; ECHO; return CSS_YYLEX_ACITON;  }
	YY_BREAK
case 59:
YY_RULE_SETUP
{cssToken = *yytext; ECHO; return CSS_YYLEX_ACITON; }
	YY_BREAK
case 60:
YY_RULE_SETUP
ECHO;
	YY_BREAK
case YY_STATE_EOF(INITIAL):
case YY_STATE_EOF(mediaquery):
	yyterminate();

	case YY_END_OF_BUFFER:
		{
		/* Amount of text matched not including the EOB char. */
		int yy_amount_of_matched_text = (int) (yy_cp - (yytext_ptr)) - 1;

		/* Undo the effects of YY_DO_BEFORE_ACTION. */
		*yy_cp = (yy_hold_char);
		YY_RESTORE_YY_MORE_OFFSET

		if ( YY_CURRENT_BUFFER_LVALUE->yy_buffer_status == YY_BUFFER_NEW )
			{
			/* We're scanning a new file or input source.  It's
			 * possible that this happened because the user
			 * just pointed yyin at a new source and called
			 * yylex().  If so, then we have to assure
			 * consistency between YY_CURRENT_BUFFER and our
			 * globals.  Here is the right place to do so, because
			 * this is the first action (other than possibly a
			 * back-up) that will match for the new input source.
			 */
			(yy_n_chars) = YY_CURRENT_BUFFER_LVALUE->yy_n_chars;
			YY_CURRENT_BUFFER_LVALUE->yy_input_file = yyin;
			YY_CURRENT_BUFFER_LVALUE->yy_buffer_status = YY_BUFFER_NORMAL;
			}

		/* Note that here we test for yy_c_buf_p "<=" to the position
		 * of the first EOB in the buffer, since yy_c_buf_p will
		 * already have been incremented past the NUL character
		 * (since all states make transitions on EOB to the
		 * end-of-buffer state).  Contrast this with the test
		 * in input().
		 */
		if ( (yy_c_buf_p) <= &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars)] )
			{ /* This was really a NUL. */
			yy_state_type yy_next_state;

			(yy_c_buf_p) = (yytext_ptr) + yy_amount_of_matched_text;

			yy_current_state = yy_get_previous_state(  );

			/* Okay, we're now positioned to make the NUL
			 * transition.  We couldn't have
			 * yy_get_previous_state() go ahead and do it
			 * for us because it doesn't know how to deal
			 * with the possibility of jamming (and we don't
			 * want to build jamming into it because then it
			 * will run more slowly).
			 */

			yy_next_state = yy_try_NUL_trans( yy_current_state );

			yy_bp = (yytext_ptr) + YY_MORE_ADJ;

			if ( yy_next_state )
				{
				/* Consume the NUL. */
				yy_cp = ++(yy_c_buf_p);
				yy_current_state = yy_next_state;
				goto yy_match;
				}

			else
				{
				yy_cp = (yy_c_buf_p);
				goto yy_find_action;
				}
			}

		else switch ( yy_get_next_buffer(  ) )
			{
			case EOB_ACT_END_OF_FILE:
				{
				(yy_did_buffer_switch_on_eof) = 0;

				if ( yywrap( ) )
					{
					/* Note: because we've taken care in
					 * yy_get_next_buffer() to have set up
					 * yytext, we can now set up
					 * yy_c_buf_p so that if some total
					 * hoser (like flex itself) wants to
					 * call the scanner after we return the
					 * YY_NULL, it'll still work - another
					 * YY_NULL will get returned.
					 */
					(yy_c_buf_p) = (yytext_ptr) + YY_MORE_ADJ;

					yy_act = YY_STATE_EOF(YY_START);
					goto do_action;
					}

				else
					{
					if ( ! (yy_did_buffer_switch_on_eof) )
						YY_NEW_FILE;
					}
				break;
				}

			case EOB_ACT_CONTINUE_SCAN:
				(yy_c_buf_p) =
					(yytext_ptr) + yy_amount_of_matched_text;

				yy_current_state = yy_get_previous_state(  );

				yy_cp = (yy_c_buf_p);
				yy_bp = (yytext_ptr) + YY_MORE_ADJ;
				goto yy_match;

			case EOB_ACT_LAST_MATCH:
				(yy_c_buf_p) =
				&YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars)];

				yy_current_state = yy_get_previous_state(  );

				yy_cp = (yy_c_buf_p);
				yy_bp = (yytext_ptr) + YY_MORE_ADJ;
				goto yy_find_action;
			}
		break;
		}

	default:
		YY_FATAL_ERROR(
			"fatal flex scanner internal error--no action found" );
	} /* end of action switch */
		} /* end of scanning one token */
} /* end of yylex */

/* yy_get_next_buffer - try to read in a new buffer
 *
 * Returns a code representing an action:
 *	EOB_ACT_LAST_MATCH -
 *	EOB_ACT_CONTINUE_SCAN - continue scanning from current position
 *	EOB_ACT_END_OF_FILE - end of file
 */
static int yy_get_next_buffer (void)
{
    	register char *dest = YY_CURRENT_BUFFER_LVALUE->yy_ch_buf;
	register char *source = (yytext_ptr);
	register int number_to_move, i;
	int ret_val;

	if ( (yy_c_buf_p) > &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars) + 1] )
		YY_FATAL_ERROR(
		"fatal flex scanner internal error--end of buffer missed" );

	if ( YY_CURRENT_BUFFER_LVALUE->yy_fill_buffer == 0 )
		{ /* Don't try to fill the buffer, so this is an EOF. */
		if ( (yy_c_buf_p) - (yytext_ptr) - YY_MORE_ADJ == 1 )
			{
			/* We matched a single character, the EOB, so
			 * treat this as a final EOF.
			 */
			return EOB_ACT_END_OF_FILE;
			}

		else
			{
			/* We matched some text prior to the EOB, first
			 * process it.
			 */
			return EOB_ACT_LAST_MATCH;
			}
		}

	/* Try to read more data. */

	/* First move last chars to start of buffer. */
	number_to_move = (int) ((yy_c_buf_p) - (yytext_ptr)) - 1;

	for ( i = 0; i < number_to_move; ++i )
		*(dest++) = *(source++);

	if ( YY_CURRENT_BUFFER_LVALUE->yy_buffer_status == YY_BUFFER_EOF_PENDING )
		/* don't do the read, it's not guaranteed to return an EOF,
		 * just force an EOF
		 */
		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = (yy_n_chars) = 0;

	else
		{
			yy_size_t num_to_read =
			YY_CURRENT_BUFFER_LVALUE->yy_buf_size - number_to_move - 1;

		while ( num_to_read <= 0 )
			{ /* Not enough room in the buffer - grow it. */

			/* just a shorter name for the current buffer */
			YY_BUFFER_STATE b = YY_CURRENT_BUFFER;

			int yy_c_buf_p_offset =
				(int) ((yy_c_buf_p) - b->yy_ch_buf);

			if ( b->yy_is_our_buffer )
				{
				yy_size_t new_size = b->yy_buf_size * 2;

				if ( new_size <= 0 )
					b->yy_buf_size += b->yy_buf_size / 8;
				else
					b->yy_buf_size *= 2;

				b->yy_ch_buf = (char *)
					/* Include room in for 2 EOB chars. */
					yyrealloc((void *) b->yy_ch_buf,b->yy_buf_size + 2  );
				}
			else
				/* Can't grow it, we don't own it. */
				b->yy_ch_buf = 0;

			if ( ! b->yy_ch_buf )
				YY_FATAL_ERROR(
				"fatal error - scanner input buffer overflow" );

			(yy_c_buf_p) = &b->yy_ch_buf[yy_c_buf_p_offset];

			num_to_read = YY_CURRENT_BUFFER_LVALUE->yy_buf_size -
						number_to_move - 1;

			}

		if ( num_to_read > YY_READ_BUF_SIZE )
			num_to_read = YY_READ_BUF_SIZE;

		/* Read in more data. */
		YY_INPUT( (&YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[number_to_move]),
			(yy_n_chars), num_to_read );

		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = (yy_n_chars);
		}

	if ( (yy_n_chars) == 0 )
		{
		if ( number_to_move == YY_MORE_ADJ )
			{
			ret_val = EOB_ACT_END_OF_FILE;
			yyrestart(yyin  );
			}

		else
			{
			ret_val = EOB_ACT_LAST_MATCH;
			YY_CURRENT_BUFFER_LVALUE->yy_buffer_status =
				YY_BUFFER_EOF_PENDING;
			}
		}

	else
		ret_val = EOB_ACT_CONTINUE_SCAN;

	if ((yy_size_t) ((yy_n_chars) + number_to_move) > YY_CURRENT_BUFFER_LVALUE->yy_buf_size) {
		/* Extend the array by 50%, plus the number we really need. */
		yy_size_t new_size = (yy_n_chars) + number_to_move + ((yy_n_chars) >> 1);
		YY_CURRENT_BUFFER_LVALUE->yy_ch_buf = (char *) yyrealloc((void *) YY_CURRENT_BUFFER_LVALUE->yy_ch_buf,new_size  );
		if ( ! YY_CURRENT_BUFFER_LVALUE->yy_ch_buf )
			YY_FATAL_ERROR( "out of dynamic memory in yy_get_next_buffer()" );
	}

	(yy_n_chars) += number_to_move;
	YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars)] = YY_END_OF_BUFFER_CHAR;
	YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars) + 1] = YY_END_OF_BUFFER_CHAR;

	(yytext_ptr) = &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[0];

	return ret_val;
}

/* yy_get_previous_state - get the state just before the EOB char was reached */

    static yy_state_type yy_get_previous_state (void)
{
	register yy_state_type yy_current_state;
	register char *yy_cp;
    
	yy_current_state = (yy_start);

	for ( yy_cp = (yytext_ptr) + YY_MORE_ADJ; yy_cp < (yy_c_buf_p); ++yy_cp )
		{
		register YY_CHAR yy_c = (*yy_cp ? yy_ec[YY_SC_TO_UI(*yy_cp)] : 1);
		if ( yy_accept[yy_current_state] )
			{
			(yy_last_accepting_state) = yy_current_state;
			(yy_last_accepting_cpos) = yy_cp;
			}
		while ( yy_chk[yy_base[yy_current_state] + yy_c] != yy_current_state )
			{
			yy_current_state = (int) yy_def[yy_current_state];
			if ( yy_current_state >= 377 )
				yy_c = yy_meta[(unsigned int) yy_c];
			}
		yy_current_state = yy_nxt[yy_base[yy_current_state] + (unsigned int) yy_c];
		}

	return yy_current_state;
}

/* yy_try_NUL_trans - try to make a transition on the NUL character
 *
 * synopsis
 *	next_state = yy_try_NUL_trans( current_state );
 */
    static yy_state_type yy_try_NUL_trans  (yy_state_type yy_current_state )
{
	register int yy_is_jam;
    	register char *yy_cp = (yy_c_buf_p);

	register YY_CHAR yy_c = 1;
	if ( yy_accept[yy_current_state] )
		{
		(yy_last_accepting_state) = yy_current_state;
		(yy_last_accepting_cpos) = yy_cp;
		}
	while ( yy_chk[yy_base[yy_current_state] + yy_c] != yy_current_state )
		{
		yy_current_state = (int) yy_def[yy_current_state];
		if ( yy_current_state >= 377 )
			yy_c = yy_meta[(unsigned int) yy_c];
		}
	yy_current_state = yy_nxt[yy_base[yy_current_state] + (unsigned int) yy_c];
	yy_is_jam = (yy_current_state == 376);

	return yy_is_jam ? 0 : yy_current_state;
}

    static void yyunput (int c, register char * yy_bp )
{
	register char *yy_cp;
    
    yy_cp = (yy_c_buf_p);

	/* undo effects of setting up yytext */
	*yy_cp = (yy_hold_char);

	if ( yy_cp < YY_CURRENT_BUFFER_LVALUE->yy_ch_buf + 2 )
		{ /* need to shift things up to make room */
		/* +2 for EOB chars. */
		register yy_size_t number_to_move = (yy_n_chars) + 2;
		register char *dest = &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[
					YY_CURRENT_BUFFER_LVALUE->yy_buf_size + 2];
		register char *source =
				&YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[number_to_move];

		while ( source > YY_CURRENT_BUFFER_LVALUE->yy_ch_buf )
			*--dest = *--source;

		yy_cp += (int) (dest - source);
		yy_bp += (int) (dest - source);
		YY_CURRENT_BUFFER_LVALUE->yy_n_chars =
			(yy_n_chars) = YY_CURRENT_BUFFER_LVALUE->yy_buf_size;

		if ( yy_cp < YY_CURRENT_BUFFER_LVALUE->yy_ch_buf + 2 )
			YY_FATAL_ERROR( "flex scanner push-back overflow" );
		}

	*--yy_cp = (char) c;

	(yytext_ptr) = yy_bp;
	(yy_hold_char) = *yy_cp;
	(yy_c_buf_p) = yy_cp;
}

#ifndef YY_NO_INPUT
#ifdef __cplusplus
    static int yyinput (void)
#else
    static int input  (void)
#endif

{
	int c;
    
	*(yy_c_buf_p) = (yy_hold_char);

	if ( *(yy_c_buf_p) == YY_END_OF_BUFFER_CHAR )
		{
		/* yy_c_buf_p now points to the character we want to return.
		 * If this occurs *before* the EOB characters, then it's a
		 * valid NUL; if not, then we've hit the end of the buffer.
		 */
		if ( (yy_c_buf_p) < &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars)] )
			/* This was really a NUL. */
			*(yy_c_buf_p) = '\0';

		else
			{ /* need more input */
			yy_size_t offset = (yy_c_buf_p) - (yytext_ptr);
			++(yy_c_buf_p);

			switch ( yy_get_next_buffer(  ) )
				{
				case EOB_ACT_LAST_MATCH:
					/* This happens because yy_g_n_b()
					 * sees that we've accumulated a
					 * token and flags that we need to
					 * try matching the token before
					 * proceeding.  But for input(),
					 * there's no matching to consider.
					 * So convert the EOB_ACT_LAST_MATCH
					 * to EOB_ACT_END_OF_FILE.
					 */

					/* Reset buffer status. */
					yyrestart(yyin );

					/*FALLTHROUGH*/

				case EOB_ACT_END_OF_FILE:
					{
					if ( yywrap( ) )
						return 0;

					if ( ! (yy_did_buffer_switch_on_eof) )
						YY_NEW_FILE;
#ifdef __cplusplus
					return yyinput();
#else
					return input();
#endif
					}

				case EOB_ACT_CONTINUE_SCAN:
					(yy_c_buf_p) = (yytext_ptr) + offset;
					break;
				}
			}
		}

	c = *(unsigned char *) (yy_c_buf_p);	/* cast for 8-bit char's */
	*(yy_c_buf_p) = '\0';	/* preserve yytext */
	(yy_hold_char) = *++(yy_c_buf_p);

	return c;
}
#endif	/* ifndef YY_NO_INPUT */

/** Immediately switch to a different input stream.
 * @param input_file A readable stream.
 * 
 * @note This function does not reset the start condition to @c INITIAL .
 */
    void yyrestart  (FILE * input_file )
{
    
	if ( ! YY_CURRENT_BUFFER ){
        yyensure_buffer_stack ();
		YY_CURRENT_BUFFER_LVALUE =
            yy_create_buffer(yyin,YY_BUF_SIZE );
	}

	yy_init_buffer(YY_CURRENT_BUFFER,input_file );
	yy_load_buffer_state( );
}

/** Switch to a different input buffer.
 * @param new_buffer The new input buffer.
 * 
 */
    void yy_switch_to_buffer  (YY_BUFFER_STATE  new_buffer )
{
    
	/* TODO. We should be able to replace this entire function body
	 * with
	 *		yypop_buffer_state();
	 *		yypush_buffer_state(new_buffer);
     */
	yyensure_buffer_stack ();
	if ( YY_CURRENT_BUFFER == new_buffer )
		return;

	if ( YY_CURRENT_BUFFER )
		{
		/* Flush out information for old buffer. */
		*(yy_c_buf_p) = (yy_hold_char);
		YY_CURRENT_BUFFER_LVALUE->yy_buf_pos = (yy_c_buf_p);
		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = (yy_n_chars);
		}

	YY_CURRENT_BUFFER_LVALUE = new_buffer;
	yy_load_buffer_state( );

	/* We don't actually know whether we did this switch during
	 * EOF (yywrap()) processing, but the only time this flag
	 * is looked at is after yywrap() is called, so it's safe
	 * to go ahead and always set it.
	 */
	(yy_did_buffer_switch_on_eof) = 1;
}

static void yy_load_buffer_state  (void)
{
    	(yy_n_chars) = YY_CURRENT_BUFFER_LVALUE->yy_n_chars;
	(yytext_ptr) = (yy_c_buf_p) = YY_CURRENT_BUFFER_LVALUE->yy_buf_pos;
	yyin = YY_CURRENT_BUFFER_LVALUE->yy_input_file;
	(yy_hold_char) = *(yy_c_buf_p);
}

/** Allocate and initialize an input buffer state.
 * @param file A readable stream.
 * @param size The character buffer size in bytes. When in doubt, use @c YY_BUF_SIZE.
 * 
 * @return the allocated buffer state.
 */
    YY_BUFFER_STATE yy_create_buffer  (FILE * file, int  size )
{
	YY_BUFFER_STATE b;
    
	b = (YY_BUFFER_STATE) yyalloc(sizeof( struct yy_buffer_state )  );
	if ( ! b )
		YY_FATAL_ERROR( "out of dynamic memory in yy_create_buffer()" );

	b->yy_buf_size = size;

	/* yy_ch_buf has to be 2 characters longer than the size given because
	 * we need to put in 2 end-of-buffer characters.
	 */
	b->yy_ch_buf = (char *) yyalloc(b->yy_buf_size + 2  );
	if ( ! b->yy_ch_buf )
		YY_FATAL_ERROR( "out of dynamic memory in yy_create_buffer()" );

	b->yy_is_our_buffer = 1;

	yy_init_buffer(b,file );

	return b;
}

/** Destroy the buffer.
 * @param b a buffer created with yy_create_buffer()
 * 
 */
    void yy_delete_buffer (YY_BUFFER_STATE  b )
{
    
	if ( ! b )
		return;

	if ( b == YY_CURRENT_BUFFER ) /* Not sure if we should pop here. */
		YY_CURRENT_BUFFER_LVALUE = (YY_BUFFER_STATE) 0;

	if ( b->yy_is_our_buffer )
		yyfree((void *) b->yy_ch_buf  );

	yyfree((void *) b  );
}

#ifndef __cplusplus
extern int isatty (int );
#endif /* __cplusplus */
    
/* Initializes or reinitializes a buffer.
 * This function is sometimes called more than once on the same buffer,
 * such as during a yyrestart() or at EOF.
 */
    static void yy_init_buffer  (YY_BUFFER_STATE  b, FILE * file )

{
	int oerrno = errno;
    
	yy_flush_buffer(b );

	b->yy_input_file = file;
	b->yy_fill_buffer = 1;

    /* If b is the current buffer, then yy_init_buffer was _probably_
     * called from yyrestart() or through yy_get_next_buffer.
     * In that case, we don't want to reset the lineno or column.
     */
    if (b != YY_CURRENT_BUFFER){
        b->yy_bs_lineno = 1;
        b->yy_bs_column = 0;
    }

        b->yy_is_interactive = file ? (isatty( fileno(file) ) > 0) : 0;
    
	errno = oerrno;
}

/** Discard all buffered characters. On the next scan, YY_INPUT will be called.
 * @param b the buffer state to be flushed, usually @c YY_CURRENT_BUFFER.
 * 
 */
    void yy_flush_buffer (YY_BUFFER_STATE  b )
{
    	if ( ! b )
		return;

	b->yy_n_chars = 0;

	/* We always need two end-of-buffer characters.  The first causes
	 * a transition to the end-of-buffer state.  The second causes
	 * a jam in that state.
	 */
	b->yy_ch_buf[0] = YY_END_OF_BUFFER_CHAR;
	b->yy_ch_buf[1] = YY_END_OF_BUFFER_CHAR;

	b->yy_buf_pos = &b->yy_ch_buf[0];

	b->yy_at_bol = 1;
	b->yy_buffer_status = YY_BUFFER_NEW;

	if ( b == YY_CURRENT_BUFFER )
		yy_load_buffer_state( );
}

/** Pushes the new state onto the stack. The new state becomes
 *  the current state. This function will allocate the stack
 *  if necessary.
 *  @param new_buffer The new state.
 *  
 */
void yypush_buffer_state (YY_BUFFER_STATE new_buffer )
{
    	if (new_buffer == NULL)
		return;

	yyensure_buffer_stack();

	/* This block is copied from yy_switch_to_buffer. */
	if ( YY_CURRENT_BUFFER )
		{
		/* Flush out information for old buffer. */
		*(yy_c_buf_p) = (yy_hold_char);
		YY_CURRENT_BUFFER_LVALUE->yy_buf_pos = (yy_c_buf_p);
		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = (yy_n_chars);
		}

	/* Only push if top exists. Otherwise, replace top. */
	if (YY_CURRENT_BUFFER)
		(yy_buffer_stack_top)++;
	YY_CURRENT_BUFFER_LVALUE = new_buffer;

	/* copied from yy_switch_to_buffer. */
	yy_load_buffer_state( );
	(yy_did_buffer_switch_on_eof) = 1;
}

/** Removes and deletes the top of the stack, if present.
 *  The next element becomes the new top.
 *  
 */
void yypop_buffer_state (void)
{
    	if (!YY_CURRENT_BUFFER)
		return;

	yy_delete_buffer(YY_CURRENT_BUFFER );
	YY_CURRENT_BUFFER_LVALUE = NULL;
	if ((yy_buffer_stack_top) > 0)
		--(yy_buffer_stack_top);

	if (YY_CURRENT_BUFFER) {
		yy_load_buffer_state( );
		(yy_did_buffer_switch_on_eof) = 1;
	}
}

/* Allocates the stack if it does not exist.
 *  Guarantees space for at least one push.
 */
static void yyensure_buffer_stack (void)
{
	yy_size_t num_to_alloc;
    
	if (!(yy_buffer_stack)) {

		/* First allocation is just for 2 elements, since we don't know if this
		 * scanner will even need a stack. We use 2 instead of 1 to avoid an
		 * immediate realloc on the next call.
         */
		num_to_alloc = 1;
		(yy_buffer_stack) = (struct yy_buffer_state**)yyalloc
								(num_to_alloc * sizeof(struct yy_buffer_state*)
								);
		if ( ! (yy_buffer_stack) )
			YY_FATAL_ERROR( "out of dynamic memory in yyensure_buffer_stack()" );
								  
		memset((yy_buffer_stack), 0, num_to_alloc * sizeof(struct yy_buffer_state*));
				
		(yy_buffer_stack_max) = num_to_alloc;
		(yy_buffer_stack_top) = 0;
		return;
	}

	if ((yy_buffer_stack_top) >= ((yy_buffer_stack_max)) - 1){

		/* Increase the buffer to prepare for a possible push. */
		int grow_size = 8 /* arbitrary grow size */;

		num_to_alloc = (yy_buffer_stack_max) + grow_size;
		(yy_buffer_stack) = (struct yy_buffer_state**)yyrealloc
								((yy_buffer_stack),
								num_to_alloc * sizeof(struct yy_buffer_state*)
								);
		if ( ! (yy_buffer_stack) )
			YY_FATAL_ERROR( "out of dynamic memory in yyensure_buffer_stack()" );

		/* zero only the new slots.*/
		memset((yy_buffer_stack) + (yy_buffer_stack_max), 0, grow_size * sizeof(struct yy_buffer_state*));
		(yy_buffer_stack_max) = num_to_alloc;
	}
}

/** Setup the input buffer state to scan directly from a user-specified character buffer.
 * @param base the character buffer
 * @param size the size in bytes of the character buffer
 * 
 * @return the newly allocated buffer state object. 
 */
YY_BUFFER_STATE yy_scan_buffer  (char * base, yy_size_t  size )
{
	YY_BUFFER_STATE b;
    
	if ( size < 2 ||
	     base[size-2] != YY_END_OF_BUFFER_CHAR ||
	     base[size-1] != YY_END_OF_BUFFER_CHAR )
		/* They forgot to leave room for the EOB's. */
		return 0;

	b = (YY_BUFFER_STATE) yyalloc(sizeof( struct yy_buffer_state )  );
	if ( ! b )
		YY_FATAL_ERROR( "out of dynamic memory in yy_scan_buffer()" );

	b->yy_buf_size = size - 2;	/* "- 2" to take care of EOB's */
	b->yy_buf_pos = b->yy_ch_buf = base;
	b->yy_is_our_buffer = 0;
	b->yy_input_file = 0;
	b->yy_n_chars = b->yy_buf_size;
	b->yy_is_interactive = 0;
	b->yy_at_bol = 1;
	b->yy_fill_buffer = 0;
	b->yy_buffer_status = YY_BUFFER_NEW;

	yy_switch_to_buffer(b  );

	return b;
}

/** Setup the input buffer state to scan a string. The next call to yylex() will
 * scan from a @e copy of @a str.
 * @param yystr a NUL-terminated string to scan
 * 
 * @return the newly allocated buffer state object.
 * @note If you want to scan bytes that may contain NUL values, then use
 *       yy_scan_bytes() instead.
 */
YY_BUFFER_STATE yy_scan_string (yyconst char * yystr )
{
    
	return yy_scan_bytes(yystr,strlen(yystr) );
}

/** Setup the input buffer state to scan the given bytes. The next call to yylex() will
 * scan from a @e copy of @a bytes.
 * @param bytes the byte buffer to scan
 * @param len the number of bytes in the buffer pointed to by @a bytes.
 * 
 * @return the newly allocated buffer state object.
 */
YY_BUFFER_STATE yy_scan_bytes  (yyconst char * yybytes, yy_size_t  _yybytes_len )
{
	YY_BUFFER_STATE b;
	char *buf;
	yy_size_t n, i;
    
	/* Get memory for full buffer, including space for trailing EOB's. */
	n = _yybytes_len + 2;
	buf = (char *) yyalloc(n  );
	if ( ! buf )
		YY_FATAL_ERROR( "out of dynamic memory in yy_scan_bytes()" );

	for ( i = 0; i < _yybytes_len; ++i )
		buf[i] = yybytes[i];

	buf[_yybytes_len] = buf[_yybytes_len+1] = YY_END_OF_BUFFER_CHAR;

	b = yy_scan_buffer(buf,n );
	if ( ! b )
		YY_FATAL_ERROR( "bad buffer in yy_scan_bytes()" );

	/* It's okay to grow etc. this buffer, and we should throw it
	 * away when we're done.
	 */
	b->yy_is_our_buffer = 1;

	return b;
}

#ifndef YY_EXIT_FAILURE
#define YY_EXIT_FAILURE 2
#endif

static void yy_fatal_error (yyconst char* msg )
{
    	(void) fprintf( stderr, "%s\n", msg );
	exit( YY_EXIT_FAILURE );
}

/* Redefine yyless() so it works in section 3 code. */

#undef yyless
#define yyless(n) \
	do \
		{ \
		/* Undo effects of setting up yytext. */ \
        int yyless_macro_arg = (n); \
        YY_LESS_LINENO(yyless_macro_arg);\
		yytext[yyleng] = (yy_hold_char); \
		(yy_c_buf_p) = yytext + yyless_macro_arg; \
		(yy_hold_char) = *(yy_c_buf_p); \
		*(yy_c_buf_p) = '\0'; \
		yyleng = yyless_macro_arg; \
		} \
	while ( 0 )

/* Accessor  methods (get/set functions) to struct members. */

/** Get the current line number.
 * 
 */
int yyget_lineno  (void)
{
        
    return yylineno;
}

/** Get the input stream.
 * 
 */
FILE *yyget_in  (void)
{
        return yyin;
}

/** Get the output stream.
 * 
 */
FILE *yyget_out  (void)
{
        return yyout;
}

/** Get the length of the current token.
 * 
 */
yy_size_t yyget_leng  (void)
{
        return yyleng;
}

/** Get the current token.
 * 
 */

char *yyget_text  (void)
{
        return yytext;
}

/** Set the current line number.
 * @param line_number
 * 
 */
void yyset_lineno (int  line_number )
{
    
    yylineno = line_number;
}

/** Set the input stream. This does not discard the current
 * input buffer.
 * @param in_str A readable stream.
 * 
 * @see yy_switch_to_buffer
 */
void yyset_in (FILE *  in_str )
{
        yyin = in_str ;
}

void yyset_out (FILE *  out_str )
{
        yyout = out_str ;
}

int yyget_debug  (void)
{
        return yy_flex_debug;
}

void yyset_debug (int  bdebug )
{
        yy_flex_debug = bdebug ;
}

static int yy_init_globals (void)
{
        /* Initialization is the same as for the non-reentrant scanner.
     * This function is called from yylex_destroy(), so don't allocate here.
     */

    (yy_buffer_stack) = 0;
    (yy_buffer_stack_top) = 0;
    (yy_buffer_stack_max) = 0;
    (yy_c_buf_p) = (char *) 0;
    (yy_init) = 0;
    (yy_start) = 0;

/* Defined in main.c */
#ifdef YY_STDINIT
    yyin = stdin;
    yyout = stdout;
#else
    yyin = (FILE *) 0;
    yyout = (FILE *) 0;
#endif

    /* For future reference: Set errno on error, since we are called by
     * yylex_init()
     */
    return 0;
}

/* yylex_destroy is for both reentrant and non-reentrant scanners. */
int yylex_destroy  (void)
{
    
    /* Pop the buffer stack, destroying each element. */
	while(YY_CURRENT_BUFFER){
		yy_delete_buffer(YY_CURRENT_BUFFER  );
		YY_CURRENT_BUFFER_LVALUE = NULL;
		yypop_buffer_state();
	}

	/* Destroy the stack itself. */
	yyfree((yy_buffer_stack) );
	(yy_buffer_stack) = NULL;

    /* Reset the globals. This is important in a non-reentrant scanner so the next time
     * yylex() is called, initialization will occur. */
    yy_init_globals( );

    return 0;
}

/*
 * Internal utility routines.
 */

#ifndef yytext_ptr
static void yy_flex_strncpy (char* s1, yyconst char * s2, int n )
{
	register int i;
	for ( i = 0; i < n; ++i )
		s1[i] = s2[i];
}
#endif

#ifdef YY_NEED_STRLEN
static int yy_flex_strlen (yyconst char * s )
{
	register int n;
	for ( n = 0; s[n]; ++n )
		;

	return n;
}
#endif

void *yyalloc (yy_size_t  size )
{
	return (void *) malloc( size );
}

void *yyrealloc  (void * ptr, yy_size_t  size )
{
	/* The cast to (char *) in the following accommodates both
	 * implementations that use char* generic pointers, and those
	 * that use void* generic pointers.  It works with the latter
	 * because both ANSI C and C++ allow castless assignment from
	 * any pointer type to void*, and deal with argument conversions
	 * as though doing an assignment.
	 */
	return (void *) realloc( (char *) ptr, size );
}

void yyfree (void * ptr )
{
	free( (char *) ptr );	/* see yyrealloc() for (char *) cast */
}

#define YYTABLES_NAME "yytables"

/* A Bison parser, made by GNU Bison 2.3.  */

/* Skeleton implementation for Bison's Yacc-like parsers in C

   Copyright (C) 1984, 1989, 1990, 2000, 2001, 2002, 2003, 2004, 2005, 2006
   Free Software Foundation, Inc.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 51 Franklin Street, Fifth Floor,
   Boston, MA 02110-1301, USA.  */

/* As a special exception, you may create a larger work that contains
   part or all of the Bison parser skeleton and distribute that work
   under terms of your choice, so long as that work isn't itself a
   parser generator using the skeleton or a modified version thereof
   as a parser skeleton.  Alternatively, if you modify or redistribute
   the parser skeleton itself, you may (at your option) remove this
   special exception, which will cause the skeleton and the resulting
   Bison output files to be licensed under the GNU General Public
   License without this special exception.

   This special exception was added by the Free Software Foundation in
   version 2.2 of Bison.  */

/* C LALR(1) parser skeleton written by Richard Stallman, by
   simplifying the original so-called "semantic" parser.  */

/* All symbols defined below should begin with yy or YY, to avoid
   infringing on user name space.  This should be done even for local
   variables, as they might otherwise be expanded by user macros.
   There are some unavoidable exceptions within include files to
   define necessary library symbols; they are noted "INFRINGES ON
   USER NAME SPACE" below.  */

/* Identify Bison output.  */
#define YYBISON 1

/* Bison version.  */
#define YYBISON_VERSION "2.3"

/* Skeleton name.  */
#define YYSKELETON_NAME "yacc.c"

/* Pure parsers.  */
#define YYPURE 1

/* Using locations.  */
#define YYLSP_NEEDED 0



/* Tokens.  */
#ifndef YYTOKENTYPE
# define YYTOKENTYPE
   /* Put the tokens into the symbol table, so that GDB and other debuggers
      know about them.  */
   enum yytokentype {
     TOKEN_EOF = 0,
     LOWEST_PREC = 258,
     UNIMPORTANT_TOK = 259,
     WHITESPACE = 260,
     SGML_CD = 261,
     INCLUDES = 262,
     DASHMATCH = 263,
     BEGINSWITH = 264,
     ENDSWITH = 265,
     CONTAINS = 266,
     STRING = 267,
     IDENT = 268,
     NTH = 269,
     HEX = 270,
     IDSEL = 271,
     IMPORT_SYM = 272,
     MEDIA_SYM = 273,
     FONT_FACE_SYM = 274,
     CHARSET_SYM = 275,
     ATKEYWORD = 276,
     IMPORTANT_SYM = 277,
     MEDIA_ONLY = 278,
     MEDIA_NOT = 279,
     MEDIA_AND = 280,
     CSSLENGTH = 281,
     DIMEN = 282,
     INVALIDDIMEN = 283,
     PERCENTAGE = 284,
     FLOATTOKEN = 285,
     INTEGER = 286,
     URII = 287,
     CSSFUNCTION = 288,
     ANYFUNCTION = 289,
     NOTFUNCTION = 290,
     CALCFUNCTION = 291,
     MINFUNCTION = 292,
     MAXFUNCTION = 293,
     UNICODERANGE = 294
   };
#endif
/* Tokens.  */
#define TOKEN_EOF 0
#define LOWEST_PREC 258
#define UNIMPORTANT_TOK 259
#define WHITESPACE 260
#define SGML_CD 261
#define INCLUDES 262
#define DASHMATCH 263
#define BEGINSWITH 264
#define ENDSWITH 265
#define CONTAINS 266
#define STRING 267
#define IDENT 268
#define NTH 269
#define HEX 270
#define IDSEL 271
#define IMPORT_SYM 272
#define MEDIA_SYM 273
#define FONT_FACE_SYM 274
#define CHARSET_SYM 275
#define ATKEYWORD 276
#define IMPORTANT_SYM 277
#define MEDIA_ONLY 278
#define MEDIA_NOT 279
#define MEDIA_AND 280
#define CSSLENGTH 281
#define DIMEN 282
#define INVALIDDIMEN 283
#define PERCENTAGE 284
#define FLOATTOKEN 285
#define INTEGER 286
#define URII 287
#define CSSFUNCTION 288
#define ANYFUNCTION 289
#define NOTFUNCTION 290
#define CALCFUNCTION 291
#define MINFUNCTION 292
#define MAXFUNCTION 293
#define UNICODERANGE 294




/* Copy the first part of user declarations.  */



#if __BEE_DEVELOPMENT__
void yyerror(CSSParser * parser, char const * s)
{
    fprintf(stderr, "[CSSError] %s. error near:\n-----\n%s\n-----\n",
            s, (*yy_buffer_stack[0]).yy_ch_buf);
}
#else  // #if __BEE_DEVELOPMENT__
void yyerror(CSSParser * parser, char const * s) {}
#endif // #if __BEE_DEVELOPMENT__



/* Enabling traces.  */
#ifndef YYDEBUG
# define YYDEBUG 1
#endif

/* Enabling verbose error messages.  */
#ifdef YYERROR_VERBOSE
# undef YYERROR_VERBOSE
# define YYERROR_VERBOSE 1
#else
# define YYERROR_VERBOSE 0
#endif

/* Enabling the token table.  */
#ifndef YYTOKEN_TABLE
# define YYTOKEN_TABLE 1
#endif

#if ! defined YYSTYPE && ! defined YYSTYPE_IS_DECLARED
typedef union YYSTYPE

{
    bool                 boolean;
    char                 character;
    int                  integer;
    double               number;
    float                val;

    NSNumber           * nsnumber;
    NSString           * nsstring;
    NSString           * string;
    CSSRule            * rule;
    CSSRuleList        * ruleList;
    CSSSelector        * selector;
    NSMutableArray     * selectorList;
    int                  marginBox;
    int                  relation;
    CSSMediaList       * mediaList;
    CSSMediaQuery      * mediaQuery;
    NSObject           * mediaQueryRestrictor;
    CSSMediaQueryExp   * mediaQueryExp;
    NSString           * value;
    NSString           * valueList;
    NSMutableArray     * mediaQueryExpList;
}
/* Line 193 of yacc.c.  */

	YYSTYPE;
# define yystype YYSTYPE /* obsolescent; will be withdrawn */
# define YYSTYPE_IS_DECLARED 1
# define YYSTYPE_IS_TRIVIAL 1
#endif



/* Copy the second part of user declarations.  */


/* Line 216 of yacc.c.  */


#ifdef short
# undef short
#endif

#ifdef YYTYPE_UINT8
typedef YYTYPE_UINT8 yytype_uint8;
#else
typedef unsigned char yytype_uint8;
#endif

#ifdef YYTYPE_INT8
typedef YYTYPE_INT8 yytype_int8;
#elif (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
typedef signed char yytype_int8;
#else
typedef short int yytype_int8;
#endif

#ifdef YYTYPE_UINT16
typedef YYTYPE_UINT16 yytype_uint16;
#else
typedef unsigned short int yytype_uint16;
#endif

#ifdef YYTYPE_INT16
typedef YYTYPE_INT16 yytype_int16;
#else
typedef short int yytype_int16;
#endif

#ifndef YYSIZE_T
# ifdef __SIZE_TYPE__
#  define YYSIZE_T __SIZE_TYPE__
# elif defined size_t
#  define YYSIZE_T size_t
# elif ! defined YYSIZE_T && (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
#  include <stddef.h> /* INFRINGES ON USER NAME SPACE */
#  define YYSIZE_T size_t
# else
#  define YYSIZE_T unsigned int
# endif
#endif

#define YYSIZE_MAXIMUM ((YYSIZE_T) -1)

#ifndef YY_
# if defined YYENABLE_NLS && YYENABLE_NLS
#  if ENABLE_NLS
#   include <libintl.h> /* INFRINGES ON USER NAME SPACE */
#   define YY_(msgid) dgettext ("bison-runtime", msgid)
#  endif
# endif
# ifndef YY_
#  define YY_(msgid) msgid
# endif
#endif

/* Suppress unused-variable warnings by "using" E.  */
#if ! defined lint || defined __GNUC__
# define YYUSE(e) ((void) (e))
#else
# define YYUSE(e) /* empty */
#endif

/* Identity function, used to suppress warnings about constant conditions.  */
#ifndef lint
# define YYID(n) (n)
#else
#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
static int
YYID (int i)
#else
static int
YYID (i)
    int i;
#endif
{
  return i;
}
#endif

#if ! defined yyoverflow || YYERROR_VERBOSE

/* The parser invokes alloca or malloc; define the necessary symbols.  */

# ifdef YYSTACK_USE_ALLOCA
#  if YYSTACK_USE_ALLOCA
#   ifdef __GNUC__
#    define YYSTACK_ALLOC __builtin_alloca
#   elif defined __BUILTIN_VA_ARG_INCR
#    include <alloca.h> /* INFRINGES ON USER NAME SPACE */
#   elif defined _AIX
#    define YYSTACK_ALLOC __alloca
#   elif defined _MSC_VER
#    include <malloc.h> /* INFRINGES ON USER NAME SPACE */
#    define alloca _alloca
#   else
#    define YYSTACK_ALLOC alloca
#    if ! defined _ALLOCA_H && ! defined _STDLIB_H && (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
#     include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
#     ifndef _STDLIB_H
#      define _STDLIB_H 1
#     endif
#    endif
#   endif
#  endif
# endif

# ifdef YYSTACK_ALLOC
   /* Pacify GCC's `empty if-body' warning.  */
#  define YYSTACK_FREE(Ptr) do { /* empty */; } while (YYID (0))
#  ifndef YYSTACK_ALLOC_MAXIMUM
    /* The OS might guarantee only one guard page at the bottom of the stack,
       and a page size can be as small as 4096 bytes.  So we cannot safely
       invoke alloca (N) if N exceeds 4096.  Use a slightly smaller number
       to allow for a few compiler-allocated temporary stack slots.  */
#   define YYSTACK_ALLOC_MAXIMUM 4032 /* reasonable circa 2006 */
#  endif
# else
#  define YYSTACK_ALLOC YYMALLOC
#  define YYSTACK_FREE YYFREE
#  ifndef YYSTACK_ALLOC_MAXIMUM
#   define YYSTACK_ALLOC_MAXIMUM YYSIZE_MAXIMUM
#  endif
#  if (defined __cplusplus && ! defined _STDLIB_H \
       && ! ((defined YYMALLOC || defined malloc) \
	     && (defined YYFREE || defined free)))
#   include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
#   ifndef _STDLIB_H
#    define _STDLIB_H 1
#   endif
#  endif
#  ifndef YYMALLOC
#   define YYMALLOC malloc
#   if ! defined malloc && ! defined _STDLIB_H && (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
void *malloc (YYSIZE_T); /* INFRINGES ON USER NAME SPACE */
#   endif
#  endif
#  ifndef YYFREE
#   define YYFREE free
#   if ! defined free && ! defined _STDLIB_H && (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
void free (void *); /* INFRINGES ON USER NAME SPACE */
#   endif
#  endif
# endif
#endif /* ! defined yyoverflow || YYERROR_VERBOSE */


#if (! defined yyoverflow \
     && (! defined __cplusplus \
	 || (defined YYSTYPE_IS_TRIVIAL && YYSTYPE_IS_TRIVIAL)))

/* A type that is properly aligned for any stack member.  */
union yyalloc
{
  yytype_int16 yyss;
  YYSTYPE yyvs;
  };

/* The size of the maximum gap between one aligned stack and the next.  */
# define YYSTACK_GAP_MAXIMUM (sizeof (union yyalloc) - 1)

/* The size of an array large to enough to hold all stacks, each with
   N elements.  */
# define YYSTACK_BYTES(N) \
     ((N) * (sizeof (yytype_int16) + sizeof (YYSTYPE)) \
      + YYSTACK_GAP_MAXIMUM)

/* Copy COUNT objects from FROM to TO.  The source and destination do
   not overlap.  */
# ifndef YYCOPY
#  if defined __GNUC__ && 1 < __GNUC__
#   define YYCOPY(To, From, Count) \
      __builtin_memcpy (To, From, (Count) * sizeof (*(From)))
#  else
#   define YYCOPY(To, From, Count)		\
      do					\
	{					\
	  YYSIZE_T yyi;				\
	  for (yyi = 0; yyi < (Count); yyi++)	\
	    (To)[yyi] = (From)[yyi];		\
	}					\
      while (YYID (0))
#  endif
# endif

/* Relocate STACK from its old location to the new one.  The
   local variables YYSIZE and YYSTACKSIZE give the old and new number of
   elements in the stack, and YYPTR gives the new location of the
   stack.  Advance YYPTR to a properly aligned location for the next
   stack.  */
# define YYSTACK_RELOCATE(Stack)					\
    do									\
      {									\
	YYSIZE_T yynewbytes;						\
	YYCOPY (&yyptr->Stack, Stack, yysize);				\
	Stack = &yyptr->Stack;						\
	yynewbytes = yystacksize * sizeof (*Stack) + YYSTACK_GAP_MAXIMUM; \
	yyptr += yynewbytes / sizeof (*yyptr);				\
      }									\
    while (YYID (0))

#endif

/* YYFINAL -- State number of the termination state.  */
#define YYFINAL  3
/* YYLAST -- Last index in YYTABLE.  */
#define YYLAST   817

/* YYNTOKENS -- Number of terminals.  */
#define YYNTOKENS  60
/* YYNNTS -- Number of nonterminals.  */
#define YYNNTS  72
/* YYNRULES -- Number of rules.  */
#define YYNRULES  203
/* YYNRULES -- Number of states.  */
#define YYNSTATES  361

/* YYTRANSLATE(YYLEX) -- Bison symbol number corresponding to YYLEX.  */
#define YYUNDEFTOK  2
#define YYMAXUTOK   294

#define YYTRANSLATE(YYX)						\
  ((unsigned int) (YYX) <= YYMAXUTOK ? yytranslate[YYX] : YYUNDEFTOK)

/* YYTRANSLATE[YYLEX] -- Bison symbol number corresponding to YYLEX.  */
static const yytype_uint8 yytranslate[] =
{
       0,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,    58,     2,    59,     2,     2,
      47,    48,    20,    51,    49,    54,    18,    57,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,    17,    46,
       2,    56,    53,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,    19,     2,    55,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,    50,    21,    45,    52,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     1,     2,     3,     4,
       5,     6,     7,     8,     9,    10,    11,    12,    13,    14,
      15,    16,    22,    23,    24,    25,    26,    27,    28,    29,
      30,    31,    32,    33,    34,    35,    36,    37,    38,    39,
      40,    41,    42,    43,    44
};

#if YYDEBUG
/* YYPRHS[YYN] -- Index of the first RHS symbol of rule number YYN in
   YYRHS.  */
static const yytype_uint16 yyprhs[] =
{
       0,     0,     3,     8,     9,    12,    13,    16,    19,    20,
      22,    24,    26,    32,    36,    40,    46,    47,    51,    54,
      56,    58,    60,    62,    64,    66,    68,    69,    73,    75,
      77,    79,    81,    83,    85,    87,    94,   101,   105,   109,
     111,   113,   116,   117,   122,   130,   132,   138,   139,   143,
     144,   146,   148,   150,   155,   156,   158,   160,   165,   168,
     176,   183,   186,   194,   198,   202,   205,   208,   211,   213,
     214,   216,   218,   220,   221,   222,   229,   231,   236,   239,
     242,   244,   246,   249,   253,   256,   258,   261,   263,   265,
     271,   274,   276,   278,   280,   283,   286,   288,   290,   292,
     294,   296,   299,   302,   307,   316,   318,   320,   322,   324,
     326,   328,   330,   332,   335,   339,   346,   353,   361,   368,
     375,   377,   380,   382,   386,   388,   391,   394,   398,   402,
     407,   411,   417,   422,   427,   434,   440,   443,   450,   457,
     460,   464,   469,   472,   475,   478,   479,   481,   485,   488,
     492,   495,   498,   501,   502,   504,   507,   510,   513,   516,
     520,   523,   526,   529,   532,   534,   536,   538,   541,   544,
     547,   550,   553,   559,   563,   565,   568,   571,   574,   577,
     580,   583,   590,   593,   597,   601,   603,   606,   608,   613,
     619,   623,   625,   627,   633,   637,   639,   642,   646,   650,
     653,   659,   663,   665
};

/* YYRHS -- A `-1'-separated list of the rules' RHS.  */
static const yytype_int16 yyrhs[] =
{
      61,     0,    -1,    62,    64,    63,    68,    -1,    -1,    62,
       5,    -1,    -1,    63,     6,    -1,    63,     5,    -1,    -1,
      66,    -1,    45,    -1,     0,    -1,    25,    62,    12,    62,
      46,    -1,    25,     1,   130,    -1,    25,     1,    46,    -1,
      25,    62,    12,    62,    46,    -1,    -1,    68,    70,    63,
      -1,    92,    94,    -1,    85,    -1,    87,    -1,    74,    -1,
      69,    -1,    67,    -1,   129,    -1,   128,    -1,    -1,    71,
      73,    63,    -1,    94,    -1,    87,    -1,    72,    -1,   129,
      -1,   128,    -1,    74,    -1,    85,    -1,    22,    62,    75,
      62,    83,    46,    -1,    22,    62,    75,    62,    83,   130,
      -1,    22,     1,    46,    -1,    22,     1,   130,    -1,    12,
      -1,    37,    -1,    13,    62,    -1,    -1,    17,    62,   114,
      62,    -1,    47,    62,    76,    62,    77,    48,    62,    -1,
      78,    -1,    79,    62,    30,    62,    78,    -1,    -1,    30,
      62,    79,    -1,    -1,    28,    -1,    29,    -1,    79,    -1,
      81,    62,    86,    80,    -1,    -1,    84,    -1,    82,    -1,
      84,    49,    62,    82,    -1,    84,     1,    -1,    23,    62,
      84,    50,    62,    71,   127,    -1,    23,    62,    50,    62,
      71,   127,    -1,    13,    62,    -1,    24,    62,    50,    62,
     109,    45,    62,    -1,    24,     1,   130,    -1,    24,     1,
      46,    -1,    51,    62,    -1,    52,    62,    -1,    53,    62,
      -1,    90,    -1,    -1,    54,    -1,    51,    -1,    62,    -1,
      -1,    -1,    95,    93,    50,    91,   109,    65,    -1,    97,
      -1,    95,    49,    62,    97,    -1,    95,     1,    -1,    97,
       5,    -1,    98,    -1,    96,    -1,    96,    98,    -1,    97,
      88,    98,    -1,    97,     1,    -1,   100,    -1,   100,   101,
      -1,   101,    -1,    98,    -1,    99,    62,    49,    62,    98,
      -1,    99,     1,    -1,    13,    -1,    20,    -1,   102,    -1,
     101,   102,    -1,   101,     1,    -1,    16,    -1,    15,    -1,
     103,    -1,   105,    -1,   108,    -1,    18,    13,    -1,    13,
      62,    -1,    19,    62,   104,    55,    -1,    19,    62,   104,
     106,    62,   107,    62,    55,    -1,    56,    -1,     7,    -1,
       8,    -1,     9,    -1,    10,    -1,    11,    -1,    13,    -1,
      12,    -1,    17,    13,    -1,    17,    17,    13,    -1,    17,
      39,    62,    99,    62,    48,    -1,    17,    38,    62,    14,
      62,    48,    -1,    17,    38,    62,    89,    36,    62,    48,
      -1,    17,    38,    62,    13,    62,    48,    -1,    17,    40,
      62,    98,    62,    48,    -1,   111,    -1,   110,   111,    -1,
     110,    -1,     1,   131,     1,    -1,     1,    -1,   110,     1,
      -1,   110,   131,    -1,   111,    46,    62,    -1,   111,   131,
      62,    -1,   111,   131,    46,    62,    -1,     1,    46,    62,
      -1,     1,   131,     1,    46,    62,    -1,   110,   111,    46,
      62,    -1,   110,     1,    46,    62,    -1,   110,     1,   131,
       1,    46,    62,    -1,   112,    17,    62,   114,   113,    -1,
     112,     1,    -1,   112,    17,    62,     1,   114,   113,    -1,
     112,    17,    62,   114,   113,     1,    -1,    27,    62,    -1,
     112,    17,    62,    -1,   112,    17,    62,     1,    -1,   112,
     130,    -1,    13,    62,    -1,    27,    62,    -1,    -1,   116,
      -1,   114,   115,   116,    -1,   114,   131,    -1,   114,   131,
       1,    -1,   114,     1,    -1,    57,    62,    -1,    49,    62,
      -1,    -1,   117,    -1,    90,   117,    -1,    12,    62,    -1,
      13,    62,    -1,    32,    62,    -1,    90,    32,    62,    -1,
      37,    62,    -1,    44,    62,    -1,    15,    62,    -1,    58,
      62,    -1,   118,    -1,   124,    -1,   126,    -1,    59,    62,
      -1,    36,    62,    -1,    35,    62,    -1,    34,    62,    -1,
      31,    62,    -1,    38,    62,   114,    48,    62,    -1,    38,
      62,     1,    -1,   117,    -1,    90,   117,    -1,    51,     5,
      -1,    54,     5,    -1,    20,    62,    -1,    57,    62,    -1,
      13,    62,    -1,    47,    62,   122,    62,    48,    62,    -1,
     119,    62,    -1,   122,   120,   119,    -1,   122,   120,   121,
      -1,   121,    -1,   122,     1,    -1,   122,    -1,   123,    49,
      62,   122,    -1,    41,    62,   122,    48,    62,    -1,    41,
      62,     1,    -1,    42,    -1,    43,    -1,   125,    62,   123,
      48,    62,    -1,   125,    62,     1,    -1,    65,    -1,     1,
      65,    -1,    26,     1,   130,    -1,    26,     1,    46,    -1,
       1,   130,    -1,    50,     1,   131,     1,    65,    -1,    50,
       1,    65,    -1,   130,    -1,   131,     1,   130,    -1
};

/* YYRLINE[YYN] -- source line where rule number YYN was defined.  */
static const yytype_uint16 yyrline[] =
{
       0,   179,   179,   183,   184,   187,   189,   190,   193,   195,
     200,   201,   205,   208,   211,   216,   222,   224,   232,   236,
     237,   238,   242,   245,   246,   247,   251,   252,   263,   264,
     268,   269,   270,   271,   272,   277,   281,   284,   287,   293,
     294,   298,   305,   308,   315,   324,   328,   335,   338,   344,
     347,   350,   356,   362,   372,   375,   379,   384,   390,   396,
     400,   407,   413,   418,   421,   427,   428,   429,   433,   434,
     438,   439,   443,   449,   455,   461,   468,   476,   484,   490,
     496,   500,   503,   515,   528,   534,   539,   545,   554,   561,
     568,   574,   577,   583,   586,   593,   599,   605,   616,   617,
     618,   622,   631,   638,   644,   654,   657,   660,   663,   666,
     669,   675,   676,   680,   689,   698,   711,   721,   731,   742,
     760,   763,   768,   771,   774,   777,   780,   786,   790,   793,
     796,   800,   803,   809,   813,   820,   825,   829,   834,   839,
     844,   849,   854,   861,   868,   869,   873,   876,   889,   892,
     895,   901,   904,   907,   913,   914,   915,   916,   917,   918,
     919,   920,   921,   922,   923,   926,   929,   932,   938,   939,
     940,   941,   945,   950,   957,   960,   966,   969,   972,   975,
     978,   984,   989,   992,   995,   998,   999,  1005,  1008,  1013,
    1016,  1023,  1026,  1032,  1035,  1043,  1046,  1052,  1055,  1061,
    1078,  1080,  1085,  1086
};
#endif

#if YYDEBUG || YYERROR_VERBOSE || YYTOKEN_TABLE
/* YYTNAME[SYMBOL-NUM] -- String name of the symbol SYMBOL-NUM.
   First, the terminals, then, starting at YYNTOKENS, nonterminals.  */
static const char *const yytname[] =
{
  "TOKEN_EOF", "error", "$undefined", "LOWEST_PREC", "UNIMPORTANT_TOK",
  "WHITESPACE", "SGML_CD", "INCLUDES", "DASHMATCH", "BEGINSWITH",
  "ENDSWITH", "CONTAINS", "STRING", "IDENT", "NTH", "HEX", "IDSEL", "':'",
  "'.'", "'['", "'*'", "'|'", "IMPORT_SYM", "MEDIA_SYM", "FONT_FACE_SYM",
  "CHARSET_SYM", "ATKEYWORD", "IMPORTANT_SYM", "MEDIA_ONLY", "MEDIA_NOT",
  "MEDIA_AND", "CSSLENGTH", "DIMEN", "INVALIDDIMEN", "PERCENTAGE",
  "FLOATTOKEN", "INTEGER", "URII", "CSSFUNCTION", "ANYFUNCTION",
  "NOTFUNCTION", "CALCFUNCTION", "MINFUNCTION", "MAXFUNCTION",
  "UNICODERANGE", "'}'", "';'", "'('", "')'", "','", "'{'", "'+'", "'~'",
  "'>'", "'-'", "']'", "'='", "'/'", "'#'", "'%'", "$accept", "stylesheet",
  "maybe_space", "maybe_sgml", "maybe_charset", "closing_brace", "charset",
  "ignored_charset", "rule_list", "valid_rule", "rule", "block_rule_list",
  "block_valid_rule", "block_rule", "import", "string_or_uri",
  "media_feature", "maybe_media_value", "media_query_exp",
  "media_query_exp_list", "maybe_and_media_query_exp_list",
  "maybe_media_restrictor", "media_query", "maybe_media_list",
  "media_list", "media", "medium", "font_face", "combinator",
  "maybe_unary_operator", "unary_operator",
  "maybe_space_before_declaration", "before_ruleset",
  "before_rule_opening_brace", "ruleset", "selector_list",
  "selector_with_trailing_whitespace", "selector", "simple_selector",
  "simple_selector_list", "element_name", "specifier_list", "specifier",
  "class", "attr_name", "attrib", "match", "ident_or_string", "pseudo",
  "declaration_list", "decl_list", "declaration", "property", "prio",
  "expr", "operator", "term", "unary_term", "function", "calc_func_term",
  "calc_func_operator", "calc_func_paren_expr", "calc_func_expr",
  "calc_func_expr_list", "calc_function", "min_or_max",
  "min_or_max_function", "save_block", "invalid_at", "invalid_rule",
  "invalid_block", "invalid_block_list", 0
};
#endif

# ifdef YYPRINT
/* YYTOKNUM[YYLEX-NUM] -- Internal token number corresponding to
   token YYLEX-NUM.  */
static const yytype_uint16 yytoknum[] =
{
       0,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,   267,   268,   269,   270,   271,    58,    46,    91,
      42,   124,   272,   273,   274,   275,   276,   277,   278,   279,
     280,   281,   282,   283,   284,   285,   286,   287,   288,   289,
     290,   291,   292,   293,   294,   125,    59,    40,    41,    44,
     123,    43,   126,    62,    45,    93,    61,    47,    35,    37
};
# endif

/* YYR1[YYN] -- Symbol number of symbol that rule YYN derives.  */
static const yytype_uint8 yyr1[] =
{
       0,    60,    61,    62,    62,    63,    63,    63,    64,    64,
      65,    65,    66,    66,    66,    67,    68,    68,    69,    69,
      69,    69,    70,    70,    70,    70,    71,    71,    72,    72,
      73,    73,    73,    73,    73,    74,    74,    74,    74,    75,
      75,    76,    77,    77,    78,    79,    79,    80,    80,    81,
      81,    81,    82,    82,    83,    83,    84,    84,    84,    85,
      85,    86,    87,    87,    87,    88,    88,    88,    89,    89,
      90,    90,    91,    92,    93,    94,    95,    95,    95,    96,
      97,    97,    97,    97,    97,    98,    98,    98,    99,    99,
      99,   100,   100,   101,   101,   101,   102,   102,   102,   102,
     102,   103,   104,   105,   105,   106,   106,   106,   106,   106,
     106,   107,   107,   108,   108,   108,   108,   108,   108,   108,
     109,   109,   109,   109,   109,   109,   109,   110,   110,   110,
     110,   110,   110,   110,   110,   111,   111,   111,   111,   111,
     111,   111,   111,   112,   113,   113,   114,   114,   114,   114,
     114,   115,   115,   115,   116,   116,   116,   116,   116,   116,
     116,   116,   116,   116,   116,   116,   116,   116,   117,   117,
     117,   117,   118,   118,   119,   119,   120,   120,   120,   120,
     120,   121,   122,   122,   122,   122,   122,   123,   123,   124,
     124,   125,   125,   126,   126,   127,   127,   128,   128,   129,
     130,   130,   131,   131
};

/* YYR2[YYN] -- Number of symbols composing right hand side of rule YYN.  */
static const yytype_uint8 yyr2[] =
{
       0,     2,     4,     0,     2,     0,     2,     2,     0,     1,
       1,     1,     5,     3,     3,     5,     0,     3,     2,     1,
       1,     1,     1,     1,     1,     1,     0,     3,     1,     1,
       1,     1,     1,     1,     1,     6,     6,     3,     3,     1,
       1,     2,     0,     4,     7,     1,     5,     0,     3,     0,
       1,     1,     1,     4,     0,     1,     1,     4,     2,     7,
       6,     2,     7,     3,     3,     2,     2,     2,     1,     0,
       1,     1,     1,     0,     0,     6,     1,     4,     2,     2,
       1,     1,     2,     3,     2,     1,     2,     1,     1,     5,
       2,     1,     1,     1,     2,     2,     1,     1,     1,     1,
       1,     2,     2,     4,     8,     1,     1,     1,     1,     1,
       1,     1,     1,     2,     3,     6,     6,     7,     6,     6,
       1,     2,     1,     3,     1,     2,     2,     3,     3,     4,
       3,     5,     4,     4,     6,     5,     2,     6,     6,     2,
       3,     4,     2,     2,     2,     0,     1,     3,     2,     3,
       2,     2,     2,     0,     1,     2,     2,     2,     2,     3,
       2,     2,     2,     2,     1,     1,     1,     2,     2,     2,
       2,     2,     5,     3,     1,     2,     2,     2,     2,     2,
       2,     6,     2,     3,     3,     1,     2,     1,     4,     5,
       3,     1,     1,     5,     3,     1,     2,     3,     3,     2,
       5,     3,     1,     3
};

/* YYDEFACT[STATE-NAME] -- Default rule to reduce with in state
   STATE-NUM when YYTABLE doesn't specify something else to do.  Zero
   means the default is an error.  */
static const yytype_uint8 yydefact[] =
{
       3,     0,     8,     1,     4,     0,     5,     9,     0,     0,
      16,    14,     0,    13,     3,     7,     6,     0,     0,     0,
       0,     0,     3,     0,     3,     0,    23,    22,     5,    21,
      19,    20,     0,    25,    24,    11,    10,   201,   202,     0,
      12,   199,     0,     0,    49,     0,     0,     0,     0,    17,
      91,    97,    96,     0,     0,     3,    92,    18,     0,    81,
       0,    80,    85,     0,    93,    98,    99,   100,     0,    37,
      38,    39,    40,     3,    50,    51,     3,     3,    45,    52,
       3,    56,     0,    64,    63,     3,     3,   198,   197,   113,
       0,     3,     3,     3,   101,     0,    78,     3,     0,    82,
      84,    79,     3,     3,     3,     0,     0,    95,    94,   200,
     203,    54,     0,    26,     0,     0,    58,     3,     3,     0,
       0,   114,    69,     0,     0,     3,     0,     0,     3,    65,
      66,    67,    83,     0,     0,     3,     3,     0,     3,     3,
      47,    49,    26,   124,     3,     3,     0,     0,   120,     0,
      15,     3,     3,    71,    70,     0,    68,    88,     0,     3,
     102,   106,   107,   108,   109,   110,   103,   105,     3,     0,
      72,     0,    35,    36,    41,    42,     0,   195,    30,     5,
      33,    34,    29,    28,    60,    32,    31,     0,    61,     3,
      53,    57,     0,     3,     0,   143,   139,     3,   125,   121,
       0,     3,     0,   136,     3,   142,     0,     0,     3,    90,
       0,     0,     0,     0,     3,     0,   196,    27,    46,     0,
      59,   130,   123,    62,     3,     0,     3,     0,   127,     3,
     128,     0,   118,   116,     0,   115,     3,   119,   112,   111,
       3,    75,     0,     3,    48,     3,   133,     0,   132,   129,
     141,     3,     3,     3,     3,     3,     3,     3,     3,     3,
       3,     3,   191,   192,     3,     3,     3,     0,     0,   146,
     154,   164,   165,     3,   166,   117,     0,     0,     0,    44,
     131,     3,     0,   156,   157,   162,   171,   158,   170,   169,
     168,   160,     0,     0,   161,   163,   167,     3,   155,   150,
       3,     3,     3,     0,     0,     0,     0,    89,   104,    43,
     134,   137,   173,     0,   190,     3,     0,   174,     3,   185,
       0,   159,   144,   152,   151,   138,   147,   149,   194,     0,
       0,     3,     0,   175,   182,   186,     3,     3,     3,     0,
       0,     3,     0,     3,     3,   172,     0,   180,   178,   189,
     176,   177,   179,   183,   184,   193,     0,     0,     0,     3,
     181
};

/* YYDEFGOTO[NTERM-NUM].  */
static const yytype_int16 yydefgoto[] =
{
      -1,     1,   114,    10,     6,   177,     7,    26,    17,    27,
      28,   137,   178,   179,   180,    73,   136,   215,    78,    79,
     190,    80,    81,   133,    82,   181,   140,   182,   105,   155,
     267,   171,    32,    98,   183,    58,    59,    60,    61,   158,
      62,    63,    64,    65,   126,    66,   168,   240,    67,   146,
     147,   148,   149,   303,   268,   304,   269,   270,   271,   318,
     342,   319,   320,   330,   272,   273,   274,   184,   185,   186,
      38,   305
};

/* YYPACT[STATE-NUM] -- Index in YYTABLE of the portion describing
   STATE-NUM.  */
#define YYPACT_NINF -261
static const yytype_int16 yypact[] =
{
    -261,    16,    24,  -261,  -261,   194,  -261,  -261,   -20,   135,
     301,  -261,    31,  -261,  -261,  -261,  -261,   791,    19,   108,
     -25,   232,  -261,    33,  -261,   111,  -261,  -261,  -261,  -261,
    -261,  -261,   564,  -261,  -261,  -261,  -261,  -261,  -261,   113,
    -261,  -261,    55,     5,   267,   184,    13,   195,   270,   301,
    -261,  -261,  -261,   561,    22,  -261,  -261,  -261,   142,   564,
       8,  -261,   446,   684,  -261,  -261,  -261,  -261,    19,  -261,
    -261,  -261,  -261,  -261,  -261,  -261,  -261,  -261,  -261,     6,
    -261,  -261,   189,  -261,  -261,  -261,  -261,  -261,  -261,  -261,
     118,  -261,  -261,  -261,  -261,    34,  -261,  -261,    96,  -261,
    -261,  -261,  -261,  -261,  -261,   564,   690,  -261,  -261,  -261,
    -261,   298,   269,   145,     7,   275,  -261,  -261,  -261,   285,
     136,  -261,   278,   403,   403,  -261,   100,   403,  -261,   145,
     145,   145,  -261,   327,   114,  -261,  -261,   760,  -261,  -261,
     149,   329,   145,   364,  -261,  -261,   172,   249,   402,   115,
    -261,  -261,  -261,  -261,  -261,   196,  -261,  -261,   222,  -261,
     145,  -261,  -261,  -261,  -261,  -261,  -261,  -261,  -261,    70,
     145,    14,  -261,  -261,   145,   171,    19,  -261,  -261,  -261,
    -261,  -261,  -261,  -261,  -261,  -261,  -261,    90,   145,  -261,
    -261,  -261,   760,  -261,   240,   145,   145,  -261,   423,   241,
     126,  -261,   475,  -261,  -261,  -261,   162,   165,  -261,  -261,
       3,   168,   272,    54,  -261,   220,  -261,   301,  -261,    90,
    -261,   145,   428,   145,  -261,   303,  -261,   -25,   145,  -261,
     145,   455,  -261,  -261,   198,  -261,  -261,  -261,  -261,  -261,
    -261,  -261,   639,  -261,     6,  -261,   145,   433,   145,   145,
     713,  -261,  -261,  -261,  -261,  -261,  -261,  -261,  -261,  -261,
    -261,  -261,  -261,  -261,  -261,  -261,  -261,   334,   400,  -261,
    -261,  -261,  -261,  -261,  -261,  -261,   403,    15,   503,   145,
     145,  -261,   400,   145,   145,   145,   145,   145,   145,   145,
     145,   145,   605,   274,   145,   145,   145,  -261,  -261,  -261,
    -261,  -261,  -261,    44,   713,   348,   288,  -261,  -261,   145,
     145,  -261,  -261,   554,  -261,  -261,   394,  -261,  -261,  -261,
     174,   145,   145,   145,   145,  -261,  -261,   -25,  -261,    30,
     339,  -261,   476,  -261,   145,  -261,  -261,  -261,  -261,   308,
     325,  -261,   320,  -261,  -261,   145,   161,   145,   145,   145,
    -261,  -261,   145,  -261,  -261,   145,   476,   200,   129,  -261,
     145
};

/* YYPGOTO[NTERM-NUM].  */
static const yytype_int16 yypgoto[] =
{
    -261,  -261,     0,   -22,  -261,   -15,  -261,  -261,  -261,  -261,
    -261,   191,  -261,  -261,   323,  -261,  -261,  -261,   163,   133,
    -261,  -261,   221,  -261,   253,   355,  -261,   361,  -261,  -261,
    -121,  -261,  -261,  -261,   349,  -261,  -261,   268,   -57,  -261,
    -261,   341,   157,  -261,  -261,  -261,  -261,  -261,  -261,   233,
    -261,   262,  -261,   144,  -144,  -261,   107,  -260,  -261,    75,
    -261,    82,  -232,  -261,  -261,  -261,  -261,   247,   416,   430,
      20,   -14
};

/* YYTABLE[YYPACT[STATE-NUM]].  What to do in state STATE-NUM.  If
   positive, shift that token.  If negative, reduce the rule which
   number is the opposite.  If zero, do what YYDEFACT says.
   If YYTABLE_NINF, syntax error.  */
#define YYTABLE_NINF -189
static const yytype_int16 yytable[] =
{
       2,   156,    99,    37,    39,     9,    49,   298,     4,   100,
       4,    -3,     4,   101,    19,   143,     3,    71,     4,    35,
       4,    43,    44,    46,    47,    12,    11,   144,    13,     4,
      12,   335,    18,   317,    45,    94,    -3,   138,    -3,     4,
      41,   145,    72,   336,  -135,   325,   317,   125,   132,     5,
     337,   235,   236,   109,    35,    95,   333,   -76,   -76,   102,
     103,   104,    70,    85,    36,    84,   157,   159,    88,    12,
     308,   100,   317,   111,   329,   101,   112,   113,  -187,  -187,
     115,   339,   317,    -3,   340,   119,   120,   341,   110,  -135,
    -135,   122,   123,   124,  -135,     4,   317,   127,   278,    36,
     346,    69,   129,   130,   131,    12,   282,   161,   162,   163,
     164,   165,    48,     4,    68,   116,   203,   141,   142,   -77,
     -77,   102,   103,   104,   358,   160,  -126,   227,   170,   194,
     335,   121,   204,   200,   202,   174,   175,    76,   187,   188,
       4,     4,   336,    96,   195,   196,   128,    14,   313,   337,
       4,   206,   207,   173,    40,   166,   167,   217,   210,   211,
     -55,   216,   335,   117,   -55,    12,    -3,     4,   212,   205,
       4,  -126,   316,     4,   336,   335,     4,  -188,  -188,   189,
     339,   337,   150,   340,   225,   316,   341,   336,   214,   219,
     116,    97,   -74,   221,   337,     8,    41,   223,   241,    -3,
       4,   228,   230,     4,   231,     4,    -3,    86,   234,    -3,
     232,   316,   339,   233,   242,   340,   237,   197,   341,   307,
     108,   316,   338,   209,   246,   339,   248,    -3,   340,   249,
      83,   341,   208,    42,    12,   316,   276,    -3,   117,   118,
     277,   222,   110,   279,    -3,   280,   275,   110,   359,  -122,
     198,   283,   284,   285,   286,   287,   288,   289,   290,   291,
     292,   293,   144,   108,   294,   295,   296,   110,   243,    -3,
      -3,    -3,     4,   306,     4,   314,   145,     4,   309,     4,
       4,   310,   135,     4,   238,   239,   143,   226,   139,   328,
       4,   151,   152,     4,  -122,    74,    75,   321,   144,    12,
     322,   323,   324,     4,   247,   254,    15,    16,   256,   257,
     258,   -49,   145,   350,    76,   332,    87,    77,   334,   254,
      12,   315,   256,   257,   258,   153,    74,    75,   154,   153,
     351,   345,   154,   192,     4,   315,   347,   348,   349,   153,
      29,   352,   154,   355,   356,    76,   357,   110,  -148,   327,
     218,   254,   244,  -148,   256,   257,   258,    74,    75,   360,
    -148,  -148,   191,  -148,   134,   254,   297,   315,   256,   257,
     258,   153,    30,   172,   154,  -148,    76,    12,    31,  -148,
    -148,    57,  -148,  -148,  -148,  -148,  -148,   343,   344,  -148,
    -148,  -148,  -148,  -148,  -148,   169,  -148,  -148,  -148,  -148,
    -145,   299,  -148,   106,   213,  -148,  -148,  -148,     4,   199,
     193,   326,  -153,  -153,    12,  -153,    50,   353,    51,    52,
      53,    54,    55,    56,   354,   254,   311,   300,   256,   257,
     258,  -153,  -153,    33,  -153,  -153,  -153,  -153,  -153,   220,
       0,  -153,  -153,  -153,  -153,  -145,  -145,    34,   201,   301,
      12,  -153,    12,     0,  -153,  -140,   250,   302,  -153,  -153,
       4,    51,    52,    53,    54,    55,     0,   251,   252,   224,
     253,     0,     0,    12,   245,    -3,   227,     0,    12,   281,
      -3,     4,     0,    12,     0,     0,   254,   255,    -3,   256,
     257,   258,   259,   260,     0,     0,   261,   262,   263,   264,
    -140,  -140,    -3,     0,   299,  -140,   153,   254,    -3,   154,
     256,   257,   258,   265,   266,  -153,  -153,     0,  -153,     0,
      -3,   229,     0,   315,     0,    -3,     0,   153,     0,     0,
     154,     0,     0,     0,  -153,  -153,     0,  -153,  -153,  -153,
    -153,  -153,     0,     0,  -153,  -153,  -153,  -153,     0,     0,
       0,    -3,   301,    12,  -153,   299,     0,  -153,     0,     0,
     302,  -153,  -153,     0,     0,     0,  -153,  -153,     0,  -153,
       0,     0,     0,     0,    89,     0,     0,    50,    90,    51,
      52,    53,    54,    55,    56,  -153,  -153,     0,  -153,  -153,
    -153,  -153,  -153,     0,     0,  -153,  -153,  -153,  -153,    91,
      92,    93,   331,   301,    12,  -153,   312,     0,  -153,     0,
       4,   302,  -153,  -153,     0,     0,     0,   251,   252,     0,
     253,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   254,   255,     0,   256,
     257,   258,   259,   260,     4,     0,   261,   262,   263,   264,
       0,   251,   252,     0,   253,     0,   153,     0,     0,   154,
       0,     0,     0,   265,   266,     0,     0,     0,     0,     0,
     254,   255,     0,   256,   257,   258,   259,   260,     0,     0,
     261,   262,   263,   264,     0,   107,     0,     0,     0,   -87,
     153,   107,     0,   154,     0,   -86,     0,   265,   266,    51,
      52,    53,    54,    55,     0,    51,    52,    53,    54,    55,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   251,   252,     0,   253,     0,
       0,     0,   -87,   -87,   -87,   -87,   -87,   -87,   -86,   -86,
     -86,   -86,   -86,   -86,   254,   255,     0,   256,   257,   258,
     259,   260,     0,     0,   261,   262,   263,   264,     0,     0,
      35,   176,     0,     0,   153,     0,     0,   154,     0,     0,
       0,   265,   266,    50,     0,    51,    52,    53,    54,    55,
      56,     0,    21,    22,    23,     0,    25,     0,     0,     0,
       0,    -2,    20,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   -73,    36,   -73,   -73,   -73,   -73,
     -73,   -73,     0,    21,    22,    23,    24,    25
};

static const yytype_int16 yycheck[] =
{
       0,   122,    59,    18,    18,     5,    28,   267,     5,     1,
       5,     5,     5,     5,    14,     1,     0,    12,     5,     0,
       5,    21,    22,    23,    24,    50,    46,    13,     8,     5,
      50,     1,     1,   293,     1,    13,    30,    30,     5,     5,
      20,    27,    37,    13,     0,     1,   306,    13,   105,    25,
      20,    48,    49,    68,     0,    55,   316,    49,    50,    51,
      52,    53,    42,    50,    45,    45,   123,   124,    48,    50,
      55,     1,   332,    73,   306,     5,    76,    77,    48,    49,
      80,    51,   342,    50,    54,    85,    86,    57,    68,    45,
      46,    91,    92,    93,    50,     5,   356,    97,   242,    45,
     332,    46,   102,   103,   104,    50,   250,     7,     8,     9,
      10,    11,     1,     5,     1,     1,     1,   117,   118,    49,
      50,    51,    52,    53,   356,   125,     0,     1,   128,   143,
       1,    13,    17,   147,   148,   135,   136,    47,   138,   139,
       5,     5,    13,     1,   144,   145,    50,    12,   292,    20,
       5,   151,   152,   133,    46,    55,    56,   179,   158,   159,
      46,   176,     1,    49,    50,    50,     5,     5,   168,   149,
       5,    45,   293,     5,    13,     1,     5,    48,    49,    30,
      51,    20,    46,    54,   198,   306,    57,    13,    17,   189,
       1,    49,    50,   193,    20,     1,   176,   197,   213,     5,
       5,   201,   202,     5,   204,     5,    12,    12,   208,    48,
      48,   332,    51,    48,   214,    54,    48,    45,    57,   276,
      63,   342,    48,     1,   224,    51,   226,     5,    54,   229,
      46,    57,    36,     1,    50,   356,   236,     5,    49,    50,
     240,     1,   222,   243,    12,   245,    48,   227,    48,     0,
       1,   251,   252,   253,   254,   255,   256,   257,   258,   259,
     260,   261,    13,   106,   264,   265,   266,   247,    48,    37,
      48,    49,     5,   273,     5,     1,    27,     5,   278,     5,
       5,   281,    13,     5,    12,    13,     1,    46,    13,     1,
       5,    13,    14,     5,    45,    28,    29,   297,    13,    50,
     300,   301,   302,     5,     1,    31,     5,     6,    34,    35,
      36,    13,    27,     5,    47,   315,    46,    50,   318,    31,
      50,    47,    34,    35,    36,    51,    28,    29,    54,    51,
       5,   331,    54,   142,     5,    47,   336,   337,   338,    51,
      17,   341,    54,   343,   344,    47,   346,   327,     0,     1,
     187,    31,   219,     5,    34,    35,    36,    28,    29,   359,
      12,    13,   141,    15,   111,    31,    32,    47,    34,    35,
      36,    51,    17,    46,    54,    27,    47,    50,    17,    31,
      32,    32,    34,    35,    36,    37,    38,    48,    49,    41,
      42,    43,    44,    45,    46,   127,    48,    49,    50,    51,
       0,     1,    54,    62,   171,    57,    58,    59,     5,   147,
      46,   304,    12,    13,    50,    15,    13,   342,    15,    16,
      17,    18,    19,    20,   342,    31,   282,    27,    34,    35,
      36,    31,    32,    17,    34,    35,    36,    37,    38,   192,
      -1,    41,    42,    43,    44,    45,    46,    17,    46,    49,
      50,    51,    50,    -1,    54,     0,     1,    57,    58,    59,
       5,    15,    16,    17,    18,    19,    -1,    12,    13,    46,
      15,    -1,    -1,    50,    46,     0,     1,    -1,    50,    46,
       5,     5,    -1,    50,    -1,    -1,    31,    32,    13,    34,
      35,    36,    37,    38,    -1,    -1,    41,    42,    43,    44,
      45,    46,    27,    -1,     1,    50,    51,    31,     5,    54,
      34,    35,    36,    58,    59,    12,    13,    -1,    15,    -1,
      45,    46,    -1,    47,    -1,    50,    -1,    51,    -1,    -1,
      54,    -1,    -1,    -1,    31,    32,    -1,    34,    35,    36,
      37,    38,    -1,    -1,    41,    42,    43,    44,    -1,    -1,
      -1,    48,    49,    50,    51,     1,    -1,    54,    -1,    -1,
      57,    58,    59,    -1,    -1,    -1,    12,    13,    -1,    15,
      -1,    -1,    -1,    -1,    13,    -1,    -1,    13,    17,    15,
      16,    17,    18,    19,    20,    31,    32,    -1,    34,    35,
      36,    37,    38,    -1,    -1,    41,    42,    43,    44,    38,
      39,    40,    48,    49,    50,    51,     1,    -1,    54,    -1,
       5,    57,    58,    59,    -1,    -1,    -1,    12,    13,    -1,
      15,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    31,    32,    -1,    34,
      35,    36,    37,    38,     5,    -1,    41,    42,    43,    44,
      -1,    12,    13,    -1,    15,    -1,    51,    -1,    -1,    54,
      -1,    -1,    -1,    58,    59,    -1,    -1,    -1,    -1,    -1,
      31,    32,    -1,    34,    35,    36,    37,    38,    -1,    -1,
      41,    42,    43,    44,    -1,     1,    -1,    -1,    -1,     5,
      51,     1,    -1,    54,    -1,     5,    -1,    58,    59,    15,
      16,    17,    18,    19,    -1,    15,    16,    17,    18,    19,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    12,    13,    -1,    15,    -1,
      -1,    -1,    48,    49,    50,    51,    52,    53,    48,    49,
      50,    51,    52,    53,    31,    32,    -1,    34,    35,    36,
      37,    38,    -1,    -1,    41,    42,    43,    44,    -1,    -1,
       0,     1,    -1,    -1,    51,    -1,    -1,    54,    -1,    -1,
      -1,    58,    59,    13,    -1,    15,    16,    17,    18,    19,
      20,    -1,    22,    23,    24,    -1,    26,    -1,    -1,    -1,
      -1,     0,     1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    13,    45,    15,    16,    17,    18,
      19,    20,    -1,    22,    23,    24,    25,    26
};

/* YYSTOS[STATE-NUM] -- The (internal number of the) accessing
   symbol of state STATE-NUM.  */
static const yytype_uint8 yystos[] =
{
       0,    61,    62,     0,     5,    25,    64,    66,     1,    62,
      63,    46,    50,   130,    12,     5,     6,    68,     1,    62,
       1,    22,    23,    24,    25,    26,    67,    69,    70,    74,
      85,    87,    92,   128,   129,     0,    45,    65,   130,   131,
      46,   130,     1,    62,    62,     1,    62,    62,     1,    63,
      13,    15,    16,    17,    18,    19,    20,    94,    95,    96,
      97,    98,   100,   101,   102,   103,   105,   108,     1,    46,
     130,    12,    37,    75,    28,    29,    47,    50,    78,    79,
      81,    82,    84,    46,   130,    50,    12,    46,   130,    13,
      17,    38,    39,    40,    13,    62,     1,    49,    93,    98,
       1,     5,    51,    52,    53,    88,   101,     1,   102,    65,
     130,    62,    62,    62,    62,    62,     1,    49,    50,    62,
      62,    13,    62,    62,    62,    13,   104,    62,    50,    62,
      62,    62,    98,    83,    84,    13,    76,    71,    30,    13,
      86,    62,    62,     1,    13,    27,   109,   110,   111,   112,
      46,    13,    14,    51,    54,    89,    90,    98,    99,    98,
      62,     7,     8,     9,    10,    11,    55,    56,   106,    97,
      62,    91,    46,   130,    62,    62,     1,    65,    72,    73,
      74,    85,    87,    94,   127,   128,   129,    62,    62,    30,
      80,    82,    71,    46,   131,    62,    62,    45,     1,   111,
     131,    46,   131,     1,    17,   130,    62,    62,    36,     1,
      62,    62,    62,   109,    17,    77,    65,    63,    78,    62,
     127,    62,     1,    62,    46,   131,    46,     1,    62,    46,
      62,    62,    48,    48,    62,    48,    49,    48,    12,    13,
     107,    65,    62,    48,    79,    46,    62,     1,    62,    62,
       1,    12,    13,    15,    31,    32,    34,    35,    36,    37,
      38,    41,    42,    43,    44,    58,    59,    90,   114,   116,
     117,   118,   124,   125,   126,    48,    62,    62,   114,    62,
      62,    46,   114,    62,    62,    62,    62,    62,    62,    62,
      62,    62,    62,    62,    62,    62,    62,    32,   117,     1,
      27,    49,    57,   113,   115,   131,    62,    98,    55,    62,
      62,   113,     1,   114,     1,    47,    90,   117,   119,   121,
     122,    62,    62,    62,    62,     1,   116,     1,     1,   122,
     123,    48,    62,   117,    62,     1,    13,    20,    48,    51,
      54,    57,   120,    48,    49,    62,   122,    62,    62,    62,
       5,     5,    62,   119,   121,    62,    62,    62,   122,    48,
      62
};

#define yyerrok		(yyerrstatus = 0)
#define yyclearin	(yychar = YYEMPTY)
#define YYEMPTY		(-2)
#define YYEOF		0

#define YYACCEPT	goto yyacceptlab
#define YYABORT		goto yyabortlab
#define YYERROR		goto yyerrorlab


/* Like YYERROR except do call yyerror.  This remains here temporarily
   to ease the transition to the new meaning of YYERROR, for GCC.
   Once GCC version 2 has supplanted version 1, this can go.  */

#define YYFAIL		goto yyerrlab

#define YYRECOVERING()  (!!yyerrstatus)

#define YYBACKUP(Token, Value)					\
do								\
  if (yychar == YYEMPTY && yylen == 1)				\
    {								\
      yychar = (Token);						\
      yylval = (Value);						\
      yytoken = YYTRANSLATE (yychar);				\
      YYPOPSTACK (1);						\
      goto yybackup;						\
    }								\
  else								\
    {								\
      yyerror (parser, YY_("syntax error: cannot back up")); \
      YYERROR;							\
    }								\
while (YYID (0))


#define YYTERROR	1
#define YYERRCODE	256


/* YYLLOC_DEFAULT -- Set CURRENT to span from RHS[1] to RHS[N].
   If N is 0, then set CURRENT to the empty location which ends
   the previous symbol: RHS[0] (always defined).  */

#define YYRHSLOC(Rhs, K) ((Rhs)[K])
#ifndef YYLLOC_DEFAULT
# define YYLLOC_DEFAULT(Current, Rhs, N)				\
    do									\
      if (YYID (N))                                                    \
	{								\
	  (Current).first_line   = YYRHSLOC (Rhs, 1).first_line;	\
	  (Current).first_column = YYRHSLOC (Rhs, 1).first_column;	\
	  (Current).last_line    = YYRHSLOC (Rhs, N).last_line;		\
	  (Current).last_column  = YYRHSLOC (Rhs, N).last_column;	\
	}								\
      else								\
	{								\
	  (Current).first_line   = (Current).last_line   =		\
	    YYRHSLOC (Rhs, 0).last_line;				\
	  (Current).first_column = (Current).last_column =		\
	    YYRHSLOC (Rhs, 0).last_column;				\
	}								\
    while (YYID (0))
#endif


/* YY_LOCATION_PRINT -- Print the location on the stream.
   This macro was not mandated originally: define only if we know
   we won't break user code: when these are the locations we know.  */

#ifndef YY_LOCATION_PRINT
# if defined YYLTYPE_IS_TRIVIAL && YYLTYPE_IS_TRIVIAL
#  define YY_LOCATION_PRINT(File, Loc)			\
     fprintf (File, "%d.%d-%d.%d",			\
	      (Loc).first_line, (Loc).first_column,	\
	      (Loc).last_line,  (Loc).last_column)
# else
#  define YY_LOCATION_PRINT(File, Loc) ((void) 0)
# endif
#endif


/* YYLEX -- calling `yylex' with the right arguments.  */

#ifdef YYLEX_PARAM
# define YYLEX yylex (&yylval, YYLEX_PARAM)
#else
# define YYLEX yylex (&yylval, parser)
#endif

/* Enable debugging if requested.  */
#if YYDEBUG

# ifndef YYFPRINTF
#  include <stdio.h> /* INFRINGES ON USER NAME SPACE */
#  define YYFPRINTF fprintf
# endif

# define YYDPRINTF(Args)			\
do {						\
  if (yydebug)					\
    YYFPRINTF Args;				\
} while (YYID (0))

# define YY_SYMBOL_PRINT(Title, Type, Value, Location)			  \
do {									  \
  if (yydebug)								  \
    {									  \
      YYFPRINTF (stderr, "%s ", Title);					  \
      yy_symbol_print (stderr,						  \
		  Type, Value, parser); \
      YYFPRINTF (stderr, "\n");						  \
    }									  \
} while (YYID (0))


/*--------------------------------.
| Print this symbol on YYOUTPUT.  |
`--------------------------------*/

/*ARGSUSED*/
#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
static void
yy_symbol_value_print (FILE *yyoutput, int yytype, YYSTYPE const * const yyvaluep, CSSParser* parser)
#else
static void
yy_symbol_value_print (yyoutput, yytype, yyvaluep, parser)
    FILE *yyoutput;
    int yytype;
    YYSTYPE const * const yyvaluep;
    CSSParser* parser;
#endif
{
  if (!yyvaluep)
    return;
  YYUSE (parser);
# ifdef YYPRINT
  if (yytype < YYNTOKENS)
    YYPRINT (yyoutput, yytoknum[yytype], *yyvaluep);
# else
  YYUSE (yyoutput);
# endif
  switch (yytype)
    {
      default:
	break;
    }
}


/*--------------------------------.
| Print this symbol on YYOUTPUT.  |
`--------------------------------*/

#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
static void
yy_symbol_print (FILE *yyoutput, int yytype, YYSTYPE const * const yyvaluep, CSSParser* parser)
#else
static void
yy_symbol_print (yyoutput, yytype, yyvaluep, parser)
    FILE *yyoutput;
    int yytype;
    YYSTYPE const * const yyvaluep;
    CSSParser* parser;
#endif
{
  if (yytype < YYNTOKENS)
    YYFPRINTF (yyoutput, "token %s (", yytname[yytype]);
  else
    YYFPRINTF (yyoutput, "nterm %s (", yytname[yytype]);

  yy_symbol_value_print (yyoutput, yytype, yyvaluep, parser);
  YYFPRINTF (yyoutput, ")");
}

/*------------------------------------------------------------------.
| yy_stack_print -- Print the state stack from its BOTTOM up to its |
| TOP (included).                                                   |
`------------------------------------------------------------------*/

#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
static void
yy_stack_print (yytype_int16 *bottom, yytype_int16 *top)
#else
static void
yy_stack_print (bottom, top)
    yytype_int16 *bottom;
    yytype_int16 *top;
#endif
{
  YYFPRINTF (stderr, "Stack now");
  for (; bottom <= top; ++bottom)
    YYFPRINTF (stderr, " %d", *bottom);
  YYFPRINTF (stderr, "\n");
}

# define YY_STACK_PRINT(Bottom, Top)				\
do {								\
  if (yydebug)							\
    yy_stack_print ((Bottom), (Top));				\
} while (YYID (0))


/*------------------------------------------------.
| Report that the YYRULE is going to be reduced.  |
`------------------------------------------------*/

#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
static void
yy_reduce_print (YYSTYPE *yyvsp, int yyrule, CSSParser* parser)
#else
static void
yy_reduce_print (yyvsp, yyrule, parser)
    YYSTYPE *yyvsp;
    int yyrule;
    CSSParser* parser;
#endif
{
  int yynrhs = yyr2[yyrule];
  int yyi;
  unsigned long int yylno = yyrline[yyrule];
  YYFPRINTF (stderr, "Reducing stack by rule %d (line %lu):\n",
	     yyrule - 1, yylno);
  /* The symbols being reduced.  */
  for (yyi = 0; yyi < yynrhs; yyi++)
    {
      fprintf (stderr, "   $%d = ", yyi + 1);
      yy_symbol_print (stderr, yyrhs[yyprhs[yyrule] + yyi],
		       &(yyvsp[(yyi + 1) - (yynrhs)])
		       		       , parser);
      fprintf (stderr, "\n");
    }
}

# define YY_REDUCE_PRINT(Rule)		\
do {					\
  if (yydebug)				\
    yy_reduce_print (yyvsp, Rule, parser); \
} while (YYID (0))

/* Nonzero means print parse trace.  It is left uninitialized so that
   multiple parsers can coexist.  */
int yydebug;
#else /* !YYDEBUG */
# define YYDPRINTF(Args)
# define YY_SYMBOL_PRINT(Title, Type, Value, Location)
# define YY_STACK_PRINT(Bottom, Top)
# define YY_REDUCE_PRINT(Rule)
#endif /* !YYDEBUG */


/* YYINITDEPTH -- initial size of the parser's stacks.  */
#ifndef	YYINITDEPTH
# define YYINITDEPTH 200
#endif

/* YYMAXDEPTH -- maximum size the stacks can grow to (effective only
   if the built-in stack extension method is used).

   Do not make this value too large; the results are undefined if
   YYSTACK_ALLOC_MAXIMUM < YYSTACK_BYTES (YYMAXDEPTH)
   evaluated with infinite-precision integer arithmetic.  */

#ifndef YYMAXDEPTH
# define YYMAXDEPTH 10000
#endif



#if YYERROR_VERBOSE

# ifndef yystrlen
#  if defined __GLIBC__ && defined _STRING_H
#   define yystrlen strlen
#  else
/* Return the length of YYSTR.  */
#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
static YYSIZE_T
yystrlen (const char *yystr)
#else
static YYSIZE_T
yystrlen (yystr)
    const char *yystr;
#endif
{
  YYSIZE_T yylen;
  for (yylen = 0; yystr[yylen]; yylen++)
    continue;
  return yylen;
}
#  endif
# endif

# ifndef yystpcpy
#  if defined __GLIBC__ && defined _STRING_H && defined _GNU_SOURCE
#   define yystpcpy stpcpy
#  else
/* Copy YYSRC to YYDEST, returning the address of the terminating '\0' in
   YYDEST.  */
#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
static char *
yystpcpy (char *yydest, const char *yysrc)
#else
static char *
yystpcpy (yydest, yysrc)
    char *yydest;
    const char *yysrc;
#endif
{
  char *yyd = yydest;
  const char *yys = yysrc;

  while ((*yyd++ = *yys++) != '\0')
    continue;

  return yyd - 1;
}
#  endif
# endif

# ifndef yytnamerr
/* Copy to YYRES the contents of YYSTR after stripping away unnecessary
   quotes and backslashes, so that it's suitable for yyerror.  The
   heuristic is that double-quoting is unnecessary unless the string
   contains an apostrophe, a comma, or backslash (other than
   backslash-backslash).  YYSTR is taken from yytname.  If YYRES is
   null, do not copy; instead, return the length of what the result
   would have been.  */
static YYSIZE_T
yytnamerr (char *yyres, const char *yystr)
{
  if (*yystr == '"')
    {
      YYSIZE_T yyn = 0;
      char const *yyp = yystr;

      for (;;)
	switch (*++yyp)
	  {
	  case '\'':
	  case ',':
	    goto do_not_strip_quotes;

	  case '\\':
	    if (*++yyp != '\\')
	      goto do_not_strip_quotes;
	    /* Fall through.  */
	  default:
	    if (yyres)
	      yyres[yyn] = *yyp;
	    yyn++;
	    break;

	  case '"':
	    if (yyres)
	      yyres[yyn] = '\0';
	    return yyn;
	  }
    do_not_strip_quotes: ;
    }

  if (! yyres)
    return yystrlen (yystr);

  return yystpcpy (yyres, yystr) - yyres;
}
# endif

/* Copy into YYRESULT an error message about the unexpected token
   YYCHAR while in state YYSTATE.  Return the number of bytes copied,
   including the terminating null byte.  If YYRESULT is null, do not
   copy anything; just return the number of bytes that would be
   copied.  As a special case, return 0 if an ordinary "syntax error"
   message will do.  Return YYSIZE_MAXIMUM if overflow occurs during
   size calculation.  */
static YYSIZE_T
yysyntax_error (char *yyresult, int yystate, int yychar)
{
  int yyn = yypact[yystate];

  if (! (YYPACT_NINF < yyn && yyn <= YYLAST))
    return 0;
  else
    {
      int yytype = YYTRANSLATE (yychar);
      YYSIZE_T yysize0 = yytnamerr (0, yytname[yytype]);
      YYSIZE_T yysize = yysize0;
      YYSIZE_T yysize1;
      int yysize_overflow = 0;
      enum { YYERROR_VERBOSE_ARGS_MAXIMUM = 5 };
      char const *yyarg[YYERROR_VERBOSE_ARGS_MAXIMUM];
      int yyx;

# if 0
      /* This is so xgettext sees the translatable formats that are
	 constructed on the fly.  */
      YY_("syntax error, unexpected %s");
      YY_("syntax error, unexpected %s, expecting %s");
      YY_("syntax error, unexpected %s, expecting %s or %s");
      YY_("syntax error, unexpected %s, expecting %s or %s or %s");
      YY_("syntax error, unexpected %s, expecting %s or %s or %s or %s");
# endif
      char *yyfmt;
      char const *yyf;
      static char const yyunexpected[] = "syntax error, unexpected %s";
      static char const yyexpecting[] = ", expecting %s";
      static char const yyor[] = " or %s";
      char yyformat[sizeof yyunexpected
		    + sizeof yyexpecting - 1
		    + ((YYERROR_VERBOSE_ARGS_MAXIMUM - 2)
		       * (sizeof yyor - 1))];
      char const *yyprefix = yyexpecting;

      /* Start YYX at -YYN if negative to avoid negative indexes in
	 YYCHECK.  */
      int yyxbegin = yyn < 0 ? -yyn : 0;

      /* Stay within bounds of both yycheck and yytname.  */
      int yychecklim = YYLAST - yyn + 1;
      int yyxend = yychecklim < YYNTOKENS ? yychecklim : YYNTOKENS;
      int yycount = 1;

      yyarg[0] = yytname[yytype];
      yyfmt = yystpcpy (yyformat, yyunexpected);

      for (yyx = yyxbegin; yyx < yyxend; ++yyx)
	if (yycheck[yyx + yyn] == yyx && yyx != YYTERROR)
	  {
	    if (yycount == YYERROR_VERBOSE_ARGS_MAXIMUM)
	      {
		yycount = 1;
		yysize = yysize0;
		yyformat[sizeof yyunexpected - 1] = '\0';
		break;
	      }
	    yyarg[yycount++] = yytname[yyx];
	    yysize1 = yysize + yytnamerr (0, yytname[yyx]);
	    yysize_overflow |= (yysize1 < yysize);
	    yysize = yysize1;
	    yyfmt = yystpcpy (yyfmt, yyprefix);
	    yyprefix = yyor;
	  }

      yyf = YY_(yyformat);
      yysize1 = yysize + yystrlen (yyf);
      yysize_overflow |= (yysize1 < yysize);
      yysize = yysize1;

      if (yysize_overflow)
	return YYSIZE_MAXIMUM;

      if (yyresult)
	{
	  /* Avoid sprintf, as that infringes on the user's name space.
	     Don't have undefined behavior even if the translation
	     produced a string with the wrong number of "%s"s.  */
	  char *yyp = yyresult;
	  int yyi = 0;
	  while ((*yyp = *yyf) != '\0')
	    {
	      if (*yyp == '%' && yyf[1] == 's' && yyi < yycount)
		{
		  yyp += yytnamerr (yyp, yyarg[yyi++]);
		  yyf += 2;
		}
	      else
		{
		  yyp++;
		  yyf++;
		}
	    }
	}
      return yysize;
    }
}
#endif /* YYERROR_VERBOSE */


/*-----------------------------------------------.
| Release the memory associated to this symbol.  |
`-----------------------------------------------*/

/*ARGSUSED*/
#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
static void
yydestruct (const char *yymsg, int yytype, YYSTYPE *yyvaluep, CSSParser* parser)
#else
static void
yydestruct (yymsg, yytype, yyvaluep, parser)
    const char *yymsg;
    int yytype;
    YYSTYPE *yyvaluep;
    CSSParser* parser;
#endif
{
  YYUSE (yyvaluep);
  YYUSE (parser);

  if (!yymsg)
    yymsg = "Deleting";
  YY_SYMBOL_PRINT (yymsg, yytype, yyvaluep, yylocationp);

  switch (yytype)
    {

      default:
	break;
    }
}


/* Prevent warnings from -Wmissing-prototypes.  */

#ifdef YYPARSE_PARAM
#if defined __STDC__ || defined __cplusplus
int yyparse (void *YYPARSE_PARAM);
#else
int yyparse ();
#endif
#else /* ! YYPARSE_PARAM */
#if defined __STDC__ || defined __cplusplus
int yyparse (CSSParser* parser);
#else
int yyparse ();
#endif
#endif /* ! YYPARSE_PARAM */






/*----------.
| yyparse.  |
`----------*/

#ifdef YYPARSE_PARAM
#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
int
yyparse (void *YYPARSE_PARAM)
#else
int
yyparse (YYPARSE_PARAM)
    void *YYPARSE_PARAM;
#endif
#else /* ! YYPARSE_PARAM */
#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
int
yyparse (CSSParser* parser)
#else
int
yyparse (parser)
    CSSParser* parser;
#endif
#endif
{
  /* The look-ahead symbol.  */
int yychar;

/* The semantic value of the look-ahead symbol.  */
YYSTYPE yylval;

/* Number of syntax errors so far.  */
int yynerrs;

  int yystate;
  int yyn;
  int yyresult;
  /* Number of tokens to shift before error messages enabled.  */
  int yyerrstatus;
  /* Look-ahead token as an internal (translated) token number.  */
  int yytoken = 0;
#if YYERROR_VERBOSE
  /* Buffer for error messages, and its allocated size.  */
  char yymsgbuf[128];
  char *yymsg = yymsgbuf;
  YYSIZE_T yymsg_alloc = sizeof yymsgbuf;
#endif

  /* Three stacks and their tools:
     `yyss': related to states,
     `yyvs': related to semantic values,
     `yyls': related to locations.

     Refer to the stacks thru separate pointers, to allow yyoverflow
     to reallocate them elsewhere.  */

  /* The state stack.  */
  yytype_int16 yyssa[YYINITDEPTH];
  yytype_int16 *yyss = yyssa;
  yytype_int16 *yyssp;

  /* The semantic value stack.  */
  YYSTYPE yyvsa[YYINITDEPTH];
  YYSTYPE *yyvs = yyvsa;
  YYSTYPE *yyvsp;



#define YYPOPSTACK(N)   (yyvsp -= (N), yyssp -= (N))

  YYSIZE_T yystacksize = YYINITDEPTH;

  /* The variables used to return semantic value and location from the
     action routines.  */
  YYSTYPE yyval;


  /* The number of symbols on the RHS of the reduced rule.
     Keep to zero when no symbol should be popped.  */
  int yylen = 0;

  YYDPRINTF ((stderr, "Starting parse\n"));

  yystate = 0;
  yyerrstatus = 0;
  yynerrs = 0;
  yychar = YYEMPTY;		/* Cause a token to be read.  */

  /* Initialize stack pointers.
     Waste one element of value and location stack
     so that they stay on the same level as the state stack.
     The wasted elements are never initialized.  */

  yyssp = yyss;
  yyvsp = yyvs;

  goto yysetstate;

/*------------------------------------------------------------.
| yynewstate -- Push a new state, which is found in yystate.  |
`------------------------------------------------------------*/
 yynewstate:
  /* In all cases, when you get here, the value and location stacks
     have just been pushed.  So pushing a state here evens the stacks.  */
  yyssp++;

 yysetstate:
  *yyssp = yystate;

  if (yyss + yystacksize - 1 <= yyssp)
    {
      /* Get the current used size of the three stacks, in elements.  */
      YYSIZE_T yysize = yyssp - yyss + 1;

#ifdef yyoverflow
      {
	/* Give user a chance to reallocate the stack.  Use copies of
	   these so that the &'s don't force the real ones into
	   memory.  */
	YYSTYPE *yyvs1 = yyvs;
	yytype_int16 *yyss1 = yyss;


	/* Each stack pointer address is followed by the size of the
	   data in use in that stack, in bytes.  This used to be a
	   conditional around just the two extra args, but that might
	   be undefined if yyoverflow is a macro.  */
	yyoverflow (YY_("memory exhausted"),
		    &yyss1, yysize * sizeof (*yyssp),
		    &yyvs1, yysize * sizeof (*yyvsp),

		    &yystacksize);

	yyss = yyss1;
	yyvs = yyvs1;
      }
#else /* no yyoverflow */
# ifndef YYSTACK_RELOCATE
      goto yyexhaustedlab;
# else
      /* Extend the stack our own way.  */
      if (YYMAXDEPTH <= yystacksize)
	goto yyexhaustedlab;
      yystacksize *= 2;
      if (YYMAXDEPTH < yystacksize)
	yystacksize = YYMAXDEPTH;

      {
	yytype_int16 *yyss1 = yyss;
	union yyalloc *yyptr =
	  (union yyalloc *) YYSTACK_ALLOC (YYSTACK_BYTES (yystacksize));
	if (! yyptr)
	  goto yyexhaustedlab;
	YYSTACK_RELOCATE (yyss);
	YYSTACK_RELOCATE (yyvs);

#  undef YYSTACK_RELOCATE
	if (yyss1 != yyssa)
	  YYSTACK_FREE (yyss1);
      }
# endif
#endif /* no yyoverflow */

      yyssp = yyss + yysize - 1;
      yyvsp = yyvs + yysize - 1;


      YYDPRINTF ((stderr, "Stack size increased to %lu\n",
		  (unsigned long int) yystacksize));

      if (yyss + yystacksize - 1 <= yyssp)
	YYABORT;
    }

  YYDPRINTF ((stderr, "Entering state %d\n", yystate));

  goto yybackup;

/*-----------.
| yybackup.  |
`-----------*/
yybackup:

  /* Do appropriate processing given the current state.  Read a
     look-ahead token if we need one and don't already have one.  */

  /* First try to decide what to do without reference to look-ahead token.  */
  yyn = yypact[yystate];
  if (yyn == YYPACT_NINF)
    goto yydefault;

  /* Not known => get a look-ahead token if don't already have one.  */

  /* YYCHAR is either YYEMPTY or YYEOF or a valid look-ahead symbol.  */
  if (yychar == YYEMPTY)
    {
      YYDPRINTF ((stderr, "Reading a token: "));
      yychar = YYLEX;
    }

  if (yychar <= YYEOF)
    {
      yychar = yytoken = YYEOF;
      YYDPRINTF ((stderr, "Now at end of input.\n"));
    }
  else
    {
      yytoken = YYTRANSLATE (yychar);
      YY_SYMBOL_PRINT ("Next token is", yytoken, &yylval, &yylloc);
    }

  /* If the proper action on seeing token YYTOKEN is to reduce or to
     detect an error, take that action.  */
  yyn += yytoken;
  if (yyn < 0 || YYLAST < yyn || yycheck[yyn] != yytoken)
    goto yydefault;
  yyn = yytable[yyn];
  if (yyn <= 0)
    {
      if (yyn == 0 || yyn == YYTABLE_NINF)
	goto yyerrlab;
      yyn = -yyn;
      goto yyreduce;
    }

  if (yyn == YYFINAL)
    YYACCEPT;

  /* Count tokens shifted since error; after three, turn off error
     status.  */
  if (yyerrstatus)
    yyerrstatus--;

  /* Shift the look-ahead token.  */
  YY_SYMBOL_PRINT ("Shifting", yytoken, &yylval, &yylloc);

  /* Discard the shifted token unless it is eof.  */
  if (yychar != YYEOF)
    yychar = YYEMPTY;

  yystate = yyn;
  *++yyvsp = yylval;

  goto yynewstate;


/*-----------------------------------------------------------.
| yydefault -- do the default action for the current state.  |
`-----------------------------------------------------------*/
yydefault:
  yyn = yydefact[yystate];
  if (yyn == 0)
    goto yyerrlab;
  goto yyreduce;


/*-----------------------------.
| yyreduce -- Do a reduction.  |
`-----------------------------*/
yyreduce:
  /* yyn is the number of a rule to reduce with.  */
  yylen = yyr2[yyn];

  /* If YYLEN is nonzero, implement the default value of the action:
     `$$ = $1'.

     Otherwise, the following line sets YYVAL to garbage.
     This behavior is undocumented and Bison
     users should not rely upon it.  Assigning to YYVAL
     unconditionally makes the parser a bit smaller, and it avoids a
     GCC warning that YYVAL may be used uninitialized.  */
  yyval = yyvsp[1-yylen];


  YY_REDUCE_PRINT (yyn);
  switch (yyn)
    {
        case 9:

    {
  ;}
    break;

  case 12:

    {
      (yyval.rule) = 0;
  ;}
    break;

  case 13:

    {
      (yyval.rule) = 0;
  ;}
    break;

  case 14:

    {
  ;}
    break;

  case 15:

    {
        // Ignore any @charset rule not at the beginning of the style sheet.
        (yyval.rule) = 0;
    ;}
    break;

  case 17:

    {
     if ((yyvsp[(2) - (3)].rule))
         [parser addRule:(yyvsp[(2) - (3)].rule)];
     // rule_list rule maybe_sgml
 ;}
    break;

  case 18:

    {
        (yyval.rule) = (yyvsp[(2) - (2)].rule);
        // before_ruleset ruleset
    ;}
    break;

  case 22:

    {
        (yyval.rule) = (yyvsp[(1) - (1)].rule);
    ;}
    break;

  case 26:

    { (yyval.ruleList) = 0; ;}
    break;

  case 27:

    {
      (yyval.ruleList) = (yyvsp[(1) - (3)].ruleList);
      if ((yyvsp[(2) - (3)].rule)) {
          if (!(yyval.ruleList))
              (yyval.ruleList) = [parser createRuleList];
          [(yyval.ruleList) appendRule:(yyvsp[(2) - (3)].rule)];
      }
  ;}
    break;

  case 35:

    {
        (yyval.rule) = [parser createImportRuleWithURL:(yyvsp[(3) - (6)].nsstring) media:(yyvsp[(5) - (6)].mediaList)];
        // IMPORT_SYM maybe_space string_or_uri maybe_space maybe_media_list ';' {
    ;}
    break;

  case 36:

    {
        (yyval.rule) = 0;
    ;}
    break;

  case 37:

    {
        (yyval.rule) = 0;
    ;}
    break;

  case 38:

    {
        (yyval.rule) = 0;
    ;}
    break;

  case 41:

    {
        (yyval.nsstring) = (yyvsp[(1) - (2)].nsstring);
        // media_feature:IDENT maybe_space
    ;}
    break;

  case 42:

    {
        (yyval.nsstring) = 0;
    ;}
    break;

  case 43:

    {
        (yyval.nsstring) = (yyvsp[(3) - (4)].nsstring);
        // ':' maybe_space expr maybe_space
    ;}
    break;

  case 44:

    {
        (yyval.mediaQueryExp) = [parser createFloatingMediaQueryExp];
        (yyval.mediaQueryExp).feature = (yyvsp[(3) - (7)].nsstring);
        (yyval.mediaQueryExp).values = (yyvsp[(5) - (7)].nsstring);
        // '(' maybe_space media_feature maybe_space maybe_media_value ')' maybe_space
    ;}
    break;

  case 45:

    {
        (yyval.mediaQueryExpList) = [parser createFloatingMediaQueryExpList];
        [(yyval.mediaQueryExpList) addObject:(yyvsp[(1) - (1)].mediaQueryExp)];
    ;}
    break;

  case 46:

    {
        (yyval.mediaQueryExpList) = (yyvsp[(1) - (5)].mediaQueryExpList);
        [(yyval.mediaQueryExpList) addObject:(yyvsp[(5) - (5)].mediaQueryExp)];
    ;}
    break;

  case 47:

    {
        (yyval.mediaQueryExpList) = [parser createFloatingMediaQueryExpList];
    ;}
    break;

  case 48:

    {
        (yyval.mediaQueryExpList) = (yyvsp[(3) - (3)].mediaQueryExpList);
    ;}
    break;

  case 49:

    {
        (yyval.nsstring) = nil;
    ;}
    break;

  case 50:

    {
        (yyval.nsstring) = @"only";        
    ;}
    break;

  case 51:

    {
        (yyval.nsstring) = @"not";
    ;}
    break;

  case 52:

    {
        (yyval.mediaQuery) = [parser createFloatingMediaQuery];
        (yyval.mediaQuery).expressions = [parser sinkFloatingMediaQueryExpList:(yyvsp[(1) - (1)].mediaQueryExpList)];
        // media_query_exp_list
    ;}
    break;

  case 53:

    {
        (yyval.mediaQuery) = [parser createFloatingMediaQuery];
        (yyval.mediaQuery).restrictor = (yyvsp[(1) - (4)].nsstring);
        (yyval.mediaQuery).mediaType = (yyvsp[(3) - (4)].nsstring);
        (yyval.mediaQuery).expressions = (yyvsp[(4) - (4)].mediaQueryExpList);
        // maybe_media_restrictor maybe_space medium maybe_and_media_query_exp_list
    ;}
    break;

  case 54:

    {
        (yyval.mediaList) = nil;
     ;}
    break;

  case 56:

    { 
        (yyval.mediaList) = [parser createMediaList];
        [(yyval.mediaList) appendMediaQuery:(yyvsp[(1) - (1)].mediaQuery)];
        // media_list:media_query
    ;}
    break;

  case 57:

    {
        (yyval.mediaList) = (yyvsp[(1) - (4)].mediaList);
        if ((yyval.mediaList))
            [(yyval.mediaList) appendMediaQuery:(yyvsp[(4) - (4)].mediaQuery)];
    // media_list:media_list ',' maybe_space media_query {
    ;}
    break;

  case 58:

    {
        (yyval.mediaList) = 0;
    ;}
    break;

  case 59:

    {
        (yyval.rule) = [parser createMediaRuleWithMediaList:(yyvsp[(3) - (7)].mediaList) ruleList:(yyvsp[(6) - (7)].ruleList)];
        // MEDIA_SYM maybe_space media_list '{' maybe_space block_rule_list save_block 
    ;}
    break;

  case 60:

    {
        (yyval.rule) = [parser createMediaRuleWithMediaList:nil ruleList:(yyvsp[(5) - (6)].ruleList)];
        // MEDIA_SYM maybe_space '{' maybe_space block_rule_list save_block {
    ;}
    break;

  case 61:

    {
      (yyval.nsstring) = (yyvsp[(1) - (2)].nsstring);
  ;}
    break;

  case 62:

    {
        (yyval.rule) = [parser createFontFaceRule];
        // '{' maybe_space declaration_list '}'  maybe_space {
    ;}
    break;

  case 63:

    {
        (yyval.rule) = 0; 
    ;}
    break;

  case 64:

    {
        (yyval.rule) = 0;
    ;}
    break;

  case 65:

    { (yyval.relation) = DirectAdjacent; ;}
    break;

  case 66:

    { (yyval.relation) = IndirectAdjacent; ;}
    break;

  case 67:

    { (yyval.relation) = Child; ;}
    break;

  case 68:

    { (yyval.nsstring) = (yyvsp[(1) - (1)].nsstring); ;}
    break;

  case 69:

    { (yyval.nsstring) = @""; ;}
    break;

  case 70:

    { (yyval.nsstring) = @"-"; ;}
    break;

  case 71:

    { (yyval.nsstring) = @"+"; ;}
    break;

  case 72:

    {
        [parser markPropertyStart];
    ;}
    break;

  case 73:

    {
        [parser markSelectorListStart];
    ;}
    break;

  case 74:

    {
        [parser markSelectorListEnd];
    ;}
    break;

  case 75:

    {
        (yyval.rule) = [parser createStyleRule:(yyvsp[(1) - (6)].selectorList)];
        // selector_list before_rule_opening_brace '{'
    ;}
    break;

  case 76:

    {
        if ((yyvsp[(1) - (1)].selector)) {
            (yyval.selectorList) = [parser reusableSelectorVector];
            // // [$$ removeAllObjects];
            [(yyval.selectorList) addObject:(yyvsp[(1) - (1)].selector)];
            // [parser updateLastSelectorLineAndPosition];
        }
    ;}
    break;

  case 77:

    {
        if ((yyvsp[(1) - (4)].selectorList) && (yyvsp[(4) - (4)].selector)) {
            (yyval.selectorList) = (yyvsp[(1) - (4)].selectorList);
            [(yyval.selectorList) addObject:(yyvsp[(4) - (4)].selector)];
        //     [parser updateLastSelectorLineAndPosition];
        } else
            (yyval.selectorList) = 0;
    ;}
    break;

  case 78:

    {
        (yyval.selectorList) = 0;
    ;}
    break;

  case 79:

    {
        (yyval.selector) = (yyvsp[(1) - (2)].selector);
    ;}
    break;

  case 80:

    {
        (yyval.selector) = (yyvsp[(1) - (1)].selector);
        //selector:simple_selector
    ;}
    break;

  case 81:

    {
        (yyval.selector) = (yyvsp[(1) - (1)].selector);
    ;}
    break;

  case 82:

    {
        (yyval.selector) = (yyvsp[(2) - (2)].selector);
        if (!(yyvsp[(1) - (2)].selector))
            (yyval.selector) = 0;
        else if ((yyval.selector)) {
            CSSSelector * end = (yyval.selector);
            while ([end tagHistory])
                end = [end tagHistory];
            [end setRelation:Descendant];
            [end setTagHistory:(yyvsp[(1) - (2)].selector)];
        }
    ;}
    break;

  case 83:

    {
        (yyval.selector) = (yyvsp[(3) - (3)].selector);
        if (!(yyvsp[(1) - (3)].selector))
            (yyval.selector) = 0;
        else if ((yyval.selector)) {
            CSSSelector * end = (yyval.selector);
            while ([end tagHistory])
                end = [end tagHistory];
            [end setRelation:(yyvsp[(2) - (3)].relation)];
            [end setTagHistory:(yyvsp[(1) - (3)].selector)];
        }
        // selector combinator simple_selector
    ;}
    break;

  case 84:

    {
        (yyval.selector) = 0;
    ;}
    break;

  case 85:

    {
        (yyval.selector) = [parser createFloatingSelector];
        [(yyval.selector) setTag:(yyvsp[(1) - (1)].nsstring)];
        // simple_selector:element_name
    ;}
    break;

  case 86:

    {
        (yyval.selector) = (yyvsp[(2) - (2)].selector);
        if ((yyval.selector))
            [parser updateSpecifier:(yyval.selector) elementName:(yyvsp[(1) - (2)].nsstring)]
        // simple_selector:element_name specifier_list
    ;}
    break;

  case 87:

    {
        (yyval.selector) = (yyvsp[(1) - (1)].selector);
        // if ($$)
        //     [parser updateSpecifier:$$ elementName:@"*"]
        // simple_selector:specifier_list
    ;}
    break;

  case 88:

    {
        if ((yyvsp[(1) - (1)].selector)) {
            (yyval.selectorList) = [parser createFloatingSelectorVector];
            [(yyval.selectorList) addObject:(yyvsp[(1) - (1)].selector)];
        } else
            (yyval.selectorList) = 0;
    ;}
    break;

  case 89:

    {
        if ((yyvsp[(1) - (5)].selectorList) && (yyvsp[(5) - (5)].selector)) {
            (yyval.selectorList) = (yyvsp[(1) - (5)].selectorList);
            [(yyval.selectorList) addObject:(yyvsp[(5) - (5)].selector)];
        } else
            (yyval.selectorList) = 0;
    ;}
    break;

  case 90:

    {
        (yyval.selectorList) = 0;
    ;}
    break;

  case 91:

    {
        (yyval.nsstring) = (yyvsp[(1) - (1)].nsstring);
    ;}
    break;

  case 92:

    {
        (yyval.nsstring) = (yyvsp[(1) - (1)].nsstring);
    ;}
    break;

  case 93:

    {
        (yyval.selector) = (yyvsp[(1) - (1)].selector);
    ;}
    break;

  case 94:

    {
        if (!(yyvsp[(2) - (2)].selector))
            (yyval.selector) = 0;
        else if ((yyvsp[(1) - (2)].selector))
           (yyval.selector) = [parser updateSpecifier:(yyvsp[(1) - (2)].selector) withNewSpecifier:(yyvsp[(2) - (2)].selector)];
           // specifier_list:specifier_list specifier
    ;}
    break;

  case 95:

    {
         (yyval.selector) = 0;
    ;}
    break;

  case 96:

    {
        (yyval.selector) = [parser createFloatingSelector];
        [(yyval.selector) setMatch:MatchId];
        [(yyval.selector) setValue:(yyvsp[(1) - (1)].nsstring)];
        // IDSEL
    ;}
    break;

  case 97:

    {
        unichar one = [(yyvsp[(1) - (1)].nsstring) characterAtIndex:0];
        if (one >= '0' && one <= '9') {
            (yyval.selector) = 0;
        } else {
            (yyval.selector) = [parser createFloatingSelector];
            [(yyval.selector) setMatch:MatchId];
            [(yyval.selector) setValue:(yyvsp[(1) - (1)].nsstring)];
        }
        // HEX
    ;}
    break;

  case 101:

    {
        (yyval.selector) = [parser createFloatingSelector];
        [(yyval.selector) setMatch:MatchClass];
        [(yyval.selector) setValue:(yyvsp[(2) - (2)].nsstring)];
        // class
    ;}
    break;

  case 102:

    {
        (yyval.nsstring) = (yyvsp[(1) - (2)].nsstring);
        // attr_name
    ;}
    break;

  case 103:

    {
        (yyval.selector) = [parser createFloatingSelector];
        [(yyval.selector) setAttribute:(yyvsp[(3) - (4)].nsstring)];
        [(yyval.selector) setMatch:MatchSet];
        // '[' maybe_space attr_name ']'
    ;}
    break;

  case 104:

    {
        (yyval.selector) = [parser createFloatingSelector];
        [(yyval.selector) setAttribute:(yyvsp[(3) - (8)].nsstring)];
        [(yyval.selector) setMatch:(int)(yyvsp[(4) - (8)].number)];
        [(yyval.selector) setValue:(yyvsp[(6) - (8)].nsstring)];
        // '[' maybe_space attr_name match maybe_space ident_or_string maybe_space ']'
    ;}
    break;

  case 105:

    {
        (yyval.number) = MatchExact;
    ;}
    break;

  case 106:

    {
        (yyval.number) = MatchList;
    ;}
    break;

  case 107:

    {
        (yyval.number) = MatchHyphen;
    ;}
    break;

  case 108:

    {
        (yyval.number) = MatchBegin;
    ;}
    break;

  case 109:

    {
        (yyval.number) = MatchEnd;
    ;}
    break;

  case 110:

    {
        (yyval.number) = MatchContain;
    ;}
    break;

  case 113:

    {
        (yyval.selector) = [parser createFloatingSelector];
        [(yyval.selector) setMatch:MatchPseudoClass];
        [(yyval.selector) setValue:(yyvsp[(2) - (2)].nsstring)];
        int type = [(yyval.selector) pseudoType];
        if (type == PseudoUnknown)
            (yyval.selector) = 0;
        // ':' IDENT
    ;}
    break;

  case 114:

    {
        (yyval.selector) = [parser createFloatingSelector];
        [(yyval.selector) setMatch:MatchPseudoElement];
        [(yyval.selector) setValue:(yyvsp[(3) - (3)].nsstring)];
        int type = [(yyval.selector) pseudoType];
        if (type == PseudoUnknown)
            (yyval.selector) = 0;
        // ':' ':' IDENT
    ;}
    break;

  case 115:

    {
        if ( (yyvsp[(4) - (6)].selectorList) ) { 
     // use by :-webkit-any.   
            (yyval.selector) = [parser createFloatingSelector];
            [(yyval.selector) setMatch:MatchPseudoClass];
            [(yyval.selector) adoptSelectorList:(yyvsp[(4) - (6)].selectorList)];
            [(yyval.selector) setValue:(yyvsp[(2) - (6)].nsstring)];
            int type = [(yyval.selector) pseudoType];
            if (type != PseudoAny)
                (yyval.selector) = 0;
        } else
            (yyval.selector) = 0;
    ;}
    break;

  case 116:

    {
     // used by :nth-*(ax+b)  
        (yyval.selector) = [parser createFloatingSelector];
        [(yyval.selector) setMatch:MatchPseudoClass];
        [(yyval.selector) setArgument:(yyvsp[(4) - (6)].nsstring)];
        [(yyval.selector) setValue:(yyvsp[(2) - (6)].nsstring)];
        int type = [(yyval.selector) pseudoType];
        if (type == PseudoUnknown)
            (yyval.selector) = 0;
    ;}
    break;

  case 117:

    {
     // used by :nth-*  
        (yyval.selector) = [parser createFloatingSelector];
        [(yyval.selector) setMatch:MatchPseudoClass];
        [(yyval.selector) setArgument:[NSString stringWithFormat:@"%@%@", (yyvsp[(4) - (7)].nsstring), (yyvsp[(5) - (7)].nsstring)]];
        [(yyval.selector) setValue:(yyvsp[(2) - (7)].nsstring)];
        int type = [(yyval.selector) pseudoType];
        if (type == PseudoUnknown)
            (yyval.selector) = 0; 
    ;}
    break;

  case 118:

    {
     // used by :nth-*(odd/even) and :lang   
        (yyval.selector) = [parser createFloatingSelector];
        [(yyval.selector) setMatch:MatchPseudoClass];
        [(yyval.selector) setArgument:(yyvsp[(4) - (6)].nsstring)];
        [(yyval.selector) setValue:(yyvsp[(2) - (6)].nsstring)];
        int type = [(yyval.selector) pseudoType];

        if (type == PseudoUnknown)
            (yyval.selector) = 0;
    ;}
    break;

  case 119:

    {
     // used by :not
        if (!(yyvsp[(4) - (6)].selector) || ![(yyvsp[(4) - (6)].selector) isSimple])
            (yyval.selector) = 0;
        else {
            (yyval.selector) = [parser createFloatingSelector];
            [(yyval.selector) setMatch:MatchPseudoClass];
            
            NSArray * selectorVector = [NSArray arrayWithObject:(yyvsp[(4) - (6)].selector)];
            [(yyval.selector) adoptSelectorList:selectorVector];

            [(yyval.selector) setArgument:[(yyvsp[(4) - (6)].selector) description]];
            [(yyval.selector) setValue:(yyvsp[(2) - (6)].nsstring)];
        }
    ;}
    break;

  case 120:

    {
        (yyval.boolean) = (yyvsp[(1) - (1)].boolean);
    ;}
    break;

  case 121:

    {
        (yyval.boolean) = (yyvsp[(1) - (2)].boolean);
        if ( (yyvsp[(2) - (2)].boolean) )
            (yyval.boolean) = (yyvsp[(2) - (2)].boolean);
    ;}
    break;

  case 122:

    {
        (yyval.boolean) = (yyvsp[(1) - (1)].boolean);
    ;}
    break;

  case 123:

    {
        (yyval.boolean) = false;
    ;}
    break;

  case 124:

    {
        (yyval.boolean) = false;
    ;}
    break;

  case 125:

    {
        (yyval.boolean) = (yyvsp[(1) - (2)].boolean);
    ;}
    break;

  case 126:

    {
        (yyval.boolean) = (yyvsp[(1) - (2)].boolean);
    ;}
    break;

  case 127:

    {
        [parser markPropertyStart];
        (yyval.boolean) = (yyvsp[(1) - (3)].boolean);
    ;}
    break;

  case 128:

    {
        (yyval.boolean) = false;
    ;}
    break;

  case 129:

    {
        (yyval.boolean) = false;
    ;}
    break;

  case 130:

    {
        [parser markPropertyStart];
        (yyval.boolean) = false;
    ;}
    break;

  case 131:

    {
        (yyval.boolean) = false;
    ;}
    break;

  case 132:

    {
        [parser markPropertyStart];
        (yyval.boolean) = (yyvsp[(1) - (4)].boolean);
        if ((yyvsp[(2) - (4)].boolean))
            (yyval.boolean) = (yyvsp[(2) - (4)].boolean);
    ;}
    break;

  case 133:

    {
        [parser markPropertyStart];
        (yyval.boolean) = (yyvsp[(1) - (4)].boolean);
    ;}
    break;

  case 134:

    {
        [parser markPropertyStart];
        (yyval.boolean) = (yyvsp[(1) - (6)].boolean);
    ;}
    break;

  case 135:

    {
        [parser addPropertyWithName:(yyvsp[(1) - (5)].nsstring) value:(yyvsp[(4) - (5)].nsstring) important:(yyvsp[(5) - (5)].boolean)];
        // [parser markPropertyEnd];
    ;}
    break;

  case 136:

    {
        (yyval.boolean) = false;   
    ;}
    break;

  case 137:

    {
        // end
        (yyval.boolean) = false;
    ;}
    break;

  case 138:

    {
        // end   
        (yyval.boolean) = false;
    ;}
    break;

  case 139:

    {
        // end
        (yyval.boolean) = false;
    ;}
    break;

  case 140:

    {
        // end
        (yyval.boolean) = false;
    ;}
    break;

  case 141:

    {
        // end
        (yyval.boolean) = false;
    ;}
    break;

  case 142:

    {
        /* if we come across: div { color{;color:maroon} }, ignore everything within curly brackets */
        (yyval.boolean) = false;
    ;}
    break;

  case 143:

    {
        (yyval.nsstring) = (yyvsp[(1) - (2)].nsstring);
        // IDENT maybe_space
    ;}
    break;

  case 144:

    { (yyval.boolean) = true; ;}
    break;

  case 145:

    { (yyval.boolean) = false; ;}
    break;

  case 146:

    {
        (yyval.nsstring) = [NSString stringWithFormat:@"%@", (yyvsp[(1) - (1)].nsstring)];
    ;}
    break;

  case 147:

    {
        (yyval.nsstring) = (yyvsp[(1) - (3)].nsstring);
        if ((yyval.nsstring)) {
            NSMutableString * string = [NSMutableString string];
            [string appendString:(yyvsp[(1) - (3)].nsstring)];
            if ((yyvsp[(2) - (3)].nsstring)) {
                [string appendFormat:@"%@", (yyvsp[(2) - (3)].nsstring)];
            }
            [string appendFormat:@" %@", (yyvsp[(3) - (3)].nsstring)];
            (yyval.nsstring) = string;
        }
        //| expr operator term
    ;}
    break;

  case 148:

    {
        (yyval.nsstring) = 0;
    ;}
    break;

  case 149:

    {
        (yyval.nsstring) = 0;
    ;}
    break;

  case 150:

    {
        (yyval.nsstring) = 0;
    ;}
    break;

  case 151:

    {
        (yyval.nsstring) = @"/";
    ;}
    break;

  case 152:

    {
        (yyval.nsstring) = @",";   
    ;}
    break;

  case 153:

    {
        (yyval.nsstring) = 0;
  ;}
    break;

  case 154:

    { (yyval.nsstring) = (yyvsp[(1) - (1)].nsstring); ;}
    break;

  case 155:

    { (yyval.nsstring) = [NSString stringWithFormat:@"%@%@", (yyvsp[(1) - (2)].nsstring), (yyvsp[(2) - (2)].nsstring)]; /* unary_operator unary_term */;}
    break;

  case 156:

    { (yyval.nsstring) = (yyvsp[(1) - (2)].nsstring); ;}
    break;

  case 157:

    { (yyval.nsstring) = (yyvsp[(1) - (2)].nsstring); ;}
    break;

  case 158:

    { (yyval.nsstring) = (yyvsp[(1) - (2)].nsstring); ;}
    break;

  case 159:

    { (yyval.nsstring) = [NSString stringWithFormat:@"%@%@", (yyvsp[(1) - (3)].nsstring), (yyvsp[(2) - (3)].nsstring)]; /* unary_operator DIMEN */ ;}
    break;

  case 160:

    { (yyval.nsstring) = (yyvsp[(1) - (2)].nsstring); ;}
    break;

  case 161:

    { (yyval.nsstring) = (yyvsp[(1) - (2)].nsstring); ;}
    break;

  case 162:

    { (yyval.nsstring) = [NSString stringWithFormat:@"#%@", (yyvsp[(1) - (2)].nsstring)]; /* '#' fix for current version */ ;}
    break;

  case 163:

    { (yyval.nsstring) = @"#"; ;}
    break;

  case 164:

    {
    (yyval.nsstring) = (yyvsp[(1) - (1)].nsstring);
  ;}
    break;

  case 165:

    {
    (yyval.nsstring) = (yyvsp[(1) - (1)].nsstring);
  ;}
    break;

  case 166:

    {
    (yyval.nsstring) = (yyvsp[(1) - (1)].nsstring);
  ;}
    break;

  case 167:

    {
    (yyval.nsstring) = 0;
  ;}
    break;

  case 168:

    { (yyval.nsstring) = (yyvsp[(1) - (2)].nsstring); ;}
    break;

  case 169:

    { (yyval.nsstring) = (yyvsp[(1) - (2)].nsstring); ;}
    break;

  case 170:

    { (yyval.nsstring) = (yyvsp[(1) - (2)].nsstring); ;}
    break;

  case 171:

    { (yyval.nsstring) = (yyvsp[(1) - (2)].nsstring); ;}
    break;

  case 172:

    {
        (yyval.nsstring) = [NSString stringWithFormat:@"%@%@)", (yyvsp[(1) - (5)].nsstring), (yyvsp[(3) - (5)].nsstring)];
        // CSSFUNCTION maybe_space expr ')' maybe_space {
    ;}
    break;

  case 173:

    {
       (yyval.nsstring) = [NSString stringWithFormat:@"%@)", (yyvsp[(1) - (3)].nsstring)];
       // CSSFUNCTION maybe_space error {
  ;}
    break;

  case 174:

    { 
    (yyval.nsstring) = 0; 
  ;}
    break;

  case 175:

    {
    (yyval.nsstring) = 0;
  ;}
    break;

  case 176:

    {
        (yyval.nsstring) = 0;
    ;}
    break;

  case 177:

    {
        (yyval.nsstring) = 0;
    ;}
    break;

  case 178:

    {
        (yyval.nsstring) = 0;
    ;}
    break;

  case 179:

    {
        (yyval.nsstring) = 0;
    ;}
    break;

  case 180:

    {
        (yyval.nsstring) = 0;
    ;}
    break;

  case 181:

    {
        (yyval.nsstring) = 0;
    ;}
    break;

  case 182:

    {
       (yyval.nsstring) = 0;
    ;}
    break;

  case 183:

    {
        (yyval.nsstring) = 0;
    ;}
    break;

  case 184:

    {
        (yyval.nsstring) = 0;
    ;}
    break;

  case 186:

    {
        (yyval.nsstring) = 0;
    ;}
    break;

  case 187:

    {
        (yyval.nsstring) = 0;
    ;}
    break;

  case 188:

    {
       (yyval.nsstring) = 0;
    ;}
    break;

  case 189:

    {
        (yyval.nsstring) = 0;
    ;}
    break;

  case 190:

    {
        YYERROR;
    ;}
    break;

  case 191:

    {
        (yyval.nsstring) = 0;
    ;}
    break;

  case 192:

    {
        (yyval.nsstring) = 0;
    ;}
    break;

  case 193:

    {
        (yyval.nsstring) = 0;
    ;}
    break;

  case 194:

    {
        YYERROR;
    ;}
    break;

  case 195:

    {
        (yyval.rule) = 0;
    ;}
    break;

  case 196:

    {
        (yyval.rule) = 0;
    ;}
    break;

  case 197:

    {
        (yyval.rule) = 0;
    ;}
    break;

  case 198:

    {
        (yyval.rule) = 0;
    ;}
    break;

  case 199:

    {
        (yyval.rule) = 0;
    ;}
    break;

  case 200:

    {
    ;}
    break;

  case 201:

    {
    ;}
    break;


/* Line 1267 of yacc.c.  */

      default: break;
    }
  YY_SYMBOL_PRINT ("-> $$ =", yyr1[yyn], &yyval, &yyloc);

  YYPOPSTACK (yylen);
  yylen = 0;
  YY_STACK_PRINT (yyss, yyssp);

  *++yyvsp = yyval;


  /* Now `shift' the result of the reduction.  Determine what state
     that goes to, based on the state we popped back to and the rule
     number reduced by.  */

  yyn = yyr1[yyn];

  yystate = yypgoto[yyn - YYNTOKENS] + *yyssp;
  if (0 <= yystate && yystate <= YYLAST && yycheck[yystate] == *yyssp)
    yystate = yytable[yystate];
  else
    yystate = yydefgoto[yyn - YYNTOKENS];

  goto yynewstate;


/*------------------------------------.
| yyerrlab -- here on detecting error |
`------------------------------------*/
yyerrlab:
  /* If not already recovering from an error, report this error.  */
  if (!yyerrstatus)
    {
      ++yynerrs;
#if ! YYERROR_VERBOSE
      yyerror (parser, YY_("syntax error"));
#else
      {
	YYSIZE_T yysize = yysyntax_error (0, yystate, yychar);
	if (yymsg_alloc < yysize && yymsg_alloc < YYSTACK_ALLOC_MAXIMUM)
	  {
	    YYSIZE_T yyalloc = 2 * yysize;
	    if (! (yysize <= yyalloc && yyalloc <= YYSTACK_ALLOC_MAXIMUM))
	      yyalloc = YYSTACK_ALLOC_MAXIMUM;
	    if (yymsg != yymsgbuf)
	      YYSTACK_FREE (yymsg);
	    yymsg = (char *) YYSTACK_ALLOC (yyalloc);
	    if (yymsg)
	      yymsg_alloc = yyalloc;
	    else
	      {
		yymsg = yymsgbuf;
		yymsg_alloc = sizeof yymsgbuf;
	      }
	  }

	if (0 < yysize && yysize <= yymsg_alloc)
	  {
	    (void) yysyntax_error (yymsg, yystate, yychar);
	    yyerror (parser, yymsg);
	  }
	else
	  {
	    yyerror (parser, YY_("syntax error"));
	    if (yysize != 0)
	      goto yyexhaustedlab;
	  }
      }
#endif
    }



  if (yyerrstatus == 3)
    {
      /* If just tried and failed to reuse look-ahead token after an
	 error, discard it.  */

      if (yychar <= YYEOF)
	{
	  /* Return failure if at end of input.  */
	  if (yychar == YYEOF)
	    YYABORT;
	}
      else
	{
	  yydestruct ("Error: discarding",
		      yytoken, &yylval, parser);
	  yychar = YYEMPTY;
	}
    }

  /* Else will try to reuse look-ahead token after shifting the error
     token.  */
  goto yyerrlab1;


/*---------------------------------------------------.
| yyerrorlab -- error raised explicitly by YYERROR.  |
`---------------------------------------------------*/
yyerrorlab:

  /* Pacify compilers like GCC when the user code never invokes
     YYERROR and the label yyerrorlab therefore never appears in user
     code.  */
  if (/*CONSTCOND*/ 0)
     goto yyerrorlab;

  /* Do not reclaim the symbols of the rule which action triggered
     this YYERROR.  */
  YYPOPSTACK (yylen);
  yylen = 0;
  YY_STACK_PRINT (yyss, yyssp);
  yystate = *yyssp;
  goto yyerrlab1;


/*-------------------------------------------------------------.
| yyerrlab1 -- common code for both syntax error and YYERROR.  |
`-------------------------------------------------------------*/
yyerrlab1:
  yyerrstatus = 3;	/* Each real token shifted decrements this.  */

  for (;;)
    {
      yyn = yypact[yystate];
      if (yyn != YYPACT_NINF)
	{
	  yyn += YYTERROR;
	  if (0 <= yyn && yyn <= YYLAST && yycheck[yyn] == YYTERROR)
	    {
	      yyn = yytable[yyn];
	      if (0 < yyn)
		break;
	    }
	}

      /* Pop the current state because it cannot handle the error token.  */
      if (yyssp == yyss)
	YYABORT;


      yydestruct ("Error: popping",
		  yystos[yystate], yyvsp, parser);
      YYPOPSTACK (1);
      yystate = *yyssp;
      YY_STACK_PRINT (yyss, yyssp);
    }

  if (yyn == YYFINAL)
    YYACCEPT;

  *++yyvsp = yylval;


  /* Shift the error token.  */
  YY_SYMBOL_PRINT ("Shifting", yystos[yyn], yyvsp, yylsp);

  yystate = yyn;
  goto yynewstate;


/*-------------------------------------.
| yyacceptlab -- YYACCEPT comes here.  |
`-------------------------------------*/
yyacceptlab:
  yyresult = 0;
  goto yyreturn;

/*-----------------------------------.
| yyabortlab -- YYABORT comes here.  |
`-----------------------------------*/
yyabortlab:
  yyresult = 1;
  goto yyreturn;

#ifndef yyoverflow
/*-------------------------------------------------.
| yyexhaustedlab -- memory exhaustion comes here.  |
`-------------------------------------------------*/
yyexhaustedlab:
  yyerror (parser, YY_("memory exhausted"));
  yyresult = 2;
  /* Fall through.  */
#endif

yyreturn:
  if (yychar != YYEOF && yychar != YYEMPTY)
     yydestruct ("Cleanup: discarding lookahead",
		 yytoken, &yylval, parser);
  /* Do not reclaim the symbols of the rule which action triggered
     this YYABORT or YYACCEPT.  */
  YYPOPSTACK (yylen);
  YY_STACK_PRINT (yyss, yyssp);
  while (yyssp != yyss)
    {
      yydestruct ("Cleanup: popping",
		  yystos[*yyssp], yyvsp, parser);
      YYPOPSTACK (1);
    }
#ifndef yyoverflow
  if (yyss != yyssa)
    YYSTACK_FREE (yyss);
#endif
#if YYERROR_VERBOSE
  if (yymsg != yymsgbuf)
    YYSTACK_FREE (yymsg);
#endif
  /* Make sure YYID is used.  */
  return YYID (yyresult);
}

#endif	// #if (TARGET_OS_IPHONE || TARGET_IPHONE_SIMULATOR)
