
//
//  VankeUserLoginAPI.m
//  vanke
//
//  Created by xiaomi on 15/10/6.
//  Copyright © 2015年 gomore. All rights reserved.
//

#import "VankeUserLoginAPI.h"
#import "VankeUtil.h"

#pragma mark VankeUserLoginAPI

@implementation VankeUserLoginAPI

@synthesize userName;
@synthesize password;
@synthesize authenticode;

-(void) route:(BeeMessage *)msg {
    if (self.sending) {
        if (![self checkToQuery]) {
            return;
        }
        
        NSString *url = [NSString stringWithFormat:@"/user/login/%@", self.userName];
        NSString *encryptPwd = [VankeUtil md5: self.password];
        NSDictionary *dict = [NSDictionary dictionaryWithObjectsAndKeys:
                                  self.authenticode, @"authenticode",
                                  encryptPwd, @"password", nil];
        NSString *postData = [VankeUtil dictToJsonString: dict];
        [self http_post: url].BODY(postData).TIMEOUT(10);
    }
    else if (self.succeed) {
        NSLog(@"response: %@", self.responseString);
        
        self.serverResp = [LoginResponse objectFromDictionary: self.responseJSONDictionary];
        if ( nil == self.serverResp )
        {
            self.failed = YES;
            return;
        }
    }
}

-(BOOL) checkToQuery {
    if ([VankeUtil isBlankString:self.userName]) {
        [self setClientError: @"用户名不能为空"];
        return NO;
    }
    
    if ([VankeUtil isBlankString:self.password]) {
        [self setClientError: @"密码不能为空"];
        return NO;
    }

    return YES;
}

@end


#pragma mark User
@implementation User
@synthesize uuid;
@synthesize code;
@synthesize name;
@end

#pragma mark Enterpirse
@implementation Enterpirse
@synthesize uuid;
@synthesize code;
@synthesize name;
@end

#pragma mark LoginResponseData
@implementation LoginResponseData
//@synthesize user;
//@synthesize enterprise;

@synthesize user_uuid;
@synthesize user_code;
@synthesize user_name;
@synthesize enterprise_uuid;
@synthesize enterprise_code;
@synthesize enterprise_name;
@synthesize authenticode;

-(User*) getUser {
    if ([VankeUtil isBlankString:self.user_uuid]) {
        return nil;
    }
    
    User *user = [[User alloc]init];
    user.uuid = self.user_uuid;
    user.code = self.user_code;
    user.name = self.user_name;
    return user;
}

-(Enterpirse*) getEnterprise {
    if ([VankeUtil isBlankString:self.enterprise_uuid]) {
        return nil;
    }
    
    Enterpirse *ent = [[Enterpirse alloc]init];
    ent.uuid = self.enterprise_uuid;
    ent.code = self.enterprise_code;
    ent.name = self.enterprise_name;
    return ent;
}

@end

#pragma mark LoginResponse
@implementation LoginResponse
@synthesize data;
@end

