//
//  VankeSaleVolumeAPI.h
//  vanke
//
//  Created by xiaomi on 15/10/9.
//  Copyright © 2015年 gomore. All rights reserved.
//

#import "VankeBaseAPI.h"

@class ProjectSaleVolume;
@class ProjectSaleVolumeResponse;

@interface VankeSaleVolumeAPI : VankeBaseAPI

// 项目ID等于
@property (nonatomic, strong) NSString *projectEquals;

// 销量日期，默认为昨天
@property (nonatomic, strong) NSString *salesDateEquals;

@end

// 项目销量
@interface ProjectSaleVolume: BeeActiveObject

// 项目标识
@property (nonatomic, strong) NSString *projectId;

// 项目名称
@property (nonatomic, strong) NSString *projectName;

// 维度
@property (nonatomic, strong) NSString *dimensionType;

// 维度值
@property (nonatomic, strong) NSString *dimensionValue;

// 销量
@property (nonatomic, strong) NSNumber *amount;

// 销量日期
@property (nonatomic, strong) NSString *salesDate;

@end

// 响应
@interface ProjectSaleVolumeResponse: VankeResponse

@property (nonatomic, strong) NSArray *data;

// 取得排序后的维度列表
-(NSArray*) getSortedDimensions;

// 按维度取得销售数据
-(NSArray*) getSalesInfo: (NSString*) dimension;

// 取得指定维度的销售总额
-(NSNumber*) getSalesTotalAmount: (NSString*) dimension;

@end