
//
//  VankeProjectSummaryAPI.h
//  vanke
//
//  Created by xiaomi on 15/10/6.
//  Copyright © 2015年 gomore. All rights reserved.
//

#import "Bee.h"
#import "VankeResponse.h"
#import "VankeBaseAPI.h"

#pragma mark -

@class ProjectSummaryResponse;

// get: http://.../wanke-server/rest/project/queryclassificationby?salesDateEquals={salesDateEquals}& passengerDateEquals={passengerDateEquals}&trafficDateEquals={trafficDateEquals}
// 查询项目汇总信息
@interface VankeProjectSummaryAPI: VankeBaseAPI

// 销量日期，默认为昨天
@property (nonatomic, strong) NSString *salesDate;

// 客流量日期，默认为今天
@property (nonatomic, strong) NSString *passengerDate;

// 车流量日期，黑夜为今天
@property (nonatomic, strong) NSString *trafficDate;

@end

// 项目汇总信息
@interface ProjectSummary: BeeActiveObject

// 项目名称
@property (nonatomic, strong) NSString *classificationName;

// 昨日销售
@property (nonatomic, strong) NSNumber *salesAmount;

// 当前客流
@property (nonatomic, strong) NSNumber *passengerFlowVolume;

// 当前车流
@property (nonatomic, strong) NSNumber *trafficVolume;

@end


@interface ProjectSummaryResponse: VankeResponse

@property (nonatomic, strong) NSArray *data;

-(ProjectSummary*) getSummary: (NSString*) classificationName;

@end

