
//
//  VankeBaseAPI.m
//  vanke
//
//  Created by xiaomi on 15/10/7.
//  Copyright © 2015年 gomore. All rights reserved.
//

#import "VankeBaseAPI.h"
#import "VankeUtil.h"
#import "VankeConfig.h"
#import "VankeCommonModel.h"

#pragma mark -

@implementation VankeBaseAPI

@synthesize serverResp;

- (id) init {
    self = [super init];
    if ( self )
    {
        self.serverResp = nil;
    }
    return self;
}

-(BeeHTTPRequest*) http_post: (NSString*) url {
    NSString *absUrl = [NSString stringWithFormat:@"%@%@", VANKE_SERVER_BASE_URL, url];
    BeeHTTPRequest *req = self.HTTP_POST(absUrl);
    [[[self addAuthorizationToHeader:req] addJsonContentTypeToHeader:req] addEnterpriseIdToHeader:req];
    return req;
}

-(BeeHTTPRequest*) http_get: (NSString*) url {
    NSString *absUrl = [NSString stringWithFormat:@"%@/%@", VANKE_SERVER_BASE_URL, url];
    BeeHTTPRequest *req = self.HTTP_GET(absUrl);
    [[[self addAuthorizationToHeader:req] addJsonContentTypeToHeader:req] addEnterpriseIdToHeader:req];
    return req;
}

-(void) setClientError: (NSString*) error {
    self.failed = YES;
    [self setLastError:-1 domain:BeeMessage.ERROR_DOMAIN_CLIENT desc:error];
}

-(VankeBaseAPI*) addAuthorizationToHeader: (BeeHTTPRequest*) req {
    NSString *src = [NSString stringWithFormat:@"%@:%@", VANKE_SERVER_USER_NAME, VANKE_SERVER_PASSWORD];
    req.HEADER(@"Authorization", [NSString stringWithFormat:@"Basic %@", [VankeUtil base64:src]]);
    return self;
}

-(VankeBaseAPI*) addJsonContentTypeToHeader: (BeeHTTPRequest*) req {
    req.HEADER(@"Content-Type", @"application/json");
    return self;
}

-(VankeBaseAPI*) addEnterpriseIdToHeader: (BeeHTTPRequest*) req {
    Enterpirse *ent = [[VankeCommonModel sharedInstance] currentEnterprise];
    if (nil != ent && ![VankeUtil isBlankString:ent.uuid]) {
        req.HEADER(@"enterprise", ent.uuid);
    }
    return self;
}

@end
