//
//  SalesInputViewController.m
//  vanke
//
//  Created by Z on 16/4/15.
//  Copyright © 2016年 gomore. All rights reserved.
//

#import "SalesInputViewController.h"
#import "SalesInputTopView.h"
#import "SalesInputTableViewCell.h"
#import "VankeAppBoard_iPhone.h"
#import "HistoryViewController.h"
#import "ChooseShopViewController.h"
#import "VankeUserLoginAPI.h"
#import "ICRHTTPController.h"
#import "MyToolBar.h"
#import "SalesInputTotalVIew.h"
#import "ICRAppMacro.h"
#define kCellCount 20
#define kCellID @"SalesInputTableViewCell.h"
@interface SalesInputViewController ()<UITableViewDelegate, UITableViewDataSource>
@property (nonatomic, strong) UITableView *tableView;
@property (nonatomic, strong) SalesInputTopView *topView;
@property (nonatomic, strong) UIDatePicker *datePicker;
@property (nonatomic, strong) UIImage *navigationbarColorImage;
@property (nonatomic, strong) SalesInputTotalVIew *totalView;
@property (nonatomic, strong) NSString *selectDate;
@property (nonatomic, strong) NSMutableDictionary *cellDataDic;
@end

@implementation SalesInputViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    
    self.cellDataDic = [NSMutableDictionary dictionary];
    self.view.backgroundColor = [UIColor whiteColor];
    [self setUpNavigationBar];
    [self setUpTopView];
    [self setUpTableView];
    [self setUpTotalView];
    
    

    
    
    // Do any additional setup after loading the view.
}

- (void)viewWillAppear:(BOOL)animated {
    [super viewWillAppear:animated];
    [[VankeAppBoard_iPhone sharedInstance] hideMenu];

}

ON_WILL_APPEAR( signal )
{
    [[VankeAppBoard_iPhone sharedInstance] hideMenu];
}

- (void)setUpTableView {
    self.tableView = [[UITableView alloc] initWithFrame:CGRectMake(0, 125, SCREEN_WIDTH, SCREEN_HEIGHT - self.topView.bottom) style:UITableViewStylePlain];
    self.tableView.contentInset = UIEdgeInsetsMake(179, 0, 0, 0);

    self.tableView.delegate = self;
    self.tableView.dataSource = self;
    self.tableView.separatorStyle = UITableViewCellSeparatorStyleNone;
    [self.tableView registerNib:[UINib nibWithNibName:@"SalesInputTableViewCell" bundle:[NSBundle mainBundle]] forCellReuseIdentifier:kCellID];
    [self.view addSubview:self.tableView];
}

- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section
{
    return kCellCount;
}

- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath
{
    SalesInputTableViewCell *cell = [tableView dequeueReusableCellWithIdentifier:kCellID forIndexPath:indexPath];
    
    [cell cellWithArray:[self getCellDataArrWithIndexPath:indexPath]];
    
    WS(weakSelf)
    cell.updateCellData = ^(NSArray *dataArr){
        NSLog(@"%@", dataArr);
        [weakSelf.cellDataDic setObject:dataArr forKey:indexPath];
        [weakSelf countTotalMonney];
    };
    return cell;
}

- (CGFloat)tableView:(UITableView *)tableView heightForRowAtIndexPath:(NSIndexPath *)indexPath
{
    return 50;
}

- (void)setUpNavigationBar {
    self.navigationItem.title = @"销售录入";
    
    self.navigationController.navigationBar.backgroundImage = [UIImage imageWithColor:[UIColor colorWithRed:0.953 green:0.439 blue:0.063 alpha:1.000]];
    
    UIBarButtonItem *rightBtn = [[UIBarButtonItem alloc] initWithTitle:@"历史" style:UIBarButtonItemStyleDone target:self action:@selector(goToHistory)];
    rightBtn.tintColor = [UIColor whiteColor];
    self.navigationItem.rightBarButtonItem = rightBtn;
    self.navigationController.navigationBar.tintColor = [UIColor whiteColor];
}


- (void)setUpTopView {
    SalesInputTopView *topView = [self viewWithNibName:@"SalesInputTopView"];
    topView.frame = CGRectMake(0, 0, SCREEN_WIDTH, 125 + 64);
    self.topView = topView;
    topView.textfieldDate.inputView = self.datePicker;
   
    topView.nameTapActionBlock = ^{
        [self chooseShopAction];
    };
    
    [self.view addSubview:topView];
}


- (void)setUpTotalView {
    self.totalView = [self viewWithNibName:@"SalesInputTotalView"];
    self.totalView.frame = CGRectMake(0, -179, SCREEN_WIDTH, 179);
    [self.tableView addSubview:self.totalView];
}


- (void)pickerDoneAction {
    [self.view endEditing:YES];
}


- (void)chooseShopAction {
    ChooseShopViewController *chooseVC = [[ChooseShopViewController alloc] init];

    chooseVC.chooseBlock = ^(NSString *string){
        [self.topView setShopName:string];
    };
    
    [self.navigationController pushViewController:chooseVC animated:YES];
}


- (UIDatePicker *)datePicker {
    if (!_datePicker) {
        _datePicker = [[UIDatePicker alloc] init];
        _datePicker.backgroundColor = [UIColor colorWithWhite:0.902 alpha:1.000];
        _datePicker.date = [NSDate date];

        _datePicker.datePickerMode = UIDatePickerModeDate;
         [_datePicker addTarget:self action:@selector(oneDatePickerValueChanged:) forControlEvents:UIControlEventValueChanged]; // 添加监听器
        
    }
    return _datePicker;
}


#pragma mark - 实现oneDatePicker的监听方法
- (void)oneDatePickerValueChanged:(UIDatePicker *) sender {
    NSDate *date = sender.date;
    NSDateFormatter *df = [[NSDateFormatter alloc] init];
    [df setDateFormat:@"yyyy-MM-dd"];
    
    NSString *strTime = [df stringFromDate:date];
    
    self.topView.textfieldDate.text = strTime;
    NSLog(@"%@", strTime);
}

- (void)countTotalMonney {
    CGFloat count = 0;
    for (NSIndexPath *obj in self.cellDataDic.allKeys) {
        NSArray *array = [self.cellDataDic objectForKey:obj];
        CGFloat monney = [array[0] floatValue];
        CGFloat bill = [array[1] floatValue];
        count = count + monney * bill;
    }
    
    self.totalView.labelTotal.text = [NSString stringWithFormat:@"%.0f",count];
}



- (id)viewWithNibName:(NSString *)viewName {
    NSArray* nibView =  [[NSBundle mainBundle] loadNibNamed:viewName owner:nil options:nil];
    return [nibView objectAtIndex:0];
}


- (NSArray *)getCellDataArrWithIndexPath:(NSIndexPath *)indextPath {
    if (![self.cellDataDic objectForKey:indextPath]) {
        [self.cellDataDic setObject:@[@"0",@"0"] forKey:indextPath];
    }
    return [self.cellDataDic objectForKey:indextPath];
}

- (void)goToHistory {
    HistoryViewController *history = [[HistoryViewController alloc] init];
    [self.navigationController pushViewController:history animated:YES];
}

- (void)setUpData {
    ICRHTTPController *httpCtrl = [ICRHTTPController sharedController];
    
    NSDictionary *myDictionary = @{@"shopCodeEquals" : @"a",
                                   @"beginDateEquals" : @"a",
                                   @"endDateEquals" : @"a",
                                   @"pageNumber" : @0,
                                   @"pageSize" : @0};
    
}


- (void)didReceiveMemoryWarning {
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}

/*
#pragma mark - Navigation

// In a storyboard-based application, you will often want to do a little preparation before navigation
- (void)prepareForSegue:(UIStoryboardSegue *)segue sender:(id)sender {
    // Get the new view controller using [segue destinationViewController].
    // Pass the selected object to the new view controller.
}
*/

@end
