//
//  VankeSettlementSubjectListAPI.h
//  vanke
//  查询对账单列表
//  Created by xiaomi on 15/10/8.
//  Copyright © 2015年 gomore. All rights reserved.
//

#import "Bee.h"
#import "VankeBaseAPI.h"
#import "VankeResponse.h"

@class Paging;
@class SubjectItem;
@class StatementShop;
@class StatementListResponse;


/*
 * 查询对账单科目列表
 * http://.../wanke-server/rest/statement?contract={contract}&settleEquals={settleEquals}
 */
@interface VankeSettlementSubjectListAPI : VankeBaseAPI

// 账期等于
@property (nonatomic, strong) NSDate *settle;

// 合同ID
@property (nonatomic, strong) NSString *contract;

@end

// 对账单科目
@interface SubjectItem : BeeActiveObject

@property (nonatomic, strong) NSString *subject;
@property (nonatomic, strong) NSString *beginDate;
@property (nonatomic, strong) NSString *endDate;
@property (nonatomic, strong) NSNumber *direction;
@property (nonatomic, strong) NSNumber *amount;
@property (nonatomic, strong) NSString *remark;

@end

@interface StatementSubjectListResponseData : BeeActiveObject

@property (nonatomic, strong) NSString *contract;
@property (nonatomic, strong) NSString *shopCode;
@property (nonatomic, strong) NSString *shopName;
@property (nonatomic, strong) NSString *picture;
@property (nonatomic, strong) NSString *settle;
@property (nonatomic, strong) NSNumber *amount;
@property (nonatomic, strong) NSString *state;
@property (nonatomic, strong) NSArray *items; // SubjectItem

-(NSString*) getPictureUrlOrDefault;
-(NSString*) codeName;
-(BOOL) unconfirmed;

@end

// 对账单返回
@interface StatementSubjectListResponse : VankeResponse

@property (nonatomic, strong) StatementSubjectListResponseData *data;

@end