//
//  VankePassengerFlowAPI.h
//  vanke
//
//  Created by xiaomi on 15/10/9.
//  Copyright © 2015年 gomore. All rights reserved.
//

#import "VankeBaseAPI.h"

@class PassengerFlow;
@class PassengerFlowResponse;

@interface VankePassengerFlowAPI : VankeBaseAPI

// 项目ID等于
@property (nonatomic, strong) NSString *projectEquals;

// 客流日期，默认为今天
@property (nonatomic, strong) NSString *passengerFlowDateEquals;

@end

// 项目销量
@interface PassengerFlow : BeeActiveObject

// 项目标识
@property (nonatomic, strong) NSString *projectId;

// 项目名称
@property (nonatomic, strong) NSString *projectName;

// 客流量
@property (nonatomic, strong) NSNumber *passengerFlowVolume;

// 客流日期
@property (nonatomic, strong) NSString *passengerFlowDate;

// 客流位置
@property (nonatomic, strong) NSString *passengerFlowPosition;

@end

// 响应
@interface PassengerFlowResponse : VankeResponse

@property (nonatomic, strong) NSArray *data;

-(int) dataCount;

-(NSArray*) getChartValues;

@end