//
//  VankeShopModel.m
//
//  Created by Z  on 16/4/25
//  Copyright (c) 2016 __MyCompanyName__. All rights reserved.
//

#import "VankeShopModel.h"


NSString *const kVankeShopModelName = @"name";
NSString *const kVankeShopModelCode = @"code";
NSString *const kVankeShopModelUuid = @"uuid";


@interface VankeShopModel ()

- (id)objectOrNilForKey:(id)aKey fromDictionary:(NSDictionary *)dict;

@end

@implementation VankeShopModel

@synthesize name = _name;
@synthesize code = _code;
@synthesize uuid = _uuid;


+ (instancetype)modelObjectWithDictionary:(NSDictionary *)dict
{
    return [[self alloc] initWithDictionary:dict];
}

- (instancetype)initWithDictionary:(NSDictionary *)dict
{
    self = [super init];
    
    // This check serves to make sure that a non-NSDictionary object
    // passed into the model class doesn't break the parsing.
    if(self && [dict isKindOfClass:[NSDictionary class]]) {
            self.name = [self objectOrNilForKey:kVankeShopModelName fromDictionary:dict];
            self.code = [self objectOrNilForKey:kVankeShopModelCode fromDictionary:dict];
            self.uuid = [self objectOrNilForKey:kVankeShopModelUuid fromDictionary:dict];

    }
    
    return self;
    
}

- (NSDictionary *)dictionaryRepresentation
{
    NSMutableDictionary *mutableDict = [NSMutableDictionary dictionary];
    [mutableDict setValue:self.name forKey:kVankeShopModelName];
    [mutableDict setValue:self.code forKey:kVankeShopModelCode];
    [mutableDict setValue:self.uuid forKey:kVankeShopModelUuid];

    return [NSDictionary dictionaryWithDictionary:mutableDict];
}

- (NSString *)description 
{
    return [NSString stringWithFormat:@"%@", [self dictionaryRepresentation]];
}

#pragma mark - Helper Method
- (id)objectOrNilForKey:(id)aKey fromDictionary:(NSDictionary *)dict
{
    id object = [dict objectForKey:aKey];
    return [object isEqual:[NSNull null]] ? nil : object;
}


#pragma mark - NSCoding Methods

- (id)initWithCoder:(NSCoder *)aDecoder
{
    self = [super init];

    self.name = [aDecoder decodeObjectForKey:kVankeShopModelName];
    self.code = [aDecoder decodeObjectForKey:kVankeShopModelCode];
    self.uuid = [aDecoder decodeObjectForKey:kVankeShopModelUuid];
    return self;
}

- (void)encodeWithCoder:(NSCoder *)aCoder
{

    [aCoder encodeObject:_name forKey:kVankeShopModelName];
    [aCoder encodeObject:_code forKey:kVankeShopModelCode];
    [aCoder encodeObject:_uuid forKey:kVankeShopModelUuid];
}

- (id)copyWithZone:(NSZone *)zone
{
    VankeShopModel *copy = [[VankeShopModel alloc] init];
    
    if (copy) {

        copy.name = [self.name copyWithZone:zone];
        copy.code = [self.code copyWithZone:zone];
        copy.uuid = [self.uuid copyWithZone:zone];
    }
    
    return copy;
}


@end
