

#import "VankeServiceBoardCell_iPhone.h"

#pragma mark -

@interface VankeServiceBoardCell_iPhone ()
{
}
@end

@implementation VankeServiceBoardCell_iPhone

SUPPORT_AUTOMATIC_LAYOUT( YES )
SUPPORT_RESOURCE_LOADING( YES )

DEF_OUTLET( BeeUIImageView, imgBg )
DEF_OUTLET( BeeUIImageView, imgIcon )
DEF_OUTLET( BeeUILabel, lblTitle )
DEF_OUTLET( BeeUIImageView, imgAmountIcon )
DEF_OUTLET( BeeUILabel, lblAmount )
DEF_OUTLET( BeeUILabel, lblAmountUnit )
DEF_OUTLET( BeeUIButton, mask)


- (void)load
{
    self.data = [[NSNumber alloc] initWithInt:0];
}

- (void)unload
{
}

- (void)dataDidChanged {
    int oldAmount = [self.lblAmount.data intValue];
    int newAmount = 0;
    if (nil != self.data) {
        newAmount = [self.data intValue];
    }
    
    if (newAmount >= oldAmount) {
        $(self.imgAmountIcon).REMOVE_CLASS(@"down");
        $(self.imgAmountIcon).ADD_CLASS(@"up");
    } else {
        $(self.imgAmountIcon).REMOVE_CLASS(@"up");
        $(self.imgAmountIcon).ADD_CLASS(@"down");
    }
    
    $(self.lblAmount).DATA([NSString stringWithFormat:@"%d",newAmount]);
}

-(NSString*) name {
    return self.lblTitle.data;
}

-(void) asNotAvailableCell {
    $(self.imgAmountIcon).HIDE();
    $(self.lblAmountUnit).HIDE();
    $(self.lblAmount).ADD_CLASS(@"not-available");
    self.lblAmount.data = @"正在研发中...";
}

-(void) loadDefaults: (NSString*) imgName title: (NSString*) title bgColor: (UIColor*) bgColor unit: (NSString*) unit defValue: (NSNumber*) defValue {
    self.imgIcon.data = imgName;
    self.lblTitle.data = title;
    self.imgBg.backgroundColor = bgColor;
    self.lblAmountUnit.data = unit;
    self.lblAmount.data = defValue;
}

@end
