//
//	 ______    ______    ______    
//	/\  __ \  /\  ___\  /\  ___\   
//	\ \  __<  \ \  __\_ \ \  __\_ 
//	 \ \_____\ \ \_____\ \ \_____\ 
//	  \/_____/  \/_____/  \/_____/ 
//
//	Powered by BeeFramework
//
//
//  VankeAffairsBoard_iPhone.m
//  vanke
//
//  Created by xiaomi on 15/10/28.
//  Copyright © 2015年 gomore. All rights reserved.
//

#import "VankeAffairsBoard_iPhone.h"
#import "VankeUtil.h"
#import "GEToast.h"
#import "VankeCommonModel.h"
#import "VankeAppBoard_iPhone.h"
#import "VankeNoticeListBoard_iPhone.h"
#import "VankeStatementListBoard_iPhone.h"
#import "ICRAnnouncementViewController.h"

#pragma mark -

@interface VankeAffairsBoard_iPhone()
{
	//<#@private var#>
    NSArray *authorizedOrgs;
}
@end

@implementation VankeAffairsBoard_iPhone

SUPPORT_AUTOMATIC_LAYOUT( YES )
SUPPORT_RESOURCE_LOADING( YES )

DEF_OUTLET( BeeUIButton, btnNotice )
DEF_OUTLET( BeeUIButton, btnBill )
DEF_OUTLET( BeeUIButton, btnSaleInput )
DEF_OUTLET( BeeUIButton, btnServiceApply )

- (void)load
{
}

- (void)unload
{
}

#pragma mark - Signal

ON_CREATE_VIEWS( signal )
{
    self.navigationBarShown = YES;
    self.navigationBarTitle = @"事务";
}

ON_DELETE_VIEWS( signal )
{
}

ON_LAYOUT_VIEWS( signal )
{
}

ON_WILL_APPEAR( signal )
{
    UIColor *color = [VankeUtil rgbStringToColor: @"237,27,35"];
    if ( IOS7_OR_LATER ) {
        self.navigationController.navigationBar.barTintColor = color;
    } else {
        self.navigationController.navigationBar.tintColor = color;
    }
    [[VankeAppBoard_iPhone sharedInstance] showMenu];
}

ON_DID_APPEAR( signal )
{
}

ON_WILL_DISAPPEAR( signal )
{
}

ON_DID_DISAPPEAR( signal )
{
}

ON_SIGNAL3(VankeAffairsBoard_iPhone, btnNotice, signal) {
    [[VankeAppBoard_iPhone sharedInstance] hideMenu];
    VankeNoticeListBoard_iPhone *board = [VankeNoticeListBoard_iPhone board];
//    ICRAnnouncementViewController *board = [ICRAnnouncementViewController board];
    [self.stack pushBoard:board animated:YES];
}

ON_SIGNAL3(VankeAffairsBoard_iPhone, btnBill, signal) {
    VankeCommonModel *userModel = [VankeCommonModel sharedInstance];
    authorizedOrgs = [userModel getAuthOrgs];
    
    if (authorizedOrgs.count == 0) {
        return;
    } else if (authorizedOrgs.count == 1) {
        AuthorizedOrg *org = [authorizedOrgs objectAtIndex:0];
        [self showStatementList:org];
    } else {
        CGFloat xWidth = self.view.bounds.size.width - 20.0f;
        CGFloat yHeight = authorizedOrgs.count * 60 + 50;
        if (yHeight > 400) {
            yHeight = 400.0f;
        }
        CGFloat yOffset = (self.view.bounds.size.height - yHeight)/2.0f;
        UIPopoverListView *poplistview = [[UIPopoverListView alloc] initWithFrame:CGRectMake(10, yOffset, xWidth, yHeight)];
        poplistview.delegate = self;
        poplistview.datasource = self;
        poplistview.listView.scrollEnabled = YES;
        [poplistview setTitle:@"请选择查看项目"];
        [poplistview show];
    }
}

ON_SIGNAL3(VankeAffairsBoard_iPhone, btnSaleInput, signal) {
    [GEToast showWithText:@"销售录入正在开发中..." bottomOffset:60.0f duration:1.0f];
}

ON_SIGNAL3(VankeAffairsBoard_iPhone, btnServiceApply, signal) {
    [GEToast showWithText:@"服务申请正在开发中..." bottomOffset:60.0f duration:1.0f];
}

#pragma mark - UIPopoverListViewDataSource

- (UITableViewCell *)popoverListView:(UIPopoverListView *)popoverListView
                    cellForIndexPath:(NSIndexPath *)indexPath
{
    static NSString *identifier = @"cell";
    UITableViewCell *cell = [[UITableViewCell alloc] initWithStyle:UITableViewCellStyleDefault
                                                    reuseIdentifier:identifier];
    
    AuthorizedOrg *org = [authorizedOrgs objectAtIndex:indexPath.row];
    cell.textLabel.text = org.name;
    cell.imageView.image = [UIImage imageNamed:org.picture];
    return cell;
}

- (NSInteger)popoverListView:(UIPopoverListView *)popoverListView
       numberOfRowsInSection:(NSInteger)section
{
    return authorizedOrgs.count;
}

#pragma mark - UIPopoverListViewDelegate
- (void)popoverListView:(UIPopoverListView *)popoverListView
     didSelectIndexPath:(NSIndexPath *)indexPath
{
    AuthorizedOrg *org = [authorizedOrgs objectAtIndex:indexPath.row];
    [self showStatementList:org];
}

- (CGFloat)popoverListView:(UIPopoverListView *)popoverListView
   heightForRowAtIndexPath:(NSIndexPath *)indexPath
{
    return 60.0f;
}

-(void) showStatementList: (AuthorizedOrg*) org {
    if (nil == org) {
        ERROR(@"Authorized Org cannot be null.");
        return;
    }
    
    [[VankeAppBoard_iPhone sharedInstance] hideMenu];
    VankeStatementListBoard_iPhone *board = [VankeStatementListBoard_iPhone board];
    board.authorizedOrgUuidEquals = org.code;
    [self.stack pushBoard:board animated:YES];
}


@end
