//
//  VankeStatementBillModel.m
//  vanke
//
//  Created by xiaomi on 15/11/26.
//  Copyright © 2015年 gomore. All rights reserved.
//

#import "VankeStatementConfirmModel.h"
#import "VankeSettlementConfirmAPI.h"

@implementation VankeStatementConfirmModel

-(void) confirm: (NSString*) contract settle: (NSString*) settle {
    [VankeSettlementConfirmAPI cancel];
    
    VankeSettlementConfirmAPI *api = [VankeSettlementConfirmAPI api];
    
    @weakify(api);
    @weakify(self);
    
    api.contract = contract;
    api.settle = settle;
    
    // 清空结果
    self.serverResp = nil;
    
    api.whenSending = ^{
        [self sendUISignal:self.RELOADING];
    };
    api.whenSucceed = ^{
        @normalize(api);
        @normalize(self);
        
        if (api.succeed) {
            if (nil == api.serverResp) {
                api.failed = YES;
            } else {
                self.serverResp = api.serverResp;
            }
        }
        [self sendUISignal:self.RELOADED];
    };
    api.whenFailed = ^{
        @normalize(api);
        @normalize(self);
        
        self.serverResp = [VankeResponse initWith:NO message:nil == api.errorDesc? @"网络异常": api.errorDesc];
        [self sendUISignal:self.RELOADED];
    };
    [api send];
}

@end
