//
//  VankeSettlementSubjectListAPI.m
//  vanke
//
//  Created by xiaomi on 15/10/8.
//  Copyright © 2015年 gomore. All rights reserved.
//

#import "VankeSettlementSubjectListAPI.h"
#import "VankeConfig.h"
#import "VankeUtil.h"

@implementation VankeSettlementSubjectListAPI

@synthesize settle = _settle;
@synthesize contract = _contract;

-(void) route:(BeeMessage *)msg {
    if (self.sending)
    {
        if (![self checkToQuery]) {
            return;
        }
        
        [self http_get:@"/statement"].PARAM(@"settle", [self getSettleStr]).PARAM(@"contract", self.contract).TIMEOUT(10);
    }
    else if (self.succeed)
    {
        NSLog(@"response: %@", self.responseString);
        
        StatementSubjectListResponse *resp = [StatementSubjectListResponse objectFromDictionary: self.responseJSONDictionary];
     
        self.serverResp = resp;
        if (nil == self.serverResp)
        {
            self.failed = YES;
            return;
        }
    } else if (self.failed) {
        NSLog(@"response: %@", self.responseString);
        self.serverResp = [StatementSubjectListResponse objectFromDictionary: self.responseJSONDictionary];
    }
}

-(BOOL) checkToQuery {
    if (nil == _settle) {
        [self setClientError: @"账期不能为空"];
        return NO;
    }
    
    if ([VankeUtil isBlankString:_contract]) {
        [self setClientError: @"合同号不能为空"];
        return NO;
    }
    
    return YES;
}

-(NSString*) getSettleStr {
    if (nil == _settle) {
        return @"";
    }
    
    NSDateFormatter *dateFormatter = [[NSDateFormatter alloc] init];
    [dateFormatter setDateFormat:@"yyyyMM"];
    return [dateFormatter stringFromDate:_settle];
}

@end

#pragma SubjectItem

@implementation SubjectItem
@synthesize subject = _subject;
@synthesize beginDate = _beginDate;
@synthesize endDate = _endDate;
@synthesize direction = _direction;
@synthesize amount = _amount;
@synthesize remark = _remark;
@end

#pragma StatementSubjectListResponseData

@implementation StatementSubjectListResponseData
@synthesize contract = _contract;
@synthesize shopCode = _shopCode;
@synthesize shopName = _shopName;
@synthesize picture = _picture;
@synthesize settle = _settle;
@synthesize amount = _amount;
@synthesize state = _state;
@synthesize items = _items;

CONVERT_PROPERTY_CLASS(items, SubjectItem)

-(NSString*) getPictureUrlOrDefault {
    if ([VankeUtil isBlankString:self.picture]) {
        return @"bill_default_image.png";
    } else {
        return [NSString stringWithFormat:@"%@/%@", VANKE_SERVER_MEDIA_BASE_URL, self.picture];
    }
}

-(NSString*) codeName {
    return [NSString stringWithFormat:@"%@ %@", _shopCode, _shopName];
}

-(BOOL) unconfirmed {
    return [_state eq: @"unconfirmed"];
}


@end

#pragma StatementSubjectListResponse

@implementation StatementSubjectListResponse

@synthesize data = _data;

@end



