//
//  VankeSaleVolumeAPI.m
//  vanke
//
//  Created by xiaomi on 15/10/9.
//  Copyright © 2015年 gomore. All rights reserved.
//

#import "VankeSaleVolumeAPI.h"
#import "VankeUtil.h"
#import "PNChart.h"

#pragma VankeSaleVolumeAPI

@implementation VankeSaleVolumeAPI

@synthesize projectEquals;
@synthesize salesDateEquals;


-(void) route:(BeeMessage *)msg {
    if (self.sending)
    {
        if (![self checkToQuery]) {
            return;
        }
        
        [self http_get:@"/sales/querysales"].PARAM(@"salesDateEquals", self.salesDateEquals).PARAM(@"projectEquals", self.projectEquals).TIMEOUT(10);
    }
    else if (self.succeed)
    {
        NSLog(@"response: %@", self.responseString);
        
        self.serverResp = [ProjectSaleVolumeResponse objectFromDictionary: self.responseJSONDictionary];
        if ( nil == self.serverResp )
        {
            self.failed = YES;
            return;
        }
    }
}

-(BOOL) checkToQuery {
    if ([VankeUtil isBlankString:self.projectEquals]) {
        [self setClientError: @"项目标识不能为空"];
        return NO;
    }
    
    if ([VankeUtil isBlankString:self.salesDateEquals]) {
        [self setClientError: @"销售日期不能为空"];
        return NO;
    }
    
    return YES;
}

@end


#pragma ProjectSaleVolume

@implementation ProjectSaleVolume

@synthesize projectId;
@synthesize projectName;
@synthesize dimensionType;
@synthesize dimensionValue;
@synthesize amount;
@synthesize salesDate;

@end

#pragma ProjectSaleVolumeResponse


@implementation ProjectSaleVolumeResponse

CONVERT_PROPERTY_CLASS(data, ProjectSaleVolume)

@synthesize data = _data;

// 按维度分类的数据字典
NSMutableDictionary *dimValues;

-(void) initDimensionValues {
    dimValues = [[NSMutableDictionary alloc] init];
    if (nil == _data) {
        return;
    }
    
    for (ProjectSaleVolume* obj in _data) {
        if (nil == [dimValues objectForKey:obj.dimensionType]) {
            NSMutableArray *ary = [[NSMutableArray alloc] init];
            [dimValues setObject:ary forKey:obj.dimensionType];
        }
        
        NSMutableArray *ary = [dimValues objectForKey:obj.dimensionType];
        [ary addObject:obj];
    }
}


-(void) setData:(NSArray *)data {
    _data = data;
    [self initDimensionValues];
}

-(NSArray*) getSortedDimensions {
    id mySort = ^(NSString * a, NSString * b){
        return [a compare:b];
    };
    NSArray *keys = [dimValues allKeys];
    return [keys sortedArrayUsingComparator:mySort];
}

-(NSArray*) getSalesInfo: (NSString*) dimension {
    id mySort = ^(ProjectSaleVolume * a, ProjectSaleVolume * b){
        return [a.dimensionValue compare:b.dimensionValue];
    };
    return [[dimValues objectForKey:dimension] sortedArrayUsingComparator:mySort];
}

-(NSNumber*) getSalesTotalAmount: (NSString*) dimension {
    double total = 0;
    NSArray *ary = [dimValues objectForKey:dimension];
    if (nil != ary) {
        for (ProjectSaleVolume* obj in ary) {
            total += [obj.amount doubleValue];
        }
    }
    return [[NSNumber alloc] initWithDouble:total];
}

-(NSArray*) getChartValues: (NSString*) dimension {
    NSMutableArray *items = [[NSMutableArray alloc] init];
    
    NSArray *ary = [self getSalesInfo:dimension];
    if (nil == ary) {
        return items;
    }
    
    for (NSInteger i = 0; i < [ary count]; ++i) {
        ProjectSaleVolume *obj = [ary objectAtIndex:i];
        PNPieChartDataItem *item = [PNPieChartDataItem new];
        item.value = [obj.amount floatValue];
        item.textDescription = obj.dimensionValue;
        [items addObject: item];
    }
    return items;
}

@end



