//
//  StatementTableViewCell.m
//  RealEstateManagement
//
//  Created by Z on 16/6/29.
//  Copyright © 2016年 上海勾芒信息科技. All rights reserved.
//

#import "StatementTableViewCell.h"

@interface StatementTableViewCell ()
@property (weak, nonatomic) IBOutlet UIView *imgShop;
@property (weak, nonatomic) IBOutlet UILabel *labelTitle;
/** 应缴 */
@property (weak, nonatomic) IBOutlet UILabel *labelShouldPay;
/** 已缴 */
@property (weak, nonatomic) IBOutlet UILabel *labelPaidIn;
/** 未缴 */
@property (weak, nonatomic) IBOutlet UILabel *labelUnPaid;

@end
@implementation StatementTableViewCell

- (void)awakeFromNib {
    // Initialization code
}

- (void)setUpCellWithArray:(NSArray *)array index:(NSIndexPath *)indexPath {
    StatementRecords *model = array[indexPath.row];
    self.labelTitle.text = [NSString stringWithFormat:@"%@ %@",model.shopCode, model.shopName];
    self.labelShouldPay.text =  [NSString stringWithFormat:@"%.2f",model.amount];
    self.labelPaidIn.text = [NSString stringWithFormat:@"[已缴]%.2f",model.paid];
    self.labelUnPaid.text = [NSString stringWithFormat:@"[未缴]%.2f",model.unpaid];
    
}
- (void)setSelected:(BOOL)selected animated:(BOOL)animated {
    [super setSelected:selected animated:animated];

    // Configure the view for the selected state
}

@end
