//
//  StatementDetailCell.m
//  RealEstateManagement
//
//  Created by Z on 16/6/29.
//  Copyright © 2016年 上海勾芒信息科技. All rights reserved.
//

#import "StatementDetailCell.h"
#import "StatementDetailItems.h"
@interface StatementDetailCell ()
/** 标题 */
@property (weak, nonatomic) IBOutlet UILabel *labelTitle;
/** 时间 */
@property (weak, nonatomic) IBOutlet UILabel *labelDate;

/** 应缴 */
@property (weak, nonatomic) IBOutlet UILabel *labelShouldPay;
/** 已缴 */
@property (weak, nonatomic) IBOutlet UILabel *labelPaidIn;
/** 未缴 */
@property (weak, nonatomic) IBOutlet UILabel *labelUnPaid;
@property (weak, nonatomic) IBOutlet UIImageView *img;

@end
@implementation StatementDetailCell

- (void)awakeFromNib {
    // Initialization code
}

- (void)setUpCellWithModelArray:(NSArray *)array index:(NSIndexPath *)indexPath {
    StatementDetailItems *item = array[indexPath.row];
    self.labelTitle.text = item.subject;
    self.labelDate.text = [NSString stringWithFormat:@"%@~%@",item.beginDate,item.endDate];
    self.labelShouldPay.text = [NSString stringWithFormat:@"%.2f",item.amount];
    self.labelPaidIn.text = [NSString stringWithFormat:@"[已缴]%.2f",item.paid];
    self.labelUnPaid.text = [NSString stringWithFormat:@"[未缴]%.2f",item.unpaid];
    if (item.direction < 0) {
        self.img.image = [UIImage imageNamed:@"money_reduce"];
    }else{
        self.img.image = [UIImage imageNamed:@"money_add"];
    }
}

- (void)setSelected:(BOOL)selected animated:(BOOL)animated {
    [super setSelected:selected animated:animated];

    // Configure the view for the selected state
}

@end
