//
//  StatementDetailViewController.m
//  RealEstateManagement
//
//  Created by Z on 16/6/29.
//  Copyright © 2016年 上海勾芒信息科技. All rights reserved.
//

#import "StatementDetailViewController.h"
#import "StatementDetailCell.h"
#import "StatementDetailModel.h"
#import "SRMonthPicker.h"
#import "UIScrollView+EmptyDataSet.h"
#import "CalculateHelper.h"
@interface StatementDetailViewController ()<UITableViewDelegate, UITableViewDataSource,SRMonthPickerDelegate, UITextFieldDelegate, DZNEmptyDataSetDelegate, DZNEmptyDataSetSource>
@property (weak, nonatomic) IBOutlet UITableView *tableView;
@property (nonatomic, strong) StatementDetailModel *detailModel;
/** 应缴 */
@property (weak, nonatomic) IBOutlet UILabel *labelShoudPay;
/** 已缴 */
@property (weak, nonatomic) IBOutlet UILabel *labelPaid;
/** 未缴 */
@property (weak, nonatomic) IBOutlet UILabel *labelUnpaid;
/** year start */
@property (weak, nonatomic) IBOutlet UILabel *labelYearStart;
/** month start */
@property (weak, nonatomic) IBOutlet UILabel *labelMonthStart;
/** year start */
@property (weak, nonatomic) IBOutlet UILabel *labelYearEnd;
/** month end */
@property (weak, nonatomic) IBOutlet UILabel *labelMontEnd;
/** textfield start */
@property (weak, nonatomic) IBOutlet UITextField *textFieldStart;
/** textfield end */
@property (weak, nonatomic) IBOutlet UITextField *textFieldEnd;
/** 缴款率 */
@property (weak, nonatomic) IBOutlet UILabel *labelPaidRate;


@end

@implementation StatementDetailViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    self.title = self.record.shopName;
    NSDate *selectStart = [self getDateFromString:self.startDate];
    NSDate *selectEnd = [self getDateFromString:self.endDate];
    [self setStart:selectStart];
    [self setEnd:selectEnd];
    self.textFieldStart.delegate = self;
    self.textFieldEnd.delegate = self;
    self.tableView.emptyDataSetSource = self;
    self.tableView.emptyDataSetDelegate = self;
    self.tableView.tableFooterView = [UIView new];
    [self setUpDatePicker];
    [self setUpData];
}


/** 设置开始时间 */
- (void)setStart:(NSDate *)date {
    self.labelYearStart.text = date.yearString;
    self.labelMonthStart.text = date.monthString;
}

/** 设置结束时间 */
- (void)setEnd:(NSDate *)date {
    self.labelYearEnd.text = date.yearString;
    self.labelMontEnd.text = date.monthString;
}

- (void)setUpDatePicker {
    SRMonthPicker *datePicker = [[SRMonthPicker alloc] initWithDate:[NSDate date]];
    datePicker.monthPickerDelegate = self;
    datePicker.yearFirst = YES;
    self.textFieldStart.inputView = datePicker;
    self.textFieldEnd.inputView = datePicker;
}

#pragma mark - SRMonthPickerDelegate
- (void)monthPickerDidChangeDate:(SRMonthPicker *)monthPicker {
    NSString *strDate = [monthPicker.date stringWithFormatter:@"%Y%m"];
    NSString *year = monthPicker.date.yearString;
    NSString *month = monthPicker.date.monthString;
    //判断是开始时间还是结束时间
    if ([self.textFieldStart isFirstResponder]) {
        self.startDate = strDate;
        self.labelYearStart.text = year;
        self.labelMonthStart.text = month;
    }else{
        self.endDate = strDate;
        self.labelYearEnd.text = year;
        self.labelMontEnd.text = month;
    }
}

- (void)setUpData {
    MBProgressHUD *hud = [MBProgressHUD showHUDAddedTo:self.view animated:YES];

    NSString *url = [NSString stringWithFormat:@"statement?contract=%@&beginSettle=%@&endSettle=%@",self.record.contract,self.startDate, self.endDate];
    WS(weakSelf);
    [[ICRHTTPController sharedController] getUrl:url params:nil success:^(id data) {
        NSDictionary *dic = data;
        weakSelf.detailModel = [StatementDetailModel modelObjectWithDictionary:dic[@"data"]];
        
        weakSelf.labelShoudPay.text = [NSString stringWithFormat:@"%.2f", weakSelf.detailModel.amount];
        weakSelf.labelPaid.text = [NSString stringWithFormat:@"%.2f",weakSelf.detailModel.paid];
        weakSelf.labelUnpaid.text = [NSString stringWithFormat:@"%.2f",weakSelf.detailModel.unpaid];
        
        //缴款率
        NSString *paidRate = [CalculateHelper getPercent:[NSNumber numberWithDouble:weakSelf.detailModel.paid] num:[NSNumber numberWithDouble:weakSelf.detailModel.amount]];
        weakSelf.labelPaidRate.text = paidRate;
        [weakSelf.tableView reloadData];
        [hud hide:YES];
        CLog(@"%@", dic.JSONString);
    } failure:^(id data) {
        
    }];
}


#pragma mark - tableView DataSource
- (CGFloat)tableView:(UITableView *)tableView estimatedHeightForRowAtIndexPath:(NSIndexPath *)indexPath {
    return 60;
}

- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section {
    return self.detailModel.items.count;
}

- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath {
    StatementDetailCell *cell = [tableView dequeueReusableCellWithIdentifier:@"StatementDetailCell" forIndexPath:indexPath];
    [cell setUpCellWithModelArray:self.detailModel.items index:indexPath];
    return cell;
}

- (NSDate *)getDateFromString:(NSString *)string {
    NSDateFormatter *f = [[NSDateFormatter alloc] init];
    [f setDateFormat:@"yyyyMM"];
    return [f dateFromString:string];
}

#pragma mark - empty state
- (UIImage *)imageForEmptyDataSet:(UIScrollView *)scrollView {
    return [UIImage imageNamed:@"no_data"];
}

- (CAAnimation *)imageAnimationForEmptyDataSet:(UIScrollView *)scrollView {
    CABasicAnimation *animation = [CABasicAnimation animationWithKeyPath: @"transform"];
    
    animation.fromValue = [NSValue valueWithCATransform3D:CATransform3DIdentity];
    animation.toValue = [NSValue valueWithCATransform3D:CATransform3DMakeRotation(M_PI_2, 0.0, 0.0, 1.0)];
    
    animation.duration = 0.25;
    animation.cumulative = YES;
    animation.repeatCount = MAXFLOAT;
    
    return animation;
}

- (CGFloat)verticalOffsetForEmptyDataSet:(UIScrollView *)scrollView {
    return -100;
}

#pragma mark - textfield delegate
- (void)textFieldDidEndEditing:(UITextField *)textField {
    [self setUpData];
}

- (void)didReceiveMemoryWarning {
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}

/*
#pragma mark - Navigation

// In a storyboard-based application, you will often want to do a little preparation before navigation
- (void)prepareForSegue:(UIStoryboardSegue *)segue sender:(id)sender {
    // Get the new view controller using [segue destinationViewController].
    // Pass the selected object to the new view controller.
}
*/

@end
