//
//  StatementListParamModel.m
//
//  Created by 杰 张 on 16/6/29
//  Copyright (c) 2016 __MyCompanyName__. All rights reserved.
//

#import "StatementListParamModel.h"


NSString *const kStatementListParamModelPageSize = @"pageSize";
NSString *const kStatementListParamModelShopLike = @"shopLike";
NSString *const kStatementListParamModelPageNumber = @"pageNumber";
NSString *const kStatementListParamModelTenantEquals = @"tenantEquals";
NSString *const kStatementListParamModelAuthorizedOrgIn = @"authorizedOrgIn";
NSString *const kStatementListParamModelSettleEquals = @"settleEquals";
NSString *const kStatementListParamModelState = @"state";


@interface StatementListParamModel ()

- (id)objectOrNilForKey:(id)aKey fromDictionary:(NSDictionary *)dict;

@end

@implementation StatementListParamModel

@synthesize pageSize = _pageSize;
@synthesize shopLike = _shopLike;
@synthesize pageNumber = _pageNumber;
@synthesize tenantEquals = _tenantEquals;
@synthesize authorizedOrgIn = _authorizedOrgIn;
@synthesize settleEquals = _settleEquals;
@synthesize state = _state;


+ (instancetype)modelObjectWithDictionary:(NSDictionary *)dict
{
    return [[self alloc] initWithDictionary:dict];
}

- (instancetype)initWithDictionary:(NSDictionary *)dict
{
    self = [super init];
    
    // This check serves to make sure that a non-NSDictionary object
    // passed into the model class doesn't break the parsing.
    if(self && [dict isKindOfClass:[NSDictionary class]]) {
            self.pageSize = [[self objectOrNilForKey:kStatementListParamModelPageSize fromDictionary:dict] doubleValue];
            self.shopLike = [self objectOrNilForKey:kStatementListParamModelShopLike fromDictionary:dict];
            self.pageNumber = [[self objectOrNilForKey:kStatementListParamModelPageNumber fromDictionary:dict] doubleValue];
            self.tenantEquals = [self objectOrNilForKey:kStatementListParamModelTenantEquals fromDictionary:dict];
            self.authorizedOrgIn = [self objectOrNilForKey:kStatementListParamModelAuthorizedOrgIn fromDictionary:dict];
            self.settleEquals = [self objectOrNilForKey:kStatementListParamModelSettleEquals fromDictionary:dict];
            self.state = [self objectOrNilForKey:kStatementListParamModelState fromDictionary:dict];

    }
    
    return self;
    
}

- (NSDictionary *)dictionaryRepresentation
{
    NSMutableDictionary *mutableDict = [NSMutableDictionary dictionary];
    NSNumber *num = [NSNumber numberWithInt:self.pageSize];
    [mutableDict setValue:num forKey:kStatementListParamModelPageSize];
    [mutableDict setValue:self.shopLike forKey:kStatementListParamModelShopLike];
    [mutableDict setValue:[NSNumber numberWithInt:self.pageNumber] forKey:kStatementListParamModelPageNumber];
    [mutableDict setValue:self.tenantEquals forKey:kStatementListParamModelTenantEquals];
    NSMutableArray *tempArrayForAuthorizedOrgIn = [NSMutableArray array];
    for (NSObject *subArrayObject in self.authorizedOrgIn) {
        if([subArrayObject respondsToSelector:@selector(dictionaryRepresentation)]) {
            // This class is a model object
            [tempArrayForAuthorizedOrgIn addObject:[subArrayObject performSelector:@selector(dictionaryRepresentation)]];
        } else {
            // Generic object
            [tempArrayForAuthorizedOrgIn addObject:subArrayObject];
        }
    }
    [mutableDict setValue:[NSArray arrayWithArray:tempArrayForAuthorizedOrgIn] forKey:kStatementListParamModelAuthorizedOrgIn];
    [mutableDict setValue:self.settleEquals forKey:kStatementListParamModelSettleEquals];
    [mutableDict setValue:self.state forKey:kStatementListParamModelState];

    return [NSDictionary dictionaryWithDictionary:mutableDict];
}

- (NSString *)description 
{
    return [NSString stringWithFormat:@"%@", [self dictionaryRepresentation]];
}

#pragma mark - Helper Method
- (id)objectOrNilForKey:(id)aKey fromDictionary:(NSDictionary *)dict
{
    id object = [dict objectForKey:aKey];
    return [object isEqual:[NSNull null]] ? nil : object;
}


#pragma mark - NSCoding Methods

- (id)initWithCoder:(NSCoder *)aDecoder
{
    self = [super init];

    self.pageSize = [aDecoder decodeDoubleForKey:kStatementListParamModelPageSize];
    self.shopLike = [aDecoder decodeObjectForKey:kStatementListParamModelShopLike];
    self.pageNumber = [aDecoder decodeDoubleForKey:kStatementListParamModelPageNumber];
    self.tenantEquals = [aDecoder decodeObjectForKey:kStatementListParamModelTenantEquals];
    self.authorizedOrgIn = [aDecoder decodeObjectForKey:kStatementListParamModelAuthorizedOrgIn];
    self.settleEquals = [aDecoder decodeObjectForKey:kStatementListParamModelSettleEquals];
    self.state = [aDecoder decodeObjectForKey:kStatementListParamModelState];
    return self;
}

- (void)encodeWithCoder:(NSCoder *)aCoder
{

    [aCoder encodeDouble:_pageSize forKey:kStatementListParamModelPageSize];
    [aCoder encodeObject:_shopLike forKey:kStatementListParamModelShopLike];
    [aCoder encodeDouble:_pageNumber forKey:kStatementListParamModelPageNumber];
    [aCoder encodeObject:_tenantEquals forKey:kStatementListParamModelTenantEquals];
    [aCoder encodeObject:_authorizedOrgIn forKey:kStatementListParamModelAuthorizedOrgIn];
    [aCoder encodeObject:_settleEquals forKey:kStatementListParamModelSettleEquals];
    [aCoder encodeObject:_state forKey:kStatementListParamModelState];
}

- (id)copyWithZone:(NSZone *)zone
{
    StatementListParamModel *copy = [[StatementListParamModel alloc] init];
    
    if (copy) {

        copy.pageSize = self.pageSize;
        copy.shopLike = [self.shopLike copyWithZone:zone];
        copy.pageNumber = self.pageNumber;
        copy.tenantEquals = [self.tenantEquals copyWithZone:zone];
        copy.authorizedOrgIn = [self.authorizedOrgIn copyWithZone:zone];
        copy.settleEquals = [self.settleEquals copyWithZone:zone];
        copy.state = [self.state copyWithZone:zone];
    }
    
    return copy;
}


@end
