//
//  SaleInputPictureTableViewCell.m
//  RealEstateManagement
//
//  Created by Z on 16/6/28.
//  Copyright © 2016年 上海勾芒信息科技. All rights reserved.
//

#import "SaleInputPictureTableViewCell.h"

@interface SaleInputPictureTableViewCell ()
@property (nonatomic, strong) NSMutableArray *arrPictures;
@end
@implementation SaleInputPictureTableViewCell

- (void)awakeFromNib {
    self.btnLeft.imageView.contentMode = UIViewContentModeScaleAspectFill;
    self.btnRight.imageView.contentMode = UIViewContentModeScaleAspectFill;
    self.selectionStyle = UITableViewCellSelectionStyleNone;
    // Initialization code
}

- (void)setUpCellWithPictureArr:(NSArray *)arrPic indexPath:(NSIndexPath *)indexPath {
    self.arrPictures = arrPic;
    [self.btnLeft setImage:arrPic[indexPath.row * 2] forState:UIControlStateNormal];
    self.btnLeft.tag = indexPath.row * 2;
    self.btnRight.hidden = YES;
    if (indexPath.row * 2 + 1 <= arrPic.count - 1) {
        [self.btnRight setImage:arrPic[indexPath.row * 2 + 1] forState:UIControlStateNormal];
        self.btnRight.tag = indexPath.row * 2 + 1;
        self.btnRight.hidden = NO;
    }
    
    [self.btnLeft addTarget:self action:@selector(actionPic:) forControlEvents:UIControlEventTouchUpInside];
    [self.btnRight addTarget:self action:@selector(actionPic:) forControlEvents:UIControlEventTouchUpInside];

}

- (void)actionPic:(UIButton *)btn {
//    CLog(@"%ld", btn.tag);
    if (btn.tag == self.arrPictures.count - 1) {
        self.addPicBlock(0);
    }else{
        self.seePicBlock(btn.tag);
    }
}

- (void)setSelected:(BOOL)selected animated:(BOOL)animated {
    [super setSelected:selected animated:animated];

    // Configure the view for the selected state
}

@end
