//
//  GalleryCollectionViewCell.m
//  CapitalChamberlain
//
//  Created by 张杰 on 15/12/3.
//  Copyright © 2015年 SunShine. All rights reserved.
//

#import "GalleryCollectionViewCell.h"

@interface GalleryCollectionViewCell ()
@property (nonatomic, strong) SingleScrollView *imageScrollView;
@end
@implementation GalleryCollectionViewCell

- (void)awakeFromNib {
    CLog(@"%f",self.width);
    self.imageScrollView = [[SingleScrollView alloc] initWithFrame:CGRectMake(0, 0, SCREEN_WIDTH, SCREEN_HEIGHT)];
    self.backgroundColor = [UIColor blackColor];
    [self.contentView addSubview:self.imageScrollView];
}

- (void)setUpCellWithModel:(AttachmentModel *)model {
    NSString *imageUrl;
    if (model.fileUrl.length < 3) {
        imageUrl = @"floor-def";
    }else{
        imageUrl = [NSString stringWithFormat:@"%@%@",VANKE_SERVER_MEDIA_BASE_URL, model.fileUrl];
    }
    [self cellWithImgName:imageUrl];
}

- (void)cellWithImgName:(NSString *)imgUrl {
    [self.imageScrollView setImage:imgUrl placeHolder:[UIImage imageNamed:@"no_picture"]];
}

@end
