//
//  SaleInputPicCollectionViewController.m
//  vanke
//
//  Created by Z on 16/7/17.
//  Copyright © 2016年 gomore. All rights reserved.
//

#import "SaleInputPicCollectionViewController.h"
#import "SaleInputPicCollectionViewCell.h"
#import "ICRHTTPController.h"
#import "AttachmentModel.h"
#import "GalleryViewController.h"
#import "UIScrollView+EmptyDataSet.h"
@interface SaleInputPicCollectionViewController ()<DZNEmptyDataSetSource, DZNEmptyDataSetDelegate>
@property (weak, nonatomic) IBOutlet UICollectionViewFlowLayout *flowLayout;

@end

@implementation SaleInputPicCollectionViewController

static NSString * const reuseIdentifier = @"saleInputCollection";

- (void)viewDidLoad {
    [super viewDidLoad];
    self.flowLayout.itemSize = CGSizeMake((SCREEN_WIDTH - 20) / 3, 110.0 / 375 * SCREEN_WIDTH);
    self.flowLayout.minimumLineSpacing = 5;
    self.flowLayout.minimumInteritemSpacing = 5;
    self.collectionView.emptyDataSetSource = self;
    self.collectionView.emptyDataSetDelegate = self;
    [self setUpData];
}

#pragma mark - empty state
- (UIImage *)imageForEmptyDataSet:(UIScrollView *)scrollView {
    return [UIImage imageNamed:@"no_data"];
}

- (CAAnimation *)imageAnimationForEmptyDataSet:(UIScrollView *)scrollView {
    CABasicAnimation *animation = [CABasicAnimation animationWithKeyPath: @"transform"];
    
    animation.fromValue = [NSValue valueWithCATransform3D:CATransform3DIdentity];
    animation.toValue = [NSValue valueWithCATransform3D:CATransform3DMakeRotation(M_PI_2, 0.0, 0.0, 1.0)];
    
    animation.duration = 1;
    animation.cumulative = YES;
    animation.repeatCount = MAXFLOAT;
    
    return animation;
}


- (void)setUpData {
    NSString *url = [NSString stringWithFormat:@"attachment/get_urls?entity_type=salesInput&entity_uuid=%@", [self.attachmentUuid isKindOfClass:[NSString class]] ? self.attachmentUuid : nil];
    
    __weak typeof(self)weakSelf = self;
    [[ICRHTTPController sharedController] getUrl:url params:nil success:^(id data) {
        NSDictionary *dic = data;
        CLog(@"%@", dic.JSONString);
        for (NSDictionary *dict in data[@"data"]) {
            AttachmentModel *model = [[AttachmentModel alloc] init];
            [model setValuesForKeysWithDictionary:dict];
            [weakSelf.dataArr addObject:model];
        }
        [weakSelf.collectionView reloadData];
    } failure:^(id data) {
        
    }];
    
}

- (NSMutableArray *)dataArr {
    if (!_dataArr) {
        _dataArr = [NSMutableArray array];
    }
    return _dataArr;
}
- (void)didReceiveMemoryWarning {
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}
#pragma mark <UICollectionViewDataSource>

- (NSInteger)numberOfSectionsInCollectionView:(UICollectionView *)collectionView {
    return 1;
}


- (NSInteger)collectionView:(UICollectionView *)collectionView numberOfItemsInSection:(NSInteger)section {
    return self.dataArr.count;
}

- (UICollectionViewCell *)collectionView:(UICollectionView *)collectionView cellForItemAtIndexPath:(NSIndexPath *)indexPath {
    SaleInputPicCollectionViewCell *cell = [collectionView dequeueReusableCellWithReuseIdentifier:reuseIdentifier forIndexPath:indexPath];
    [cell setCellWith:self.dataArr index:indexPath];
    // Configure the cell
    
    return cell;
}

- (void)collectionView:(UICollectionView *)collectionView didSelectItemAtIndexPath:(NSIndexPath *)indexPath {
    UIStoryboard *storyBoard = [UIStoryboard storyboardWithName:@"SalesInPut" bundle:nil];
    GalleryViewController *seePicVC = [storyBoard instantiateViewControllerWithIdentifier:@"GalleryViewController"];
    seePicVC.arrData = self.dataArr;
    seePicVC.page = indexPath.row;
    [self.navigationController pushViewController:seePicVC animated:YES];
}


/*
 #pragma mark - Navigation
 
 // In a storyboard-based application, you will often want to do a little preparation before navigation
 - (void)prepareForSegue:(UIStoryboardSegue *)segue sender:(id)sender {
 // Get the new view controller using [segue destinationViewController].
 // Pass the selected object to the new view controller.
 }
 */



#pragma mark <UICollectionViewDelegate>

/*
// Uncomment this method to specify if the specified item should be highlighted during tracking
- (BOOL)collectionView:(UICollectionView *)collectionView shouldHighlightItemAtIndexPath:(NSIndexPath *)indexPath {
	return YES;
}
*/

/*
// Uncomment this method to specify if the specified item should be selected
- (BOOL)collectionView:(UICollectionView *)collectionView shouldSelectItemAtIndexPath:(NSIndexPath *)indexPath {
    return YES;
}
*/

/*
// Uncomment these methods to specify if an action menu should be displayed for the specified item, and react to actions performed on the item
- (BOOL)collectionView:(UICollectionView *)collectionView shouldShowMenuForItemAtIndexPath:(NSIndexPath *)indexPath {
	return NO;
}

- (BOOL)collectionView:(UICollectionView *)collectionView canPerformAction:(SEL)action forItemAtIndexPath:(NSIndexPath *)indexPath withSender:(id)sender {
	return NO;
}

- (void)collectionView:(UICollectionView *)collectionView performAction:(SEL)action forItemAtIndexPath:(NSIndexPath *)indexPath withSender:(id)sender {
	
}
*/

@end
