//
//  SaleHeaderView.m
//  XFFruit
//
//  Created by 陈俊俊 on 15/11/8.
//  Copyright © 2015年 Xummer. All rights reserved.
//

#import "SaleHeaderView.h"

#define Sale_Header_Height 35

@interface SaleHeaderView ()
{
    BOOL    hasBuildLayout;         // default, NO;
}

@property (nonatomic, strong) UILabel *label;
@property (nonatomic, strong) UIFont *textFont;
@property (nonatomic, strong) UILabel *bszLabel;

@end


@implementation SaleHeaderView


+ (CGFloat)viewHeight
{
    return Sale_Header_Height;
}

- (void)buildLayout
{
    if(hasBuildLayout) {
        return;
    }
    
    if(self.textFont == nil) {
        self.textFont = [UIFont systemFontOfSize:13];
    }
    
    hasBuildLayout = YES;
    self.contentView.backgroundColor = [UIColor colorWithWhite:0.965 alpha:1.000];
    CGRect rect = CGRectMake(0, 0, SCREEN_WIDTH, 1);
    UILabel *lineLabel = [[UILabel alloc]initWithFrame:rect];
    lineLabel.backgroundColor = GXF_LINE_COLOR;
    [self.contentView addSubview:lineLabel];
    
    
    //右侧共几家 jv
    rect = CGRectMake(10, 0, 115, Sale_Header_Height);
    UILabel *searLabel = [IBTCommon labelWithTitle:@"共280家" frame:rect textFont:self.textFont];
    searLabel.textColor = ReportTitleColor;
    [self.contentView addSubview:searLabel];
    searLabel.alpha = 0;
    self.totalLabel = searLabel;
    
    CGFloat width = (SCREEN_WIDTH  - searLabel.right - 4)/4;

    rect = CGRectMake(searLabel.right, 0, width + 15, Sale_Header_Height);
    UILabel * xsBtn = [IBTCommon labelWithTitle:@"销售额" frame:rect textFont:self.textFont];
    xsBtn.textColor = ReportTitleColor;
    [self.contentView addSubview:xsBtn];
    
    rect = CGRectMake(xsBtn.right , 0, width, Sale_Header_Height);
    UILabel * bszLabel = [IBTCommon labelWithTitle:@"比上周" frame:rect textFont:self.textFont];
    bszLabel.textAlignment = NSTextAlignmentCenter;
    bszLabel.textColor = ReportTitleColor;
    [self.contentView addSubview:bszLabel];
    self.bszLabel = bszLabel;
    
    rect = CGRectMake(bszLabel.right , 0, width, Sale_Header_Height);
    UILabel * sclLabel = [IBTCommon labelWithTitle:@"坪效" frame:rect textFont:self.textFont];
    sclLabel.textColor = ReportTitleColor;
    sclLabel.textAlignment = NSTextAlignmentCenter;
    [self.contentView addSubview:sclLabel];
    
    //日均销售
    UILabel *dailySale = [IBTCommon labelWithTitle:@"日均销售" frame:CGRectMake(sclLabel.right, 0, width + 10, Sale_Header_Height) textFont:self.textFont];
    dailySale.textColor = ReportTitleColor;
//    dailySale.backgroundColor = [UIColor redColor];
    [self.contentView addSubview:dailySale];
    
    rect = CGRectMake(0, Sale_Header_Height-1, SCREEN_WIDTH, 1);
    UILabel *lineTLabel = [[UILabel alloc]initWithFrame:rect];
    lineTLabel.backgroundColor = GXF_LINE_COLOR;
    [self.contentView addSubview:lineTLabel];
   
}
- (void)changeTypeName:(NSString *)name{
    NSString *typeStr = @"";
    if ([name isEqualToString:SaleEnMonth]) {
        typeStr = LastMonth;
    }else{
        typeStr = LastWeak;
    }
    self.bszLabel.text = typeStr;
}
@end
