//
//  ICRAttachmentCellContentView.m
//  Cruiser
//
//  Created by Lili Wang on 15/4/15.
//  Copyright (c) 2015年 Xummer. All rights reserved.
//

#define LABEL_LEFT_PANDING      (15)
#define LABEL_HEIGHT            (11)
#define LABEL_WIDTH             (0)
#define TITLE_LABEL_WIDTH       (180)
#define BUTTON_HEIGHT           (20)
#define BUTTON_WIDTH            (50)
#define NAME_LABEL_LEFT_PANDING (20)
#define BUTTON_LEFT_PANDING     (25)

#import "ICRAttachmentCellContentView.h"
#import "ICRAttachment.h"
#import "UIImage+Helper.h"

@interface ICRAttachmentCellContentView ()

@property (strong, nonatomic) UILabel  *m_attIdLabel;
@property (strong, nonatomic) UILabel  *m_attNameLabel;
@property (strong, nonatomic) UIView   *view;

@end

@implementation ICRAttachmentCellContentView

- (id)initWithFrame:(CGRect)frame {
    self = [super initWithFrame:frame];
    if (self) {
        [self _init];
    }
    return self;
}

- (void)layoutSubviews {
    
    _m_attIdLabel.frame = (CGRect){
       .origin.x = LABEL_LEFT_PANDING,
        .origin.y = (self.height - LABEL_HEIGHT)/2,
        .size.width = LABEL_WIDTH,
        .size.height = LABEL_HEIGHT
    };
    
    _m_attNameLabel.frame = (CGRect){
        .origin.x = _m_attIdLabel.right + NAME_LABEL_LEFT_PANDING,
        .origin.y = _m_attIdLabel.top,
        .size.width = TITLE_LABEL_WIDTH,
        .size.height = LABEL_HEIGHT
    };
    
    _m_downloadBtn.frame = (CGRect){
        .origin.x = _m_attNameLabel.right + BUTTON_LEFT_PANDING,
        .origin.y = (self.height - BUTTON_HEIGHT)/2,
        .size.width = BUTTON_WIDTH,
        .size.height = BUTTON_HEIGHT
    };
    
    _view.frame = (CGRect){
        .origin.x = _m_attIdLabel.left,
        .origin.y = self.height - 1,
        .size.width = self.width - 2 * LABEL_LEFT_PANDING,
        .size.height = 1
    };
}

#pragma mark - Private Method

- (void)_init {
    
    self.m_attIdLabel = [[UILabel alloc] init];
    _m_attIdLabel.textColor = [UIColor colorWithRed:0.443f green:0.443f blue:0.443f alpha:1.00f];
    _m_attIdLabel.font = [UIFont systemFontOfSize:10];
    _m_attIdLabel.textAlignment = NSTextAlignmentLeft;
    [self addSubview:_m_attIdLabel];
    
    self.view = [[UIView alloc] init];
    _view.backgroundColor = [UIColor lightGrayColor];
    [self addSubview:_view];
    
    self.m_attNameLabel = [[UILabel alloc] init];
    _m_attNameLabel.textColor = [UIColor colorWithRed:0.000f green:0.463f blue:0.925f alpha:1.00f];
    _m_attNameLabel.font = [UIFont systemFontOfSize:10];
    _m_attNameLabel.textAlignment = NSTextAlignmentLeft;
    [self addSubview:_m_attNameLabel];
    
    self.m_downloadBtn = [UIButton buttonWithType:UIButtonTypeCustom];
    _m_downloadBtn.layer.masksToBounds = YES;
    _m_downloadBtn.layer.cornerRadius = 5;
    [_m_downloadBtn setTitle:@"打开"
                    forState:UIControlStateNormal];
    [_m_downloadBtn setBackgroundImage:[UIImage imageWithColor:[UIColor colorWithRed:0.157f green:0.843f blue:0.463f alpha:1.00f]] forState:UIControlStateNormal];
//     [UIColor colorWithRed:0.690f green:0.690f blue:0.690f alpha:1.00f]];
     
    [self addSubview:_m_downloadBtn];

}

#pragma mark - Pubulic Method

- (void)updateContentWithData:(id)data {
    if ([data isKindOfClass:[ICRAttachment class]]) {
        
        ICRAttachment *attachment = data;
        _m_attIdLabel.text = attachment.objectId;
        NSDictionary *underlineAttribute = @{NSUnderlineStyleAttributeName: @(NSUnderlineStyleSingle)};
        _m_attNameLabel.attributedText = [[NSAttributedString alloc] initWithString:attachment.fileName
                                                                 attributes:underlineAttribute];
    }
}
@end
