//
//  VankeUtil.h
//  vanke
//
//  Created by xiaomi on 15/10/5.
//  Copyright © 2015年 gomore. All rights reserved.
//

#ifndef VankeUtil_h
#define VankeUtil_h

#import "Bee.h"

@class VersionNumber;

@interface VankeUtil : NSObject

AS_SINGLETON( VankeUtil )

+ (NSString*) getConfigValue: (NSString*) key;

// 去除空格
+ (NSString*) trim: (NSString*) str;

// 判断字符串是否为空
+ (BOOL) isBlankString:(NSString *)string;

// md5加密(小写)
+ (NSString*) md5: (NSString*) src;

// base64
+ (NSString*) base64: (NSString*) src;

// 字典转换成json字符串
+ (NSString*)dictToJsonString:(id)object;

+ (UIColor *)colorWithHexString:(NSString *)stringToConvert;

+ (NSString *)hexToRGB:(NSString *)hexString;

+ (UIColor *)rgbStringToColor:(NSString *)rgbString;

+ (NSString *)getHexStringForColor:(UIColor*)color;

+ (void)drawDashedBorderAroundView:(UIView *) v cornerRadius: (CGFloat) cornerRadius borderWidth: (CGFloat) borderWidth borderColor: (UIColor*) borderColor;

/**
 *  当前版本
 *
 *  @return 当前版本
 */
+ (VersionNumber*) getCurrentVersion;

@end

// 版本号
@interface VersionNumber: NSObject

@property (nonatomic, assign) NSInteger major; // 主版本
@property (nonatomic, assign) NSInteger minor; // 小版本
@property (nonatomic, assign) NSInteger revision; // 修正版本号

/**
 *  构造函数
 *
 *  @param version 版本号字符串,格式:major.minor.revision，如: 1.0.1
 */
+(instancetype) initWithVersion: (NSString*) version;

/**
 *  版本号比较
 *
 *  @param version 版本号
 *
 *  @return 0：相等 1: 大于传入版本 -1: 小于传入版本
 */
-(int) compareTo: (VersionNumber*) version;

/**
 *  输出版本号字符串
 *
 *  @return 版本号字符串,格式:major.minor.build，如: 1.0.1
 */
-(NSString*) toString;

@end


#endif /* VankeUtil_h */
