//
//  NSMutableArray+SafeInsert.m
//  Cruiser
//
//  Created by Xummer on 4/10/15.
//  Copyright (c) 2015 Xummer. All rights reserved.
//

#import "NSMutableArray+SafeInsert.h"

#pragma mark - NSMutableArray (SafeInsert)
@implementation NSMutableArray (SafeInsert)

- (void)safeAddObject:(id)object {
    if (object) {
        [self addObject:object];
    }
}

- (void)safeInsertObject:(id)object atIndex:(NSUInteger)index {
    if (index < self.count && object) {
        [self insertObject:object atIndex:index];
    }
}

- (void)safeRemoveObjectAtIndex:(NSUInteger)index {
    if (index < self.count) {
        [self removeObjectAtIndex:index];
    }
}

- (void)safeReplaceObjectAtIndex:(NSUInteger)index withObject:(id)object {
    if (index < self.count && object) {
        [self replaceObjectAtIndex:index withObject:object];
    }
}

- (void)removeFirstObject {
    id firstObj = [self firstObject];
    if (firstObj) {
        [self removeObject:firstObj];
    }
}

@end

#pragma mark - NSMutableDictionary (SafeInsert)
@implementation NSMutableDictionary (SafeInsert)

- (void)safeSetObject:(id)object forKey:(id <NSCopying>)key {
    if (object) {
        [self setObject:object forKey:key];
    }
}

- (void)safeRemoveObjectForKey:(id)key {
    [self removeObjectForKey:key];
}

@end

#pragma mark - NSMutableSet (SafeInsert)
@implementation NSMutableSet (SafeInsert)

- (void)safeAddObject:(id)object {
    if (object) {
        [self addObject:object];
    }
}

- (void)safeRemoveObject:(id)object {
    if (object) {
        [self removeObject:object];
    }
}

@end

#pragma mark - NSMutableString (SafeInsert)
@implementation NSMutableString (SafeInsert)

- (void)safeAppendString:(NSString *)string {
    if ([string isKindOfClass:[NSString class]]) {
        [self appendString:string];
    }
}

@end

#pragma mark - NSArray (SafeFetch)
@implementation NSArray (SafeFetch)

- (id)safeObjectAtIndex:(NSUInteger)index {
    @synchronized(self) {
        if (index >= [self count]) return nil;
        return [self objectAtIndex:index];
    }
}

@end
