

#import "VankeServiceDashBoard_iPhone.h"
#import "CalculateHelper.h"
#pragma mark -

@interface VankeServiceDashBoard_iPhone ()
{
}
@end

@implementation VankeServiceDashBoard_iPhone

SUPPORT_AUTOMATIC_LAYOUT( YES )
SUPPORT_RESOURCE_LOADING( YES )

DEF_OUTLET( VankeServiceSaleCell_iPhone, salesInfo );
DEF_OUTLET( VankeServiceBoardCell_iPhone, passenger );
DEF_OUTLET( VankeServiceBoardCell_iPhone, traffic );
DEF_OUTLET( VankeServiceBoardCell_iPhone, energy );
DEF_OUTLET( VankeServiceBoardCell_iPhone, complaint );

@synthesize name = _name;
@synthesize theme = _theme;

+ (id) dashBoardByIndex: (int) index {
    if (index == 0) {
        return [VankeServiceDashBoard_iPhone communityDashBarod];
    } else if (index == 1) {
        return [VankeServiceDashBoard_iPhone centerDashBarod];
    } else  if (index == 2) {
        return [VankeServiceDashBoard_iPhone squreDashBarod];
    } else {
        return nil;
    }
}

+ (id) communityDashBarod {
    VankeServiceDashBoard_iPhone *board = [super cell];
    //万科
//    board.name = @"社区2049";
    //新天地修改
    board.name = @"新天地";
    board.theme = @"red";
    return board;
}

+ (id) centerDashBarod {
    VankeServiceDashBoard_iPhone *board = [super cell];
    board.name = @"万科中心";
    board.theme = @"purple";
    return board;
}

+ (id) squreDashBarod {
    VankeServiceDashBoard_iPhone *board = [super cell];
    board.name = @"万科广场";
    board.theme = @"orange";
    return board;
}

- (void)load
{
    self.salesInfo.imgRightBg.backgroundColor = [UIColor colorWithRed:0.278 green:0.561 blue:0.945 alpha:1.000];
    [self.passenger loadDefaults:@"people.png" title:@"昨日客流" bgColor:[UIColor colorWithRed:0 green:195/255.0 blue:230/255.0 alpha:1] unit:@"人" defValue:[NSNumber numberWithInt:0]];
    [self.traffic loadDefaults:@"car.png" title:@"车流" bgColor:[UIColor colorWithRed:79/255.0 green:143/255.0 blue:248/255.0 alpha:1] unit:@"次" defValue:[NSNumber numberWithInt:0]];
    [self.energy loadDefaults:@"energy.png" title:@"日坪效" bgColor:[UIColor colorWithRed:149/255.0 green:200/255.0 blue:8/255.0 alpha:1] unit:@"元"
                     defValue:[NSNumber numberWithFloat:0.00]];
    [self.complaint loadDefaults:@"complaint.png" title:@"收缴率" bgColor:[UIColor colorWithRed:252/255.0 green:67/255.0 blue:62/255.0 alpha:1] unit:@" " defValue:[NSNumber numberWithInt:0]];
}

- (void)unload
{
}

- (BOOL)dataWillChange:(id)newData {
    return self.data != newData;
}

- (void) dataDidChanged {
    ProjectSummary *summary = self.data;
    if (nil != summary) {
        [self.salesInfo setData:summary.salesAmount];
        [self.passenger setData:summary.passengerFlowVolume];
        [self.traffic setData:[NSNumber numberWithFloat:0]];
        //计算出坪效
        NSDecimalNumber *energy = [CalculateHelper calculateNum1:summary.rentalAmount num2:summary.rentalArea type:CalculateTypeDiv roundingType:NSRoundPlain cutLenth:2];
        self.energy.lblAmount.text = [CalculateHelper getMoneyStringFrom:energy];
        NSString *rate = [CalculateHelper getPercent:summary.paidStatement num:summary.totalStatement];
        self.complaint.lblAmount.text = rate;
        
    }
}

-(void) setTheme:(NSString *)theme {
    _theme = theme;
    [self.salesInfo setTheme: theme];
}

@end
