//
//  VankeBaseViewController.m
//  vanke
//
//  Created by xiaomi on 15/10/10.
//  Copyright © 2015年 gomore. All rights reserved.
//

#import "VankeBaseBoard.h"
#import "VankeAppBoard_iPhone.h"

@implementation VankeBaseBoard

@synthesize theme = _theme;
@synthesize showMenu = _showMenu;

ON_CREATE_VIEWS( signal )
{
    [[UINavigationBar appearance] setTitleTextAttributes:@{NSForegroundColorAttributeName:[UIColor whiteColor]}];
    self.navigationBarLeft  = [UIImage imageNamed:@"left_arrow"];
}

ON_WILL_APPEAR( signal )
{
    [BeeUIRouter sharedInstance].view.pannable = YES;
    
    UIColor *bgColor = [self getThemeColor];
    if (nil == bgColor) {
        if ( IOS7_OR_LATER ) {
            self.navigationController.navigationBar.backgroundImage = [UIImage imageNamed:@"navigation-bar-64.png"];
        } else {
            self.navigationController.navigationBar.backgroundImage = [UIImage imageNamed:@"navigation-bar.png"];
        }
    } else {
//        if ( IOS7_OR_LATER ) {
            self.navigationController.navigationBar.barTintColor = kMainBlueColor;
        [[UINavigationBar appearance] setTitleTextAttributes:@{NSForegroundColorAttributeName:[UIColor whiteColor]}];
        //        } else {
//        }
    }
}

ON_LEFT_BUTTON_TOUCHED( signal )
{
    [self.stack popBoardAnimated:YES];
    if ([self.stack.boards count] <= 1) {
        [[VankeAppBoard_iPhone sharedInstance] showMenu];
    }
}

-(UIColor*) getThemeColor {
    if ([@"red" eq:_theme]) {
        return [UIColor colorWithRed:237/255.0 green:27/255.0 blue:35/255.0 alpha:1.0];
    } else if ([@"purple" eq:_theme]) {
        return [UIColor colorWithRed:84/255.0 green:53/255.0 blue:173/255.0 alpha:1.0];
    } else if ([@"orange" eq:_theme]) {
        return [UIColor colorWithRed:234/255.0 green:100/255.0 blue:2/255.0 alpha:1.0];
    } else {
        return nil;
    }
}

@end
