//
//  StatementTableViewCell.m
//  RealEstateManagement
//
//  Created by Z on 16/6/29.
//  Copyright © 2016年 上海勾芒信息科技. All rights reserved.
//

#import "StatementTableViewCell.h"
#import "CalculateHelper.h"
@interface StatementTableViewCell ()
@property (weak, nonatomic) IBOutlet UIView *imgShop;
@property (weak, nonatomic) IBOutlet UILabel *labelTitle;
/** 应缴 */
@property (weak, nonatomic) IBOutlet UILabel *labelShouldPay;
/** 已缴 */
@property (weak, nonatomic) IBOutlet UILabel *labelPaidIn;
/** 未缴 */
@property (weak, nonatomic) IBOutlet UILabel *labelUnPaid;

@end
@implementation StatementTableViewCell

- (void)awakeFromNib {
    // Initialization code
}

- (void)setUpCellWithArray:(NSArray *)array index:(NSIndexPath *)indexPath {
    StatementRecords *model = array[indexPath.row];
    self.labelTitle.text = [NSString stringWithFormat:@"%@", model.shopName];
    self.labelShouldPay.text = [NSString stringWithFormat:@"%@元",[CalculateHelper getMoneyStringFrom:[NSNumber numberWithDouble:model.amount] Lenth:2 isSeparate:YES]];
    self.labelPaidIn.text = [NSString stringWithFormat:@"[已缴]%@元",[CalculateHelper getMoneyStringFrom:[NSNumber numberWithDouble:model.paid] Lenth:2 isSeparate:YES]];
    self.labelUnPaid.text = [NSString stringWithFormat:@"[未缴]%@元",[CalculateHelper getMoneyStringFrom:[NSNumber numberWithDouble:model.unpaid] Lenth:2 isSeparate:YES]];
    
}
- (void)setSelected:(BOOL)selected animated:(BOOL)animated {
    [super setSelected:selected animated:animated];

    // Configure the view for the selected state
}

@end
