//
//  StatementRecords.m
//
//  Created by 杰 张 on 16/7/18
//  Copyright (c) 2016 __MyCompanyName__. All rights reserved.
//

#import "StatementRecords.h"


NSString *const kStatementRecordsAmount = @"amount";
NSString *const kStatementRecordsSettle = @"settle";
NSString *const kStatementRecordsUnpaid = @"unpaid";
NSString *const kStatementRecordsPicture = @"picture";
NSString *const kStatementRecordsContract = @"contract";
NSString *const kStatementRecordsShopName = @"shopName";
NSString *const kStatementRecordsShopCode = @"shopCode";
NSString *const kStatementRecordsPaid = @"paid";
NSString *const kStatementRecordsState = @"state";
NSString *const kStatementRecordsItems = @"items";


@interface StatementRecords ()

- (id)objectOrNilForKey:(id)aKey fromDictionary:(NSDictionary *)dict;

@end

@implementation StatementRecords

@synthesize amount = _amount;
@synthesize settle = _settle;
@synthesize unpaid = _unpaid;
@synthesize picture = _picture;
@synthesize contract = _contract;
@synthesize shopName = _shopName;
@synthesize shopCode = _shopCode;
@synthesize paid = _paid;
@synthesize state = _state;
@synthesize items = _items;


+ (instancetype)modelObjectWithDictionary:(NSDictionary *)dict
{
    return [[self alloc] initWithDictionary:dict];
}

- (instancetype)initWithDictionary:(NSDictionary *)dict
{
    self = [super init];
    
    // This check serves to make sure that a non-NSDictionary object
    // passed into the model class doesn't break the parsing.
    if(self && [dict isKindOfClass:[NSDictionary class]]) {
            self.amount = [[self objectOrNilForKey:kStatementRecordsAmount fromDictionary:dict] doubleValue];
            self.settle = [self objectOrNilForKey:kStatementRecordsSettle fromDictionary:dict];
            self.unpaid = [[self objectOrNilForKey:kStatementRecordsUnpaid fromDictionary:dict] doubleValue];
            self.picture = [self objectOrNilForKey:kStatementRecordsPicture fromDictionary:dict];
            self.contract = [self objectOrNilForKey:kStatementRecordsContract fromDictionary:dict];
            self.shopName = [self objectOrNilForKey:kStatementRecordsShopName fromDictionary:dict];
            self.shopCode = [self objectOrNilForKey:kStatementRecordsShopCode fromDictionary:dict];
            self.paid = [[self objectOrNilForKey:kStatementRecordsPaid fromDictionary:dict] doubleValue];
            self.state = [self objectOrNilForKey:kStatementRecordsState fromDictionary:dict];
            self.items = [self objectOrNilForKey:kStatementRecordsItems fromDictionary:dict];

    }
    
    return self;
    
}

- (NSDictionary *)dictionaryRepresentation
{
    NSMutableDictionary *mutableDict = [NSMutableDictionary dictionary];
    [mutableDict setValue:[NSNumber numberWithDouble:self.amount] forKey:kStatementRecordsAmount];
    [mutableDict setValue:self.settle forKey:kStatementRecordsSettle];
    [mutableDict setValue:[NSNumber numberWithDouble:self.unpaid] forKey:kStatementRecordsUnpaid];
    [mutableDict setValue:self.picture forKey:kStatementRecordsPicture];
    [mutableDict setValue:self.contract forKey:kStatementRecordsContract];
    [mutableDict setValue:self.shopName forKey:kStatementRecordsShopName];
    [mutableDict setValue:self.shopCode forKey:kStatementRecordsShopCode];
    [mutableDict setValue:[NSNumber numberWithDouble:self.paid] forKey:kStatementRecordsPaid];
    [mutableDict setValue:self.state forKey:kStatementRecordsState];
    NSMutableArray *tempArrayForItems = [NSMutableArray array];
    for (NSObject *subArrayObject in self.items) {
        if([subArrayObject respondsToSelector:@selector(dictionaryRepresentation)]) {
            // This class is a model object
            [tempArrayForItems addObject:[subArrayObject performSelector:@selector(dictionaryRepresentation)]];
        } else {
            // Generic object
            [tempArrayForItems addObject:subArrayObject];
        }
    }
    [mutableDict setValue:[NSArray arrayWithArray:tempArrayForItems] forKey:kStatementRecordsItems];

    return [NSDictionary dictionaryWithDictionary:mutableDict];
}

- (NSString *)description 
{
    return [NSString stringWithFormat:@"%@", [self dictionaryRepresentation]];
}

#pragma mark - Helper Method
- (id)objectOrNilForKey:(id)aKey fromDictionary:(NSDictionary *)dict
{
    id object = [dict objectForKey:aKey];
    return [object isEqual:[NSNull null]] ? nil : object;
}


#pragma mark - NSCoding Methods

- (id)initWithCoder:(NSCoder *)aDecoder
{
    self = [super init];

    self.amount = [aDecoder decodeDoubleForKey:kStatementRecordsAmount];
    self.settle = [aDecoder decodeObjectForKey:kStatementRecordsSettle];
    self.unpaid = [aDecoder decodeDoubleForKey:kStatementRecordsUnpaid];
    self.picture = [aDecoder decodeObjectForKey:kStatementRecordsPicture];
    self.contract = [aDecoder decodeObjectForKey:kStatementRecordsContract];
    self.shopName = [aDecoder decodeObjectForKey:kStatementRecordsShopName];
    self.shopCode = [aDecoder decodeObjectForKey:kStatementRecordsShopCode];
    self.paid = [aDecoder decodeDoubleForKey:kStatementRecordsPaid];
    self.state = [aDecoder decodeObjectForKey:kStatementRecordsState];
    self.items = [aDecoder decodeObjectForKey:kStatementRecordsItems];
    return self;
}

- (void)encodeWithCoder:(NSCoder *)aCoder
{

    [aCoder encodeDouble:_amount forKey:kStatementRecordsAmount];
    [aCoder encodeObject:_settle forKey:kStatementRecordsSettle];
    [aCoder encodeDouble:_unpaid forKey:kStatementRecordsUnpaid];
    [aCoder encodeObject:_picture forKey:kStatementRecordsPicture];
    [aCoder encodeObject:_contract forKey:kStatementRecordsContract];
    [aCoder encodeObject:_shopName forKey:kStatementRecordsShopName];
    [aCoder encodeObject:_shopCode forKey:kStatementRecordsShopCode];
    [aCoder encodeDouble:_paid forKey:kStatementRecordsPaid];
    [aCoder encodeObject:_state forKey:kStatementRecordsState];
    [aCoder encodeObject:_items forKey:kStatementRecordsItems];
}

- (id)copyWithZone:(NSZone *)zone
{
    StatementRecords *copy = [[StatementRecords alloc] init];
    
    if (copy) {

        copy.amount = self.amount;
        copy.settle = [self.settle copyWithZone:zone];
        copy.unpaid = self.unpaid;
        copy.picture = [self.picture copyWithZone:zone];
        copy.contract = [self.contract copyWithZone:zone];
        copy.shopName = [self.shopName copyWithZone:zone];
        copy.shopCode = [self.shopCode copyWithZone:zone];
        copy.paid = self.paid;
        copy.state = [self.state copyWithZone:zone];
        copy.items = [self.items copyWithZone:zone];
    }
    
    return copy;
}


@end
