//
//  StatementPaging.m
//
//  Created by 杰 张 on 16/7/18
//  Copyright (c) 2016 __MyCompanyName__. All rights reserved.
//

#import "StatementPaging.h"


NSString *const kStatementPagingPageCount = @"pageCount";
NSString *const kStatementPagingRecordCount = @"recordCount";
NSString *const kStatementPagingPageSize = @"pageSize";
NSString *const kStatementPagingPage = @"page";


@interface StatementPaging ()

- (id)objectOrNilForKey:(id)aKey fromDictionary:(NSDictionary *)dict;

@end

@implementation StatementPaging

@synthesize pageCount = _pageCount;
@synthesize recordCount = _recordCount;
@synthesize pageSize = _pageSize;
@synthesize page = _page;


+ (instancetype)modelObjectWithDictionary:(NSDictionary *)dict
{
    return [[self alloc] initWithDictionary:dict];
}

- (instancetype)initWithDictionary:(NSDictionary *)dict
{
    self = [super init];
    
    // This check serves to make sure that a non-NSDictionary object
    // passed into the model class doesn't break the parsing.
    if(self && [dict isKindOfClass:[NSDictionary class]]) {
            self.pageCount = [[self objectOrNilForKey:kStatementPagingPageCount fromDictionary:dict] doubleValue];
            self.recordCount = [[self objectOrNilForKey:kStatementPagingRecordCount fromDictionary:dict] doubleValue];
            self.pageSize = [[self objectOrNilForKey:kStatementPagingPageSize fromDictionary:dict] doubleValue];
            self.page = [[self objectOrNilForKey:kStatementPagingPage fromDictionary:dict] doubleValue];

    }
    
    return self;
    
}

- (NSDictionary *)dictionaryRepresentation
{
    NSMutableDictionary *mutableDict = [NSMutableDictionary dictionary];
    [mutableDict setValue:[NSNumber numberWithDouble:self.pageCount] forKey:kStatementPagingPageCount];
    [mutableDict setValue:[NSNumber numberWithDouble:self.recordCount] forKey:kStatementPagingRecordCount];
    [mutableDict setValue:[NSNumber numberWithDouble:self.pageSize] forKey:kStatementPagingPageSize];
    [mutableDict setValue:[NSNumber numberWithDouble:self.page] forKey:kStatementPagingPage];

    return [NSDictionary dictionaryWithDictionary:mutableDict];
}

- (NSString *)description 
{
    return [NSString stringWithFormat:@"%@", [self dictionaryRepresentation]];
}

#pragma mark - Helper Method
- (id)objectOrNilForKey:(id)aKey fromDictionary:(NSDictionary *)dict
{
    id object = [dict objectForKey:aKey];
    return [object isEqual:[NSNull null]] ? nil : object;
}


#pragma mark - NSCoding Methods

- (id)initWithCoder:(NSCoder *)aDecoder
{
    self = [super init];

    self.pageCount = [aDecoder decodeDoubleForKey:kStatementPagingPageCount];
    self.recordCount = [aDecoder decodeDoubleForKey:kStatementPagingRecordCount];
    self.pageSize = [aDecoder decodeDoubleForKey:kStatementPagingPageSize];
    self.page = [aDecoder decodeDoubleForKey:kStatementPagingPage];
    return self;
}

- (void)encodeWithCoder:(NSCoder *)aCoder
{

    [aCoder encodeDouble:_pageCount forKey:kStatementPagingPageCount];
    [aCoder encodeDouble:_recordCount forKey:kStatementPagingRecordCount];
    [aCoder encodeDouble:_pageSize forKey:kStatementPagingPageSize];
    [aCoder encodeDouble:_page forKey:kStatementPagingPage];
}

- (id)copyWithZone:(NSZone *)zone
{
    StatementPaging *copy = [[StatementPaging alloc] init];
    
    if (copy) {

        copy.pageCount = self.pageCount;
        copy.recordCount = self.recordCount;
        copy.pageSize = self.pageSize;
        copy.page = self.page;
    }
    
    return copy;
}


@end
