//
//  SaleInputPictureTableViewCell.m
//  RealEstateManagement
//
//  Created by Z on 16/6/28.
//  Copyright © 2016年 上海勾芒信息科技. All rights reserved.
//

#import "SaleInputPictureTableViewCell.h"
#import "UIButton+WebCache.h"
@interface SaleInputPictureTableViewCell ()
@property (nonatomic, strong) NSMutableArray *arrPictures;
@end
@implementation SaleInputPictureTableViewCell

- (void)awakeFromNib {
    self.btnLeft.imageView.contentMode = UIViewContentModeScaleAspectFill;
    self.btnRight.imageView.contentMode = UIViewContentModeScaleAspectFill;
    self.selectionStyle = UITableViewCellSelectionStyleNone;
    // Initialization code
}

- (void)setUpCellWithPictureArr:(NSMutableArray *)arrPic indexPath:(NSIndexPath *)indexPath {
    self.arrPictures = arrPic;
    id img = arrPic[indexPath.row * 2];
    if ([img isKindOfClass:[UIImage class]]) {
        [self.btnLeft setImage:img forState:UIControlStateNormal];
    }else if ([img isKindOfClass:[NSString class]]) {
        [self.btnLeft sd_setImageWithURL:[NSURL URLWithString:img] forState:UIControlStateNormal];
    }
    self.btnLeft.tag = indexPath.row * 2;
    self.btnRight.hidden = YES;
    if (indexPath.row * 2 + 1 <= arrPic.count - 1) {
        id image = arrPic[indexPath.row * 2 + 1];
        if ([image isKindOfClass:[UIImage class]]) {
            [self.btnRight setImage:image forState:UIControlStateNormal];
        }else if ([image isKindOfClass:[NSString class]]) {
            [self.btnRight sd_setImageWithURL:[NSURL URLWithString:image] forState:UIControlStateNormal];
        }
        self.btnRight.tag = indexPath.row * 2 + 1;
        self.btnRight.hidden = NO;
    }
    
    UILongPressGestureRecognizer *longPress = [[UILongPressGestureRecognizer alloc] initWithTarget:self action:@selector(longPress:)];
    UILongPressGestureRecognizer *lp2 = [[UILongPressGestureRecognizer alloc] initWithTarget:self action:@selector(longPress:)];
    [self.btnLeft addGestureRecognizer:longPress];
    [self.btnRight addGestureRecognizer:lp2];
    
    [self.btnLeft addTarget:self action:@selector(actionPic:) forControlEvents:UIControlEventTouchUpInside];
    [self.btnRight addTarget:self action:@selector(actionPic:) forControlEvents:UIControlEventTouchUpInside];

}

- (void)actionPic:(UIButton *)btn {
//    CLog(@"%ld", btn.tag);
    if (btn.tag == self.arrPictures.count - 1) {
        self.addPicBlock(0);
    }else{
        self.seePicBlock(btn.tag);
    }
}

- (void)longPress:(UILongPressGestureRecognizer *)recognizer{
    UIButton *btn = (UIButton *)recognizer.view;
    if (btn.tag == self.arrPictures.count - 1) {
        self.addPicBlock(0);
    }else{
        self.deleteBolock(btn.tag);
    }
}

- (void)setSelected:(BOOL)selected animated:(BOOL)animated {
    [super setSelected:selected animated:animated];

    // Configure the view for the selected state
}

@end
