//
//  SalesInputLines.m
//
//  Created by 杰 张 on 16/8/22
//  Copyright (c) 2016 __MyCompanyName__. All rights reserved.
//

#import "SalesInputLines.h"


NSString *const kSalesInputLinesAmount = @"amount";
NSString *const kSalesInputLinesPayment = @"payment";
NSString *const kSalesInputLinesSortNumber = @"sortNumber";
NSString *const kSalesInputLinesTransactions = @"transactions";


@interface SalesInputLines ()

- (id)objectOrNilForKey:(id)aKey fromDictionary:(NSDictionary *)dict;

@end

@implementation SalesInputLines

@synthesize amount = _amount;
@synthesize payment = _payment;
@synthesize sortNumber = _sortNumber;
@synthesize transactions = _transactions;


+ (instancetype)modelObjectWithDictionary:(NSDictionary *)dict
{
    return [[self alloc] initWithDictionary:dict];
}

- (instancetype)initWithDictionary:(NSDictionary *)dict
{
    self = [super init];
    
    // This check serves to make sure that a non-NSDictionary object
    // passed into the model class doesn't break the parsing.
    if(self && [dict isKindOfClass:[NSDictionary class]]) {
            self.amount = [[self objectOrNilForKey:kSalesInputLinesAmount fromDictionary:dict] doubleValue];
            self.payment = [self objectOrNilForKey:kSalesInputLinesPayment fromDictionary:dict];
            self.sortNumber = [[self objectOrNilForKey:kSalesInputLinesSortNumber fromDictionary:dict] doubleValue];
            self.transactions = [[self objectOrNilForKey:kSalesInputLinesTransactions fromDictionary:dict] doubleValue];

    }
    
    return self;
    
}

- (NSDictionary *)dictionaryRepresentation
{
    NSMutableDictionary *mutableDict = [NSMutableDictionary dictionary];
    [mutableDict setValue:[NSNumber numberWithDouble:self.amount] forKey:kSalesInputLinesAmount];
    [mutableDict setValue:self.payment forKey:kSalesInputLinesPayment];
    [mutableDict setValue:[NSNumber numberWithDouble:self.sortNumber] forKey:kSalesInputLinesSortNumber];
    [mutableDict setValue:[NSNumber numberWithDouble:self.transactions] forKey:kSalesInputLinesTransactions];

    return [NSDictionary dictionaryWithDictionary:mutableDict];
}

- (NSString *)description 
{
    return [NSString stringWithFormat:@"%@", [self dictionaryRepresentation]];
}

#pragma mark - Helper Method
- (id)objectOrNilForKey:(id)aKey fromDictionary:(NSDictionary *)dict
{
    id object = [dict objectForKey:aKey];
    return [object isEqual:[NSNull null]] ? nil : object;
}


#pragma mark - NSCoding Methods

- (id)initWithCoder:(NSCoder *)aDecoder
{
    self = [super init];

    self.amount = [aDecoder decodeDoubleForKey:kSalesInputLinesAmount];
    self.payment = [aDecoder decodeObjectForKey:kSalesInputLinesPayment];
    self.sortNumber = [aDecoder decodeDoubleForKey:kSalesInputLinesSortNumber];
    self.transactions = [aDecoder decodeDoubleForKey:kSalesInputLinesTransactions];
    return self;
}

- (void)encodeWithCoder:(NSCoder *)aCoder
{

    [aCoder encodeDouble:_amount forKey:kSalesInputLinesAmount];
    [aCoder encodeObject:_payment forKey:kSalesInputLinesPayment];
    [aCoder encodeDouble:_sortNumber forKey:kSalesInputLinesSortNumber];
    [aCoder encodeDouble:_transactions forKey:kSalesInputLinesTransactions];
}

- (id)copyWithZone:(NSZone *)zone
{
    SalesInputLines *copy = [[SalesInputLines alloc] init];
    
    if (copy) {

        copy.amount = self.amount;
        copy.payment = [self.payment copyWithZone:zone];
        copy.sortNumber = self.sortNumber;
        copy.transactions = self.transactions;
    }
    
    return copy;
}


@end
