//
//  SalesInputAuditListModel.m
//
//  Created by 杰 张 on 16/8/22
//  Copyright (c) 2016 __MyCompanyName__. All rights reserved.
//

#import "SalesInputAuditListModel.h"
#import "SalesInputLines.h"


NSString *const kSalesInputAuditListModelAmount = @"amount";
NSString *const kSalesInputAuditListModelLines = @"lines";
NSString *const kSalesInputAuditListModelSalesDate = @"salesDate";
NSString *const kSalesInputAuditListModelAttachmentUuid = @"attachmentUuid";
NSString *const kSalesInputAuditListModelUuid = @"uuid";
NSString *const kSalesInputAuditListModelShopName = @"shopName";
NSString *const kSalesInputAuditListModelTransactions = @"transactions";
NSString *const kSalesInputAuditListModelShopCode = @"shopCode";
NSString *const kSalesInputAuditListModelAttachments = @"attachments";
NSString *const kSalesInputAuditListModelState = @"state";
NSString *const kSalesInputAuditListModelProjectId = @"projectId";


@interface SalesInputAuditListModel ()

- (id)objectOrNilForKey:(id)aKey fromDictionary:(NSDictionary *)dict;

@end

@implementation SalesInputAuditListModel

@synthesize amount = _amount;
@synthesize lines = _lines;
@synthesize salesDate = _salesDate;
@synthesize attachmentUuid = _attachmentUuid;
@synthesize uuid = _uuid;
@synthesize shopName = _shopName;
@synthesize transactions = _transactions;
@synthesize shopCode = _shopCode;
@synthesize attachments = _attachments;
@synthesize state = _state;
@synthesize projectId = _projectId;


+ (instancetype)modelObjectWithDictionary:(NSDictionary *)dict
{
    return [[self alloc] initWithDictionary:dict];
}

- (instancetype)initWithDictionary:(NSDictionary *)dict
{
    self = [super init];
    
    // This check serves to make sure that a non-NSDictionary object
    // passed into the model class doesn't break the parsing.
    if(self && [dict isKindOfClass:[NSDictionary class]]) {
            self.amount = [[self objectOrNilForKey:kSalesInputAuditListModelAmount fromDictionary:dict] doubleValue];
    NSObject *receivedSalesInputLines = [dict objectForKey:kSalesInputAuditListModelLines];
    NSMutableArray *parsedSalesInputLines = [NSMutableArray array];
    if ([receivedSalesInputLines isKindOfClass:[NSArray class]]) {
        for (NSDictionary *item in (NSArray *)receivedSalesInputLines) {
            if ([item isKindOfClass:[NSDictionary class]]) {
                [parsedSalesInputLines addObject:[SalesInputLines modelObjectWithDictionary:item]];
            }
       }
    } else if ([receivedSalesInputLines isKindOfClass:[NSDictionary class]]) {
       [parsedSalesInputLines addObject:[SalesInputLines modelObjectWithDictionary:(NSDictionary *)receivedSalesInputLines]];
    }

    self.lines = [NSArray arrayWithArray:parsedSalesInputLines];
            self.salesDate = [self objectOrNilForKey:kSalesInputAuditListModelSalesDate fromDictionary:dict];
            self.attachmentUuid = [self objectOrNilForKey:kSalesInputAuditListModelAttachmentUuid fromDictionary:dict];
            self.uuid = [self objectOrNilForKey:kSalesInputAuditListModelUuid fromDictionary:dict];
            self.shopName = [self objectOrNilForKey:kSalesInputAuditListModelShopName fromDictionary:dict];
            self.transactions = [[self objectOrNilForKey:kSalesInputAuditListModelTransactions fromDictionary:dict] doubleValue];
            self.shopCode = [self objectOrNilForKey:kSalesInputAuditListModelShopCode fromDictionary:dict];
            self.attachments = [self objectOrNilForKey:kSalesInputAuditListModelAttachments fromDictionary:dict];
            self.state = [self objectOrNilForKey:kSalesInputAuditListModelState fromDictionary:dict];
            self.projectId = [self objectOrNilForKey:kSalesInputAuditListModelProjectId fromDictionary:dict];

    }
    
    return self;
    
}

- (NSDictionary *)dictionaryRepresentation
{
    NSMutableDictionary *mutableDict = [NSMutableDictionary dictionary];
    [mutableDict setValue:[NSNumber numberWithDouble:self.amount] forKey:kSalesInputAuditListModelAmount];
    NSMutableArray *tempArrayForLines = [NSMutableArray array];
    for (NSObject *subArrayObject in self.lines) {
        if([subArrayObject respondsToSelector:@selector(dictionaryRepresentation)]) {
            // This class is a model object
            [tempArrayForLines addObject:[subArrayObject performSelector:@selector(dictionaryRepresentation)]];
        } else {
            // Generic object
            [tempArrayForLines addObject:subArrayObject];
        }
    }
    [mutableDict setValue:[NSArray arrayWithArray:tempArrayForLines] forKey:kSalesInputAuditListModelLines];
    [mutableDict setValue:self.salesDate forKey:kSalesInputAuditListModelSalesDate];
    [mutableDict setValue:self.attachmentUuid forKey:kSalesInputAuditListModelAttachmentUuid];
    [mutableDict setValue:self.uuid forKey:kSalesInputAuditListModelUuid];
    [mutableDict setValue:self.shopName forKey:kSalesInputAuditListModelShopName];
    [mutableDict setValue:[NSNumber numberWithDouble:self.transactions] forKey:kSalesInputAuditListModelTransactions];
    [mutableDict setValue:self.shopCode forKey:kSalesInputAuditListModelShopCode];
    NSMutableArray *tempArrayForAttachments = [NSMutableArray array];
    for (NSObject *subArrayObject in self.attachments) {
        if([subArrayObject respondsToSelector:@selector(dictionaryRepresentation)]) {
            // This class is a model object
            [tempArrayForAttachments addObject:[subArrayObject performSelector:@selector(dictionaryRepresentation)]];
        } else {
            // Generic object
            [tempArrayForAttachments addObject:subArrayObject];
        }
    }
    [mutableDict setValue:[NSArray arrayWithArray:tempArrayForAttachments] forKey:kSalesInputAuditListModelAttachments];
    [mutableDict setValue:self.state forKey:kSalesInputAuditListModelState];
    [mutableDict setValue:self.projectId forKey:kSalesInputAuditListModelProjectId];

    return [NSDictionary dictionaryWithDictionary:mutableDict];
}

- (NSString *)description 
{
    return [NSString stringWithFormat:@"%@", [self dictionaryRepresentation]];
}

#pragma mark - Helper Method
- (id)objectOrNilForKey:(id)aKey fromDictionary:(NSDictionary *)dict
{
    id object = [dict objectForKey:aKey];
    return [object isEqual:[NSNull null]] ? nil : object;
}


#pragma mark - NSCoding Methods

- (id)initWithCoder:(NSCoder *)aDecoder
{
    self = [super init];

    self.amount = [aDecoder decodeDoubleForKey:kSalesInputAuditListModelAmount];
    self.lines = [aDecoder decodeObjectForKey:kSalesInputAuditListModelLines];
    self.salesDate = [aDecoder decodeObjectForKey:kSalesInputAuditListModelSalesDate];
    self.attachmentUuid = [aDecoder decodeObjectForKey:kSalesInputAuditListModelAttachmentUuid];
    self.uuid = [aDecoder decodeObjectForKey:kSalesInputAuditListModelUuid];
    self.shopName = [aDecoder decodeObjectForKey:kSalesInputAuditListModelShopName];
    self.transactions = [aDecoder decodeDoubleForKey:kSalesInputAuditListModelTransactions];
    self.shopCode = [aDecoder decodeObjectForKey:kSalesInputAuditListModelShopCode];
    self.attachments = [aDecoder decodeObjectForKey:kSalesInputAuditListModelAttachments];
    self.state = [aDecoder decodeObjectForKey:kSalesInputAuditListModelState];
    self.projectId = [aDecoder decodeObjectForKey:kSalesInputAuditListModelProjectId];
    return self;
}

- (void)encodeWithCoder:(NSCoder *)aCoder
{

    [aCoder encodeDouble:_amount forKey:kSalesInputAuditListModelAmount];
    [aCoder encodeObject:_lines forKey:kSalesInputAuditListModelLines];
    [aCoder encodeObject:_salesDate forKey:kSalesInputAuditListModelSalesDate];
    [aCoder encodeObject:_attachmentUuid forKey:kSalesInputAuditListModelAttachmentUuid];
    [aCoder encodeObject:_uuid forKey:kSalesInputAuditListModelUuid];
    [aCoder encodeObject:_shopName forKey:kSalesInputAuditListModelShopName];
    [aCoder encodeDouble:_transactions forKey:kSalesInputAuditListModelTransactions];
    [aCoder encodeObject:_shopCode forKey:kSalesInputAuditListModelShopCode];
    [aCoder encodeObject:_attachments forKey:kSalesInputAuditListModelAttachments];
    [aCoder encodeObject:_state forKey:kSalesInputAuditListModelState];
    [aCoder encodeObject:_projectId forKey:kSalesInputAuditListModelProjectId];
}

- (id)copyWithZone:(NSZone *)zone
{
    SalesInputAuditListModel *copy = [[SalesInputAuditListModel alloc] init];
    
    if (copy) {

        copy.amount = self.amount;
        copy.lines = [self.lines copyWithZone:zone];
        copy.salesDate = [self.salesDate copyWithZone:zone];
        copy.attachmentUuid = [self.attachmentUuid copyWithZone:zone];
        copy.uuid = [self.uuid copyWithZone:zone];
        copy.shopName = [self.shopName copyWithZone:zone];
        copy.transactions = self.transactions;
        copy.shopCode = [self.shopCode copyWithZone:zone];
        copy.attachments = [self.attachments copyWithZone:zone];
        copy.state = [self.state copyWithZone:zone];
        copy.projectId = [self.projectId copyWithZone:zone];
    }
    
    return copy;
}


@end
