//
//  SaleInputAuditViewController.m
//  vanke
//
//  Created by Javen on 16/8/22.
//  Copyright © 2016年 gomore. All rights reserved.
//

#import "SaleInputAuditViewController.h"
#import "SalesInputAuditModels.h"
#import "SaleInputAuditTableViewCell.h"
#import "MJRefresh.h"
#import "SalesInputViewController.h"
#import "UIScrollView+EmptyDataSet.h"
@interface SaleInputAuditViewController ()<UITableViewDelegate, UITableViewDataSource,DZNEmptyDataSetSource, DZNEmptyDataSetDelegate>
@property (weak, nonatomic) IBOutlet UITableView *tableView;
@property (nonatomic, strong) NSMutableArray *arrData;
@property (nonatomic, assign) NSInteger page;
@property (nonatomic, strong) MBProgressHUD *hud;

@end

@implementation SaleInputAuditViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    self.page = 0;
    self.title = @"审批列表";
    self.tableView.estimatedRowHeight = 159;
    self.tableView.rowHeight = UITableViewAutomaticDimension;
    self.navigationController.navigationBar.tintColor = [UIColor whiteColor];
    self.navigationController.navigationBar.backgroundImage = [UIImage imageWithColor:[UIColor colorWithRed:0.918 green:0.392 blue:0.004 alpha:1.000]];
    self.navigationController.navigationBar.barTintColor = kMainOrangeColor;
    
    WS(weakSelf);
    self.tableView.mj_footer = [MJRefreshAutoNormalFooter footerWithRefreshingBlock:^{
        weakSelf.page++;
        [weakSelf httpRequest];
    }];
    
    
    self.tableView.mj_header = [MJRefreshNormalHeader headerWithRefreshingBlock:^{
        [weakSelf.arrData removeAllObjects];
        weakSelf.page = 0;
        weakSelf.hud  = [MBProgressHUD showHUDAddedTo:self.view animated:YES];
        [weakSelf httpRequest];
    }];
}

- (void)viewWillAppear:(BOOL)animated {
    [super viewWillAppear:animated];
    [self.tableView.mj_header beginRefreshing];
}


#pragma mark - empty state
- (UIImage *)imageForEmptyDataSet:(UIScrollView *)scrollView {
    return [UIImage imageNamed:@"no_data"];
}

- (CAAnimation *)imageAnimationForEmptyDataSet:(UIScrollView *)scrollView {
    CABasicAnimation *animation = [CABasicAnimation animationWithKeyPath: @"transform"];
    
    animation.fromValue = [NSValue valueWithCATransform3D:CATransform3DIdentity];
    animation.toValue = [NSValue valueWithCATransform3D:CATransform3DMakeRotation(M_PI_2, 0.0, 0.0, 1.0)];
    
    animation.duration = 1;
    animation.cumulative = YES;
    animation.repeatCount = MAXFLOAT;
    
    return animation;
}

- (UIColor *)backgroundColorForEmptyDataSet:(UIScrollView *)scrollView {
    return [UIColor whiteColor];
}

/** 网络请求 */
- (void)httpRequest{
    NSDictionary *dic = @{@"beginDateEquals":@"2015-01-01",
                          @"endDateEquals":[[NSDate date] yearMonthDayString],
                          @"pageNumber":@(self.page),
                          @"pageSize":@50};
    WS(weakSelf);
    
    [[ICRHTTPController sharedController] getUrl:@"salesinput/bill/query" params:dic success:^(id data) {
        NSString *strData = [data JSONString];
        CLog(@"%@",strData);
        for (NSDictionary *dic in data[@"data"][@"records"]) {
            SalesInputAuditListModel *model = [SalesInputAuditListModel modelObjectWithDictionary:dic];
            if ([model.projectId isEqualToString:weakSelf.org.code]) {
                [weakSelf.arrData addObject:model];
            }
        }
        [self.hud hide:YES];
        [weakSelf.tableView.mj_header endRefreshing];
        if ([data[@"data"][@"records"] count] == 0) {
            [weakSelf.tableView.mj_footer endRefreshingWithNoMoreData];
        }else{
            [weakSelf.tableView.mj_footer endRefreshing];
        }
        if (weakSelf.page == 0 && weakSelf.arrData.count == 0) {
            weakSelf.tableView.mj_footer.hidden = YES;
        }
        
        [weakSelf.tableView reloadData];
    } failure:^(id data) {
        
    }];
}


- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section {
    return self.arrData.count;
}

- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath {
    SaleInputAuditTableViewCell *cell = [tableView dequeueReusableCellWithIdentifier:@"SaleInputAuditTableViewCell" forIndexPath:indexPath];
    [cell configCellWithArr:self.arrData index:indexPath];
    return cell;
}

- (void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath {
    SalesInputViewController *saleInputVC = [[SalesInputViewController alloc] init];
    saleInputVC.type = SalesInputViewControllerTypeAudit;
    saleInputVC.model = self.arrData[indexPath.row];
    [self.navigationController pushViewController:saleInputVC animated:YES];
}


- (NSMutableArray *)arrData {
    if (!_arrData) {
        _arrData = [NSMutableArray array];
    }
    return _arrData;
}
- (void)didReceiveMemoryWarning {
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}

/*
#pragma mark - Navigation

// In a storyboard-based application, you will often want to do a little preparation before navigation
- (void)prepareForSegue:(UIStoryboardSegue *)segue sender:(id)sender {
    // Get the new view controller using [segue destinationViewController].
    // Pass the selected object to the new view controller.
}
*/

@end
