//
//  GalleryViewController.m
//  vanke
//
//  Created by Z on 16/7/18.
//  Copyright © 2016年 gomore. All rights reserved.
//

#import "GalleryViewController.h"
#import "GalleryCollectionViewCell.h"
#import "AttachmentModel.h"
@interface GalleryViewController ()<UIScrollViewDelegate>
@property (weak, nonatomic) IBOutlet UICollectionView *collectionView;
@property (weak, nonatomic) IBOutlet UICollectionViewFlowLayout *flowLayout;
@property (nonatomic, strong) NSMutableArray *arrPic;


@end

@implementation GalleryViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    self.flowLayout.itemSize = CGSizeMake(SCREEN_WIDTH, SCREEN_HEIGHT);
    self.flowLayout.minimumLineSpacing = 0;
    self.flowLayout.minimumInteritemSpacing = 0;
    self.flowLayout.scrollDirection = UICollectionViewScrollDirectionHorizontal;
    self.view.backgroundColor = [UIColor blackColor];
    UIBarButtonItem *bacBtn = [[UIBarButtonItem alloc] initWithImage:[UIImage imageNamed:@"back_icon"] style:UIBarButtonItemStyleDone target:self action:@selector(actionBack)];
    self.navigationItem.leftBarButtonItem = bacBtn;
    switch (self.type) {
        case GalleryTypeHistory: {
            self.arrPic = self.arrData;
            break;
        }
        case GalleryTypeAudit: {
            UIBarButtonItem *rightBtn = [[UIBarButtonItem alloc] initWithBarButtonSystemItem:UIBarButtonSystemItemTrash target:self action:@selector(deletePic)];
            self.navigationItem.rightBarButtonItem = rightBtn;
            self.arrPic = [self.arrData mutableCopy];
            [self.arrPic removeLastObject];
            break;
        }
    }
    
}

- (void)actionBack {
    [self DismissModalViewControllerAnimated:YES];
}


- (void)deletePic {
    UIAlertController *alertVC = [UIAlertController alertControllerWithTitle:@"确认删除这张图片？" message:nil preferredStyle:UIAlertControllerStyleAlert];
    WS(weakSelf);
    UIAlertAction *action = [UIAlertAction actionWithTitle:@"确定" style:UIAlertActionStyleDestructive handler:^(UIAlertAction * _Nonnull action) {
        if (weakSelf.page < weakSelf.arrOnlineUuids.count) {
            [weakSelf.arrOnlineUuids removeObjectAtIndex:weakSelf.page];
        }
        
        [weakSelf.arrPic removeObjectAtIndex:weakSelf.page];
        [weakSelf.arrData removeObjectAtIndex:weakSelf.page];
        [weakSelf.collectionView reloadData];
        weakSelf.page--;
        if (self.arrPic.count == 0) {
            [weakSelf.navigationController popViewControllerAnimated:YES];
        }
        
    }];
    [alertVC addAction:action];
    
    UIAlertAction *actionCancel = [UIAlertAction actionWithTitle:@"取消" style:UIAlertActionStyleDefault handler:nil];
    [alertVC addAction:actionCancel];
    [self.navigationController presentViewController:alertVC animated:YES completion:nil];
    
}

- (void)viewDidLayoutSubviews {
    [self.collectionView scrollToItemAtIndexPath:[NSIndexPath indexPathForRow:self.page inSection:0] atScrollPosition:UICollectionViewScrollPositionCenteredHorizontally animated:NO];
    if (self.page < 0) {
        return;
    }

}

#pragma mark <UICollectionViewDataSource>

- (NSInteger)numberOfSectionsInCollectionView:(UICollectionView *)collectionView {
    return 1;
}

- (NSInteger)collectionView:(UICollectionView *)collectionView numberOfItemsInSection:(NSInteger)section {
    return self.arrPic.count;
}

- (UICollectionViewCell *)collectionView:(UICollectionView *)collectionView cellForItemAtIndexPath:(NSIndexPath *)indexPath {
    GalleryCollectionViewCell *cell = [collectionView dequeueReusableCellWithReuseIdentifier:@"GalleryCollectionViewCell" forIndexPath:indexPath];
//    [cell setUpCellWithModel:model];
    switch (self.type) {
        case GalleryTypeHistory: {
            
            AttachmentModel *model = self.arrPic[indexPath.row];
            [cell setUpCell:[NSString stringWithFormat:@"%@%@",VANKE_SERVER_MEDIA_BASE_URL, model.fileUrl]];
            break;
        }
        case GalleryTypeAudit: {
            [cell setUpCell:self.arrPic[indexPath.row]];
            break;
        }
    }
    self.title = [NSString stringWithFormat:@"(%ld/%.0lu)", indexPath.row + 1, (unsigned long)self.arrPic.count];
    return cell;
}

- (void)scrollViewDidEndDecelerating:(UIScrollView *)scrollView {
    self.title = [NSString stringWithFormat:@"(%.0f/%.0lu)", scrollView.contentOffset.x / SCREEN_WIDTH + 1, (unsigned long)self.arrPic.count];
    self.page = scrollView.contentOffset.x / SCREEN_WIDTH;
}

- (void)didReceiveMemoryWarning {
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}

/*
#pragma mark - Navigation

// In a storyboard-based application, you will often want to do a little preparation before navigation
- (void)prepareForSegue:(UIStoryboardSegue *)segue sender:(id)sender {
    // Get the new view controller using [segue destinationViewController].
    // Pass the selected object to the new view controller.
}
*/

@end
