//
//  SaleViewController.m
//  XFFruit
//
//  Created by 陈俊俊 on 15/11/6.
//  Copyright © 2015年 Xummer. All rights reserved.
//

#import "SaleViewController.h"
#import "SaleViewCell.h"
#import "SaleHeaderView.h"
//#import "ReportDetailViewController.h"
#import "RSaleView.h"
#import "Compass.h"
#import "UIScrollView+EmptyDataSet.h"

static NSString *saleCellIdentify = @"saleCellIdentify";
static NSString *saleHeaderIdentify = @"saleHeaderIdentify";


@interface SaleViewController ()<UITableViewDataSource,UITableViewDelegate,DZNEmptyDataSetSource, DZNEmptyDataSetDelegate>
@property (nonatomic,strong)RSaleView *rsaleView;
@property (nonatomic,strong)Compass *compass;
@property (nonatomic,strong)NSIndexPath *currentIndex;
@end

@implementation SaleViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    [self initData];
    [self bulidLayout];
}
#pragma mark - 初始化数据
- (void)initData{
    if(!self.dataArr){
        self.dataArr = [NSMutableArray array];
    }
}

#pragma mark - 布局
- (void)bulidLayout{
    
    self.view .backgroundColor = [UIColor whiteColor];
    
    CGRect rect = CGRectMake(0, 0, SCREEN_WIDTH, 145);
    self.rsaleView = [[RSaleView alloc]initWithFrame:rect];
    self.rsaleView.bgImage.image = [UIImage imageNamed:@"salebg_1"];
    self.rsaleView.cenImage.image = [UIImage imageNamed:@"sale_1"];
    [self.view addSubview:self.rsaleView];
    
    NSLog(@"%f---------",self.view.height);
    
    rect = CGRectMake(0, 0, self.view.width, self.view.height - 49 - 64);
    self.tableView = [[UITableView alloc]initWithFrame:rect style:UITableViewStylePlain];
    self.tableView.delegate = self;
    self.tableView.dataSource = self;
    self.tableView.emptyDataSetSource = self;
    self.tableView.emptyDataSetDelegate = self;
    [self.tableView registerClass:[SaleViewCell class] forCellReuseIdentifier:saleCellIdentify];
    [self.tableView registerClass:[SaleHeaderView class] forHeaderFooterViewReuseIdentifier:saleHeaderIdentify];
    self.tableView.tableHeaderView = self.rsaleView;
    self.tableView.tableFooterView = [UIView new];
    [self.view addSubview:self.tableView];

}
- (void)setValueInSale:(Compass *)compass  withType:(NSString *)type{
    self.compass = compass;
    self.rsaleView.weekLabelStr = type;
    [self.rsaleView setValueInSaleView:compass];
    
}

#pragma mark - tableViewDelegate
- (NSInteger)numberOfSectionsInTableView:(UITableView *)tableView{
    return 1;
}
- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section{
    return self.dataArr.count;
}
- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath{
     SaleViewCell *cell = (SaleViewCell *)[tableView dequeueReusableCellWithIdentifier:saleCellIdentify forIndexPath:indexPath];
    
    if(cell == nil) {
        cell = [[SaleViewCell alloc] initWithStyle:UITableViewCellStyleDefault reuseIdentifier:saleCellIdentify];
    }
    //没有选中风格
    cell.selectionStyle = UITableViewCellSelectionStyleNone;
    //取消分割线
    tableView.separatorStyle = UITableViewCellSeparatorStyleNone;
    
    Compass *test = _dataArr[indexPath.row];
    if(test != nil) {
        [cell updateCellWith:test index:indexPath];
    }
    cell.detailBtn.tag = indexPath.row;
    [cell.detailBtn addTarget:self action:@selector(detailClick:) forControlEvents:UIControlEventTouchUpInside];
    
    return cell;
}

#pragma mark - empty state
- (UIImage *)imageForEmptyDataSet:(UIScrollView *)scrollView {
    return [UIImage imageNamed:@"no_data"];
}

- (CAAnimation *)imageAnimationForEmptyDataSet:(UIScrollView *)scrollView {
    CABasicAnimation *animation = [CABasicAnimation animationWithKeyPath: @"transform"];
    
    animation.fromValue = [NSValue valueWithCATransform3D:CATransform3DIdentity];
    animation.toValue = [NSValue valueWithCATransform3D:CATransform3DMakeRotation(M_PI_2, 0.0, 0.0, 1.0)];
    
    animation.duration = 1;
    animation.cumulative = YES;
    animation.repeatCount = MAXFLOAT;
    
    return animation;
}

- (CGFloat)verticalOffsetForEmptyDataSet:(UIScrollView *)scrollView {
    return 50;
}

- (CGFloat)tableView:(UITableView *)tableView heightForRowAtIndexPath:(NSIndexPath *)indexPath
{
    return [SaleViewCell cellHeight];
}



- (void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath{
    [[NSNotificationCenter defaultCenter]postNotificationName:KNOTIFICATION_GetNextDetailData object:nil userInfo:@{@"indexPath":indexPath}];
}


- (UIView *)tableView:(UITableView *)tableView viewForHeaderInSection:(NSInteger)section
{
    SaleHeaderView *headerView = [tableView dequeueReusableHeaderFooterViewWithIdentifier:saleHeaderIdentify];
    
    if (headerView == nil) {
        headerView = [[SaleHeaderView alloc] initWithReuseIdentifier:saleHeaderIdentify];
    }
    [headerView buildLayout];
    //jv
    headerView.totalLabel.text = [NSString stringWithFormat:@"共%ld家",(long)self.count];
    [headerView changeTypeName:self.typeStr];

    return headerView;
}


- (CGFloat)tableView:(UITableView *)tableView heightForHeaderInSection:(NSInteger)section
{
    return [SaleHeaderView viewHeight];
}

- (void)detailClick:(UIButton *)btn{
    Compass *com = self.dataArr[btn.tag];
    NSObject *comObj = [NSNull null];
    if (com) {
        comObj = com;
    }
    [[NSNotificationCenter defaultCenter] postNotificationName:KNOTIFICATION_GoReportDetail object:nil userInfo:@{@"compass":comObj}];
}


- (void)didReceiveMemoryWarning {
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}

@end
