//
//  ReportViewController.m
//  XFFruit
//
//  Created by 陈俊俊 on 15/11/6.
//  Copyright © 2015年 Xummer. All rights reserved.
// 报表

#import "ReportViewController.h"
#import "SaleViewController.h"
//#import "PassengerViewController.h"
//#import "PassgerPriceViewController.h"
//#import "GrossRateViewController.h"
#import "CustomSegView.h"
#import "FinishTimeView.h"
//#import "SearchReportViewController.h"
#import "QueryOrder.h"
#import "CalculateHelper.h"
#import "VankeAppBoard_iPhone.h"
//#import "ReportDetailViewController.h"
@interface ReportViewController ()<UIScrollViewDelegate,CustomSegViewDelegate,FinishTimeViewDelegate>
{
    SaleViewController *svc;

    NSInteger _currentView;
    NSInteger _oldView;
    CGRect _currentRect;
}
@property (nonatomic,strong)UIScrollView *scrollView;
@property (nonatomic,assign)NSInteger currentPage;
@property (nonatomic,strong)CustomSegView *segView;
@property (nonatomic,strong)NSString *dayType;
@property (nonatomic,strong)FinishTimeView *startTimeView;
@property (nonatomic,strong)NSString *scopeType;
@property (nonatomic,strong)NSString *selectDay;
@property (nonatomic,strong)NSString *selectMonth;
@property (nonatomic,strong)NSString *selectWeek;
//组织范围
@property (nonatomic,strong)NSString *orgScope;
//数据源数组
@property (nonatomic,strong)NSMutableArray *dataArr;
@property (nonatomic,strong)NSMutableArray *totalArr;
@property (nonatomic,strong)Compass *compass;
@property (nonatomic,assign)NSInteger storeCount;
@property (nonatomic,strong)NSIndexPath *currentIndex;
@property (nonatomic,strong)NSMutableArray *selectArr;
@property (nonatomic, assign) BOOL isAuto;



@end

@implementation ReportViewController

ON_CREATE_VIEWS( signal )
{
    self.navigationBarShown = YES;
    self.navigationBarLeft  = nil;
    //添加通知

    UIColor *color = [UIColor colorWithR:63 g:134 b:244 a:1];
//    if ( IOS7_OR_LATER ) {
        self.navigationController.navigationBar.barTintColor = color;
        self.navigationController.navigationBar.tintColor = [UIColor whiteColor];
//    } else {
//        self.navigationController.navigationBar.tintColor = color;
//    }
}



- (instancetype)init{
    self = [super init];
    if (self) {
        //添加通知
        [[NSNotificationCenter defaultCenter] addObserver:self selector:@selector(getNextDetailData:) name:KNOTIFICATION_GetNextDetailData object:nil];
        [[NSNotificationCenter defaultCenter] addObserver:self selector:@selector(goReoprtDetail:) name:KNOTIFICATION_GoReportDetail object:nil];

    }
    return self;
}

- (void)dealloc{
    [[NSNotificationCenter defaultCenter] removeObserver:self];
}

- (void)viewDidLoad {
    [super viewDidLoad];
    [[VankeAppBoard_iPhone sharedInstance] hideMenu];
    //布局
#if 1
    self.dataArr = [NSMutableArray array];
    self.totalArr = [NSMutableArray array];
    self.selectArr = [NSMutableArray array];
    [self bulidLayout];
    
    UIBarButtonItem *searchItem = [[UIBarButtonItem alloc]initWithTitle:@"历史" style:UIBarButtonItemStyleDone target:self action:@selector(customSegTwoClick:)];
    self.navigationItem.rightBarButtonItem = searchItem;
    self.automaticallyAdjustsScrollViewInsets = NO;
    self.dayType = @"day";
     self.scopeType = [IBTCommon stringFromDateWithFormat:[NSDate date] format:@"yyyy-MM-dd"];
    
    [self getDataFromServer];
#else
    CGRect rect = CGRectMake(0, 200, self.view.width, 30);
    IBTUILabel *lbl = [[IBTUILabel alloc]initWithFrame:rect];
    lbl.text = @"哎呦，功能还没实现呢，下次再来看看吧。";
    lbl.textAlignment = NSTextAlignmentCenter;
    lbl.font = [UIFont systemFontOfSize:15];
    lbl.textColor = GXF_NAVIGAYION_COLOR;
    [self.view addSubview:lbl];
#endif
   
}

- (void)viewWillDisappear:(BOOL)animated {
    [super viewWillDisappear:animated];
    [self clearDatePickView];
}

- (void)searchClick{
    if (self.startTimeView) {
        [self.startTimeView removeFromSuperview];
        self.startTimeView = nil;
    }
//    SearchReportViewController *srvc = [SearchReportViewController new];
//    [self PushViewController:srvc animated:YES];
}

- (void)getWeekbydayFromServer {
    
    NSDate *date ;
    if (!_selectDay) {
        self.selectDay = [[NSDate date]localYMDString];
    }
    date = [IBTCommon dateFromStringWithFormat:_selectDay format:@"yyyy-MM-dd" ];
    
    NSInteger week = [date getWeekOfYear];
    NSString  *year = [date yearString];
    self.scopeType = [NSString stringWithFormat:@"%@-%ld",year, (long)week - 1];
    [self getDataFromServer];
    
}

#pragma mark - 获取上部数据
- (void)getDataFromServer{
    __weak typeof(self)weakSelf = self;
//    [IBTLoadingView showProgressLabel:@"正在加载..."];
    NSMutableArray *orderArr =[NSMutableArray array];
    if (orderArr.count == 0) {
        QueryOrder *order = [QueryOrder new];
        order.field = @"orgCode";
        order.direction = @"desc";
        [orderArr addObject:[order dictForCommit]];
        
    }
    NSArray *arr = [[VankeCommonModel sharedInstance] getAuthOrgs];
    NSMutableArray *arrAuthordCode = [NSMutableArray array];
    for (AuthorizedOrg *org in arr) {
        [arrAuthordCode addObject:org.code];
    }
    
    NSString *authorCodes = [arrAuthordCode componentsJoinedByString:@","];
    NSDictionary *testParams = @{@"dataType" : self.reportType,
                                 @"dataScopeType" : self.dayType,
                                 @"dataScope" : self.scopeType,
                                 @"orgCodes" : authorCodes,
                                 @"upperOrgCode" : [NSNull null],
                                 @"queryOrders" : @[@{@"field" : @"salesInfo.orgCode",
                                                      @"direction" : @"asc"}],
                                 @"pageNumber" : @0,
                                 @"pageSize" : @100};
    NSString *sss = testParams.JSONString;
    [[ICRHTTPController sharedController] postUrl:@"salesdata/query" params:testParams success:^(id data) {
        CLog(@"%@", data);
        __strong __typeof(weakSelf)strongSelf = weakSelf;
        //赋值
        NSInteger success = [data[@"success"] integerValue];
        NSString *message  = data[@"message"] ;
        if (success == 1) {
            [strongSelf prepareDataInScrollView:data];
            [strongSelf getBottomData:nil];
        }else{
            [IBTLoadingView hideHUDWithText:message];
            [IBTLoadingView showTips:data];
        }
    } failure:^(id data) {
        [IBTLoadingView hideHUDWithText:nil];
        [IBTLoadingView showTips:data];
    }];
}

- (void)prepareDataInScrollView:(id)data{
    if (data) {
        NSInteger success = [data[@"success"] integerValue];
        NSString *message  = data[@"message"] ;
        if (success == 1) {
            NSDictionary *compassDict = data[ @"data" ][@"salesData"];
            NSArray *arr = compassDict[@"records"];

            //计算顶部总的数据
            Compass *com = nil;
            for (NSDictionary *comDict in arr) {
                if (!com) {
                    com = [[Compass alloc] init];
                    [com setValuesForKeysWithDictionary:comDict];
                    com.area = [CalculateHelper calculateNum1:com.sales num2:com.groundEffect type:CalculateTypeDiv roundingType:NSRoundPlain cutLenth:10];
                }else{
                    Compass *obj = [[Compass alloc]init];
                    [obj setValuesForKeysWithDictionary:comDict];

                    com.sales = [CalculateHelper calculateNum1:com.sales num2:obj.sales type:CalculateTypeAdd roundingType:NSRoundPlain cutLenth:2];
                    com.salesChain = [CalculateHelper calculateNum1:com.salesChain num2:obj.salesChain type:CalculateTypeAdd roundingType:NSRoundPlain cutLenth:2];
                    com.salesYoY = [CalculateHelper calculateNum1:com.salesYoY num2:obj.salesYoY type:CalculateTypeAdd roundingType:NSRoundPlain cutLenth:2];
                    NSDecimalNumber *area = [CalculateHelper calculateNum1:obj.sales num2:obj.groundEffect type:CalculateTypeDiv roundingType:NSRoundPlain cutLenth:10];
                    com.area = [CalculateHelper calculateNum1:com.area num2:area type:CalculateTypeAdd roundingType:NSRoundPlain cutLenth:10];
                }
                
            }
            if (com == nil) {
                com = [[Compass alloc] init];
            }
            if ([self.segView.currentTitle isEqualToString:SaleDay]) {
                com.dataScope = self.selectDay;
                if (self.selectDay == nil) {
                    com.dataScope = [[NSDate date] yearMonthDayString];
                }
                
            }else if ([self.segView.currentTitle isEqualToString:SaleWeek]) {
                 com.dataScope = self.selectWeek;;
                if (self.selectWeek == nil) {
                    com.dataScope = [IBTCommon getWeekFromDate];
                }
            }else if ([self.segView.currentTitle isEqualToString:SaleMonth]) {
                 com.dataScope = self.selectMonth;;
                if (self.selectMonth == nil) {
                    com.dataScope = [[NSDate date] yearMonthString];
                }
            }

            self.compass = com;
            self.compass.dateScopeType = self.dayType;
            [self setValueInScrollView];
        }else{
            [IBTLoadingView showTips:message];
        }
    }else{
        [IBTLoadingView showTips:@"      无记录      "];
    }
}
- (void)setValueInScrollView{
    [svc setValueInSale:self.compass withType:self.dayType];
//    [pvc setValueInPassenger:self.compass withType:self.dayType];
//    [ppvc setValueInPassgerPrice:self.compass withType:self.dayType];
//    [gvc setValueInGrossRate:self.compass withType:self.dayType];
}

//获取底部详情数据
- (void)getBottomData:(NSIndexPath *)indexPath{
    __weak typeof(self)weakSelf = self;
    MBProgressHUD *hud = [MBProgressHUD showHUDAddedTo:self.view animated:YES];
    NSArray *arr = [[VankeCommonModel sharedInstance] getAuthOrgs];
    NSMutableArray *arrAuthordCode = [NSMutableArray array];
    for (AuthorizedOrg *org in arr) {
        [arrAuthordCode addObject:org.code];
    }
    NSString *authorCodes = [arrAuthordCode componentsJoinedByString:@","];
    NSDictionary *testParams = @{@"dataType" : self.reportType,
                                 @"dataScopeType" : self.dayType,
                                 @"dataScope" : self.scopeType,
                                 @"orgCodes" : self.orgScope ? [NSNull null] : authorCodes,
                                 @"upperOrgCode" : self.orgScope ? self.orgScope : [NSNull null],
                                 @"queryOrders" : @[@{@"field" : @"salesInfo.orgCode",
                                                      @"direction" : @"asc"}],
                                 @"pageNumber" : @0,
                                 @"pageSize" : @100};
    CLog(@"%@", testParams.JSONString);
    [[ICRHTTPController sharedController] postUrl:@"salesdata/query" params:testParams success:^(id data) {
        CLog(@"%@", data);
        __strong __typeof(weakSelf)strongSelf = weakSelf;
        //赋值
        [IBTLoadingView hideHUDWithText:nil];
        [strongSelf downLoadData:data indexPath:indexPath];
        [hud hide:YES];
    } failure:^(id data) {
        [IBTLoadingView hideHUDWithText:nil];
        [IBTLoadingView showTips:data];
        [hud hide:YES];
    }];

}

- (void)downLoadData:(id)data indexPath:(NSIndexPath *)indexPath{
    if (data) {
        NSInteger success = [data[@"success"] integerValue];
        NSString *message  = data[@"message"] ;
        if (success == 1) {
            NSDictionary *recodesDict = data[ @"data" ][ @"salesData" ];
            NSArray *recodesArr = recodesDict[@"records"];
            if (!indexPath) {
                self.storeCount =[data[ @"data" ][ @"stores" ] integerValue];
                if (self.dataArr.count > 0) {
                    [self.dataArr removeAllObjects];
                }
                if (self.totalArr.count > 0) {
                    [self.totalArr removeAllObjects];
                }
                if (self.selectArr.count > 0) {
                    [self.selectArr removeAllObjects];
                }
            }
            for (NSDictionary *orgDict in recodesArr) {
                Compass *orgCompass = [[Compass alloc]init];
                [orgCompass setValuesForKeysWithDictionary:orgDict];
                if (!indexPath) {
                    [self.dataArr addObject:orgCompass]; 
                }
                [self.totalArr addObject:orgCompass];
            }
            //刷新tableView
            [self refreshAllTable];
            if (indexPath) {
                [self actionTableView:indexPath];
            }
            
            if (indexPath == nil && self.dataArr.count > 0) {
                self.isAuto = YES;
                NSIndexPath *index = [NSIndexPath indexPathForRow:0 inSection:0];
                [[NSNotificationCenter defaultCenter]postNotificationName:KNOTIFICATION_GetNextDetailData object:nil userInfo:@{@"indexPath":index}];
            }
        }else{
            [IBTLoadingView showTips:message];
        }
    }else{
        [IBTLoadingView showTips:@"      无记录      "];
    }
}
#pragma mark - 刷新所有的tableView
- (void)refreshAllTable{
    svc.count = self.storeCount;
    svc.typeStr = self.dayType;
//    pvc.count = self.storeCount;
//    pvc.typeStr = self.dayType;
//    ppvc.count = self.storeCount;
//    ppvc.typeStr = self.dayType;
//    gvc.count = self.storeCount;
//    gvc.typeStr = self.dayType;
    svc.dataArr = self.dataArr;
//    pvc.dataArr = self.dataArr;
//    ppvc.dataArr = self.dataArr;
//    gvc.dataArr = self.dataArr;
    [svc.tableView reloadData];
//    [pvc.tableView reloadData];
//    [ppvc.tableView reloadData];
//    [gvc.tableView reloadData];
}

#pragma mark - 布局
- (void)bulidLayout{

    self.view.backgroundColor = [UIColor whiteColor];
    CGRect rect = CGRectMake(10, 10 + 64, SCREEN_WIDTH - 10*2, 30);
    NSArray *arr = @[SaleDay,SaleWeek,SaleMonth];
    self.segView = [[CustomSegView alloc]initWithFrame:rect withArr:arr];
    self.segView.delegate = self;
    [self.view addSubview:self.segView];
    
    self.scrollView = [[UIScrollView alloc]initWithFrame:CGRectMake(0, self.segView.bottom, SCREEN_WIDTH, SCREEN_HEIGHT- self.segView.bottom)];
    self.scrollView.delegate = self;
    self.scrollView.showsHorizontalScrollIndicator  = NO;
    self.scrollView.showsVerticalScrollIndicator = NO;
    self.scrollView.pagingEnabled = YES;
    [self.view addSubview:self.scrollView];
    
    svc = [SaleViewController new];
    [self addChildViewController:svc];
    
//    pvc = [PassengerViewController new];
//    [self addChildViewController:pvc];
//    
//    ppvc = [PassgerPriceViewController new];
//    [self addChildViewController:ppvc];
//    
//    gvc = [GrossRateViewController new];
//    [self addChildViewController:gvc];
    
    rect = CGRectMake(0, 0, SCREEN_WIDTH, self.scrollView.height + 64);
    svc.view.frame = rect;
    [self.scrollView addSubview:svc.view];
    
//    rect = CGRectMake(self.scrollView.width,0 , SCREEN_WIDTH, SCREEN_HEIGHT - 49 - 64- self.segView.bottom);
//    pvc.view.frame = rect;
//    [self.scrollView addSubview:pvc.view];
//    
//    rect = CGRectMake(self.scrollView.width*2, 0, SCREEN_WIDTH, self.scrollView.height);
//    ppvc.view.frame = rect;
//    [self.scrollView addSubview:ppvc.view];
//    
//    rect = CGRectMake(self.scrollView.width*3, 0, SCREEN_WIDTH, self.scrollView.height);
//    gvc.view.frame = rect;
//    [self.scrollView addSubview:gvc.view];
    
    self.scrollView.contentSize = CGSizeMake(self.scrollView.width, self.scrollView.height);
}

#pragma mark - segViewDelegate
- (void)customSegOneClick:(NSString *)title{
    NSDate *date ;
    if (!_selectDay) {
        self.selectDay = [[NSDate date]localYMDString];
        //
    }
    date = [IBTCommon dateFromStringWithFormat:_selectDay format:@"yyyy-MM-dd" ];
    //    NSString *strDate = [_selectDay substringToIndex:_selectDay.length - 3];
    //日周年切换
    NSString *dayType = @"";
    if ([title isEqualToString:SaleWeek]) {
        dayType = @"week";
        self.dayType = dayType;
        self.orgScope = nil;
        [self getWeekbydayFromServer];
        return;
    }
    
    if ([title isEqualToString:SaleDay]) {
        dayType = @"day";
        self.scopeType = _selectDay;
    }else if ([title isEqualToString:SaleMonth]) {
        dayType = @"month";
        self.scopeType = [IBTCommon stringFromDateWithFormat:date format:@"yyyy-MM"];
    } else {
        return;
    }
    CLog(@"-------%@",self.scopeType);
    self.dayType = dayType;
    self.orgScope = nil;
    [self getDataFromServer];
    
    
}

- (void)customSegTwoClick:(NSString *)title{
    self.isAuto = NO;
    //选择历史查看
    if ([self.segView.currentTitle isEqualToString:SaleDay]) {
        [self startDatePickView:SaleEnDay];
    }else if ([self.segView.currentTitle isEqualToString:SaleWeek]) {
        [self startDatePickView:SaleEnWeek];
    }else if ([self.segView.currentTitle isEqualToString:SaleMonth]) {
        [self startDatePickView:SaleEnMonth];
    }
}

- (void)startDatePickView:(NSString *)type{
    if (!self.startTimeView) {
        
        NSString *currentStr  = @"";
        if ([type isEqualToString:SaleEnDay]) {
            if (self.selectDay) {
                currentStr =  self.selectDay;
            }else{
                currentStr = [IBTCommon stringFromDateWithFormat:[NSDate date] format:@"yyyy-MM-dd"];
            }
            
        }else if([type isEqualToString:SaleEnMonth]){
            if (self.selectMonth) {
                currentStr =  self.selectMonth;
            }else{
                currentStr = [IBTCommon stringFromDateWithFormat:[NSDate date] format:@"yyyy-MM"];
            }
        }else{
            if (self.selectWeek) {
                currentStr =  self.selectWeek;
            }else{
                currentStr = [IBTCommon getWeekFromDate];
            }
        }

        self.startTimeView = [[FinishTimeView alloc] initWithFrame:CGRectMake(0, SCREEN_HEIGHT, SCREEN_WIDTH, SCREEN_HEIGHT - 64) withDate:currentStr type:type];
        self.startTimeView.delegate = self;
        self.startTimeView.backgroundColor        = RGBA(0, 0, 0 ,0.5);
        [AppWindow addSubview:self.startTimeView];
        
        [UIView animateWithDuration:0.15 animations:^{
            CGRect startFrame =  self.startTimeView.frame;
            startFrame.origin.y =  64;
            self.startTimeView.frame = startFrame;
        } completion:^(BOOL finished) {
            
        }];
    }
}
- (void)cancelTimeView{
    [self clearDatePickView];
}
- (void)okTimeView:(NSString *)time withType:(NSString *)type{
    CLog(@"--------%@",time);
    // 关闭选择器
    [self clearDatePickView];
    if ([type isEqualToString:SaleEnDay]) {
        self.selectDay = time;
    }else if ([type isEqualToString:SaleEnWeek]) {
        self.selectWeek = time;
    }else if ([type isEqualToString:SaleEnMonth]) {
        self.selectMonth = time;
    }
    self.scopeType = time;
    self.orgScope = nil;
    [self getDataFromServer];
}
#pragma mark - 取消
- (void)clearDatePickView{
    [UIView animateWithDuration:0.15 animations:^{
        CGRect startFrame =  self.startTimeView.frame;
        startFrame.origin.y = SCREEN_HEIGHT;
        self.startTimeView.frame = startFrame;
    } completion:^(BOOL finished) {
        [self.startTimeView removeFromSuperview];
        self.startTimeView = nil;
    }];
}
- (void)getNextDetailData:(NSNotification *)fication{
    NSDictionary *dict = fication.userInfo;
    NSIndexPath *indexPath = dict[@"indexPath"];
    if (indexPath.row > self.dataArr.count - 1) {
        self.isAuto = NO;
        return;
    }
    
        Compass *parentCompass = [self.dataArr objectAtIndex:indexPath.row];
        //如果当前点击的不是删除，则要先获取数据在进行插入
        if (![self isHaveIndexPath:parentCompass.orgCode]) {
            if (parentCompass.isLeaf) {
                //如果是子节点就不用进行网络请求
                return;
            }//不是子节点进行网络请求
            self.orgScope = parentCompass.orgCode;
            [self getBottomData:indexPath];
            return;
        }
    [self actionTableView:indexPath];
}
- (void)actionTableView:(NSIndexPath *)indexPath{
    Compass *parentCompass = [self.dataArr objectAtIndex:indexPath.row];
    NSInteger startPosition = indexPath.row+1;
    NSInteger endPosition = startPosition;
    BOOL expand = NO;
    for (int i=0; i<self.totalArr.count; i++) {
        Compass *node = [self.totalArr objectAtIndex:i];
        if ([node.upperOrgCode isEqualToString:parentCompass.orgCode]) {
            //修改二级节点的属性为为原属性相反属性
            node.expand = !node.expand;
            if (node.expand) {
                [self.dataArr insertObject:node atIndex:endPosition];
                expand = YES;
                endPosition++;
            }else{
                expand = NO;
                endPosition = [self removeAllNodesAtParentNode:parentCompass];
                break;
            }
        }
    }
    
    //获得需要修正的indexPath
    NSMutableArray *indexPathArray = [NSMutableArray array];
    for (NSInteger i=startPosition; i<endPosition; i++) {
        NSIndexPath *tempIndexPath = [NSIndexPath indexPathForRow:i inSection:0];
        [indexPathArray addObject:tempIndexPath];
    }
    
    //插入或者删除相关节点
    if (expand) {
        [self.selectArr addObject:parentCompass.orgCode];
        [self insertDataWithTable:svc.tableView arr:indexPathArray];
//        [self insertDataWithTable:ppvc.tableView arr:indexPathArray];
//        [self insertDataWithTable:pvc.tableView arr:indexPathArray];
//        [self insertDataWithTable:gvc.tableView arr:indexPathArray];
    }else{
        [self.selectArr removeObject:parentCompass.orgCode];
        [self deleteDataWithTable:svc.tableView arr:indexPathArray];
//        [self deleteDataWithTable:pvc.tableView arr:indexPathArray];
//        [self deleteDataWithTable:ppvc.tableView arr:indexPathArray];
//        [self deleteDataWithTable:gvc.tableView arr:indexPathArray];
    }
    [self refreshAllTable];

    if (self.isAuto) {
        [[NSNotificationCenter defaultCenter]postNotificationName:KNOTIFICATION_GetNextDetailData object:nil userInfo:@{@"indexPath":[NSIndexPath indexPathForRow:endPosition  inSection:0]}];
    }
    

}

- (void)insertDataWithTable:(UITableView *)tableView arr:(NSMutableArray *)arr{
    [tableView insertRowsAtIndexPaths:arr withRowAnimation:UITableViewRowAnimationFade];
}
- (void)deleteDataWithTable:(UITableView *)tableView arr:(NSMutableArray *)arr{
    [tableView deleteRowsAtIndexPaths:arr withRowAnimation:UITableViewRowAnimationFade];
}
/**
 *  删除该父节点下的所有子节点（包括孙子节点）
 *
 *  @param parentNode 父节点
 *
 *  @return 该父节点下一个相邻的统一级别的节点的位置
 */
-(NSUInteger)removeAllNodesAtParentNode : (Compass *)parentNode{
    NSUInteger startPosition = [self.dataArr indexOfObject:parentNode];
    NSUInteger endPosition = startPosition;
        for (NSUInteger i=startPosition+1; i<self.dataArr.count; i++) {
            Compass *node = [self.dataArr objectAtIndex:i];
            endPosition++;
            if (node.level <= parentNode.level) {
                break;
            }
            if(endPosition == self.dataArr.count-1){
                endPosition++;
                node.expand = NO;
                break;
            }
            node.expand = NO;
        }
        if (endPosition>startPosition) {
            for (NSInteger i = startPosition+1; i < endPosition; i++) {
                Compass *parentCompass = self.dataArr[i];
                for (Compass *orgCompass in self.totalArr) {
                    if (parentCompass.orgCode == orgCompass.orgCode) {
                        [self.totalArr removeObject:orgCompass];
                        break;
                    }
                }
            }
            [self.dataArr removeObjectsInRange:NSMakeRange(startPosition+1, endPosition-startPosition-1)];
        }
    return endPosition;
}

- (BOOL)isHaveIndexPath:(NSString *)orgUuid{
    for (NSString *selectoUuid in self.selectArr) {
        if ([selectoUuid isEqualToString:orgUuid]) {
            return YES;
        }
    }
    return NO;
}

#pragma mark - 详情页面跳转
- (void)goReoprtDetail:(NSNotification *)finication{
//    NSDictionary *dict = finication.userInfo;
//    Compass *compass = dict[@"compass"];
//    ReportDetailViewController *rvc = [ReportDetailViewController new];
//    rvc.compass = compass;
//    rvc.title = compass.orgName;
//    [self PushViewController:rvc animated:YES];
}

- (void)didReceiveMemoryWarning {
    [super didReceiveMemoryWarning];
}

@end
