

#import "VankeTenantTabBoard_iPhone.h"
#import "VankeCommonModel.h"

NSString *const TENANT_TAB_NAME_AFFAIRS = @"tenantAffairs";  // affairs
NSString *const TENANT_TAB_NAME_ME = @"me";       // me

#pragma mark -

@interface VankeTenantTabBoard_iPhone()
{
	//<#@private var#>
}
@end

@implementation VankeTenantTabBoard_iPhone

SUPPORT_RESOURCE_LOADING(YES)
SUPPORT_AUTOMATIC_LAYOUT(YES)

DEF_OUTLET( BeeUIButton, affairs );
DEF_OUTLET( BeeUIButton, me );

- (void)load
{
}

- (void)unload
{
}

- (void)dataDidChanged {
}

- (void)selectAffairs
{
    [self removeActiveClass];
    [self addActiveClass:$(self.affairs) relayout:YES];
}

- (void)selectMe
{
    [self removeActiveClass];
    [self addActiveClass:$(self.me) relayout:YES];
}

- (void) removeActiveClass {
    $(self.affairs).REMOVE_CLASS( @"active" );
    $(self.me).REMOVE_CLASS( @"active" );
}

- (void) addActiveClass: (BeeUIQuery*) activeItem relayout: (BOOL) relayout {
    activeItem.ADD_CLASS( @"active" );
    if (relayout) {
        self.RELAYOUT();
    }
}

-(NSString*) showAndSelectFirst {
    if ([self.affairs visible]) {
        [self selectAffairs];
        return TENANT_TAB_NAME_AFFAIRS;
    } else {
        [self selectMe];
        return TENANT_TAB_NAME_ME;
    }
}

-(void) hideTab: (NSString*) tabName visible: (BOOL) visible {
    if (visible) {
        $(tabName).SHOW();
    } else {
        $(tabName).HIDE();
    }
}

ON_SIGNAL3( VankeTenantTabBoard_iPhone, affairs, signal )
{
    [self selectAffairs];
}

ON_SIGNAL3( VankeTenantTabBoard_iPhone, me, signal )
{
    [self selectMe];
}

@end
